/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ffdc.Manager;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class WriteStream
extends OutputStream {
    private byte[] write_buffer = new byte[8192];
    private int write_length;
    private Stream source;
    private char[] chars;
    private byte[] bytes;
    private boolean disableClose;
    private StreamWriter writer;
    private PrintWriter printWriter;

    public void init(Stream source) {
        this.disableClose = false;
        if (this.source != null && this.source != source) {
            try {
                this.close();
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.io.WriteStream.init", "49", this);
                e.printStackTrace();
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.write_length = 0;
        this.printWriter = null;
    }

    public Stream getSource() {
        return this.source;
    }

    public void write(int ch) throws IOException {
        if (this.write_length >= this.write_buffer.length) {
            this.flushMyBuf(false);
        }
        this.write_buffer[this.write_length++] = (byte)ch;
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            if (this.write_length == 0 && length >= this.write_buffer.length) {
                this.source.write(buf, offset, length, false);
                return;
            }
            int sublen = this.write_buffer.length - this.write_length;
            if (sublen > length) {
                sublen = length;
            }
            System.arraycopy(buf, offset, this.write_buffer, this.write_length, sublen);
            this.write_length += sublen;
            offset += sublen;
            length -= sublen;
            if (this.write_length < this.write_buffer.length) continue;
            this.flushMyBuf(false);
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void flush() throws IOException {
        if (this.write_length > 0) {
            this.flushMyBuf(false);
        }
        this.source.flush();
    }

    private void flushMyBuf(boolean isEnd) throws IOException {
        int len = this.write_length;
        this.write_length = 0;
        this.source.write(this.write_buffer, 0, len, isEnd);
    }

    public final void print(char[] buffer, int offset, int length) throws IOException {
        byte[] writeBuffer = this.write_buffer;
        if (writeBuffer == null) {
            return;
        }
        while (length > 0) {
            int writeLength = this.write_length;
            int sublen = writeBuffer.length - writeLength;
            if (sublen <= 0) {
                this.flushMyBuf(false);
                sublen = writeBuffer.length;
                writeLength = this.write_length;
            }
            if (length < sublen) {
                sublen = length;
            }
            for (int i = 0; i < sublen; ++i) {
                writeBuffer[writeLength + i] = (byte)buffer[offset + i];
            }
            this.write_length = writeLength + sublen;
            offset += sublen;
            length -= sublen;
        }
    }

    public final void print(char ch) throws IOException {
        this.write((byte)ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int off, int len) throws IOException {
        while (len > 0) {
            int sublen;
            int n = sublen = len < 1024 ? len : 1024;
            if (this.chars == null || this.chars.length < sublen) {
                this.chars = new char[sublen < 32 ? 32 : sublen];
            }
            string.getChars(off, off + sublen, this.chars, 0);
            this.print(this.chars, 0, sublen);
            len -= sublen;
            off += sublen;
        }
    }

    public final void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public final void print(int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i == 0) {
            this.write(48);
            return;
        }
        int j = 31;
        while (i > 0) {
            this.bytes[--j] = (byte)(i % 10 + 48);
            i /= 10;
        }
        this.write(this.bytes, j, 31 - j);
    }

    public final void print(long i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (i < 0L) {
            this.write(45);
            i = -i;
        } else if (i == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (i > 0L) {
            this.bytes[--j] = (byte)(i % 10L + 48L);
            i /= 10L;
        }
        this.write(this.bytes, j, 31 - j);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        this.print(o.toString());
    }

    public PrintWriter getPrintWriter() {
        if (this.writer == null) {
            this.writer = new StreamWriter();
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.writer);
        }
        return this.printWriter;
    }

    public void setDisableClose(boolean disableClose) {
        this.disableClose = disableClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void close() throws IOException {
        Stream s2;
        try {
            if (this.write_length > 0) {
                this.flushMyBuf(true);
            }
            Object var2_1 = null;
            if (this.disableClose) {
                this.printWriter = null;
                return;
            }
            s2 = this.source;
            this.source = null;
            if (s2 == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.disableClose) {
                this.printWriter = null;
                return;
            }
            Stream s2 = this.source;
            this.source = null;
            if (s2 == null) throw throwable;
            s2.close();
            throw throwable;
        }
        s2.close();
    }

    private class StreamWriter
    extends Writer {
        private StreamWriter() {
        }

        public final void write(char ch) throws IOException {
            WriteStream.this.print(ch);
        }

        public final void write(char[] buffer, int offset, int length) throws IOException {
            WriteStream.this.print(buffer, offset, length);
        }

        public final void write(char[] buffer) throws IOException {
            WriteStream.this.print(buffer, 0, buffer.length);
        }

        public final void write(String string) throws IOException {
            WriteStream.this.print(string);
        }

        public final void write(String string, int off, int len) throws IOException {
            WriteStream.this.print(string, off, len);
        }

        public final void flush() throws IOException {
            WriteStream.this.flush();
        }

        public final void close() throws IOException {
            WriteStream.this.printWriter = null;
        }
    }
}

