/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.io.Writer;

public class WSCharArrayWriter
extends Writer {
    protected Buffer head;
    protected Buffer tail;
    protected boolean isClosed = false;

    public WSCharArrayWriter() {
        this(16384);
    }

    public WSCharArrayWriter(int initialSize) {
    }

    public void write(int c) {
        this.write(new char[]{(char)c}, 0, 1);
    }

    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        while (len > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                Buffer tBuf = Buffer.allocate();
                this.tail.setNext(tBuf);
                this.tail = tBuf;
            }
            int sublen = this.tail.write(c, off, len);
            off += sublen;
            len -= sublen;
        }
    }

    public void write(String str, int off, int len) {
        while (len > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                Buffer tBuf = Buffer.allocate();
                this.tail.setNext(tBuf);
                this.tail = tBuf;
            }
            char[] buf = this.tail.getBuffer();
            int avail = Math.min(this.tail.getAvailable(), len);
            str.getChars(off, off + avail, buf, this.tail.getCurrentOffset());
            this.tail.length += avail;
            off += avail;
            len -= avail;
        }
    }

    public void writeTo(Writer out) throws IOException {
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
    }

    public void reset() {
        Buffer.freeAll(this.head);
        this.tail = null;
        this.head = null;
        this.isClosed = false;
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.size()];
        int offset = 0;
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            System.arraycopy(ptr.getBuffer(), 0, newbuf, offset, ptr.getLength());
            offset += ptr.getLength();
        }
        return newbuf;
    }

    public int size() {
        int len = 0;
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            len += ptr.getLength();
        }
        return len;
    }

    public String toString() {
        char[] buf = this.toCharArray();
        return new String(buf, 0, buf.length);
    }

    public void flush() {
    }

    public void close() {
        this.isClosed = true;
    }

    static class Buffer {
        private static ObjectPool pool = new ObjectPool(Buffer.class.getName(), 64){

            protected Object createObject() {
                return new Buffer();
            }
        };
        public static int SIZE = 16384;
        protected Buffer next;
        protected char[] buf = new char[SIZE];
        protected int length;

        private Buffer() {
        }

        public static Buffer allocate() {
            Buffer next = (Buffer)pool.remove();
            next.clear();
            return next;
        }

        public void clear() {
            this.next = null;
            this.length = 0;
        }

        public char[] getBuffer() {
            return this.buf;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int write(char[] buf, int offset, int length) {
            if (SIZE - this.length < length) {
                length = SIZE - this.length;
            }
            System.arraycopy(buf, offset, this.buf, this.length, length);
            this.length += length;
            return length;
        }

        public int getAvailable() {
            return this.buf.length - this.length;
        }

        public int getCurrentOffset() {
            return this.length;
        }

        public Buffer getNext() {
            return this.next;
        }

        public void setNext(Buffer next) {
            this.next = next;
        }

        public static void free(Buffer buf) {
            buf.next = null;
            pool.add(buf);
        }

        public static void freeAll(Buffer buf) {
            while (buf != null) {
                Buffer next = buf.next;
                Buffer.free(buf);
                buf = next;
            }
        }
    }
}

