/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCBodyReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadAhead;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCWriteCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.exception.IllegalRequestObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpOutboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpOutboundServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    protected static final int CALLBACK_STATE_IDLE = 0;
    protected static final int CALLBACK_STATE_PENDING = 1;
    protected static final int CALLBACK_STATE_ERROR = 2;
    protected static final int CALLBACK_STATE_COMPLETE = 4;
    protected static final int READ_STATE_IDLE = 0;
    protected static final int READ_STATE_TIME_RESET = 1;
    protected static final int READ_STATE_SYNC = 3;
    protected static final int READ_STATE_ASYNC = 4;
    private HttpOutboundLink myLink = null;
    private int[] positionList = null;
    private int callback_state = 0;
    private int read_state = 0;
    private Object readAheadSyncer = new Object();
    protected Object stateSyncObject = new Object();
    private IOException readException = null;
    private boolean bReadAheadEnabled = false;
    private boolean bImmediateRead = false;
    private boolean bTempResponsesUsed = false;
    private boolean bEarlyReads = false;
    private int numResponsesReceived = 0;

    public HttpOutboundServiceContextImpl(TCPConnectionContext tsc, HttpOutboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        this.init(tsc, link, vc, hcc);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.positionList = new int[this.getPendingBuffers().length];
    }

    public void init(TCPConnectionContext tsc, HttpOutboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing OSC: " + this);
        }
        this.init(tsc, hcc);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.setLink(link);
        this.setVC(vc);
        this.getVC().getStateMap().put(CallbackIDs.CALLBACK_HTTPOSC, this);
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying OSC: " + this);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPOSC);
        super.destroy();
        this.myLink = null;
        this.readException = null;
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing OSC: " + this);
        }
        if (null != this.getLink()) {
            this.getLink().clear();
        }
        super.clear();
        this.setReadBuffer(null);
        this.getTSC().getReadInterface().setBuffers(null);
        this.callback_state = 0;
        this.read_state = 0;
        this.readException = null;
        this.bReadAheadEnabled = false;
        this.bImmediateRead = false;
        this.bTempResponsesUsed = false;
        this.bEarlyReads = false;
        this.numResponsesReceived = 0;
        this.getVC().getStateMap().remove("HTTPFinalWrite");
    }

    protected void reConnect(VirtualConnection inVC, IOException ioe) {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting reconnect: " + this.getLink().getVirtualConnection());
            }
            this.getTSC().getReadInterface().setBuffer(null);
            this.getLink().reConnectAsync(ioe);
        } else {
            this.callErrorCallback(inVC, ioe);
        }
    }

    void callErrorCallback(VirtualConnection inVC, IOException ioe) {
        this.setPersistent(false);
        if (this.bEarlyReads && null != this.getAppReadCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Early read failure calling error() on appside");
            }
            this.getAppReadCallback().error(inVC, ioe);
        } else if (null != this.getAppWriteCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling write.error() on appside");
            }
            this.getAppWriteCallback().error(inVC, ioe);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No appside, closing connection");
            }
            this.getLink().getDeviceLink().close(inVC, ioe);
        }
    }

    protected void reConnect(IOException originalExcep) throws IOException {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting synchronous reconnect");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reconnect sync not allowed");
            }
            this.setPersistent(false);
            throw originalExcep;
        }
        this.getTSC().getReadInterface().setBuffer(null);
        this.getLink().reConnectSync(originalExcep);
        this.nowReconnectedSync(originalExcep);
    }

    protected WsByteBuffer[] getBuffList() {
        int start;
        if (!this.getLink().isReconnectAllowed()) {
            return super.getBuffList();
        }
        int stop = this.getPendingStop();
        int size = stop - (start = this.getPendingStart());
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] buffs = this.getPendingBuffers();
        WsByteBuffer[] list = new WsByteBuffer[size];
        if (this.positionList.length < buffs.length) {
            int[] newList = new int[buffs.length];
            System.arraycopy(this.positionList, 0, newList, 0, this.positionList.length);
            this.positionList = newList;
        }
        int i = start;
        for (int x = 0; x < size; ++x) {
            list[x] = buffs[i];
            this.positionList[i] = buffs[i].position();
            ++i;
        }
        this.setPendingStart(stop);
        return list;
    }

    private boolean resetWriteBuffers() {
        int stop = this.getPendingStop();
        WsByteBuffer[] list = this.getPendingBuffers();
        if (null == this.positionList || null == list) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error in resetBuffers: posList: " + this.positionList + " list: " + list);
            }
            this.getTSC().getWriteInterface().setBuffer(null);
            return false;
        }
        for (int i = 0; i < stop; ++i) {
            list[i].position(this.positionList[i]);
        }
        this.getTSC().getWriteInterface().setBuffers(list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reset positions on (" + stop + ") write buffers");
        }
        return true;
    }

    protected void nowReconnectedAsync() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reconnected async for " + this);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting buffers (async) failed");
            }
            IOException ioe = new IOException("Failed reconnect");
            if (null != this.getAppWriteCallback()) {
                this.getAppWriteCallback().error(this.getVC(), ioe);
            } else {
                this.getLink().getDeviceLink().close(this.getVC(), ioe);
            }
            return;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        this.resetRead();
        VirtualConnection rc = this.getTSC().getWriteInterface().write(-1L, HttpOSCWriteCallback.getRef(), this.isForceAsync(), this.getWriteTimeout());
        if (null != rc) {
            if (!this.isMessageSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling callback.complete of app channel.");
                }
                this.getAppWriteCallback().complete(this.getLink().getVirtualConnection());
            } else {
                if (this.isReadAheadEnabled()) {
                    this.bReadAheadEnabled = false;
                }
                this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
                this.getTSC().getReadInterface().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
            }
        }
    }

    protected void nowReconnectedSync(IOException originalExcep) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reconnected sync for " + this);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting buffers (sync) failed");
            }
            throw originalExcep;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        if (this.isReadAheadEnabled()) {
            this.bReadAheadEnabled = false;
        }
        try {
            this.getTSC().getWriteInterface().write(-1L, this.getWriteTimeout());
        }
        catch (IOException ioe) {
            this.setPersistent(false);
            throw ioe;
        }
    }

    public boolean disallowRewrites() {
        boolean rc = this.getLink().disallowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Rewrites disabled: " + rc);
        }
        return rc;
    }

    public boolean allowRewrites() {
        boolean rc = this.getLink().allowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Rewrites enabled: " + rc);
        }
        return rc;
    }

    public boolean isInboundConnection() {
        return false;
    }

    protected boolean isCompressionAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isCompressionAllowed");
        }
        boolean rc = true;
        if (!this.getRequest().getVersionValue().equals(VersionValues.V11)) {
            boolean bl = rc = !this.isPartialBody();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isCompressionAllowed: " + rc);
        }
        return rc;
    }

    private VirtualConnection startEarlyRead(InterChannelCallback cb, boolean forceQueue) {
        this.getLink().disallowRewrites();
        this.setAppReadCallback(cb);
        if (this.headersParsed() && !this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "earlyRead: Final response already received.");
            }
            if (forceQueue) {
                cb.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "earlyRead: Message exists, isOwner: " + this.isResponseOwner());
            }
            this.resetMsgParsedState();
            if (!this.isResponseOwner()) {
                this.setMyResponse(null);
                this.getResponseImpl();
            } else {
                this.getResponseImpl().clear();
            }
        }
        VirtualConnection vc = this.parseResponseMessageAsync();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "earlyRead: return vc=" + vc);
        }
        if (null != vc && forceQueue) {
            cb.complete(this.getVC());
            return null;
        }
        return vc;
    }

    public VirtualConnection readNextResponse(InterChannelCallback cb, boolean forceQueue) {
        if (null == cb) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readNext: Invalid null callback as input.");
            }
            throw new NullPointerException("Null callback");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel requesting next response on " + this.getVC());
            Tr.debug(tc, "Async forcequeue flag is " + forceQueue);
        }
        this.bTempResponsesUsed = true;
        return this.startEarlyRead(cb, forceQueue);
    }

    public void registerEarlyRead(InterChannelCallback cb) {
        if (null == cb) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "registerEarlyRead: Invalid null callback as input.");
            }
            throw new IllegalArgumentException("Callback is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel requesting early response read on " + this.getVC());
        }
        this.bEarlyReads = true;
        this.startEarlyRead(cb, true);
    }

    public boolean deregisterEarlyRead() {
        if (!this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "User tried to deregister non-existent early read");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "User deregistering early read interest");
        }
        this.bEarlyReads = false;
        super.cancelOutstandingRead();
        if (this.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error: full request already sent");
            }
            return false;
        }
        return true;
    }

    protected boolean isEarlyRead() {
        return this.bEarlyReads;
    }

    public void readAsyncResponse() {
        VirtualConnection vc = null;
        if (!this.isReadDataAvailable() && null == this.getNextReadBuffer()) {
            this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            vc = this.getTSC().getReadInterface().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readAsyncResponse found existing data");
            }
            vc = this.getVC();
        }
        if (null != vc && null != this.parseResponseMessageAsync()) {
            this.handleParsedMessage();
        }
    }

    public void readSyncResponse() throws IOException {
        do {
            this.parseResponseMessageSync();
            int code = this.getResponse().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readSyncReponse: code is " + code);
            }
            if (this.isImmediateReadEnabled()) {
                return;
            }
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                return;
            }
            if (this.bTempResponsesUsed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "readSyncResponse: using temp response");
                }
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != code) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expect 100-continue failed with " + code);
                    }
                    this.setPersistent(false);
                    throw new ExpectationFailedException(code + " " + this.getResponseImpl().getReasonPhrase());
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    this.resetRead();
                    return;
                }
            }
            this.resetRead();
        } while (this.numberResponsesReceived() <= this.getHttpConfig().getLimitOnNumberOfResponses());
        this.setPersistent(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readSyncResponse: too many responses: " + this.numberResponsesReceived());
        }
        throw new IOException("Max temp responses received: " + this.numberResponsesReceived());
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    private final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    private final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setRequest(HttpRequestMessage msg) throws IllegalRequestObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequest: " + msg);
        }
        if (null == msg) {
            throw new IllegalRequestObjectException("Illegal null message");
        }
        HttpRequestMessageImpl temp = null;
        try {
            temp = (HttpRequestMessageImpl)msg;
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non msg impl passed to setRequest");
            }
            throw new IllegalRequestObjectException("Invalid message provided");
        }
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            if (!this.getMyRequest().equals(temp)) {
                this.getMyRequest().destroy();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Caller overlaying same message");
            }
        }
        this.setMyRequest(temp);
        VersionValues version = temp.getVersionValue();
        this.getMyRequest().init(this);
        this.getMyRequest().setVersion(version);
        this.updatePersistence(this.getMyRequest());
        this.getResponseImpl().setHeaderChangeLimit(this.getMyRequest().getHeaderChangeLimit());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequest");
        }
    }

    public void sendRequestHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(sync)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.setPartialBody(true);
        this.getLink().setAllowReconnect(true);
        try {
            this.sendHeaders(this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (this.shouldReadResponseImmediately()) {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(sync)");
        }
    }

    public VirtualConnection sendRequestHeaders(InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(async)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.setPartialBody(true);
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendHeaders(this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != vc && this.shouldReadResponseImmediately()) {
            vc = this.startResponseRead();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(async): " + vc);
        }
        return vc;
    }

    public void sendRequestBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendOutgoing(body, this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(sync)");
        }
    }

    public VirtualConnection sendRequestBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendOutgoing(body, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(async): " + vc);
        }
        return vc;
    }

    public void sendRawRequestBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawRequestBody(sync)");
        }
        this.setRawBody(true);
        this.sendRequestBody(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawRequestBody(sync)");
        }
    }

    public VirtualConnection sendRawRequestBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawRequestBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.sendRequestBody(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawRequestBody(async): " + vc);
        }
        return vc;
    }

    public void finishRequestMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendFullOutgoing(body, this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "finishRequestMessage(sync): early read is active");
            }
            return;
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Response headers already parsed");
            }
            if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishRequestMessage(sync): already parsed");
                }
                return;
            }
            this.resetRead();
            this.readSyncResponse();
        } else {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRequestMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bForce);
        this.getLink().setAllowReconnect(true);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendFullOutgoing(body, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request write completed immediately.");
            }
            if (this.bEarlyReads) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishRequestMessage(async): early read is active");
                }
                return this.getVC();
            }
            if (this.headersParsed()) {
                if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "finishRequestMessage(async): already parsed");
                    }
                    return this.getVC();
                }
                this.resetRead();
                this.readAsyncResponse();
                vc = null;
            } else {
                vc = this.startResponseRead();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(async): " + vc);
        }
        return vc;
    }

    public void finishRawRequestMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawRequestMessage(sync)");
        }
        this.setRawBody(true);
        this.finishRequestMessage(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRawRequestMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawRequestMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.finishRequestMessage(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawRequestMessage(async)");
        }
        return vc;
    }

    private HttpInvalidMessageException checkRequestValidity() {
        if (this.shouldReadResponseImmediately()) {
            return null;
        }
        int len = this.getRequest().getContentLength();
        int num = this.getNumBytesWritten();
        if (-1 != len && num != len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request had content-length of " + len + " but sent " + num);
            }
            this.setPersistent(false);
            return new HttpInvalidMessageException("Request length " + len + " but sent " + num);
        }
        return null;
    }

    protected void handleParsedMessage() {
        InterChannelCallback cb = null;
        cb = this.bEarlyReads || this.bTempResponsesUsed ? this.getAppReadCallback() : this.getAppWriteCallback();
        VirtualConnection vc = null;
        do {
            ++this.numResponsesReceived;
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying app channel of final response.");
                }
                cb.complete(this.getVC());
                return;
            }
            int code = this.getResponseImpl().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received response (#" + this.numberResponsesReceived() + "): " + code);
            }
            if (this.numberResponsesReceived() > this.getHttpConfig().getLimitOnNumberOfResponses()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Too many async temp responses received.");
                }
                cb.error(this.getVC(), new IOException("Max temp responses received: " + this.numberResponsesReceived()));
                return;
            }
            if (this.bTempResponsesUsed) {
                cb.complete(this.getVC());
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != code) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expect 100-continue failed with " + code);
                    }
                    this.setPersistent(false);
                    cb.error(this.getVC(), new ExpectationFailedException(code + " " + this.getResponseImpl().getReasonPhrase()));
                    return;
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Notifying channel of first 100-continue");
                    }
                    cb.complete(this.getVC());
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring temporary response...");
            }
            this.resetRead();
            vc = this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false) ? this.getVC() : this.getTSC().getReadInterface().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout());
            if (null == vc) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting a parse of response data.");
            }
            vc = this.parseResponseMessageAsync();
        } while (null != vc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualConnection startResponseRead() {
        HttpInvalidMessageException inv;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startResponseRead");
        }
        if (null != (inv = this.checkRequestValidity())) {
            this.getAppWriteCallback().error(this.getVC(), inv);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: error");
            }
            return null;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int state = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                state = this.getCallbackState();
                this.setReadState(4);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Async response read, callback state: " + state);
            }
            switch (state) {
                case 4: {
                    this.readAsyncResponse();
                    break;
                }
                case 2: {
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), this.readException);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected state (" + state + ") during async readahead");
                    }
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), new IOException("Read-ahead state failure"));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: read-ahead");
            }
            return null;
        }
        if (this.bEarlyReads || this.bTempResponsesUsed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: temp resp env");
            }
            this.getAppWriteCallback().complete(this.getVC());
            return null;
        }
        this.getResponseImpl();
        this.readAsyncResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startResponseRead");
        }
        return null;
    }

    VirtualConnection parseResponseMessageAsync() {
        VirtualConnection readVC = null;
        try {
            do {
                if (this.parseMessage()) {
                    return this.getVC();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading for more data to parse");
                }
                this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (readVC = this.getTSC().getReadInterface().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout())));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while parsing response: " + e);
            }
            this.setPersistent(false);
            if (this.bEarlyReads || this.bTempResponsesUsed) {
                this.getAppReadCallback().error(this.getVC(), e);
            } else {
                this.getAppWriteCallback().error(this.getVC(), e);
            }
            return null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private void parseResponseMessageSync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResponseReadSync() throws IOException {
        HttpInvalidMessageException inv;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startResponseReadSync");
        }
        if (null != (inv = this.checkRequestValidity())) {
            throw inv;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int state = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                state = this.getCallbackState();
                this.setReadState(3);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Sync response read, callback state: " + state);
            }
            switch (state) {
                case 4: {
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read-ahead reports previous failure");
                    }
                    if (null == this.readException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Callback indicates error but no exception");
                        }
                        throw new IOException("Bad read-ahead state");
                    }
                    throw this.readException;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for read-ahead to finish");
                    }
                    while (1 == this.getCallbackState()) {
                        try {
                            object = this.readAheadSyncer;
                            synchronized (object) {
                                this.readAheadSyncer.wait(2 * this.getHttpConfig().getReadTimeout());
                            }
                        }
                        catch (InterruptedException ie) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Read-ahead block wait timed out");
                        }
                    }
                    if (null == this.readException) break;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read-ahead reports new failure");
                    }
                    throw this.readException;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected state (" + state + ") during sync readahead");
                    }
                    throw new IOException("Read-ahead state failure: " + state);
                }
            }
        }
        this.getResponseImpl();
        this.readSyncResponse();
    }

    private boolean checkBodyValidity() throws IOException {
        if (this.isImmediateReadEnabled() || this.bEarlyReads) {
            if (!this.headersParsed()) {
                IOException ioe = new IOException("Request headers not sent yet");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempt to read response prior to sendRequest");
                }
                throw ioe;
            }
        } else if (!this.isMessageSent()) {
            IOException ioe = new IOException("Request not finished yet");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read response prior to finishRequest");
            }
            throw ioe;
        }
        return this.isIncomingBodyValid();
    }

    public WsByteBuffer[] getResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getResponseBodyBuffers(sync)");
            }
            if (!this.checkBodyValidity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(sync): No body allowed");
                }
                return null;
            }
            this.setMultiRead(true);
            if (!this.isBodyComplete()) {
                try {
                    this.readBodyBuffers(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getResponseBodyBuffers(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException ihe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Unexpected exception: " + ihe);
                }
            }
        }
        WsByteBuffer[] buffers = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffers(sync): " + (null == buffers ? 0 : buffers.length));
        }
        return buffers;
    }

    public VirtualConnection getResponseBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffers(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(async): read not needed");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            callback.error(this.getVC(), ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffers(async): error=" + ioe);
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffers(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(async): read already");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodybuffers(async): exception: " + ioe);
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffer(sync)");
        }
        if (!this.checkBodyValidity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer retVal = this.getNextBuffer();
        if (null == retVal && !this.isBodyComplete()) {
            block9: {
                try {
                    this.readBodyBuffer(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getResponseBodyBuffer(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException ihe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Unexpected exception: " + ihe);
                }
            }
            retVal = this.getNextBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffer(sync): " + retVal);
        }
        return retVal;
    }

    public VirtualConnection getResponseBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffer(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffer(async): read not needed");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            callback.error(this.getVC(), ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): error " + ioe);
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffer(async): read finished");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): exception: " + ioe);
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer buffer = this.getResponseBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffer(sync): " + buffer);
        }
        return buffer;
    }

    public WsByteBuffer[] getRawResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] list = this.getResponseBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffers(sync): " + list);
        }
        return list;
    }

    public VirtualConnection getRawResponseBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getResponseBodyBuffer(callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffer(async): " + vc);
        }
        return vc;
    }

    public VirtualConnection getRawResponseBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getResponseBodyBuffers(callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffers(async): " + vc);
        }
        return vc;
    }

    protected boolean readUntilEnd(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called readUntilEnd");
        }
        if (!this.isReadDataAvailable()) {
            try {
                if (this.fillABuffer(1, async, false)) {
                    return true;
                }
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception: " + ioe);
                }
                return false;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "End of body found in new buffer");
                }
                return false;
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Current body buffer " + this.getReadBuffer());
        }
        if (0 == position && limit == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Return a full buffer");
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.setReadBuffer(null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slice the return buffer");
            }
            this.storeTempBuffer(this.getReadBuffer().slice());
            this.getReadBuffer().position(limit);
        }
        return false;
    }

    protected final HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getResponseImpl();
    }

    protected final HttpBaseMessageImpl getMessageBeingSent() {
        return this.getRequestImpl();
    }

    public final HttpOutboundLink getLink() {
        return this.myLink;
    }

    private final void setLink(HttpOutboundLink link) {
        this.myLink = link;
    }

    protected boolean reconnectAllowed() {
        return this.getLink().isReconnectAllowed();
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.getLink() ? null : this.getLink().getObjectFactory();
    }

    protected WsByteBuffer createChunkHeader(byte[] length) {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkHeader(length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OSC creating chunk length buffer");
        }
        WsByteBuffer header = this.allocateBuffer(32);
        header.put(length);
        header.put(BNFHeaders.EOL);
        header.flip();
        return header;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkTrailer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OSC creating chunk trailer");
        }
        WsByteBuffer buffer = this.allocateBuffer(32);
        buffer.put(CHUNK_TRAILER_DATA);
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerReadAhead(InterChannelCallback cb, int timeout) {
        int myState;
        int state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read-ahead requested (timeout=" + timeout + ") " + this.getVC());
        }
        if (-1 > timeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid timeout used by caller.");
            }
            return false;
        }
        Object object = this.stateSyncObject;
        synchronized (object) {
            state = this.getCallbackState();
            myState = this.getReadState();
            this.setCallbackState(1, null);
        }
        if (0 != state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback state is invalid: " + state);
            }
            return false;
        }
        if (0 != myState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read for response state is invalid: " + myState);
            }
            return false;
        }
        this.bReadAheadEnabled = true;
        int time = -1 == timeout ? this.getReadTimeout() : timeout;
        this.setAppReadCallback(cb);
        this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
        this.getTSC().getReadInterface().read(1L, HttpOSCReadAhead.getRef(), true, time);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel called init: " + this);
        }
        int cbState = 0;
        int myState = 0;
        if (this.isReadAheadEnabled()) {
            this.getReadCancel().init();
            if (!super.cancelOutstandingRead()) {
                this.getReadCancel().clear();
                return false;
            }
            if (!this.getReadCancel().block(2000L)) {
                return false;
            }
            Object object = this.stateSyncObject;
            synchronized (object) {
                cbState = this.getCallbackState();
                myState = this.getReadState();
                this.setReadState(1);
            }
        }
        if (0 == cbState) {
            return true;
        }
        if (1 != cbState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback state indicates error: " + cbState);
            }
            return false;
        }
        if (0 != myState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read for response state indicates error: " + myState);
            }
            return false;
        }
        return true;
    }

    protected int getCallbackState() {
        return this.callback_state;
    }

    protected void setCallbackState(int state, IOException ioe) {
        this.callback_state = state;
        this.readException = ioe;
    }

    protected int getReadState() {
        return this.read_state;
    }

    protected void setReadState(int state) {
        this.read_state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Received synchronous read-ahead wake-up call.");
        }
        Object object = this.readAheadSyncer;
        synchronized (object) {
            this.readAheadSyncer.notify();
        }
    }

    private int numberResponsesReceived() {
        return this.numResponsesReceived;
    }

    private boolean isReadAheadEnabled() {
        return this.bReadAheadEnabled;
    }

    protected boolean isImmediateReadEnabled() {
        return this.bImmediateRead;
    }

    public boolean enableImmediateResponseRead() {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request hdrs already sent, too late for immediate read");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Immediate response read requested: " + this.getVC());
        }
        this.bImmediateRead = true;
        return true;
    }

    protected boolean shouldReadResponseImmediately() {
        return this.isImmediateReadEnabled() || this.getRequestImpl().isExpect100Continue() || this.getRequestImpl().containsHeader(HttpHeaderKeys.HDR_UPGRADE);
    }

    public boolean cancelOutstandingRead() {
        this.disallowRewrites();
        return super.cancelOutstandingRead();
    }

    public boolean cancelOutstandingWrite() {
        this.disallowRewrites();
        return super.cancelOutstandingWrite();
    }

    public HttpAddress getTargetAddress() {
        return this.myLink.getTargetAddress();
    }
}

