/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.Http100ContWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCBodyReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteErrorCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.values.impl.ReturnCodes;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpPlatformUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class HttpInboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpInboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpInboundServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String CLASS_NAME = HttpInboundServiceContextImpl.class.getName();
    private static final String HTTP_ERROR_IDENTIFIER = "Http Error ID";
    private HttpInboundLink myLink = null;
    private boolean bCheckedAcceptEncoding = false;
    private boolean bCompressionAllowed = false;
    private boolean bIsRequestFormData = false;
    private boolean bContainsLargeMessage = false;

    public HttpInboundServiceContextImpl(TCPConnectionContext tsc, HttpInboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        this.init(tsc, link, vc, hcc);
    }

    public void init(TCPConnectionContext tsc, ConnectionLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing ISC: " + this);
        }
        super.init(tsc, hcc);
        this.setBodyRC(HttpISCBodyReadCallback.getRef());
        this.myLink = (HttpInboundLink)link;
        this.setVC(vc);
        vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPISC, this);
        this.getRequestImpl().initScheme();
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying ISC: " + this);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPISC);
        this.getVC().getStateMap().remove(HTTP_ERROR_IDENTIFIER);
        this.myLink = null;
        super.destroy();
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing ISC: " + this);
        }
        super.clear();
        this.bCheckedAcceptEncoding = false;
        this.bIsRequestFormData = false;
        this.bContainsLargeMessage = false;
        this.getVC().getStateMap().remove("HTTPFinalWrite");
    }

    protected void updatePersistence(HttpBaseMessageImpl msg) {
        if (this.myLink.maxRequestsServed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Max requests already processed on this connection");
            }
            this.setPersistent(false);
        } else if (this.getResponse().getStatusCode().isErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error status code disabling persistence.");
            }
            this.setPersistent(false);
        } else {
            super.updatePersistence(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePersistence(inbound) updated: " + this.isPersistent());
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessage msg) {
        if (!this.getRequestImpl().getMethodValue().equals(MethodValues.HEAD)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Body not valid on response, fixing headers");
            }
            if (0 < msg.getContentLength()) {
                msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            }
            msg.setTransferEncoding(TransferEncodingValues.NOTSET);
        }
    }

    private int skipWhiteSpace(byte[] data, int start) {
        int index;
        for (index = start; index < data.length && (32 == data[index] || 9 == data[index]); ++index) {
        }
        return index;
    }

    private ReturnCodes parseQValue(byte[] data, int start) {
        ReturnCodes rc = new ReturnCodes(false);
        int len = data.length;
        int index = this.skipWhiteSpace(data, start);
        if (index >= len || 113 != data[index] && 81 != data[index]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non qvalue found");
            }
            rc.setIntValue(index);
            return rc;
        }
        ++index;
        if ((index = this.skipWhiteSpace(data, index)) >= len || 61 != data[index]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Qvalue missing equals");
            }
            rc.setIntValue(index);
            return rc;
        }
        ++index;
        if ((index = this.skipWhiteSpace(data, index)) < len && (49 == data[index] || 48 == data[index])) {
            boolean leadingOne = 49 == data[index];
            rc.setBooleanValue(leadingOne);
            if (++index < len && 44 != data[index]) {
                if (32 == data[index] || 9 == data[index]) {
                    if ((index = this.skipWhiteSpace(data, index)) < len && 44 != data[index]) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid char after trailing whitespace (1) [" + data[index] + "]");
                        }
                        rc.setBooleanValue(false);
                    }
                } else if (46 != data[index]) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Non-period found after leading digit");
                    }
                    rc.setBooleanValue(false);
                } else {
                    int numDigits = 0;
                    while (++index < len && 44 != data[index] && 48 <= data[index] && 57 >= data[index]) {
                        ++numDigits;
                        if (48 == data[index]) continue;
                        if (leadingOne) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-zero after a leading one");
                            }
                            rc.setBooleanValue(false);
                            break;
                        }
                        rc.setBooleanValue(true);
                    }
                    if (3 < numDigits) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Too many digits in float (" + numDigits + ")");
                        }
                        rc.setBooleanValue(false);
                    } else if (index < len && 44 != data[index]) {
                        if (32 == data[index] || 9 == data[index]) {
                            ++index;
                            if ((index = this.skipWhiteSpace(data, index)) < len && 44 != data[index]) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Invalid char after trailing whitespace (2) [" + data[index] + "]");
                                }
                                rc.setBooleanValue(false);
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Invalid char after number [" + data[index] + "]");
                            }
                            rc.setBooleanValue(false);
                        }
                    }
                }
            }
        }
        rc.setIntValue(index);
        return rc;
    }

    protected boolean isCompressionAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isCompressionAllowed");
        }
        if (this.bCheckedAcceptEncoding) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isCompressionAllowed(1): " + this.bCompressionAllowed);
            }
            return this.bCompressionAllowed;
        }
        boolean rc = false;
        byte[] name = null;
        if (this.isGZipEncoded() || this.isXGZipEncoded()) {
            name = ContentEncodingValues.GZIP.getByteArray();
        } else if (this.isZlibEncoded()) {
            name = ContentEncodingValues.DEFLATE.getByteArray();
        } else {
            this.bCheckedAcceptEncoding = true;
            this.bCompressionAllowed = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isCompressionAllowed(2): false");
            }
            return false;
        }
        int index = 0;
        boolean bStarFound = false;
        boolean bStarApproved = false;
        byte[] data = this.getRequest().getHeaderAsByteArray(HttpHeaderKeys.HDR_ACCEPT_ENCODING);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isCompressionAllowed: parsing [" + this.getRequest().getHeaderAsString(HttpHeaderKeys.HDR_ACCEPT_ENCODING) + "] against requested [" + new String(name) + "]");
        }
        if (null != data) {
            while (index < data.length) {
                int x;
                ReturnCodes myRC;
                if ((index = this.skipWhiteSpace(data, index)) >= data.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ran out of data");
                    }
                    break;
                }
                if (42 == data[index]) {
                    bStarFound = true;
                    if (++index < data.length && 59 == data[index]) {
                        myRC = this.parseQValue(data, ++index);
                        bStarApproved = myRC.getBooleanValue();
                        index = GenericUtils.skipToChar(data, myRC.getIntValue(), (byte)44) + 1;
                        continue;
                    }
                    bStarApproved = true;
                    continue;
                }
                if (index < data.length && (120 == data[index] || 88 == data[index])) {
                    if (++index < data.length && 45 == data[index]) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "skipping past [x-]");
                        }
                        ++index;
                    } else {
                        --index;
                    }
                }
                for (x = 0; x < name.length && index < data.length && (name[x] == data[index] || GenericUtils.reverseCase(name[x]) == data[index]); ++x, ++index) {
                }
                if (x != name.length) {
                    index = GenericUtils.skipToChar(data, index, (byte)44) + 1;
                    continue;
                }
                if ((index = this.skipWhiteSpace(data, index)) < data.length && 44 == data[index]) {
                    rc = true;
                    break;
                }
                if (index < data.length && 59 == data[index]) {
                    myRC = this.parseQValue(data, ++index);
                    rc = myRC.getBooleanValue();
                    break;
                }
                if (index >= data.length) {
                    rc = true;
                    break;
                }
                index = GenericUtils.skipToChar(data, index, (byte)44) + 1;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Accept-Encoding header not present");
            }
            rc = true;
        }
        if (!rc && bStarFound && bStarApproved) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No explicit match, but wildcard was found");
            }
            rc = true;
        }
        this.bCheckedAcceptEncoding = true;
        this.bCompressionAllowed = rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isCompressionAllowed(3): " + rc);
        }
        return rc;
    }

    public boolean isIncomingMessageFullyRead() {
        if (!this.isBodyComplete()) {
            return !super.isIncomingBodyExpected();
        }
        return true;
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    protected final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
            this.getMyRequest().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    protected final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setResponse(HttpResponseMessage msg) throws IllegalResponseObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponse: " + msg);
        }
        if (null == msg) {
            throw new IllegalResponseObjectException("Illegal null message");
        }
        HttpResponseMessageImpl temp = null;
        try {
            temp = (HttpResponseMessageImpl)msg;
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non msg impl passed to setResponse");
            }
            throw new IllegalResponseObjectException("Invalid message provided");
        }
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            if (!this.getMyResponse().equals(temp)) {
                this.getMyResponse().destroy();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Caller overlaying same message");
            }
        }
        this.setMyResponse(temp);
        this.getMyResponse().init(this);
        this.getMyResponse().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
        this.updatePersistence(this.getMyResponse());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setResponse");
        }
    }

    public void sendResponseHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseHeaders(sync)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".sendResponseHeaders", "594");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw ioe;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.sendHeaders(this.getResponseImpl());
        if (this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
    }

    public VirtualConnection sendResponseHeaders(InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseHeaders(async)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".sendResponseHeaders", "639");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            callback.error(this.getVC(), ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendReponseHeaders(async): no request");
            }
            return null;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendHeaders(this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != vc && this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseHeaders(async): " + vc);
        }
        return vc;
    }

    public void sendResponseBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseBody(body)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".sendResponseBody", "684");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw ioe;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "sendBody() setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.sendOutgoing(body, this.getResponseImpl());
    }

    public VirtualConnection sendResponseBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseBody(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".sendResponseBody", "746");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "sendBody(cb) setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        return this.sendOutgoing(body, this.getResponseImpl(), HttpISCWriteCallback.getRef());
    }

    public void sendRawResponseBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawResponseBody(sync)");
        }
        this.setRawBody(true);
        this.sendResponseBody(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawResponseBody(sync)");
        }
    }

    public VirtualConnection sendRawResponseBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawResponseBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.sendResponseBody(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawResponseBody(async): " + vc);
        }
        return vc;
    }

    protected HttpInvalidMessageException checkResponseValidity() {
        if (!MethodValues.HEAD.equals(this.getRequest().getMethodValue())) {
            int len = this.getResponse().getContentLength();
            int num = this.getNumBytesWritten();
            if (-1 != len && num != len) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Response had content-length of " + len + " but sent " + num);
                }
                if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.ERROR)) {
                    this.getHttpConfig().getDebugLog().log(DebugLog.Level.ERROR, "Mismatch in content-length and bytes written: " + len + " but sent " + num, (HttpServiceContext)this);
                }
                this.setPersistent(false);
                return new HttpInvalidMessageException("Response length: " + len + " " + num);
            }
        }
        return null;
    }

    protected void logFinalResponse() {
        if (!this.getHttpConfig().getAccessLog().isStarted()) {
            return;
        }
        if (MethodValues.UNDEF.equals(this.getRequest().getMethodValue())) {
            return;
        }
        this.getHttpConfig().getAccessLog().log(this.getRequest(), this.getResponse(), this.getRequestVersion().getName(), null, this.getRemoteAddr().getHostAddress(), this.getNumBytesWritten());
    }

    public void finishResponseMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishResponseMessage(body)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".finishResponseMessage", "941");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw ioe;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finishMessage() setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.sendFullOutgoing(body, this.getResponseImpl());
        this.logFinalResponse();
        HttpInvalidMessageException inv = this.checkResponseValidity();
        if (null != inv) {
            throw inv;
        }
    }

    public VirtualConnection finishResponseMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishResponseMessage(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".finishResponseMessage", "1010");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finishMessage(cb) setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendFullOutgoing(body, this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != vc) {
            this.logFinalResponse();
            HttpInvalidMessageException inv = this.checkResponseValidity();
            if (null != inv) {
                callback.error(vc, inv);
                return null;
            }
        }
        return vc;
    }

    public void finishRawResponseMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawResponseMessage(sync)");
        }
        this.setRawBody(true);
        this.finishResponseMessage(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawResponseMessage(sync)");
        }
    }

    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] body, InterChannelCallback cb, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawResponseMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.finishResponseMessage(body, cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawResponseMessage(async): " + vc);
        }
        return vc;
    }

    public void sendError(HttpError error) throws MessageSentException {
        WsByteBuffer[] body;
        VirtualConnection rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called sendError with: " + error);
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".sendError", "1116");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            this.finishSendError(ioe);
            return;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (null == error) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset null error to Internal Server Error");
            }
            error = StatusCodes.INTERNAL_ERROR.getHttpError();
        }
        this.getResponse().setStatusCode(error.getErrorCode());
        if (this.getResponse().getStatusCode().isErrorCode()) {
            this.setPersistent(false);
        }
        this.getVC().getStateMap().put(HTTP_ERROR_IDENTIFIER, error);
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.ERROR)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.ERROR, "Sending an error status code: " + error.getErrorCode(), (HttpServiceContext)this);
        }
        if (null != (rc = this.finishResponseMessage(body = this.loadErrorBody(error, this.getMyRequest(), this.getResponse()), HttpISCWriteErrorCallback.getRef(), false))) {
            this.finishSendError(error.getClosingException());
        }
    }

    protected void finishSendError() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError: " + this.getVC());
        }
        HttpError error = (HttpError)this.getVC().getStateMap().get(HTTP_ERROR_IDENTIFIER);
        WsByteBuffer[] body = (WsByteBuffer[])this.getVC().getStateMap().remove("HttpChannel_ErrorPageService_Body");
        if (null != body) {
            for (int i = 0; i < body.length && null != body[i]; ++i) {
                body[i].release();
            }
        }
        if (null != error) {
            this.myLink.close(this.getVC(), error.getClosingException());
        } else {
            this.myLink.close(this.getVC(), null);
        }
    }

    protected void finishSendError(Exception e) {
        WsByteBuffer[] body;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError(exception): " + this.getVC());
        }
        if (null != (body = (WsByteBuffer[])this.getVC().getStateMap().remove("HttpChannel_ErrorPageService_Body"))) {
            for (int i = 0; i < body.length && null != body[i]; ++i) {
                body[i].release();
            }
        }
        this.myLink.close(this.getVC(), e);
    }

    protected boolean check100Continue() {
        if (!this.getRequest().isExpect100Continue()) {
            return true;
        }
        if (this.myLink.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, sending error instead of 100-continue");
            }
            try {
                this.sendError(StatusCodes.UNAVAILABLE.getHttpError());
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, CLASS_NAME + ".check100Continue", "1206");
            }
            return false;
        }
        if (this.getHttpConfig().isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "100 continue not sent on SR");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Request contains [Expect: 100-continue]");
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Request contains the Expect: 100 Continues header", (HttpServiceContext)this);
        }
        HttpResponseMessageImpl msg = this.getResponseImpl();
        msg.setStatusCode(StatusCodes.CONTINUE);
        msg.setContentLength(0);
        VirtualConnection vc = this.sendHeaders(msg, Http100ContWriteCallback.getRef());
        if (null == vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Async write of 100 continue still going");
            }
            return false;
        }
        this.resetMsgSentState();
        msg.setStatusCode(StatusCodes.OK);
        msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        return true;
    }

    public boolean isFormData() {
        return this.bIsRequestFormData;
    }

    protected boolean checkFormData() {
        return false;
    }

    protected void finishFormDataReads() {
        if (!this.isBodyComplete()) {
            try {
                this.getNextReadBuffer();
                if (this.readBodyBuffers(this.getRequestImpl(), true)) {
                    return;
                }
            }
            catch (BodyCompleteException bce) {
            }
            catch (Exception e) {
                this.formDataError(e);
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Body fully read: " + this.isBodyComplete());
        }
        this.myLink.handleDiscrimination();
    }

    protected void formDataError(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Closing the connection due to exception: " + e);
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "Closing connection to client: " + e, (HttpServiceContext)this);
        }
        if (e instanceof SocketTimeoutException) {
            try {
                this.sendError(StatusCodes.REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException mse) {
                this.myLink.getDeviceLink().close(this.getVC(), mse);
            }
        } else {
            this.myLink.getDeviceLink().close(this.getVC(), e);
        }
    }

    public void purgeBodyBuffers(boolean callClose) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Discarding body buffers...");
        }
        super.clearStorage();
        super.clearTempStorage();
        if (callClose) {
            this.myLink.close(this.getVC(), null);
        }
    }

    public WsByteBuffer[] getRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffers(sync)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".getRequestBodyBuffers", "1281");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            throw ioe;
        }
        if (!this.isIncomingBodyValid()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(sync): No body allowed");
            }
            return null;
        }
        WsByteBuffer[] buffers = null;
        this.setMultiRead(true);
        if (!this.isBodyComplete()) {
            try {
                this.readBodyBuffers(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffers(sync): BodyCompleteException");
                }
                return null;
            }
        }
        buffers = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffers(sync): " + (null == buffers ? 0 : buffers.length));
        }
        return buffers;
    }

    public VirtualConnection getRequestBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffers(async)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".getRequestBodyBuffers", "1355");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            callback.error(this.getVC(), ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): read not needed");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getRequestImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffers(async): read finished");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): exception:" + ioe);
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffer(sync)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".getRequestBodyBuffer", "1436");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            throw ioe;
        }
        if (!this.isIncomingBodyValid()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer buffer = this.getNextBuffer();
        if (null == buffer && !this.isBodyComplete()) {
            try {
                this.readBodyBuffer(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffer(sync): BodyCompleteException");
                }
                return null;
            }
            buffer = this.getNextBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffer(sync): " + buffer);
        }
        return buffer;
    }

    public VirtualConnection getRequestBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffer(async)");
        }
        if (!this.headersParsed()) {
            IOException ioe = new IOException("Request not read yet");
            FFDCFilter.processException(ioe, CLASS_NAME + ".getRequestBodyBuffer", "1511");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            callback.error(this.getVC(), ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): read not needed");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getRequestImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffer(async): read finished");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): exception: " + ioe);
            }
            callback.error(this.getVC(), ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer buffer = this.getRequestBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffer(sync): " + buffer);
        }
        return buffer;
    }

    public WsByteBuffer[] getRawRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] list = this.getRequestBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffers(sync): " + list);
        }
        return list;
    }

    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback cb, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getRequestBodyBuffer(cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffer(async): " + vc);
        }
        return vc;
    }

    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback cb, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getRequestBodyBuffers(cb, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffers(async): " + vc);
        }
        return vc;
    }

    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getRequestImpl();
    }

    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.getResponseImpl();
    }

    protected final void parsingComplete() throws Exception {
        super.parsingComplete();
        if (super.isContentLength()) {
            this.checkIncomingMessageLimit(super.getContentLength());
        }
    }

    protected boolean containsLargeMessage() {
        return this.bContainsLargeMessage;
    }

    protected void checkIncomingMessageLimit(int addition) throws MessageTooLargeException {
        super.addToIncomingMsgSize(addition);
        if (-1L == this.getHttpConfig().getMessageSizeLimit()) {
            return;
        }
        if (this.queryIncomingMsgSize() > this.getHttpConfig().getMessageSizeLimit()) {
            HttpInboundChannelFactory factory = this.myLink.getChannel().getFactory();
            if (factory.getConfig().areMessagesLimited() && factory.allowLargeMessage(this.queryIncomingMsgSize())) {
                this.bContainsLargeMessage = true;
            } else {
                throw new MessageTooLargeException("Size=" + this.queryIncomingMsgSize());
            }
        }
    }

    public final HttpInboundLink getLink() {
        return this.myLink;
    }

    protected boolean reconnectAllowed() {
        return false;
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.myLink ? null : this.myLink.getObjectFactory();
    }

    public boolean isInboundConnection() {
        return true;
    }

    public void logLegacyMessage() {
        HttpPlatformUtils utils;
        if (this.getHttpConfig().isControlRegion() && this.writingHeaders() && null != (utils = (HttpPlatformUtils)this.getHttpConfig().getCHFW().lookupService(HttpPlatformUtils.class))) {
            utils.logLegacyMessage(this);
        }
    }
}

