/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.util.ThreadPool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger
extends HttpServer {
    static String serverName;
    static String logFileName;

    public Logger(ThreadPool threadPool) {
        super(threadPool);
    }

    private static String getLogFilePath() {
        serverName = ServerName.getDisplayName();
        String logFilePath = System.getProperty("user.install.root");
        if (logFilePath == null || logFilePath.length() <= 0) {
            logFilePath = System.getProperty("was.install.root");
        }
        logFilePath = logFilePath + File.separator + "logs" + File.separator + serverName;
        return logFilePath;
    }

    private static String getLogFile(int type) {
        logFileName = type == 5 ? HttpServer.accessLog : HttpServer.errorLog;
        if (logFileName.equals("http_access.log") || logFileName.equals("http.log")) {
            logFileName = Logger.getLogFilePath() + File.separator + logFileName;
        }
        return logFileName;
    }

    public static void log(int levelType, String message) {
        PrintWriter logFile = levelType == 5 ? HttpServer.accessPw : HttpServer.errorPw;
        try {
            if (levelType == 5) {
                logFile.println(Logger.getDate() + " " + message);
            } else {
                Thread thread = Thread.currentThread();
                String t1 = thread.getName();
                String logLevel = HttpServer.logLevel;
                int logLevel_t = HttpServer.logLevel.equalsIgnoreCase("crit") ? 0 : (HttpServer.logLevel.equalsIgnoreCase("error") ? 1 : (HttpServer.logLevel.equalsIgnoreCase("warn") ? 2 : (HttpServer.logLevel.equalsIgnoreCase("info") ? 3 : (HttpServer.logLevel.equalsIgnoreCase("debug") ? 4 : 2))));
                logLevel = levelType == 0 ? "crit" : (levelType == 1 ? "error" : (levelType == 2 ? "warn" : (levelType == 3 ? "info" : (levelType == 4 ? "debug" : "warn"))));
                String mes = Logger.getDate() + t1 + " " + "[" + logLevel + "]" + " " + message;
                if (logLevel_t == 4) {
                    if (levelType == 4 || levelType == 3 || levelType == 2 || levelType == 1 || levelType == 0) {
                        logFile.println(mes);
                    }
                } else if (logLevel_t == 3) {
                    if (levelType == 3 || levelType == 2 || levelType == 1 || levelType == 0) {
                        logFile.print(mes);
                    }
                } else if (logLevel_t == 2) {
                    if (levelType == 2 || levelType == 1 || levelType == 0) {
                        logFile.println(mes);
                    }
                } else if (logLevel_t == 1) {
                    if (levelType == 1 || levelType == 0) {
                        logFile.println(mes);
                    }
                } else if (logLevel_t == 0) {
                    if (levelType == 0) {
                        logFile.println(mes);
                    }
                } else {
                    System.out.println("The LogLevel can only be debug, info, warn, error, or crit");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Could not write to the file: " + logFileName);
            e.printStackTrace();
        }
    }

    public static PrintWriter openFile(int logFileType) {
        try {
            logFileName = Logger.getLogFile(logFileType);
            FileOutputStream fos = new FileOutputStream(logFileName, true);
            PrintWriter printWriter = new PrintWriter(fos, true);
            return printWriter;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found : " + logFileName);
            e.printStackTrace();
            return null;
        }
    }

    private static String getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("[EEE MMM d, yyyy hh:mm:ss a]");
        Date currentTime = new Date();
        String date = formatter.format(currentTime);
        return date;
    }
}

