/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.http.ResponseStream;
import com.ibm.ws.io.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class HttpResponse {
    Logger logger;
    HttpServer httpserver;
    private static final TraceComponent tc = Tr.register(HttpResponse.class, "HTTP_Transport", null);
    protected HttpConnection connection;
    protected WriteStream outStream;
    protected ResponseStream responseStream;
    protected int status;
    protected String reason;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    protected boolean headersWritten;
    protected boolean isClosed;
    private int contentLength;
    protected String contentLengthString = "-";

    public HttpResponse(HttpConnection conn) {
        this.connection = conn;
        this.outStream = new WriteStream();
        this.responseStream = new ResponseStream();
    }

    public void init(WriteStream s) {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpResponse: Sending Response");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.responseStream.init(this, s);
        this.outStream.init(this.responseStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.status = 200;
        this.reason = null;
        this.responseStream.start();
        this.headersWritten = false;
        this.contentLength = -1;
        this.contentLengthString = "-";
        this.isClosed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean flush) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finish");
        }
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.responseStream.setFlushMode(false);
                this.outStream.flush();
                this.responseStream.setFlushMode(true);
                this.responseStream.finish(!this.connection.getAllowKeepAlive(), flush);
                if (this.contentLength >= 0 && this.responseStream.getNumBytesWritten() != this.contentLength) {
                    String errMsg = this.responseStream.getNumBytesWritten() + " response bytes written, but Content-Length header equals " + this.contentLength;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "finish", "invalid Content-Length header");
                    }
                    throw new IllegalStateException(errMsg);
                }
            }
            Object var4_3 = null;
            this.headerKeys.clear();
            this.headerValues.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.headerKeys.clear();
            this.headerValues.clear();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setReason(String msg) {
        this.reason = msg;
    }

    public String getReason() {
        if (this.reason != null) {
            return this.reason;
        }
        return StatusMessage.get(this.status);
    }

    public void sendContinue() throws IOException {
        this.responseStream.sendContinue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sendContinue");
        }
    }

    public void sendExtendedHandshake() throws IOException {
        this.responseStream.sendExtendedHandshake();
        this.isClosed = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sendExtendedHandshake");
        }
    }

    public boolean isCommitted() {
        return this.responseStream.isCommitted();
    }

    public void sendError(HttpException exc) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendError", exc);
        }
        this.sendError(exc.getCode(), exc.getMessage());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendError");
        }
    }

    public void sendError(int code, String message) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendError", message);
        }
        this.responseStream.clear();
        if (this.responseStream.isCommitted()) {
            throw new IllegalStateException("Response can't be sent");
        }
        this.setStatus(code);
        try {
            this.addHeader("Content-Type", "text/html");
            this.outStream.print("<HTML><TITLE>");
            this.outStream.print(this.status);
            this.outStream.print(" - ");
            this.outStream.print(StatusMessage.get(this.status));
            this.outStream.print("</TITLE><BODY><h1>");
            this.outStream.print(this.status);
            this.outStream.print(' ');
            this.outStream.print(this.encodeDataString(message));
            this.outStream.print("</h1></BODY></HTML>");
        }
        catch (Exception e) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0416E error sending error");
            }
            Tr.error(tc, "error sending error", e);
        }
        this.connection.setAllowKeepAlive(false);
        this.finish(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendError");
        }
    }

    public void addHeader(String field, String val) {
        if (field == null || val == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addHeader: header dropped due to NULL value", new Object[]{field, val});
            }
        } else {
            this.headerKeys.add(field);
            this.headerValues.add(val);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addHeader", new Object[]{field, val});
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outStream;
    }

    public WriteStream getStream() {
        return this.outStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.outStream.getPrintWriter();
    }

    boolean writeHeaders(WriteStream s, int length) throws IOException {
        HttpRequest request;
        int version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeHeaders", new Integer(length));
        }
        if ((version = (request = this.connection.getHttpRequest()).getVersion()) < 1000) {
            return false;
        }
        this.headersWritten = true;
        String method = request.getMethod();
        boolean isHead = method != null && method.equals("HEAD");
        boolean allowBody = this.status >= 200 && this.status != 204 && this.status != 304;
        if (isHead || !allowBody) {
            this.responseStream.setNoBody();
        }
        s.print(version >= 1000 ? "HTTP/1.1 " : "HTTP/1.0 ");
        s.write(this.status / 100 + 48);
        s.write(this.status / 10 % 10 + 48);
        s.write(this.status % 10 + 48);
        s.write(32);
        s.print(this.getReason());
        s.write(ResponseStream.CRLF);
        if (!this.headerKeys.contains("Server") && !this.connection.getHttpTransport().isRemoveServerHeader()) {
            this.writeMessageHeader(s, "Server", this.connection.getHttpTransport().getServerHeader());
        }
        boolean hasContentType = false;
        boolean hasChunkedTransferEncoding = false;
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            String key = (String)this.headerKeys.get(i);
            String val = (String)this.headerValues.get(i);
            if (!hasContentType && key.equalsIgnoreCase("content-type")) {
                hasContentType = true;
            } else if (key.equalsIgnoreCase("content-length")) {
                if (!allowBody) continue;
                if (!isHead) {
                    this.contentLength = Integer.parseInt(val);
                }
            } else if (key.equalsIgnoreCase("transfer-encoding")) {
                if (!allowBody) continue;
                if (val.equalsIgnoreCase("chunked")) {
                    hasChunkedTransferEncoding = true;
                }
            } else if (key.equalsIgnoreCase("server") && this.connection.getHttpTransport().isRemoveServerHeader()) continue;
            this.writeMessageHeader(s, key, val);
        }
        boolean isChunked = false;
        if (allowBody && !isHead && this.contentLength < 0 && !hasChunkedTransferEncoding) {
            if (length >= 0) {
                this.writeMessageHeader(s, "Content-Length", length);
                this.contentLength = length;
                this.contentLengthString = String.valueOf(length);
            } else if (version >= 1001) {
                s.print("Transfer-Encoding: chunked\r\n");
                isChunked = true;
            }
        }
        if (this.connection.shouldSignalClose()) {
            s.print("Connection: close\r\n");
        }
        s.write(ResponseStream.CRLF);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeHeaders", new Boolean(isChunked));
        }
        return isChunked;
    }

    private void writeMessageHeader(WriteStream s, String field, String value) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeMessageHeader", new Object[]{field, value});
        }
        s.print(field);
        s.write(58);
        s.write(32);
        s.print(value);
        s.write(ResponseStream.CRLF);
    }

    private void writeMessageHeader(WriteStream s, String field, int value) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeMessageHeader", new Object[]{field, new Integer(value)});
        }
        s.print(field);
        s.write(58);
        s.write(32);
        s.print(value);
        s.write(ResponseStream.CRLF);
    }

    public String encodeDataString(String iString) {
        if (iString == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encodeDataString input string is null");
            }
            return "";
        }
        boolean addLen = false;
        int strLen = iString.length();
        if (strLen < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encodeDataString input string length invalid [" + strLen + "]");
            }
            return iString;
        }
        StringBuffer retString = new StringBuffer(strLen * 2);
        block12: for (int i = 0; i < strLen; ++i) {
            switch (iString.charAt(i)) {
                case '<': {
                    retString.append("&lt;");
                    continue block12;
                }
                case '>': {
                    retString.append("&gt;");
                    continue block12;
                }
                case '&': {
                    retString.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    retString.append("&quot;");
                    continue block12;
                }
                case '+': {
                    retString.append("&#43;");
                    continue block12;
                }
                case '(': {
                    retString.append("&#40;");
                    continue block12;
                }
                case ')': {
                    retString.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    retString.append("&#39;");
                    continue block12;
                }
                case '%': {
                    retString.append("&#37;");
                    continue block12;
                }
                case ';': {
                    retString.append("&#59;");
                    continue block12;
                }
                default: {
                    retString.append(iString.charAt(i));
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeDataString: Input string [" + iString + "], encoded result is [" + retString.toString() + "]");
        }
        return retString.toString();
    }

    public void setFlushMode(boolean writeToWire) {
        this.responseStream.setFlushMode(writeToWire);
    }

    protected static class StatusMessage {
        public int status;
        public String message;
        private static StatusMessage[] messages = new StatusMessage[]{new StatusMessage(100, "Continue"), new StatusMessage(101, "Switching Protocols"), new StatusMessage(200, "OK"), new StatusMessage(201, "Created"), new StatusMessage(202, "Accepted"), new StatusMessage(203, "Non-Authoritative Information"), new StatusMessage(204, "No Content"), new StatusMessage(205, "Reset Content"), new StatusMessage(206, "Partial Content"), new StatusMessage(300, "Multiple Choices"), new StatusMessage(301, "Moved Perminantly"), new StatusMessage(302, "Found"), new StatusMessage(303, "See Other"), new StatusMessage(304, "Not Modified"), new StatusMessage(305, "Use Proxy"), new StatusMessage(307, "Temporary Redirect"), new StatusMessage(400, "Bad Request"), new StatusMessage(401, "Unauthorized"), new StatusMessage(402, "Payment Required"), new StatusMessage(403, "Forbidden"), new StatusMessage(404, "Not Found"), new StatusMessage(405, "Method Not Allowed"), new StatusMessage(406, "Not Acceptable"), new StatusMessage(407, "Proxy Authentication Required"), new StatusMessage(408, "Request Timeout"), new StatusMessage(409, "Conflict"), new StatusMessage(410, "Gone"), new StatusMessage(411, "Length Required"), new StatusMessage(412, "Precondition Failed"), new StatusMessage(413, "Request Entity Too Large"), new StatusMessage(414, "Request-URI Too Long"), new StatusMessage(415, "Unsupported Media Type"), new StatusMessage(416, "Requested Range Not Satisfiable"), new StatusMessage(417, "Expectation Failed"), new StatusMessage(500, "Internal Server Error"), new StatusMessage(501, "Not Implemented"), new StatusMessage(502, "Bad Gateway"), new StatusMessage(503, "Service Unavailable"), new StatusMessage(504, "Gateway Timeout"), new StatusMessage(505, "Http Version Not Supported")};

        public static String get(int code) {
            for (int i = 0; i < messages.length; ++i) {
                if (code != StatusMessage.messages[i].status) continue;
                return StatusMessage.messages[i].message;
            }
            return "Unknown";
        }

        public StatusMessage(int code, String msg) {
            this.status = code;
            this.message = msg;
        }
    }
}

