/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.ChunkedInputStream;
import com.ibm.ws.http.ContentLengthInputStream;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.http.MutableString;
import com.ibm.ws.io.ReadStream;
import com.ibm.ws.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class HttpRequest {
    public static final int HTTP_VERSION_09 = 9;
    public static final int HTTP_VERSION_10 = 1000;
    public static final int HTTP_VERSION_11 = 1001;
    public static final int DEFAULT_LIMIT_REQUEST_LINE = 8190;
    public static final int DEFAULT_LIMIT_REQUEST_FIELDSIZE = 8190;
    public static final int DEFAULT_LIMIT_REQUEST_FIELDS = 100;
    Logger logger;
    HttpServer httpserver;
    private static final String CONTENT_LENGTH = "Content-Length";
    private static TraceComponent tc = Tr.register(HttpRequest.class.getName(), "HTTP_Transport");
    private final Hashtable hdrNamesByMutableString = new Hashtable();
    private final Hashtable toLower = new Hashtable();
    private HttpConnection conn = null;
    private ReadStream rawStream = null;
    private ReadStream filterStream = new ReadStream();
    private ContentLengthInputStream contentLengthStream = null;
    private ChunkedInputStream chunkedInputStream = new ChunkedInputStream();
    private final MutableString mutableString = new MutableString();
    private boolean hasInputStream;
    protected String scheme;
    protected String method;
    protected String uri;
    protected String queryString;
    protected int version;
    protected String serverName;
    protected int serverPort;
    protected boolean wantToStayAlive;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    private CharBuffer buffer = new CharBuffer(8190);

    public HttpRequest(HttpConnection c) {
        this.conn = c;
        this.contentLengthStream = new ContentLengthInputStream(c);
    }

    public void init(ReadStream s) {
        this.rawStream = s;
    }

    public void start() {
        this.hasInputStream = false;
        this.scheme = null;
        this.method = null;
        this.uri = null;
        this.queryString = null;
        this.version = -1;
        this.serverName = null;
        this.serverPort = -1;
        this.wantToStayAlive = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finish " + this);
        }
        try {
            InputStream rs = this.getInputStream();
            int nLen = rs.available();
            if (nLen == 0) {
                nLen = rs.read();
            }
            if (nLen >= 0) {
                byte[] garbagebuff = new byte[16384];
                while (nLen >= 0) {
                    nLen = rs.read(garbagebuff, 0, garbagebuff.length);
                }
            }
        }
        finally {
            this.headerKeys.clear();
            this.headerValues.clear();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finish");
            }
        }
    }

    public HttpConnection getHttpConnection() {
        return this.conn;
    }

    public InputStream getInputStream() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream");
        }
        if (!this.hasInputStream) {
            this.hasInputStream = true;
            boolean isChunked = false;
            String transferEncoding = this.getHeader("Transfer-Encoding");
            if (transferEncoding != null) {
                String[] tokens = transferEncoding.split(",");
                for (int x = 0; x < tokens.length; ++x) {
                    if (!tokens[x].trim().equalsIgnoreCase("chunked")) continue;
                    isChunked = true;
                    break;
                }
            }
            if (this.getVersion() >= 1001 && isChunked) {
                this.chunkedInputStream.init(this, this.rawStream);
                this.filterStream.init(this.chunkedInputStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using ChunkedInputStream");
                }
            } else {
                this.contentLengthStream.init((InputStream)this.rawStream, this.getContentLength());
                this.filterStream.init(this.contentLengthStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using ContentLengthInputStream");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream");
        }
        return this.filterStream;
    }

    public boolean isProxied() {
        return false;
    }

    public String getScheme() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: getScheme = " + this.uri);
        }
        return this.scheme;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getProtocol() {
        if (this.version >= 1001) {
            return "HTTP/1.1";
        }
        return "HTTP/1.0";
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setVersion(int ver) {
        this.version = ver;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean wantsToStayAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: StayAlive = " + this.wantToStayAlive);
        }
        return this.wantToStayAlive;
    }

    public int getContentLength() {
        String cl = this.getHeader(CONTENT_LENGTH);
        int rtn = -1;
        if (cl != null) {
            rtn = Integer.parseInt(cl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getContentLength", new Integer(rtn));
        }
        return rtn;
    }

    public void setContentLength(int len) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength", new Integer(len));
        }
        this.setHeader(CONTENT_LENGTH, String.valueOf(len));
    }

    public String getHeader(String field) {
        String val;
        int idx = this.headerKeys.indexOf(this.toLower(field));
        String string = val = idx != -1 ? (String)this.headerValues.get(idx) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeader", new Object[]{field, val});
        }
        return val;
    }

    protected void setHeader(String field, String value) {
        int idx = this.headerKeys.indexOf(field = this.toLower(field));
        if (idx == -1) {
            this.addHeader(field, value);
        } else {
            this.headerValues.set(idx, value);
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: setHeader= " + new Object[]{field, value});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader", new Object[]{field, value});
        }
    }

    protected void addHeader(String field, String value) {
        this.headerKeys.add(field);
        this.headerValues.add(value);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addHeader", new Object[]{field, value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readRequest() throws HttpException {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: Reading Request");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRequest");
        }
        try {
            this.readRequestLine();
            this.readHeaders();
        }
        catch (IOException io) {
            if (io instanceof HttpException) {
                throw (HttpException)io;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reading the request line", io);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readRequest");
            }
        }
        return true;
    }

    private void readRequestLine() throws HttpException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRequestLine");
        }
        this.buffer.setLength(0);
        int ch = this.rawStream.read();
        while (ch == 13 || ch == 10) {
            ch = this.rawStream.read();
        }
        while (ch >= 0 && ch != 32 && ch != 10) {
            if (ch >= 97 && ch <= 122) {
                ch = ch - 97 + 65;
            }
            this.buffer.append((char)ch);
            ch = this.rawStream.read();
        }
        if (ch == -1 || this.buffer.length() == 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Bad Request Method, ch[" + ch + "], Buffer length[" + this.buffer.length() + "] value[" + this.buffer.toString() + "]");
            }
            throw new HttpException(400, "Invalid request");
        }
        this.method = this.buffer.toString();
        while (ch == 32) {
            ch = this.rawStream.read();
        }
        ch = this.readUri(this.buffer, ch);
        while (ch == 32) {
            ch = this.rawStream.read();
        }
        ch = this.readVersion(ch);
        if (this.version == 9) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0403E HTTP Version not supported");
            }
            throw new HttpException(505);
        }
        while (ch >= 0 && ch != 10 && ch != 13) {
            ch = this.rawStream.read();
        }
        if (ch == 13 && (ch = this.rawStream.read()) != 10) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Bad Request, Request line end invalid");
            }
            throw new HttpException(400);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readRequestLine");
        }
    }

    private void readHeaders() throws HttpException, IOException {
        String host;
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpRequest: readHeaders");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readHeaders");
        }
        int fieldsRead = 0;
        boolean hasContentLengthHeader = false;
        String key = null;
        String value = "";
        while (true) {
            this.buffer.setLength(0);
            try {
                this.rawStream.readLine(this.buffer);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0405E Exceeded size of header field");
                }
                throw new HttpException(400, "Size of header field exceeded.");
            }
            int len = this.buffer.length();
            if (len == 0) {
                if (key == null) break;
                this.addHeader(key, value);
                break;
            }
            if (++fieldsRead > 100) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0406E Exceeded number of headers. Default request fields 100");
                }
                throw new HttpException(400, "Number of headers exceeded");
            }
            int valueIdx = 0;
            char[] field = this.buffer.getValue();
            while (field[valueIdx] == ' ' || field[valueIdx] == '\t') {
                ++valueIdx;
            }
            if (valueIdx > 0) {
                value = new StringBuffer(value).append(' ').append(field, valueIdx, len - valueIdx).toString();
                continue;
            }
            if (key != null) {
                this.addHeader(key, value);
                key = null;
                value = "";
            }
            while (valueIdx < len && field[valueIdx] != ':') {
                ++valueIdx;
            }
            if (valueIdx == len) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0407E Bad Request");
                }
                throw new HttpException(400);
            }
            int headerLen = valueIdx++;
            while (field[valueIdx] == ' ' || field[valueIdx] == '\t') {
                ++valueIdx;
            }
            key = this.getHdrName(field, headerLen);
            if (key.equalsIgnoreCase(CONTENT_LENGTH)) {
                if (hasContentLengthHeader) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid request, multiple Content-Length headers.");
                    }
                    throw new HttpException(400);
                }
                hasContentLengthHeader = true;
            }
            value = new String(field, valueIdx, len - valueIdx);
        }
        if ((host = this.getHeader("Host")) != null) {
            int idx = host.indexOf(58);
            if (idx != -1) {
                this.serverName = host.substring(0, idx);
                int len = host.length();
            } else {
                this.serverName = host;
            }
        }
        if (this.version >= 1001 && host == null) {
            this.conn.setAllowKeepAlive(false);
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0408E Missing Host header");
            }
            throw new HttpException(400, "Missing Host header");
        }
        String clValue = this.getHeader(CONTENT_LENGTH);
        if (clValue != null) {
            try {
                int rtn = Integer.parseInt(clValue);
            }
            catch (NumberFormatException nfe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid request, Content-Length header value [" + clValue + "] is invalid");
                }
                throw new HttpException(411, "Invalid value for Content-Length header");
            }
        }
        this.wantToStayAlive = true;
        if (!this.isProxied()) {
            if (this.version >= 1001) {
                String conn = this.getHeader("Connection");
                if (conn != null && conn.equalsIgnoreCase("close")) {
                    this.wantToStayAlive = false;
                }
            } else {
                this.wantToStayAlive = false;
            }
        }
        if (this.scheme == null) {
            this.scheme = this.conn.getConnectionScheme();
        }
        if (this.serverName == null) {
            this.serverName = this.conn.getConnectionServerName();
        }
        if (this.serverPort == -1) {
            this.serverPort = this.conn.getConnectionServerPort();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readHeaders");
        }
    }

    private int readUri(CharBuffer buffer, int ch) throws HttpException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readUri");
        }
        buffer.setLength(0);
        while (ch != 47) {
            switch (ch) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0410E Bad Request");
                    }
                    throw new HttpException(400);
                }
            }
            buffer.append((char)ch);
            ch = this.rawStream.read();
        }
        int ch1 = this.rawStream.read();
        if (ch1 == 47 && buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == ':') {
            this.scheme = buffer.substring(0, buffer.length() - 1);
            ch = this.readHost(buffer);
            buffer.setLength(0);
        } else {
            buffer.append((char)ch);
            ch = ch1;
        }
        while (ch >= 0 && !this.isWhitespace(ch) && ch != 63) {
            buffer.append((char)ch);
            ch = this.rawStream.read();
        }
        if (buffer.length() == 0) {
            throw new HttpException(400);
        }
        this.uri = buffer.toString();
        if (ch == 63) {
            return this.readQuery(buffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readUri");
        }
        return ch;
    }

    private int readHost(CharBuffer buffer) throws IOException {
        int ch;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readHost");
        }
        buffer.setLength(0);
        block5: while ((ch = this.rawStream.read()) >= 0) {
            switch (ch) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0412E Bad Request");
                    }
                    throw new HttpException(400);
                }
                case 58: {
                    break block5;
                }
                case 47: {
                    break block5;
                }
                default: {
                    buffer.append((char)ch);
                    continue block5;
                }
            }
        }
        this.serverName = buffer.toString();
        if (ch == 58) {
            return this.readPort(buffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readHost");
        }
        return ch;
    }

    private int readPort(CharBuffer buffer) throws IOException {
        int ch;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPort");
        }
        this.serverPort = 0;
        while ((ch = this.rawStream.read()) >= 0) {
            if (ch == 47) {
                return ch;
            }
            if (ch >= 48 && ch <= 57) {
                this.serverPort = this.serverPort * 10 + ch - 48;
                continue;
            }
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0413E Bad Request");
            }
            throw new HttpException(400);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPort");
        }
        return ch;
    }

    private int readQuery(CharBuffer buffer) throws IOException {
        int ch;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readQuery");
        }
        buffer.setLength(0);
        while ((ch = this.rawStream.read()) >= 0 && !this.isWhitespace(ch)) {
            buffer.append((char)ch);
        }
        this.queryString = buffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readQuery");
        }
        return ch;
    }

    private char readUrlEscape() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readUrlEscape");
        }
        int h1 = this.toHex(this.rawStream.read());
        int h2 = this.toHex(this.rawStream.read());
        char rtn = (char)((h1 << 4) + h2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readUrlEscape", new Character(rtn));
        }
        return rtn;
    }

    private int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private int readVersion(int ch) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readVersion");
        }
        boolean idx = false;
        if (ch < 0 || this.isWhitespace(ch)) {
            this.version = 9;
            return ch;
        }
        this.version = 1000;
        while (ch >= 0 && ch != 47) {
            ch = this.rawStream.read();
        }
        int major = 0;
        while ((ch = this.rawStream.read()) >= 0) {
            if (ch >= 48 && ch <= 57) {
                major = major * 10 + ch - 48;
                continue;
            }
            if (ch == 46) break;
            return ch;
        }
        int minor = 0;
        while ((ch = this.rawStream.read()) >= 0 && ch >= 48 && ch <= 57) {
            minor = minor * 10 + ch - 48;
        }
        this.version = major * 1000 + minor;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readVersion");
        }
        return ch;
    }

    private boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 10 || ch == 13;
    }

    public void dump(PrintStream ps) {
        ps.print("scheme = ");
        ps.println(this.scheme);
        ps.print("method = ");
        ps.println(this.method);
        ps.print("uri = ");
        ps.println(this.uri);
        ps.print("query = ");
        ps.println(this.queryString);
        ps.print("version = ");
        ps.println(this.version);
        ps.print("serverName = ");
        ps.println(this.serverName);
        ps.print("serverPort = ");
        ps.println(this.serverPort);
        ps.println("Headers");
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            ps.print(this.headerKeys.get(i));
            ps.print(" : ");
            ps.println(this.headerValues.get(i));
        }
        ps.println("Reading data");
        try {
            int ch;
            InputStream is = this.getInputStream();
            while ((ch = is.read()) > 0) {
                ps.print((char)ch);
            }
        }
        catch (Throwable t) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0414E Couldn't get Input Stream");
            }
            t.printStackTrace(ps);
        }
        ps.println("Headers");
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            ps.print(this.headerKeys.get(i));
            ps.print(" : ");
            ps.println(this.headerValues.get(i));
        }
    }

    public void getHeaders(String[][] headers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeaders");
        }
        headers[0] = new String[this.headerKeys.size()];
        headers[1] = new String[this.headerKeys.size()];
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            headers[0][i] = (String)this.headerKeys.get(i);
            headers[1][i] = (String)this.headerValues.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeaders");
        }
    }

    public String getCookieValue(String cookieName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", cookieName);
        }
        try {
            String cookieMatch = cookieName.toLowerCase();
            for (int idx = 0; idx < this.headerKeys.size(); ++idx) {
                String hdrValue;
                int index;
                String hdrName = (String)this.headerKeys.get(idx);
                if (!hdrName.equalsIgnoreCase("COOKIE") || (index = (hdrValue = (String)this.headerValues.get(idx)).toLowerCase().indexOf(cookieMatch)) == -1) continue;
                StringTokenizer st = new StringTokenizer(hdrValue, ";,");
                while (st.hasMoreTokens()) {
                    String attr;
                    String currToken = st.nextToken().trim();
                    int theEquals = currToken.indexOf("=");
                    if (theEquals <= 0 || !(attr = currToken.substring(0, theEquals).trim()).equalsIgnoreCase(cookieMatch)) continue;
                    String value = currToken.substring(theEquals + 1);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCookieValue", value);
                    }
                    return value;
                }
            }
        }
        catch (Exception e) {
            Tr.error(tc, "can't get cookie value for " + cookieName, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", "null");
        }
        return null;
    }

    private String getHdrName(char[] name, int len) {
        this.mutableString.init(name, 0, len);
        String hdrName = (String)this.hdrNamesByMutableString.get(this.mutableString);
        if (hdrName == null) {
            hdrName = new String(name, 0, len).toLowerCase(Locale.US);
            this.hdrNamesByMutableString.put(new MutableString(name, 0, len), hdrName);
        }
        return hdrName;
    }

    private String toLower(String str) {
        String lower = (String)this.toLower.get(str);
        if (lower == null) {
            lower = str.toLowerCase(Locale.US);
            this.toLower.put(str, lower);
        }
        return lower;
    }
}

