/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.http.Logger;
import com.ibm.ws.io.ReadStream;
import com.ibm.ws.io.Stream;
import com.ibm.ws.io.WriteStream;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.TransportLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class HttpConnection
implements Runnable {
    protected HttpRequest request = this.createHttpRequest();
    protected HttpResponse response = this.createHttpResponse();
    protected static final int defaultWaitTime = 10;
    private static TraceComponent tc = Tr.register(HttpConnection.class.getName(), "HTTP_Transport");
    private static final String WAIT_PROPERTY = "com.ibm.ws.http.waitBeforeCloseTime";
    private HttpServer httpServer = null;
    private HttpTransport transport = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private Stream stream = new Stream();
    private ReadStream readStream = new ReadStream();
    private WriteStream writeStream = new WriteStream();
    private Socket socket = null;
    private boolean allowKeepAlive;
    private boolean isKeptAlive;
    private boolean shouldStayAlive;
    private boolean Allocated = false;
    private boolean Aborted = false;
    private int curKeepAliveRequests;
    private boolean waitBeforeClose = false;
    private int waitBeforeCloseTime = 10;
    Logger logger;
    HttpServer httpserver;

    public HttpConnection() {
        this.setWaitBeforeClose(WAIT_PROPERTY, false, 10);
    }

    protected void setWaitBeforeClose(String property, boolean waitDefault, int waitTimeDefault) {
        String waitBC = System.getProperty(property);
        this.waitBeforeClose = waitDefault;
        this.waitBeforeCloseTime = waitTimeDefault;
        try {
            int value = Integer.parseInt(waitBC);
            if (value == 0) {
                this.waitBeforeClose = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, property + " is disabled");
                }
            } else if (value > 0) {
                this.waitBeforeCloseTime = value;
                this.waitBeforeClose = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, property + " = " + this.waitBeforeCloseTime + "ms");
                }
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
    }

    public void init(HttpTransport transport, Socket socket) {
        this.transport = transport;
        this.socket = socket;
        this.setFlushMode(false);
        this.setAborted(false);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HttpTransport getHttpTransport() {
        return this.transport;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public String getConnectionScheme() {
        return this.transport.getScheme();
    }

    public String getConnectionServerName() {
        String sName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getLocalAddress().getHostName();
            }
        });
        if (sName == null || sName.equalsIgnoreCase("localhost")) {
            sName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (Throwable th) {
                        return null;
                    }
                }
            });
        }
        return sName;
    }

    public int getConnectionServerPort() {
        return this.socket.getLocalPort();
    }

    public String getConnectionRemoteHost() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getInetAddress().getHostName();
            }
        });
    }

    public String getConnectionRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getConnectionRemotePort() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Remote Port - ConnectionRemotePort " + this.socket.getPort());
        }
        return this.socket.getPort();
    }

    public String getConnectionLocalName() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getLocalAddress().getHostName();
            }
        });
    }

    public String getConnectionLocalAddr() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Local Address - ConnectionLocalAddress " + this.socket.getLocalAddress().getHostAddress());
        }
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getConnectionLocalPort() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Local Port - ConnectionLocalPort " + this.socket.getLocalPort());
        }
        return this.socket.getLocalPort();
    }

    public boolean isConnectionSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determining if Connection is Secure");
        }
        return this.transport.isSecure();
    }

    public java.security.cert.X509Certificate[] getConnectionPeerCertificates() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Peer Certificates (Client Certificates");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionPeerCertificates");
        }
        try {
            java.security.cert.X509Certificate[] chain = null;
            if (this.isConnectionSecure() && this.sslSocket().getNeedClientAuth()) {
                X509Certificate[] objs = null;
                try {
                    objs = this.sslSocket().getSession().getPeerCertificateChain();
                }
                catch (SSLPeerUnverifiedException exc) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0200E Could not Verify Client Certificate");
                    }
                    Tr.error(tc, "unverified client certificate", exc);
                }
                if (objs != null) {
                    if (objs instanceof X509Certificate[]) {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Client Certificate is instance of javax.security.cert.X509Certificate");
                        }
                        chain = this.convertCertificateChain(objs);
                    } else {
                        chain = (java.security.cert.X509Certificate[])objs;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionPeerCertificates", chain);
            }
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpConnection: Client Certificate Chain");
            }
            return chain;
        }
        catch (Exception exc) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0201E Peer Ceritificate is Invalid");
            }
            Tr.error(tc, "invalid peer certificate: " + exc.getMessage());
            return null;
        }
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] inChain) throws Exception {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converting Certificate Chain - inChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCertificateChain", inChain);
        }
        java.security.cert.X509Certificate[] outChain = new java.security.cert.X509Certificate[inChain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int idx = 0; idx < inChain.length; ++idx) {
            outChain[idx] = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(inChain[idx].getEncoded()));
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converted Certificate Chain-outChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCertificateChain", outChain);
        }
        return outChain;
    }

    public String getConnectionCipherSuite() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionCipherSuite");
        }
        String cipherSuite = null;
        if (this.isConnectionSecure()) {
            cipherSuite = ((SSLSocket)this.socket).getSession().getCipherSuite();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionCipherSuite", cipherSuite);
        }
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0203I Connection Cipher Suite = " + cipherSuite);
        }
        return cipherSuite;
    }

    public Integer getAlgorithmBitSize() {
        Integer bitSize = null;
        String cipherSuite = this.getConnectionCipherSuite();
        if (cipherSuite != null) {
            // empty if block
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Cipher Suite Algorithm Bitsize = " + bitSize);
        }
        return bitSize;
    }

    public byte[] getConnectionSessionId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionSessionId");
        }
        byte[] sessionId = null;
        if (this.isConnectionSecure()) {
            sessionId = ((SSLSocket)this.socket).getSession().getId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionSessionId", sessionId);
        }
        return sessionId;
    }

    private SSLSocket sslSocket() {
        return (SSLSocket)this.socket;
    }

    public boolean shouldSignalClose() {
        if (!(this.transport.isAlive() && this.transport.isKeepAlive() && this.allowKeepAlive && this.request.wantsToStayAlive())) {
            this.shouldStayAlive = false;
            return true;
        }
        int maxKeepAliveRequests = this.transport.getMaxKeepAliveRequests();
        if (maxKeepAliveRequests != 0 && ++this.curKeepAliveRequests > maxKeepAliveRequests) {
            this.shouldStayAlive = false;
            return true;
        }
        if (!this.isKeptAlive) {
            this.isKeptAlive = this.allowKeepAlive = this.httpServer.allocateKeepAlive();
            if (!this.allowKeepAlive) {
                this.shouldStayAlive = false;
                return true;
            }
        }
        return false;
    }

    public boolean getAllowKeepAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determine if allowing Keepalive");
        }
        return this.allowKeepAlive;
    }

    public void setAllowKeepAlive(boolean allow) {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Setting allowing Keepalive");
        }
        this.allowKeepAlive = allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block98: {
            Throwable th22222;
            int remotePort;
            String remoteAddress;
            block89: {
                block88: {
                    block87: {
                        boolean changeTimeout;
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Running Connection");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                        }
                        HttpConnection httpConnection = this;
                        synchronized (httpConnection) {
                            if (this.Aborted) {
                                this.socket = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Run Aborted [" + this + "]");
                                }
                                return;
                            }
                        }
                        remoteAddress = "unknown";
                        remotePort = -1;
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(3, "HTTP0400I Initializing Socket Input/Output Stream");
                        }
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.run(): thread started: " + Thread.currentThread().getName());
                            remoteAddress = this.socket.getInetAddress().getHostAddress();
                            remotePort = this.socket.getPort();
                            TransportLogger.debug("HttpConnection.run(): remoteAddress: " + remoteAddress);
                            TransportLogger.debug("HttpConnection.run(): remotePort: " + remotePort);
                        }
                        this.httpServer = this.transport.getHttpServer();
                        this.inStream = this.socket.getInputStream();
                        this.outStream = this.socket.getOutputStream();
                        this.stream.init(this.inStream, this.outStream);
                        this.readStream.init(this.stream);
                        this.writeStream.init(this.stream);
                        this.readStream.setDisableClose(true);
                        this.writeStream.setDisableClose(true);
                        this.request.init(this.readStream);
                        this.response.init(this.writeStream);
                        int IOTimeout = this.transport.getConnectionIOTimeout();
                        int keepAliveTimeout = this.transport.getConnectionKeepAliveTimeout();
                        this.socket.setTcpNoDelay(this.transport.getTcpNoDelay());
                        this.socket.setSoTimeout(IOTimeout);
                        this.socket.setSoLinger(true, 20);
                        this.allowKeepAlive = true;
                        this.isKeptAlive = false;
                        this.shouldStayAlive = true;
                        this.curKeepAliveRequests = 0;
                        this.readAndHandleRequest(true);
                        boolean bl = changeTimeout = IOTimeout != keepAliveTimeout;
                        while (this.shouldStayAlive) {
                            if (changeTimeout) {
                                this.socket.setSoTimeout(keepAliveTimeout);
                            }
                            if (this.readStream.read() != -1) {
                                this.readStream.unread();
                                if (changeTimeout) {
                                    this.socket.setSoTimeout(IOTimeout);
                                }
                                this.readAndHandleRequest(false);
                                continue;
                            }
                            if (!HttpServer.errorLogDisable) {
                                Logger.log(2, "HTTP0400W error Reading data - Connection is being closed");
                            }
                            this.shouldStayAlive = false;
                        }
                        Object var7_11 = null;
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                        }
                        try {
                            String osName;
                            if (this.waitBeforeClose && (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                Thread.sleep(this.waitBeforeCloseTime);
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            this.writeStream.setDisableClose(false);
                            this.writeStream.close();
                            this.outStream.close();
                        }
                        catch (Throwable th22222) {
                            if (HttpServer.errorLogDisable) break block87;
                            Logger.log(2, "HTTP0402W Could not Close Output Stream");
                        }
                    }
                    try {
                        this.readStream.setDisableClose(false);
                        this.readStream.close();
                        this.inStream.close();
                    }
                    catch (Throwable th22222) {
                        if (HttpServer.errorLogDisable) break block88;
                        Logger.log(2, "HTTP0403W Could not Close Input Stream");
                    }
                }
                try {
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                    }
                    catch (Throwable th22222) {
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        Object var10_20 = null;
                        this.socket = null;
                        break block89;
                    }
                    Object var10_19 = null;
                    this.socket = null;
                }
                catch (Throwable throwable) {
                    Object var10_21 = null;
                    this.socket = null;
                    throw throwable;
                }
            }
            this.inStream = null;
            this.outStream = null;
            if (this.isKeptAlive) {
                try {
                    this.httpServer.freeKeepAlive();
                }
                catch (Throwable th22222) {
                    // empty catch block
                }
            }
            try {
                if (this.httpServer.freeConnection(this)) {
                    this.cleanup();
                }
            }
            catch (Throwable th22222) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            break block98;
            {
                catch (IOException ioe) {
                    block95: {
                        block94: {
                            block93: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, ioe.getMessage(), ioe);
                                }
                                Object var7_12 = null;
                                if (TransportLogger.debugEnabled()) {
                                    TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                                }
                                try {
                                    String osName;
                                    if (this.waitBeforeClose && (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                        Thread.sleep(this.waitBeforeCloseTime);
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    this.writeStream.setDisableClose(false);
                                    this.writeStream.close();
                                    this.outStream.close();
                                }
                                catch (Throwable th22222) {
                                    if (HttpServer.errorLogDisable) break block93;
                                    Logger.log(2, "HTTP0402W Could not Close Output Stream");
                                }
                            }
                            try {
                                this.readStream.setDisableClose(false);
                                this.readStream.close();
                                this.inStream.close();
                            }
                            catch (Throwable th22222) {
                                if (HttpServer.errorLogDisable) break block94;
                                Logger.log(2, "HTTP0403W Could not Close Input Stream");
                            }
                        }
                        try {
                            try {
                                if (HttpServer.debugEnabled) {
                                    Logger.log(4, "HttpConnection: Closing Socket");
                                }
                                this.socket.close();
                            }
                            catch (Throwable th22222) {
                                if (!HttpServer.errorLogDisable) {
                                    Logger.log(1, "HTTP0401E Could not Close Socket");
                                }
                                Object var10_23 = null;
                                this.socket = null;
                                break block95;
                            }
                            Object var10_22 = null;
                            this.socket = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_24 = null;
                            this.socket = null;
                            throw throwable;
                        }
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable th22222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable th22222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    break block98;
                }
                catch (Throwable th3) {
                    block103: {
                        block102: {
                            block101: {
                                block99: {
                                    String errMsg = "HttpConnection.run: " + th3;
                                    Tr.error(tc, errMsg);
                                    Manager.Ffdc.log(th3, this, "com.ibm.ws.http.HttpConnection.run", "483");
                                    if (!this.response.isCommitted()) {
                                        try {
                                            this.response.sendError(new HttpException(500, errMsg));
                                        }
                                        catch (IOException ioe2) {
                                            if (!tc.isDebugEnabled()) break block99;
                                            Tr.debug(tc, ioe2.getMessage(), ioe2);
                                        }
                                    }
                                }
                                Object var7_13 = null;
                                if (TransportLogger.debugEnabled()) {
                                    TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                                }
                                try {
                                    String osName;
                                    if (this.waitBeforeClose && (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                        Thread.sleep(this.waitBeforeCloseTime);
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    this.writeStream.setDisableClose(false);
                                    this.writeStream.close();
                                    this.outStream.close();
                                }
                                catch (Throwable th22222) {
                                    if (HttpServer.errorLogDisable) break block101;
                                    Logger.log(2, "HTTP0402W Could not Close Output Stream");
                                }
                            }
                            try {
                                this.readStream.setDisableClose(false);
                                this.readStream.close();
                                this.inStream.close();
                            }
                            catch (Throwable th22222) {
                                if (HttpServer.errorLogDisable) break block102;
                                Logger.log(2, "HTTP0403W Could not Close Input Stream");
                            }
                        }
                        try {
                            try {
                                if (HttpServer.debugEnabled) {
                                    Logger.log(4, "HttpConnection: Closing Socket");
                                }
                                this.socket.close();
                            }
                            catch (Throwable th22222) {
                                if (!HttpServer.errorLogDisable) {
                                    Logger.log(1, "HTTP0401E Could not Close Socket");
                                }
                                Object var10_26 = null;
                                this.socket = null;
                                break block103;
                            }
                            Object var10_25 = null;
                            this.socket = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_27 = null;
                            this.socket = null;
                            throw throwable;
                        }
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable th22222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable th22222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
            }
            catch (Throwable throwable) {
                block107: {
                    block106: {
                        Object var7_14 = null;
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                        }
                        try {
                            String osName;
                            if (this.waitBeforeClose && (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                Thread.sleep(this.waitBeforeCloseTime);
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            this.writeStream.setDisableClose(false);
                            this.writeStream.close();
                            this.outStream.close();
                        }
                        catch (Throwable th22222) {
                            if (HttpServer.errorLogDisable) break block106;
                            Logger.log(2, "HTTP0402W Could not Close Output Stream");
                        }
                    }
                    try {
                        this.readStream.setDisableClose(false);
                        this.readStream.close();
                        this.inStream.close();
                    }
                    catch (Throwable th22222) {
                        if (HttpServer.errorLogDisable) break block107;
                        Logger.log(2, "HTTP0403W Could not Close Input Stream");
                    }
                }
                try {
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                    }
                    catch (Throwable th22222) {
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        Object var10_29 = null;
                        this.socket = null;
                    }
                    Object var10_28 = null;
                    this.socket = null;
                }
                catch (Throwable throwable2) {
                    Object var10_30 = null;
                    this.socket = null;
                    throw throwable2;
                }
                this.inStream = null;
                this.outStream = null;
                if (this.isKeptAlive) {
                    try {
                        this.httpServer.freeKeepAlive();
                    }
                    catch (Throwable th22222) {
                        // empty catch block
                    }
                }
                try {
                    if (this.httpServer.freeConnection(this)) {
                        this.cleanup();
                    }
                }
                catch (Throwable th22222) {
                    // empty catch block
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void readAndHandleRequest(boolean isFirstRequest) throws IOException {
        block49: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "readAndHandleRequest");
            }
            boolean flushResponse = true;
            String remoteAddress = "unknown";
            int remotePort = -1;
            this.request.start();
            this.response.start();
            try {
                block48: {
                    if (TransportLogger.debugEnabled()) {
                        remoteAddress = this.socket.getInetAddress().getHostAddress();
                        remotePort = this.socket.getPort();
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): about to read request remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                    }
                    if (this.request.readRequest()) {
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): started dispatch to uri: " + this.request.getURI());
                        }
                        if (!this.transport.isAlive()) {
                            throw new HttpException(503);
                        }
                        if (isFirstRequest && this.request.getURI().equals("/_WS/EH")) {
                            this.response.sendExtendedHandshake();
                            Object var9_5 = null;
                            if (TransportLogger.debugEnabled()) {
                                if (this.request.getURI() != null) {
                                    TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                                } else {
                                    TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                                }
                                TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                                TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                            }
                            try {
                                this.response.finish(flushResponse);
                                Object var11_11 = null;
                                this.request.finish();
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                this.request.finish();
                                throw throwable;
                            }
                        }
                        String expect = this.request.getHeader("Expect");
                        if (expect != null && expect.length() > 0) {
                            if (!expect.equalsIgnoreCase("100-continue")) throw new HttpException(417, "invalid Expect header value: " + expect);
                            if (this.readStream.available() <= 0) {
                                this.response.sendContinue();
                            }
                        }
                        this.response.setStatus(200);
                        this.handleRequest();
                        if (!HttpServer.accessLogDisable) {
                            String httpVersion = this.request.version == 1001 ? "HTTP/1.1" : "HTTP/1.0";
                            String logString = this.getConnectionRemoteAddr() + " \"" + this.request.method + " " + this.request.uri + " " + httpVersion + "\" " + this.response.status + " " + this.response.contentLengthString;
                            Logger.log(5, logString);
                        }
                        break block48;
                    }
                    if (!this.isKeptAlive) {
                        this.request.setVersion(1001);
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): Connection timed out while reading request ");
                        }
                        this.response.sendError(408, "Connection timed out while reading request");
                        this.shouldStayAlive = false;
                        break block48;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection timed out on keep-alive thread");
                    }
                    this.shouldStayAlive = false;
                }
                Object var9_6 = null;
                if (TransportLogger.debugEnabled()) {
                    if (this.request.getURI() != null) {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                    } else {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                    }
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                }
                try {}
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    this.request.finish();
                    throw throwable;
                }
                this.response.finish(flushResponse);
                Object var11_13 = null;
                this.request.finish();
                break block49;
                catch (HttpException exc) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(2, "HTTP0405W Could not Read Request - Closing Connection");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HTTP Exception", exc);
                    }
                    this.response.sendError(exc);
                    this.shouldStayAlive = false;
                    Object var9_7 = null;
                    if (TransportLogger.debugEnabled()) {
                        if (this.request.getURI() != null) {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                        } else {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                        }
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        this.request.finish();
                        throw throwable;
                    }
                    this.response.finish(flushResponse);
                    Object var11_15 = null;
                    this.request.finish();
                    break block49;
                }
                catch (IOException ioe) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(2, "HTTP0406W I/O exception has occurred");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ioe.getMessage(), ioe);
                    }
                    this.shouldStayAlive = false;
                    Object var9_8 = null;
                    if (TransportLogger.debugEnabled()) {
                        if (this.request.getURI() != null) {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                        } else {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                        }
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var11_18 = null;
                        this.request.finish();
                        throw throwable;
                    }
                    this.response.finish(flushResponse);
                    Object var11_17 = null;
                    this.request.finish();
                    break block49;
                }
                catch (Throwable t) {
                    this.shouldStayAlive = false;
                    Tr.error(tc, "Unable to read and handle request: " + t.getMessage());
                    Manager.Ffdc.log(t, this, "com.ibm.ws.http.HttpConnection.readAndHandleRequest", "671");
                    Object var9_9 = null;
                    if (TransportLogger.debugEnabled()) {
                        if (this.request.getURI() != null) {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                        } else {
                            TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                        }
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                        TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var11_20 = null;
                        this.request.finish();
                        throw throwable;
                    }
                    this.response.finish(flushResponse);
                    Object var11_19 = null;
                    this.request.finish();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (TransportLogger.debugEnabled()) {
                    if (this.request.getURI() != null) {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: " + this.request.getURI());
                    } else {
                        TransportLogger.debug("HttpConnection.readAndHandleRequest(): completed dispatch to uri: NOT_AVAILABLE");
                    }
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() status code: " + this.response.getStatus());
                    TransportLogger.debug("HttpConnection.readAndHandleRequest() shouldStayAlive: " + this.shouldStayAlive);
                }
                try {}
                catch (Throwable throwable2) {
                    Object var11_22 = null;
                    this.request.finish();
                    throw throwable2;
                }
                this.response.finish(flushResponse);
                Object var11_21 = null;
                this.request.finish();
                throw throwable;
            }
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Read and Handle Request Complete");
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "readAndHandleRequest");
    }

    protected void handleRequest() throws HttpException, IOException {
        String uri = this.request.getURI();
        this.response.setStatus(200);
        PrintWriter pw = this.response.getWriter();
        pw.print("<HTML><BODY><p>This is a do nothing handler for uri '" + uri + "'</BODY></HTML>");
        pw.print("<HTML><BODY><p>This handleRequest method should be overridden!</BODY></HTML>");
    }

    protected void cleanup() {
    }

    protected HttpRequest createHttpRequest() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Request");
        }
        return new HttpRequest(this);
    }

    protected HttpResponse createHttpResponse() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Response");
        }
        return new HttpResponse(this);
    }

    public void setFlushMode(boolean flushToWire) {
        this.response.setFlushMode(flushToWire);
    }

    public void setshouldStayAlive(boolean yesno) {
        this.shouldStayAlive = yesno;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection should stay alive = ", new Boolean(this.shouldStayAlive));
        }
    }

    public boolean isAllocated() {
        return this.Allocated;
    }

    public void setAllocated(boolean bvalue) {
        this.Allocated = bvalue;
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public void setAborted(boolean bvalue) {
        this.Aborted = bvalue;
    }
}

