/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStreamImpl;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FFDCFilter {
    public static final String $sccsid = "@(#) 1.6 SERV1/ws/code/ras.lite/src/com/ibm/ws/ffdc/FFDCFilter.java, WAS.ras.lite, WAS70.SERV1, cf070937.21 06/12/08 03:03:36 [9/18/09 22:40:07]";
    private static final String className = FFDCFilter.class.getName();
    private static final TraceComponent tc = Tr.register(className);
    private static final String ALT_FFDC_LOG_FILE = "com.ibm.ejs.ras.lite.ffdcLogFile";
    private static String ffdcFileName;
    private static final String COMMA_PATTERN = ",";
    private static Set<Source> _ignoredSources;
    private static IncidentStreamImpl _is;

    private static void ignoreSource(String sourceid, String probeid) {
        Tr.debug(tc, "Ignoring FFDCs from sourceid=" + sourceid + " and probeid=" + probeid);
        _ignoredSources.add(new Source(sourceid, probeid));
    }

    public static void processException(Throwable th, String sourceId, String probeId) {
        String txt = th + " " + sourceId + " " + probeId;
        if (!_ignoredSources.contains(new Source(sourceId, probeId))) {
            FFDCFilter.log(txt, sourceId, probeId, th, null, null);
            Tr.debug(tc, "FFDC exception: " + txt);
        } else {
            Tr.debug(tc, "Ignoring FFDC exception: " + txt);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object callerThis) {
        String txt = th + " " + sourceId + " " + probeId;
        if (!_ignoredSources.contains(new Source(sourceId, probeId))) {
            FFDCFilter.log(txt, sourceId, probeId, th, callerThis, null);
            Tr.debug(tc, "FFDC exception: " + txt);
        } else {
            Tr.debug(tc, "Ignoring FFDC exception: " + txt);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object[] objectArray) {
        String txt = th + " " + sourceId + " " + probeId;
        if (!_ignoredSources.contains(new Source(sourceId, probeId))) {
            FFDCFilter.log(txt, sourceId, probeId, th, null, objectArray);
            Tr.debug(tc, "FFDC exception: " + txt);
        } else {
            Tr.debug(tc, "Ignoring FFDC exception: " + txt);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object callerThis, Object[] objectArray) {
        String txt = th + " " + sourceId + " " + probeId;
        if (!_ignoredSources.contains(new Source(sourceId, probeId))) {
            FFDCFilter.log(txt, sourceId, probeId, th, callerThis, objectArray);
            Tr.debug(tc, "FFDC exception: " + txt);
        } else {
            Tr.debug(tc, "Ignoring FFDC exception: " + txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void log(String txt, String sourceId, String probeId, Throwable th, Object callerThis, Object[] objectArray) {
        if (ffdcFileName == null || ffdcFileName.equals("")) return;
        Class<FFDCFilter> clazz = FFDCFilter.class;
        synchronized (FFDCFilter.class) {
            if (_is == null) {
                _is = new IncidentStreamImpl(ffdcFileName);
            }
            _is.processIncident(txt, sourceId, probeId, th, callerThis, objectArray);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static {
        _ignoredSources = new HashSet<Source>();
        try {
            ffdcFileName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(FFDCFilter.ALT_FFDC_LOG_FILE);
                }
            });
            if (ffdcFileName == null) {
                ffdcFileName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("ffdcLogFile");
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
        List<String> ignoreList = Tr.getFfdcIgnoreList();
        for (String ignore : ignoreList) {
            String[] fields = ignore.split(COMMA_PATTERN);
            if (fields.length <= 1 || fields[0] == null || fields[1] == null) continue;
            FFDCFilter.ignoreSource(fields[0], fields[1]);
        }
        _is = null;
    }

    private static final class Source {
        private static final int _PRIME = 1000003;
        private String _sourceId = "";
        private String _probeId = "";

        public Source(String source, String probe) {
            if (source != null) {
                this._sourceId = source;
            }
            if (probe != null) {
                this._probeId = probe;
            }
        }

        public int hashCode() {
            return this._sourceId.hashCode() * 1000003 + this._probeId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source other = (Source)o;
            if (this._sourceId == null && other._sourceId != null) {
                return false;
            }
            if (this._probeId == null && other._probeId != null) {
                return false;
            }
            if (this._sourceId != null && !this._sourceId.equals(other._sourceId)) {
                return false;
            }
            return this._probeId == null || this._probeId.equals(other._probeId);
        }

        public String getProbeId() {
            return this._probeId;
        }

        public String getSourceId() {
            return this._sourceId;
        }
    }
}

