/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.ConfigurationElement;
import com.ibm.ws.extension.thinregistry.ConfigurationProperty;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler {
    private static final String srcClass = "PluginParser";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_REQUIRES_STATE = 3;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 4;
    private static final int PLUGIN_EXTENSION_STATE = 5;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 7;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private String _locationName;
    private Stack _stateStack;
    private Stack _objectStack;
    private static SAXParser _saxParser;
    private static XMLReader _xmlReader;
    private Locator _locator;
    private Vector[] _scratchVectors;
    private int _autoGenId;

    public PluginParser() {
        block4: {
            this._locationName = null;
            this._stateStack = new Stack();
            this._objectStack = new Stack();
            this._locator = null;
            this._scratchVectors = new Vector[2];
            this._autoGenId = 0;
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setValidating(false);
                saxFactory.setNamespaceAware(false);
                _saxParser = saxFactory.newSAXParser();
                _xmlReader = _saxParser.getXMLReader();
                try {
                    _xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                _xmlReader.setEntityResolver(this);
                _xmlReader.setContentHandler(this);
                _xmlReader.setDTDHandler(this);
                _xmlReader.setErrorHandler(this);
            }
            catch (Exception pce) {
                if (!LoggingServices.debugEnabled) break block4;
                LoggingServices.trace("Exception " + pce);
                pce.printStackTrace(LoggingServices.out);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] ch, int start, int length) {
        int state = (Integer)this._stateStack.peek();
        if (state != 7) {
            return;
        }
        if (state == 7) {
            ConfigurationElement currentConfigElement = (ConfigurationElement)this._objectStack.peek();
            String value = new String(ch, start, length);
            String oldValue = currentConfigElement.getValue();
            if (oldValue == null) {
                if (value.trim().length() != 0) {
                    currentConfigElement.setValue(value);
                }
            } else {
                currentConfigElement.setValue(oldValue + value);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String namespaceURI, String localName, String elementName) {
        String srcMethod = "endElement";
        switch ((Integer)this._stateStack.peek()) {
            case 0: {
                this._stateStack.pop();
                break;
            }
            case 1: {
                if (!LoggingServices.debugEnabled) break;
                LoggingServices.trace("registry.error.internal_stack_error", new Object[]{namespaceURI, elementName});
                break;
            }
            case 2: {
                Vector extVector;
                if (!elementName.equals("plugin") && !elementName.equals("fragment")) break;
                this._stateStack.pop();
                PluginDescriptor root = (PluginDescriptor)this._objectStack.peek();
                Vector extPointVector = this._scratchVectors[0];
                if (extPointVector.size() > 0) {
                    root.setExtensionPoints(extPointVector);
                    this._scratchVectors[0].removeAllElements();
                }
                if ((extVector = this._scratchVectors[1]).size() <= 0) break;
                root.setExtensions(extVector);
                this._scratchVectors[1].removeAllElements();
                break;
            }
            case 3: {
                if (!elementName.equals("requires")) break;
                this._stateStack.pop();
                Vector importVector = (Vector)this._objectStack.pop();
                if (importVector.size() <= 0) break;
                PluginDescriptor parentDescriptor = (PluginDescriptor)this._objectStack.peek();
                break;
            }
            case 4: {
                if (!elementName.equals("extension-point")) break;
                this._stateStack.pop();
                break;
            }
            case 5: {
                if (!elementName.equals("extension")) break;
                this._stateStack.pop();
                Extension currentExtension = (Extension)this._objectStack.pop();
                if (currentExtension.getSimpleIdentifier() == null) {
                    StringBuffer buf = new StringBuffer("ibmautogeneratedidentifier");
                    buf.append(Integer.toString(++this._autoGenId));
                    currentExtension.setSimpleIdentifier(buf.toString());
                }
                PluginDescriptor parent = (PluginDescriptor)this._objectStack.peek();
                currentExtension.setParentDescriptor(parent);
                this._scratchVectors[1].addElement(currentExtension);
                break;
            }
            case 6: {
                if (!elementName.equals("import")) break;
                this._stateStack.pop();
                break;
            }
            case 7: {
                this._stateStack.pop();
                ConfigurationElement currentConfigElement = (ConfigurationElement)this._objectStack.pop();
                String value = currentConfigElement.getValue();
                if (value != null) {
                    currentConfigElement.setValue(value.trim());
                }
                Object parent = this._objectStack.peek();
                currentConfigElement.setParent(parent);
                if ((Integer)this._stateStack.peek() == 5) {
                    ConfigurationElement[] oldValues = ((Extension)parent).getElements();
                    int size = oldValues == null ? 0 : oldValues.length;
                    ConfigurationElement[] newValues = new ConfigurationElement[size + 1];
                    for (int i = 0; i < size; ++i) {
                        newValues[i] = oldValues[i];
                    }
                    newValues[size] = currentConfigElement;
                    ((Extension)parent).setElements(newValues);
                    break;
                }
                ConfigurationElement[] oldValues = ((ConfigurationElement)parent).getSubElements();
                int size = oldValues == null ? 0 : oldValues.length;
                ConfigurationElement[] newValues = new ConfigurationElement[size + 1];
                for (int i = 0; i < size; ++i) {
                    newValues[i] = oldValues[i];
                }
                newValues[size] = currentConfigElement;
                ((ConfigurationElement)parent).setSubElements(newValues);
            }
        }
    }

    public void error(SAXParseException ex) {
        if (!ex.getMessage().startsWith("Element type") && !ex.getMessage().endsWith("must be declared") && LoggingServices.debugEnabled) {
            LoggingServices.trace("registry.error.parse_error", new Object[]{ex.getSystemId(), new Integer(ex.getLineNumber())});
        }
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("registry.error.parse_error", new Object[]{ex.getSystemId(), new Integer(ex.getLineNumber())});
        }
    }

    public void handleExtensionPointState(String elementName, Attributes attributes) {
        this._stateStack.push(new Integer(0));
    }

    public void handleExtensionState(String elementName, Attributes attributes) {
        this._stateStack.push(new Integer(7));
        ConfigurationElement currentConfigurationElement = new ConfigurationElement();
        this._objectStack.push(currentConfigurationElement);
        currentConfigurationElement.setName(elementName);
        this.parseConfigurationElementAttributes(attributes);
    }

    public void handleInitialState(String elementName, Attributes attributes) {
        if (elementName.equals("plugin") || elementName.equals("fragment")) {
            this._stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else {
            this._stateStack.push(new Integer(0));
            this._objectStack.push(null);
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("unknown root element: " + elementName);
            }
        }
    }

    protected static String[] getArrayFromList(String line) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    public void handlePluginState(String elementName, Attributes attributes) {
        if (elementName.equals("requires")) {
            this._stateStack.push(new Integer(3));
            this._objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (elementName.equals("extension-point")) {
            this._stateStack.push(new Integer(4));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (elementName.equals("extension")) {
            this._stateStack.push(new Integer(5));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("unknown element: " + elementName);
        }
    }

    public void handleRequiresImportState(String elementName, Attributes attributes) {
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("ignored element: " + elementName);
        }
    }

    public void handleRequiresState(String elementName, Attributes attributes) {
        if (elementName.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("unknown element: " + elementName);
        }
    }

    public void ignoreableWhitespace(char[] ch, int start, int length) {
    }

    public synchronized PluginDescriptor parsePlugin(InputSource in) {
        PluginDescriptor pd;
        block3: {
            pd = null;
            if (in.getSystemId() != null) {
                this._locationName = in.getSystemId();
            }
            try {
                _xmlReader.parse(in);
                pd = (PluginDescriptor)this._objectStack.pop();
            }
            catch (Exception ex) {
                if (!LoggingServices.debugEnabled) break block3;
                LoggingServices.trace("Exception parsing plugin", ex);
                ex.printStackTrace(LoggingServices.out);
            }
        }
        return pd;
    }

    public void parseConfigurationElementAttributes(Attributes attributes) {
        int len;
        ConfigurationElement parentConfigurationElement = (ConfigurationElement)this._objectStack.peek();
        parentConfigurationElement.setStartLine(this._locator.getLineNumber());
        Vector<ConfigurationProperty> propVector = null;
        int n = len = attributes != null ? attributes.getLength() : 0;
        if (len == 0) {
            return;
        }
        propVector = new Vector<ConfigurationProperty>();
        for (int i = 0; i < len; ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            ConfigurationProperty currentConfigurationProperty = new ConfigurationProperty();
            currentConfigurationProperty.setName(attrName);
            currentConfigurationProperty.setValue(attrValue);
            propVector.addElement(currentConfigurationProperty);
        }
        parentConfigurationElement.setProperties(propVector.toArray(new ConfigurationProperty[propVector.size()]));
        propVector = null;
    }

    public void parseExtensionAttributes(Attributes attributes) {
        PluginDescriptor parent = (PluginDescriptor)this._objectStack.peek();
        Extension currentExtension = new Extension();
        currentExtension.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(currentExtension);
        int len = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                currentExtension.setSimpleIdentifier(attrValue);
                continue;
            }
            if (attrName.equals("point")) {
                String targetName;
                if (attrValue.lastIndexOf(46) == -1) {
                    String baseId = parent.getUniqueIdentifier();
                    targetName = baseId + "." + attrValue;
                } else {
                    targetName = attrValue;
                }
                currentExtension.setExtensionPointUniqueId(targetName);
                continue;
            }
            if (attrName.equals("name")) {
                currentExtension.setName(attrValue);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace("unknown attribute: " + attrName);
        }
    }

    public void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint currentExtPoint = new ExtensionPoint();
        currentExtPoint.setStartLine(this._locator.getLineNumber());
        int len = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                currentExtPoint.setSimpleId(attrValue);
                continue;
            }
            if (attrName.equals("schema")) {
                currentExtPoint.setSchema(attrValue);
                continue;
            }
            if (attrName.equals("name")) {
                currentExtPoint.setName(attrValue);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace("unknown attribute: " + attrName);
        }
        PluginDescriptor root = (PluginDescriptor)this._objectStack.peek();
        currentExtPoint.setParentDescriptor(root);
        this._scratchVectors[0].addElement(currentExtPoint);
    }

    public void parsePluginAttributes(Attributes attributes) {
        PluginDescriptor current = new PluginDescriptor();
        current.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(current);
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                current.setUniqueIdentifier(attrValue);
                continue;
            }
            if (attrName.equals("version")) {
                current.setVersion(attrValue);
                continue;
            }
            if (attrName.equals("provider-name")) {
                current.setProviderName(attrValue);
                continue;
            }
            if (attrName.equals("name")) {
                current.setName(attrValue);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace("unknown attribute: " + attrName);
        }
        if (current.getUniqueIdentifier() == null && !this.setPluginAttrFromLocation(this._locationName, current)) {
            StringBuffer buf = new StringBuffer("ibmautogeneratedidentifier");
            buf.append(Integer.toString(++this._autoGenId));
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("Setting plugin ID: " + buf.toString());
            }
            current.setUniqueIdentifier(buf.toString());
        }
    }

    private boolean setPluginAttrFromLocation(String loc, PluginDescriptor p) {
        boolean result = false;
        try {
            String str = null;
            int idx = loc.lastIndexOf("/");
            if (idx == -1) {
                return result;
            }
            str = loc.substring(0, idx);
            if ((idx = str.lastIndexOf("/")) == -1) {
                return result;
            }
            if ((idx = (str = str.substring(idx + 1)).lastIndexOf("_")) == -1) {
                idx = str.lastIndexOf(".jar");
                String name = idx == -1 ? str : str.substring(0, idx);
                p.setUniqueIdentifier(name);
                return true;
            }
            String name = str.substring(0, idx);
            p.setUniqueIdentifier(name);
            result = true;
            if (p.getVersion() != null) {
                return result;
            }
            if ((idx = (str = str.substring(idx + 1)).lastIndexOf(".jar")) != -1) {
                str = str.substring(0, idx);
            }
            int count = 0;
            idx = 0;
            while ((idx = str.indexOf(".", idx)) != -1) {
                ++count;
                ++idx;
            }
            if (count >= 2) {
                p.setVersion(str);
            }
        }
        catch (Exception ex) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("Exception parsing Location: ", ex);
                ex.printStackTrace(LoggingServices.out);
            }
            result = false;
        }
        return result;
    }

    public void parsePluginRequiresImport(Attributes attributes) {
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String s, String from, String to) {
        String str = s;
        int fromLen = from.length();
        int toLen = to.length();
        int ix = str.indexOf(from);
        while (ix != -1) {
            str = str.substring(0, ix) + to + str.substring(ix + fromLen);
            ix = str.indexOf(from, ix + toLen);
        }
        return str;
    }

    public void startDocument() {
        this._stateStack.push(new Integer(1));
        for (int i = 0; i <= 1; ++i) {
            this._scratchVectors[i] = new Vector();
        }
        this._autoGenId = 0;
    }

    public void startElement(String nameSpaceURI, String localName, String elementName, Attributes attributes) {
        switch ((Integer)this._stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 2: {
                this.handlePluginState(elementName, attributes);
                break;
            }
            case 3: {
                this.handleRequiresState(elementName, attributes);
                break;
            }
            case 4: {
                this.handleExtensionPointState(elementName, attributes);
                break;
            }
            case 5: 
            case 7: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            case 6: {
                this.handleRequiresImportState(elementName, attributes);
                break;
            }
            default: {
                this._stateStack.push(new Integer(0));
                if (!LoggingServices.debugEnabled) break;
                LoggingServices.trace("unknown element: " + elementName);
            }
        }
    }

    public void warning(SAXParseException ex) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("Parser warning: ", ex);
            ex.printStackTrace(LoggingServices.out);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    public void releaseParser() {
        _saxParser = null;
    }
}

