/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.ConfigurationProperty;
import com.ibm.ws.extension.thinregistry.Constants;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionRegistry;
import com.ibm.ws.extension.thinregistry.PluginModelObject;
import com.ibm.ws.extension.thinregistry.ResourceHelper;
import com.ibm.ws.extension.thinregistry.Status;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class ConfigurationElement
extends PluginModelObject
implements IConfigurationElement {
    private static final String srcClass = "ConfigurationElement";
    private ConfigurationProperty[] _properties;
    private Object _parent;
    private String _value;
    private ConfigurationElement[] _subElements;

    public Object createExecutableExtension(String propertyName) throws CoreException {
        String className = this.getClassNameToLoad(propertyName);
        Object initData = null;
        if (className == null) {
            IConfigurationElement[] exec = this.getChildren(propertyName);
            if (0 < exec.length) {
                IConfigurationElement[] parms;
                IConfigurationElement element = exec[0];
                className = element.getAttribute("class");
                if (LoggingServices.debugEnabled) {
                    LoggingServices.trace("className from attribute: " + className);
                }
                if ((parms = element.getChildren("parameter")) != null) {
                    Hashtable<String, String> initParms = new Hashtable<String, String>(parms.length + 1);
                    for (int i = 0; i < parms.length; ++i) {
                        String pname = parms[i].getAttribute("name");
                        if (pname == null) continue;
                        String val = parms[i].getAttribute("value");
                        if (LoggingServices.debugEnabled) {
                            LoggingServices.trace("param name=" + pname + ", val=" + val);
                        }
                        initParms.put(pname, val);
                    }
                    if (!initParms.isEmpty()) {
                        initData = initParms;
                    }
                }
            }
        } else {
            String executable;
            int i = className.indexOf(58);
            if (i != -1) {
                executable = className.substring(0, i).trim();
                initData = className.substring(i + 1).trim();
            } else {
                executable = className;
            }
            i = executable.indexOf(47);
            className = i != -1 ? executable.substring(i + 1).trim() : executable;
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("ClassName(2): " + className);
            }
        }
        if (className == null) {
            throw new CoreException(this.getIStatusObject(propertyName, ResourceHelper.getString("registry.error.no_exe_spec_found", new Object[]{propertyName}), new IllegalArgumentException("propertyName")));
        }
        Object instance = this.getExecutable(className);
        if (instance != null) {
            if (instance instanceof IExecutableExtension) {
                ((IExecutableExtension)instance).setInitializationData(this, propertyName, initData);
            }
            if (instance instanceof IExecutableExtensionFactory) {
                instance = ((IExecutableExtensionFactory)instance).create();
            }
        } else if (LoggingServices.debugEnabled) {
            LoggingServices.trace("registry.error.class_load_failed", className);
        }
        return instance;
    }

    private Object getExecutable(String className) throws CoreException {
        Object exe = null;
        ClassLoader cl = this.getClassLoaderForTheExtensionPoint();
        Class<?> c = null;
        try {
            c = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException cnfe) {
            this.pojoLoadError(className, cnfe, "1");
        }
        if (c != null) {
            try {
                exe = c.newInstance();
            }
            catch (InstantiationException ie) {
                this.pojoLoadError(className, ie, "3");
            }
            catch (IllegalAccessException iae) {
                this.pojoLoadError(className, iae, "4");
            }
        }
        return exe;
    }

    private ClassLoader getClassLoaderForTheExtensionPoint() {
        return ExtensionRegistry.getClassLoader();
    }

    private void pojoLoadError(String className, Throwable t, String errNo) throws CoreException {
        throw new CoreException(this.getIStatusObject(className, ResourceHelper.getString("registry.error.class_load_failed", new Object[]{className}), t));
    }

    private IStatus getIStatusObject(String pluginId, String msg, Throwable t) {
        return new Status(4, pluginId, 4, msg, t);
    }

    private String getClassNameToLoad(String propertyName) {
        String className = null;
        if (propertyName != null) {
            className = this.getAttribute(propertyName);
        } else {
            className = this.getValue();
            if (className != null && (className = className.trim()).equals("")) {
                className = null;
            }
        }
        return className;
    }

    public String getAttribute(String name) throws InvalidRegistryObjectException {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        ConfigurationProperty found = null;
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            found = list[i];
            break;
        }
        return found == null ? null : this.translate(found.getValue(), ((Extension)this.getDeclaringExtension()).getDeclaringPluginDescriptor());
    }

    public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            return list[i].getValue();
        }
        return null;
    }

    public String[] getAttributeNames() throws InvalidRegistryObjectException {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return new String[0];
        }
        String[] result = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = list[i].getName();
        }
        return result;
    }

    public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
        IConfigurationElement[] list = this.getSubElements();
        if (list == null) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        return list;
    }

    public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
        ConfigurationElement[] list = this.getSubElements();
        if (list == null) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        ArrayList<ConfigurationElement> children = new ArrayList<ConfigurationElement>();
        for (int i = 0; i < list.length; ++i) {
            ConfigurationElement element = list[i];
            if (!name.equals(element.getName())) continue;
            children.add(list[i]);
        }
        return children.toArray(new IConfigurationElement[children.size()]);
    }

    public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
        Object p = this.getParent();
        if (p instanceof Extension) {
            return (IExtension)p;
        }
        while (p != null && p instanceof ConfigurationElement) {
            p = ((ConfigurationElement)p).getParent();
        }
        return (IExtension)p;
    }

    public Object getParent() throws InvalidRegistryObjectException {
        return this._parent;
    }

    public String getValue() throws InvalidRegistryObjectException {
        return this._value;
    }

    public String getValueAsIs() throws InvalidRegistryObjectException {
        String s = null;
        return s;
    }

    public String getNamespace() throws InvalidRegistryObjectException {
        return this.getDeclaringExtension().getNamespace();
    }

    public boolean isValid() {
        return true;
    }

    void setParent(Object parent) {
        this._parent = parent;
    }

    ConfigurationElement[] getSubElements() {
        return this._subElements;
    }

    private ConfigurationProperty[] getProperties() {
        return this._properties;
    }

    void setProperties(ConfigurationProperty[] properties) {
        this._properties = properties;
    }

    void setSubElements(ConfigurationElement[] elements) {
        this._subElements = elements;
    }

    void setValue(String value) {
        this._value = value;
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return this.getDeclaringExtension().getContributor();
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.getDeclaringExtension().getNamespace();
    }
}

