/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RMItoIDL {
    private static final String CLASS_NAME = RMItoIDL.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");

    static String getIdlExceptionName(String exClassName) {
        StringBuilder idlName = new StringBuilder(256);
        idlName.append("IDL:");
        idlName.append(exClassName.replace('.', '/'));
        if (exClassName.endsWith("Exception")) {
            idlName.setLength(idlName.length() - 7);
        } else {
            idlName.append("Ex");
        }
        idlName.append(":1.0");
        return idlName.toString();
    }

    static String[] getIdlMethodNames(Method[] methods) throws EJBConfigurationException {
        return RMItoIDL.getIdlMethodNames(methods, null, false);
    }

    static String[] getIdlMethodNames(Method[] methods, Class<?> remoteInterface, boolean forTie) throws EJBConfigurationException {
        int i;
        Class<?> remoteIntf;
        Class<?>[] methodParams;
        Method method;
        int i2;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdlMethodNames : " + methods.length);
        }
        int numMethods = methods.length;
        String[] idlNames = new String[numMethods];
        boolean[] property = new boolean[numMethods];
        boolean[] overloaded = new boolean[numMethods];
        int capacity = (int)((double)numMethods * 1.5);
        HashMap<String, Integer> getProperties = new HashMap<String, Integer>(capacity);
        HashMap<String, Integer> isProperties = new HashMap<String, Integer>(capacity);
        HashMap<String, Integer> setProperties = new HashMap<String, Integer>(capacity);
        HashMap<String, Integer> overloadMap = new HashMap<String, Integer>(capacity);
        for (i2 = 0; i2 < numMethods; ++i2) {
            method = methods[i2];
            String methodName = method.getName();
            methodParams = method.getParameterTypes();
            if (methodParams.length == 0) {
                String propertyName;
                Integer duplicate = null;
                if (methodName.startsWith("get") && methodName.length() > 3 && RMItoIDL.onlyRemoteExceptions(method)) {
                    propertyName = RMItoIDL.getPropertyName(methodName, 3);
                    duplicate = getProperties.put(propertyName, i2);
                } else if (methodName.startsWith("is") && methodName.length() > 2 && method.getReturnType() == Boolean.TYPE && RMItoIDL.onlyRemoteExceptions(method)) {
                    propertyName = RMItoIDL.getPropertyName(methodName, 2);
                    duplicate = isProperties.put(propertyName, i2);
                }
                if (duplicate != null) {
                    Class<?> remoteIntf2 = methods[duplicate].getDeclaringClass();
                    if (remoteIntf2.isAssignableFrom(method.getDeclaringClass())) {
                        remoteIntf2 = method.getDeclaringClass();
                    }
                    Tr.error(tc, "JIT_DUPLICATE_PROPERTY_METHODS_CNTR5105E", new java.lang.Object[]{remoteIntf2.getName(), methods[duplicate].getName(), method.getName()});
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug(tc, "     IDL name conflict (1): '" + methods[duplicate] + "' and '" + method + "'");
                    }
                    throw new EJBConfigurationException(remoteIntf2.getName() + " is not a valid remote interface: " + "the idl name for method '" + methods[duplicate] + "' confilicts with method '" + method + "'");
                }
            }
            idlNames[i2] = methodName;
        }
        for (i2 = 0; i2 < numMethods; ++i2) {
            Integer getIndex;
            method = methods[i2];
            Class<?> methodReturn = method.getReturnType();
            methodParams = method.getParameterTypes();
            if (methodReturn != Void.TYPE || methodParams.length != 1) continue;
            String methodName = method.getName();
            Class<?> methodParam = methodParams[0];
            if (!methodName.startsWith("set") || methodName.length() <= 3 || !RMItoIDL.onlyRemoteExceptions(method)) continue;
            Integer isIndex = null;
            String propertyName = RMItoIDL.getPropertyName(methodName, 3);
            if (methodParam == Boolean.TYPE && (isIndex = (Integer)isProperties.get(propertyName)) != null) {
                if (methodName.regionMatches(3, methods[isIndex].getName(), 2, propertyName.length())) {
                    setProperties.put(propertyName, i2);
                    getProperties.remove(propertyName);
                } else {
                    isIndex = null;
                }
            }
            if (isIndex != null || (getIndex = (Integer)getProperties.get(propertyName)) == null || methodParam != methods[getIndex].getReturnType() || !methodName.regionMatches(3, methods[getIndex].getName(), 3, propertyName.length())) continue;
            setProperties.put(propertyName, i2);
        }
        for (String propertyName : isProperties.keySet()) {
            String getMethodName;
            Integer isIndex;
            String isMethodName;
            Integer getIndex = (Integer)getProperties.get(propertyName);
            if (getIndex != null && !(isMethodName = methods[isIndex = (Integer)isProperties.get(propertyName)].getName()).regionMatches(2, getMethodName = methods[getIndex].getName(), 3, propertyName.length())) {
                Class<?> getIntf;
                remoteIntf = methods[isIndex].getDeclaringClass();
                if (remoteIntf.isAssignableFrom(getIntf = methods[getIndex].getDeclaringClass())) {
                    remoteIntf = getIntf;
                }
                Tr.error(tc, "JIT_DUPLICATE_PROPERTY_METHODS_CNTR5105E", new java.lang.Object[]{remoteIntf.getName(), isMethodName, getMethodName});
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "     IDL name conflict (2): " + isMethodName + " and " + getMethodName);
                }
                throw new EJBConfigurationException(remoteIntf.getName() + " is not a valid remote interface: " + "the idl name for method " + isMethodName + " confilicts with method " + getMethodName);
            }
            if (getIndex != null && methods[getIndex].getReturnType() != Boolean.TYPE) continue;
            getProperties.put(propertyName, (Integer)isProperties.get(propertyName));
        }
        for (String propertyName : getProperties.keySet()) {
            int getIndex = (Integer)getProperties.get(propertyName);
            idlNames[getIndex] = propertyName;
            property[getIndex] = true;
        }
        for (String propertyName : setProperties.keySet()) {
            int setIndex = (Integer)setProperties.get(propertyName);
            idlNames[setIndex] = null;
            property[setIndex] = true;
        }
        boolean[] caseDiff = new boolean[numMethods];
        for (int i3 = 0; i3 < numMethods; ++i3) {
            String idlName = idlNames[i3];
            if (!caseDiff[i3] && idlName != null) {
                for (int j = i3 + 1; j < numMethods; ++j) {
                    String compName = idlNames[j];
                    if (!idlName.equalsIgnoreCase(compName)) continue;
                    if (caseDiff[i3]) {
                        caseDiff[j] = true;
                        continue;
                    }
                    if (idlName.equals(compName)) continue;
                    caseDiff[i3] = true;
                    caseDiff[j] = true;
                }
            }
            if (!caseDiff[i3]) continue;
            idlNames[i3] = RMItoIDL.getCaseDiffName(idlName);
        }
        StringBuilder idlbldr = new StringBuilder(256);
        for (i = 0; i < numMethods; ++i) {
            String idlName = idlNames[i];
            if (idlName == null) continue;
            idlbldr.setLength(0);
            idlbldr.append(idlNames[i]);
            idlNames[i] = RMItoIDL.convertSpecialCharacters(idlbldr);
        }
        for (i = 0; i < numMethods; ++i) {
            Integer Dup;
            if (property[i] || (Dup = overloadMap.put(idlNames[i], i)) == null) continue;
            int dup = Dup;
            if (!overloaded[dup] && !property[dup]) {
                idlNames[dup] = RMItoIDL.getOverloadedIdlName(idlNames[dup], methods[dup]);
                overloaded[dup] = true;
            }
            if (property[i]) continue;
            idlNames[i] = RMItoIDL.getOverloadedIdlName(idlNames[i], methods[i]);
            overloaded[i] = true;
        }
        overloadMap.clear();
        for (i = 0; i < numMethods; ++i) {
            Integer Dup;
            String idlName = idlNames[i];
            if (idlName == null || (Dup = overloadMap.put(idlName, i)) == null) continue;
            int dup = Dup;
            if (!property[dup] && !property[i]) {
                Class<?> dupIntf;
                remoteIntf = methods[i].getDeclaringClass();
                if (remoteIntf.isAssignableFrom(dupIntf = methods[dup].getDeclaringClass())) {
                    remoteIntf = dupIntf;
                }
                Tr.error(tc, "JIT_DUPLICATE_PROPERTY_METHODS_CNTR5105E", new java.lang.Object[]{remoteIntf.getName(), methods[i].getName(), methods[dup].getName()});
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "     IDL name conflict (3): '" + methods[i] + "' and '" + methods[dup] + "'");
                }
                throw new EJBConfigurationException(remoteIntf.getName() + " is not a valid remote interface: " + "the idl name for method '" + methods[i] + "' confilicts with method '" + methods[dup] + "'");
            }
            if (!overloaded[dup] && property[dup]) {
                idlNames[dup] = RMItoIDL.getOverloadedIdlName(idlNames[dup], methods[dup]);
                overloaded[dup] = true;
            }
            if (!property[i]) continue;
            idlNames[i] = RMItoIDL.getOverloadedIdlName(idlName, methods[i]);
            overloaded[i] = true;
        }
        if (remoteInterface != null) {
            idlbldr.setLength(0);
            idlbldr.append(remoteInterface.getSimpleName());
            String interfaceName = RMItoIDL.convertSpecialCharacters(idlbldr);
            for (int i4 = 0; i4 < numMethods; ++i4) {
                String idlName = idlNames[i4];
                if (!interfaceName.equalsIgnoreCase(idlName)) continue;
                int conflict = -1;
                String newIdlName = idlName + "_";
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "     IDL name conflict between class and method names : " + idlName + " -> " + newIdlName);
                }
                for (int j = 0; j < numMethods; ++j) {
                    if (!newIdlName.equals(idlNames[j])) continue;
                    conflict = j;
                    break;
                }
                if (forTie) {
                    if (conflict < 0) {
                        int numIdlNames = idlNames.length;
                        String[] newIdlNames = new String[numIdlNames + 1];
                        System.arraycopy(idlNames, 0, newIdlNames, 0, numIdlNames);
                        idlNames = newIdlNames;
                        idlNames[numIdlNames] = newIdlName;
                        continue;
                    }
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "     IDL name conflict (4): '" + methods[i4] + "' and '" + methods[conflict] + "'");
                    continue;
                }
                if (conflict < 0) {
                    idlNames[i4] = newIdlName;
                    continue;
                }
                Tr.error(tc, "JIT_DUPLICATE_PROPERTY_METHODS_CNTR5105E", new java.lang.Object[]{remoteInterface.getName(), methods[i4].getName(), methods[conflict].getName()});
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "     IDL name conflict (4): '" + methods[i4] + "' and '" + methods[conflict] + "'");
                }
                throw new EJBConfigurationException(remoteInterface.getName() + " is not a valid remote interface: " + "the idl name for method '" + methods[i4] + "' confilicts with method '" + methods[conflict] + "'");
            }
        }
        for (String propertyName : setProperties.keySet()) {
            int setIndex = (Integer)setProperties.get(propertyName);
            String idlName = idlNames[(Integer)getProperties.get(propertyName)];
            idlNames[setIndex] = "_set_" + idlName;
        }
        for (String propertyName : getProperties.keySet()) {
            int getIndex = (Integer)getProperties.get(propertyName);
            idlNames[getIndex] = "_get_" + idlNames[getIndex];
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            for (int i5 = 0; i5 < numMethods; ++i5) {
                Tr.debug(tc, "     RMItoIDL: " + methods[i5].getName() + " -> " + idlNames[i5]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdlMethodNames : " + idlNames.length);
        }
        return idlNames;
    }

    private static boolean onlyRemoteExceptions(Method method) {
        Class<?>[] exceptions;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        for (Class<?> exception : exceptions = method.getExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom(exception)) continue;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "     " + method.getName() + " throws non-Remote exception " + exception.getName());
            }
            return false;
        }
        return true;
    }

    private static String getPropertyName(String methodName, int beginIndex) {
        String propertyName;
        int secondIndex = beginIndex + 1;
        if (methodName.length() <= secondIndex || Character.isLowerCase(methodName.charAt(secondIndex))) {
            StringBuilder namebldr = new StringBuilder(methodName);
            namebldr.setCharAt(beginIndex, Character.toLowerCase(namebldr.charAt(beginIndex)));
            propertyName = namebldr.substring(beginIndex);
        } else {
            propertyName = methodName.substring(beginIndex);
        }
        return propertyName;
    }

    private static String getCaseDiffName(String idlName) {
        int idlLength = idlName.length();
        StringBuilder namebldr = new StringBuilder(idlName);
        for (int i = 0; i < idlLength; ++i) {
            char nextChar = namebldr.charAt(i);
            if (!Character.isUpperCase(nextChar)) continue;
            namebldr.append('_');
            namebldr.append(i);
        }
        if (namebldr.length() == idlLength) {
            namebldr.append('_');
        }
        return namebldr.toString();
    }

    private static String convertSpecialCharacters(StringBuilder idlName) {
        for (int i = 0; i < idlName.length(); ++i) {
            char c = idlName.charAt(i);
            if (c != '$' && c <= '\u00ff') continue;
            idlName.replace(i, i + 1, "U");
            String hex = Integer.toHexString(c).toUpperCase();
            int numHex = hex.length();
            for (int numZero = 4 - numHex; numZero > 0; --numZero) {
                idlName.insert(++i, '0');
            }
            idlName.insert(i + 1, hex);
            i += numHex;
        }
        if (idlName.charAt(0) == '_') {
            idlName.insert(0, 'J');
        }
        return idlName.toString();
    }

    private static String getOverloadedIdlName(String idlName, Method method) {
        StringBuilder idlbldr = new StringBuilder(idlName);
        Class<?>[] args = method.getParameterTypes();
        if (args.length == 0) {
            idlbldr.append("__");
        } else {
            StringBuilder arrayStr = new StringBuilder();
            for (Class<?> argType : args) {
                idlbldr.append("__");
                arrayStr.setLength(0);
                int arrayDimension = 0;
                while (argType.isArray()) {
                    ++arrayDimension;
                    argType = argType.getComponentType();
                }
                if (arrayDimension > 0) {
                    idlbldr.append("org_omg_boxedRMI_");
                    arrayStr.append("seq").append(arrayDimension).append("_");
                }
                if (argType.isPrimitive()) {
                    if (arrayDimension > 0) {
                        idlbldr.append(arrayStr.toString());
                    }
                    if (argType == Boolean.TYPE) {
                        idlbldr.append("boolean");
                        continue;
                    }
                    if (argType == Character.TYPE) {
                        idlbldr.append("wchar");
                        continue;
                    }
                    if (argType == Byte.TYPE) {
                        idlbldr.append("octet");
                        continue;
                    }
                    if (argType == Short.TYPE) {
                        idlbldr.append("short");
                        continue;
                    }
                    if (argType == Integer.TYPE) {
                        idlbldr.append("long");
                        continue;
                    }
                    if (argType == Long.TYPE) {
                        idlbldr.append("long_long");
                        continue;
                    }
                    if (argType == Float.TYPE) {
                        idlbldr.append("float");
                        continue;
                    }
                    if (argType != Double.TYPE) continue;
                    idlbldr.append("double");
                    continue;
                }
                int unqualifiedLength = 0;
                if (argType == String.class) {
                    idlbldr.append("CORBA_WStringValue");
                    unqualifiedLength = 12;
                } else if (argType == Class.class) {
                    idlbldr.append("javax_rmi_CORBA_ClassDesc");
                    unqualifiedLength = 9;
                } else if (argType == Object.class) {
                    idlbldr.append("Object");
                    unqualifiedLength = 6;
                } else {
                    String typeName = argType.getName();
                    idlbldr.append(typeName.replace('.', '_'));
                    int unqualifiedOffset = typeName.lastIndexOf(46) + 1;
                    unqualifiedLength = typeName.length() - unqualifiedOffset;
                }
                if (arrayDimension <= 0) continue;
                int seqIndex = idlbldr.length() - unqualifiedLength;
                idlbldr.insert(seqIndex, arrayStr.toString());
            }
        }
        return idlbldr.toString();
    }
}

