/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;
import org.osgi.framework.Bundle;

public class ModelMgr {
    private static final TraceComponent tc = Tr.register(ModelMgr.class, null, "com.ibm.ws.config.config");
    private static final ThreadContextAccessor threadContextAccessor = ThreadContextAccessor.getThreadContextAccessor();
    private static boolean initialized = false;
    private static EncoderDecoder encoderDecoder;
    private static List rcsModels;

    public static void initialize(String applicationType) {
        ModelMgr.initialize(applicationType, false);
    }

    public static synchronized void initialize(String applicationType, boolean rcsMode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{applicationType, rcsMode});
        }
        if (!initialized) {
            Tr.info(tc, rcsMode ? "WSVR0800I" : "WSVR0801I");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "call stack", new Exception());
            }
            ModelMgr.initializeModels(applicationType, rcsMode);
            ModelMgr.initializeEncoderDecoder();
            initialized = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ModelMgr.displayPackages();
                ModelMgr.testArchivePackage();
            }
        } else if (!rcsMode && rcsModels != null) {
            if (threadContextAccessor.isPrivileged()) {
                ModelMgr.initializeDeferredModels();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ModelMgr.initializeDeferredModels();
                        return null;
                    }
                });
            }
            ModelMgr.initializeEncoderDecoder();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeDeferredModels() {
        Thread thread = Thread.currentThread();
        ClassLoader origCL = threadContextAccessor.getContextClassLoader(thread);
        threadContextAccessor.setContextClassLoader(thread, ExtClassLoader.getInstance());
        try {
            Tr.info(tc, "WSVR0801I");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "call stack", new Exception());
            }
            int size = rcsModels.size();
            for (int i = 0; i < size; ++i) {
                IConfigurationElement element = (IConfigurationElement)rcsModels.get(i);
                ModelMgr.performInitialization(element);
            }
            rcsModels = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ModelMgr.displayPackages();
            }
        }
        finally {
            threadContextAccessor.setContextClassLoader(thread, origCL);
        }
    }

    private static void displayPackages() {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        Tr.debug(tc, "begin registry packages for " + registry);
        for (String nextURI : registry.keySet()) {
            EPackage nextPackage = registry.getEPackage(nextURI);
            Tr.debug(tc, "  [ " + nextURI + " ] [ " + nextPackage + " ]");
        }
        Tr.debug(tc, "end registry packages");
    }

    private static void testArchivePackage() {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        Tr.debug(tc, "registry " + registry);
        String targetURI = "http:///com/ibm/etools/commonarchive.ecore";
        EPackage selectedPackage = registry.getEPackage(targetURI);
        if (selectedPackage == null) {
            Tr.debug(tc, "unable to locate package " + targetURI);
        } else {
            Tr.debug(tc, "factory for package with URI " + targetURI + " = " + selectedPackage.getEFactoryInstance());
        }
    }

    public static synchronized void initializeEncoderDecoder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeEncoderDecoder");
        }
        if (encoderDecoder == null) {
            try {
                encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey(EncoderDecoder.class);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "loaded encoder/decoder " + encoderDecoder);
                }
            }
            catch (Throwable th) {
                throw new IllegalStateException(th);
            }
        }
        EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeEncoderDecoder");
        }
    }

    private static void initializeModels(String applicationType, boolean rcsMode) {
        if ("ws-server".equals(applicationType)) {
            applicationType = "server";
        }
        try {
            HashSet processed = new HashSet();
            ModelMgr.loadModelsViaEclipse(applicationType, processed, rcsMode);
            ModelMgr.loadModelsViaLegacy(applicationType, processed);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModelsViaLegacy(String applicationType, Set processed) {
        Enumeration<URL> urls;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadModelsViaLegacy");
        }
        String selector = "META-INF/ws-" + applicationType + "-model.init";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            urls = classLoader.getResources(selector);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        while (urls.hasMoreElements()) {
            URL nextURL = urls.nextElement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "processing " + nextURL);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(nextURL.openStream()));
                try {
                    String className;
                    while ((className = reader.readLine()) != null) {
                        Class<?> modelInitializer;
                        if (className.trim().length() == 0) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "found " + className);
                        }
                        if (!processed.add(className)) continue;
                        try {
                            modelInitializer = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException(ex);
                        }
                        ModelMgr.performInitialization(modelInitializer);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                Manager.Ffdc.log(ioe, ModelMgr.class, "com.ibm.ws.config.ModelMgr.loadModelsViaLegacy", "82");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModelsViaLegacy");
        }
    }

    private static void loadModelsViaEclipse(String applicationType, Set processed, boolean rcsMode) {
        IExtensionRegistry registry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadModelsViaEclipse");
        }
        if ((registry = ExtensionRegistryFactory.instance().getExtensionRegistry()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "extension registry is null");
            }
        } else {
            String defaultPluginID = ExtensionRegistryFactory.instance().getDefaultPluginID();
            String extensionPointID = defaultPluginID + "." + applicationType + "-model-init";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
            if (extensionPoint == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "extension point " + extensionPointID + " not found");
                }
            } else {
                for (IExtension extension : extensionPoint.getExtensions()) {
                    ModelMgr.processInitializer(extension, processed, rcsMode);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModelsViaEclipse");
        }
    }

    private static void processInitializer(IExtension extension, Set processed, boolean rcsMode) {
        IConfigurationElement[] elements;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processInitializer", extension);
        }
        boolean debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        for (IConfigurationElement element : elements = extension.getConfigurationElements()) {
            String className;
            if (debug) {
                if (!element.isValid()) {
                    Tr.debug(tc, "element is not valid");
                } else {
                    Tr.debug(tc, "element " + element.getName() + ", " + element.getNamespaceIdentifier());
                    for (String attributeName : element.getAttributeNames()) {
                        String attributeValue = element.getAttribute(attributeName);
                        Tr.debug(tc, " " + attributeName + "=" + attributeValue);
                    }
                }
            }
            if (!processed.add(className = element.getAttribute("classname"))) continue;
            String mode = element.getAttribute("rcsMode");
            if (rcsMode && "optional".equals(mode)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "deferring initialization of RCS model");
                }
                if (rcsModels == null) {
                    rcsModels = new ArrayList();
                }
                rcsModels.add(element);
                continue;
            }
            ModelMgr.performInitialization(element);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processInitializer");
        }
    }

    private static void performInitialization(IConfigurationElement element) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "performInitialization", new Object[]{element, element.getAttribute("classname"), element.getContributor().getName()});
        }
        try {
            String className = element.getAttribute("classname");
            Bundle bundle = Platform.getBundle(element.getDeclaringExtension().getNamespace());
            Class<?> modelInitializer = bundle != null ? bundle.loadClass(className) : Thread.currentThread().getContextClassLoader().loadClass(className);
            ModelMgr.performInitialization(modelInitializer);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "performInitialization");
        }
    }

    private static void performInitialization(Class modelInitializer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "performInitialization", modelInitializer);
        }
        try {
            Method initMethod = modelInitializer.getDeclaredMethod("init", null);
            initMethod.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "performInitialization");
        }
    }
}

