/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MOFErrorHandler {
    private static TraceComponent tc = Tr.register("ConfigError", null, "com.ibm.ws.config.config");
    protected URI uri;
    protected Resource r;
    protected ArrayList errors = new ArrayList();
    protected ArrayList warnings = new ArrayList();

    public MOFErrorHandler(URI uri) {
        this.uri = uri;
    }

    public void startDocument(Resource r) {
        this.r = r;
    }

    public void warning(Exception e) {
        this.warnings.add(e);
    }

    public void error(Exception e) {
        this.errors.add(e);
    }

    public void fatalError(Exception e) throws Exception {
        this.errors.add(e);
        this.endDocument();
    }

    public void endDocument() {
        if (this.errors.size() > 0 || this.warnings.size() > 0) {
            int i;
            URIConverter uriConv = this.r.getResourceSet().getURIConverter();
            String path = null;
            if (uriConv instanceof ArchiveURIConverterImpl) {
                try {
                    path = ((ArchiveURIConverterImpl)uriConv).getArchive().getAbsolutePath();
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            }
            path = path + File.separator + this.uri.toFileString();
            this.logInfo("WSVR0300I", path);
            for (i = 0; i < this.errors.size(); ++i) {
                this.handleError(path, (Exception)this.errors.get(i));
            }
            for (i = 0; i < this.warnings.size(); ++i) {
                this.handleWarning(path, (Exception)this.warnings.get(i));
            }
            throw new WsRuntimeException("Parse failures for " + path);
        }
    }

    protected void handleWarning(String documentName, Exception e) {
        if (e instanceof ClassNotFoundException) {
            this.handleClassNotFoundWarning((ClassNotFoundException)e);
        } else if (e instanceof UnresolvedReferenceException) {
            this.handleUnresolvedReferenceWarning((UnresolvedReferenceException)e);
        } else if (e instanceof FeatureNotFoundException) {
            this.handleFeatureNotFoundWarning((FeatureNotFoundException)e);
        } else if (e instanceof PackageNotFoundException) {
            this.handlePackageNotFoundWarning((PackageNotFoundException)e);
        } else if (e instanceof SAXParseException) {
            this.handleSAXParseWarning(documentName, (SAXParseException)e);
        } else if (e instanceof SAXException) {
            this.handleSAXWarning(documentName, (SAXException)e);
        } else {
            this.handleUnknownWarning(e);
        }
    }

    protected void handleError(String documentName, Exception e) {
        if (e instanceof SAXParseException) {
            this.handleSAXParseError(documentName, (SAXParseException)e);
        } else if (e instanceof SAXException) {
            this.handleSAXError(documentName, (SAXException)e);
        } else {
            this.handleUnknownError(e);
        }
    }

    public void handleUnknownWarning(Exception e) {
        this.logWarning("WSVR0311W", e);
    }

    public void handleUnknownError(Exception e) {
        this.logError("WSVR0312E", e);
    }

    public void handleClassNotFoundWarning(ClassNotFoundException e) {
        this.logWarning("WSVR0303W", new Object[]{e.getName(), new Integer(e.getLine())});
    }

    public void handleFeatureNotFoundWarning(FeatureNotFoundException e) {
        this.logWarning("WSVR0305W", new Object[]{e.getName(), new Integer(e.getLine())});
    }

    public void handlePackageNotFoundWarning(PackageNotFoundException e) {
        this.logWarning("WSVR0308W", new Object[]{e.uri(), new Integer(e.getLine())});
    }

    public void handlePackageNotRegisteredError(PackageNotFoundException e) {
        this.logError("WSVR0309E");
    }

    public void handleUnresolvedReferenceWarning(UnresolvedReferenceException e) {
        this.logWarning("WSVR0310W", new Object[]{e.getReference(), new Integer(e.getLine())});
    }

    public void handleSAXParseWarning(String documentName, SAXParseException e) {
        this.logWarning("WSVR0314E", new Object[]{documentName, new Integer(e.getLineNumber()), new Integer(e.getColumnNumber()), e});
    }

    public void handleSAXParseError(String documentName, SAXParseException e) {
        this.logError("WSVR0314E", new Object[]{documentName, new Integer(e.getLineNumber()), new Integer(e.getColumnNumber()), e});
    }

    public void handleSAXWarning(String documentName, SAXException e) {
        this.logWarning("WSVR0314E", new Object[]{documentName, "?", "?", e});
    }

    public void handleSAXError(String documentName, SAXException e) {
        this.logError("WSVR0314E", new Object[]{documentName, "?", "?", e});
    }

    public void logInfo(String msgKey) {
        Tr.info(tc, msgKey);
    }

    public void logInfo(String msgKey, Object objs) {
        Tr.info(tc, msgKey, objs);
    }

    public void logWarning(String msgKey) {
        Tr.warning(tc, msgKey);
    }

    public void logWarning(String msgKey, Object objs) {
        Tr.warning(tc, msgKey, objs);
    }

    public void logError(String msgKey) {
        Tr.error(tc, msgKey);
    }

    public void logError(String msgKey, Object objs) {
        Tr.error(tc, msgKey, objs);
    }
}

