/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.component.platform.axis2.logging;

import com.ibm.webservices.component.logging.Trace;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.ws.component.platform.axis2.logging.LoggerTraceComponentImpl;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerTraceImpl
implements Trace {
    private static final String HELPER_CLASS = "com.ibm.ws.logging.LoggerHelper";

    public TraceComponent register(Class clazz, String string, String string2) {
        Logger logger = null;
        try {
            logger = Logger.getLogger(clazz.getName(), string2);
        }
        catch (MissingResourceException missingResourceException) {
            logger = Logger.getLogger(clazz.getName(), null);
        }
        if (string != null && string.length() > 0) {
            this.addLoggerToGroup(logger, string);
        }
        return new LoggerTraceComponentImpl(logger);
    }

    private void log(TraceComponent traceComponent, String string, Level level, Object object) {
        if (traceComponent != null && traceComponent instanceof LoggerTraceComponentImpl) {
            Logger logger = ((LoggerTraceComponentImpl)traceComponent).getLogger();
            if (object == null) {
                logger.log(level, string);
            } else if (object instanceof Object[]) {
                logger.log(level, string, (Object[])object);
            } else {
                logger.log(level, string, object);
            }
        }
    }

    private void log(TraceComponent traceComponent, Level level, String string, Object object) {
        String string2 = this.getMessage(traceComponent, string);
        this.log(traceComponent, string2, level, object);
    }

    public void audit(TraceComponent traceComponent, String string) {
        this.log(traceComponent, Level.INFO, string, null);
    }

    public void audit(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, Level.INFO, string, object);
    }

    public void error(TraceComponent traceComponent, String string) {
        this.log(traceComponent, Level.SEVERE, string, null);
    }

    public void error(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, Level.SEVERE, string, object);
    }

    public void info(TraceComponent traceComponent, String string) {
        this.log(traceComponent, Level.INFO, string, null);
    }

    public void info(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, Level.INFO, string, object);
    }

    public void warning(TraceComponent traceComponent, String string) {
        this.log(traceComponent, Level.WARNING, string, null);
    }

    public void warning(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, Level.WARNING, string, object);
    }

    public void debug(TraceComponent traceComponent, String string) {
        this.log(traceComponent, string, Level.FINER, null);
    }

    public void debug(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, string, Level.FINER, object);
    }

    public void entry(TraceComponent traceComponent, String string) {
        this.log(traceComponent, string, Level.FINE, null);
    }

    public void entry(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, string, Level.FINE, object);
    }

    public void exit(TraceComponent traceComponent, String string) {
        this.log(traceComponent, string, Level.FINE, null);
    }

    public void exit(TraceComponent traceComponent, String string, Object object) {
        this.log(traceComponent, string, Level.FINE, object);
    }

    private String getMessage(TraceComponent traceComponent, String string) {
        Logger logger;
        String string2 = null;
        ResourceBundle resourceBundle = null;
        if (traceComponent != null && traceComponent instanceof LoggerTraceComponentImpl && (logger = ((LoggerTraceComponentImpl)traceComponent).getLogger()) != null) {
            resourceBundle = logger.getResourceBundle();
        }
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    private void addLoggerToGroup(Logger logger, String string) {
        Method method = _loggerHelper._addLoggerToGroup;
        if (method != null) {
            try {
                method.invoke(null, logger, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Class getLoggerHelperClass() {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = classLoader != null ? classLoader.loadClass(HELPER_CLASS) : Class.forName(HELPER_CLASS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private static class _loggerHelper {
        static Method _addLoggerToGroup = null;

        private _loggerHelper() {
        }

        static {
            Class clazz = LoggerTraceImpl.getLoggerHelperClass();
            if (clazz != null) {
                try {
                    _addLoggerToGroup = clazz.getMethod("addLoggerToGroup", Logger.class, String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

