/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionCallback;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.topography.DescriptionManagerA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;

public class FileSystemDescriptionManager
extends DescriptionManagerA {
    private static final TraceComponent tc = Tr.register(FileSystemDescriptionManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String TOP_DIRECTORY = "com.ibm.wsspi.cluster.shared-file";
    private Map fileList = new WeakHashMap();
    private File top = null;
    private String id = "local";

    public void setIdentifier(String identifier) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setIdentifier", identifier);
        }
        this.id = identifier;
    }

    public void setTopDirectory(String path) {
        File dir;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setTopDirectory", path);
        }
        if (!(dir = new File(path)).exists()) {
            dir.mkdir();
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The directory given by com.ibm.wsspi.cluster.shared-file must be a directory.  " + dir);
        }
        this.top = dir;
    }

    public FileSystemDescriptionManager() {
        this(null);
    }

    public FileSystemDescriptionManager(String topDirectory) {
        this.top = topDirectory == null ? new File(System.getProperty(TOP_DIRECTORY, File.separator + "tmp" + File.separator + "cluster-data")) : new File(topDirectory);
        if (!this.top.exists()) {
            this.top.mkdir();
        }
        if (!this.top.isDirectory()) {
            throw new IllegalArgumentException("The directory given by com.ibm.wsspi.cluster.shared-file must be a directory.  " + this.top);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "<init>", new Object[]{this.top, this.id});
        }
        Thread fmn = new Thread(new FileModifiedNotifier(10000L));
        fmn.setDaemon(true);
        fmn.start();
    }

    public synchronized Description getDescription(DescriptionKey key, String implKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Description result = this.getDescription(key);
        if (result == null) {
            result = super.getDescription(key, implKey);
            String identifier = this.keyToString(key);
            this.fileList.put(identifier, new FileDescriptor());
        }
        return result;
    }

    public void lookupClusterCallback(String clusterName, Contract contract, URL location, DescriptionCallback callback, Object handback) {
    }

    public boolean publish(String identifier, byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", identifier);
        }
        File descriptionFile = null;
        boolean result = true;
        try {
            descriptionFile = this.getFile(identifier);
            FileOutputStream fos = new FileOutputStream(descriptionFile);
            fos.write(data);
            fos.flush();
            fos.close();
            this.update(descriptionFile.getParentFile());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            result = false;
        }
        catch (IOException ioe) {
            System.err.println(identifier.length() + " " + identifier + "\n" + descriptionFile);
            ioe.printStackTrace();
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publish", descriptionFile);
        }
        return result;
    }

    private void update(File identifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", identifier);
        }
        try {
            String name = identifier.getName();
            File[] files = new File[]{identifier};
            if (identifier.isDirectory()) {
                files = identifier.listFiles();
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].length() == 0L) continue;
                FileInputStream fis = new FileInputStream(files[i]);
                byte[][] bytes = new byte[1][0];
                do {
                    byte[] lbytes = new byte[fis.available() + bytes[0].length];
                    System.arraycopy(bytes[0], 0, lbytes, 0, bytes[0].length);
                    fis.read(lbytes);
                    bytes[0] = lbytes;
                } while (fis.available() > 0);
                fis.close();
                this.update(name, bytes);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private File getFile(String identifier) throws IOException {
        File result;
        File file = this.top;
        File dir = new File(file, identifier);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(result = new File(dir, this.id)).exists()) {
            result.createNewFile();
        }
        return result;
    }

    private final class FileDescriptor {
        private long lastModified = -1L;

        private FileDescriptor() {
        }
    }

    private final class FileModifiedNotifier
    implements Runnable {
        private final long interval;

        private FileModifiedNotifier(long trollingInterval) {
            this.interval = trollingInterval;
        }

        public void run() {
            File[] files = FileSystemDescriptionManager.this.top.listFiles();
            while (true) {
                files = FileSystemDescriptionManager.this.top.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileDescriptor fd = (FileDescriptor)FileSystemDescriptionManager.this.fileList.get(files[i].getName());
                    if (fd == null) continue;
                    File[] subfiles = files[i].listFiles();
                    if (subfiles != null) {
                        boolean doUpdate = false;
                        for (int j = 0; j < subfiles.length; ++j) {
                            long lastModified = subfiles[i].lastModified();
                            if (fd.lastModified >= lastModified) continue;
                            fd.lastModified = lastModified;
                            doUpdate = true;
                        }
                        if (!doUpdate) continue;
                        FileSystemDescriptionManager.this.update(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
                try {
                    Thread.sleep(this.interval);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

