/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service.delaycache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.service.delaycache.DelayCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class DelayCacheManagementThread
extends Thread {
    static final TraceComponent tc = Tr.register(DelayCacheManagementThread.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final TraceComponent tcPublish = Tr.register(Publish.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final SleeperThreadPool pool;
    private int cycleTime;
    private int timeUntilDelayCacheChecked;
    private static final int ACS_DELAY_TIME = 2000;
    private int timeUntilHotModeChecked = 2000;
    private int sleepTime = 0;
    private Date idTag = null;

    public DelayCacheManagementThread(int cycleTime) {
        this.setDaemon(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", cycleTime);
        }
        this.cycleTime = cycleTime;
        this.timeUntilDelayCacheChecked = cycleTime;
        this.idTag = Calendar.getInstance().getTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.toString());
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "run", this);
        }
        try {
            while (true) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "DelayCacheManagementThread counter check", new Object[]{this.timeUntilDelayCacheChecked, this.timeUntilHotModeChecked, this.sleepTime});
                }
                if (this.timeUntilDelayCacheChecked <= 0) {
                    if (DelayCache.isManagementThreadWorkComplete()) {
                        return;
                    }
                    Set<DescriptionKey> descriptionsToBePublished = DelayCache.getDelayedUpdatesToBePublished(this.sleepTime);
                    for (DescriptionKey key : descriptionsToBePublished) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "DelayCacheManagementThread publishing", key);
                        }
                        Publish command = new Publish(key);
                        pool.RunInTimeOrder(command);
                    }
                    this.timeUntilDelayCacheChecked = this.cycleTime;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "DelayCacheManagementThread - timeUntilDelayCacheChecked reset", this.timeUntilDelayCacheChecked);
                    }
                }
                if (this.timeUntilHotModeChecked <= 0) {
                    DelayCache.updateDelayCacheCounters(2000);
                    this.timeUntilHotModeChecked = 2000;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "DelayCacheManagementThread - timeUntilHotModeChecked reset", this.timeUntilHotModeChecked);
                    }
                }
                this.sleepTime = this.timeUntilDelayCacheChecked <= this.timeUntilHotModeChecked ? this.timeUntilDelayCacheChecked : this.timeUntilHotModeChecked;
                this.timeUntilDelayCacheChecked -= this.sleepTime;
                this.timeUntilHotModeChecked -= this.sleepTime;
                Thread.sleep(this.sleepTime);
            }
        }
        catch (Exception e) {
            DelayCache.handleManagementThreadException();
            FFDCFilter.processException((Throwable)e, DelayCacheManagementThread.class.getName(), "132", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected Exception in DelayCacheManagementThread", e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run", this.toString());
            }
            return;
        }
    }

    public String toString() {
        return this.idTag + " cycleTime:" + this.cycleTime + " timeUntilDelayCacheChecked:" + this.timeUntilDelayCacheChecked + " timeUntilHotModeChecked:" + this.timeUntilHotModeChecked;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.1");
        }
        pool = SleeperThreadPoolFactory.getInstance();
    }

    public class Publish
    implements Runnable {
        private final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
        private DescriptionKey key;

        public Publish(DescriptionKey key) {
            this.key = key;
        }

        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tcPublish.isEntryEnabled()) {
                    Tr.entry(tc, "run", new Object[]{this, this.key});
                }
                try {
                    DelayCache.resetTotalDelayCounter();
                    Description desc = this.descMgr.getDescription(this.key);
                    this.descMgr.publish(desc);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, Publish.class.getName(), "183", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tcPublish.isEventEnabled()) break block3;
                    Tr.event(tc, "Unexpected exception trying to publish a delayed update", e);
                }
            }
        }
    }
}

