/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service.delaycache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.service.delaycache.DelayCacheManagementThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayCache {
    static final TraceComponent tc = Tr.register(DelayCache.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static Object delayCacheMutex;
    private static final Map<DescriptionKey, Integer> delayedUpdatesCache;
    private static final int UPDATE_MEMENTO_DELAY_TIME_MINIMUM = 250;
    private static final int UPDATE_MEMENTO_DELAY_TIME_MAXIMUM = 60000;
    private static boolean acsDelayPostingEnabled;
    private static int delayCacheManagementCycleTime;
    private static boolean managementThreadExists;
    private static boolean runningHot;
    private static int hotCounter;
    private static int totalDelayCounter;
    private static final int MAXIMUM_ALLOWABLE_DELAY = 30000;
    public static boolean hit30secDelay;
    public static boolean hit2secDelay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(DescriptionKey key, int delay) throws IllegalArgumentException {
        if (delay < 250 || delay > 60000) {
            throw new IllegalArgumentException("Specified value of " + delay + " for Key " + key + " is outside the acceptable bounds for the delay time (" + 250 + " to " + 60000 + ")");
        }
        Object object = delayCacheMutex;
        synchronized (object) {
            delayedUpdatesCache.put(key, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(DescriptionKey key) {
        Object object = delayCacheMutex;
        synchronized (object) {
            delayedUpdatesCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        Object object = delayCacheMutex;
        synchronized (object) {
            return delayedUpdatesCache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isManagementThreadWorkComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagementThreadWorkComplete");
        }
        Object object = delayCacheMutex;
        synchronized (object) {
            if (delayedUpdatesCache.isEmpty() && hotCounter == 0 && !runningHot) {
                managementThreadExists = false;
                hotCounter = 0;
                totalDelayCounter = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "isManagementThreadWorkComplete - true");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isManagementThreadWorkComplete - false");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleManagementThreadException() {
        Object object = delayCacheMutex;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "handleManagementThreadException - runningHot is false");
            }
            managementThreadExists = false;
            runningHot = false;
            hotCounter = 0;
            totalDelayCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DescriptionKey> getDelayedUpdatesToBePublished(int sleepTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelayedUpdatesToBePublished");
        }
        HashSet<DescriptionKey> results = new HashSet<DescriptionKey>();
        HashMap<DescriptionKey, Integer> descriptionsToBeUpdated = new HashMap<DescriptionKey, Integer>();
        Object object = delayCacheMutex;
        synchronized (object) {
            for (Map.Entry<DescriptionKey, Integer> pair : delayedUpdatesCache.entrySet()) {
                DescriptionKey key = pair.getKey();
                int delayTime = pair.getValue();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDelayedUpdatesToBePublished processing ", new Object[]{key, delayTime, sleepTime});
                }
                if ((delayTime -= sleepTime) <= 0) {
                    results.add(key);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDelayedUpdatesToBePublished updating", new Object[]{key, delayTime});
                }
                descriptionsToBeUpdated.put(key, delayTime);
            }
            for (DescriptionKey key : descriptionsToBeUpdated.keySet()) {
                delayedUpdatesCache.put(key, (Integer)descriptionsToBeUpdated.get(key));
            }
            for (DescriptionKey key : results) {
                delayedUpdatesCache.remove(key);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDelayedUpdatesToBePublished", results);
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTotalDelayCounter() {
        Object object = delayCacheMutex;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetTotalDelayCounter");
            }
            totalDelayCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDelayCacheCounters(int delayIncrement) {
        Object object = delayCacheMutex;
        synchronized (object) {
            totalDelayCounter += delayIncrement;
            if (hotCounter == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateDelayCacheCounters - runningHot is false");
                }
                runningHot = false;
                hit2secDelay = true;
            } else {
                hotCounter = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useDelayedActiveClusterSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "useDelayedActiveClusterSet");
        }
        boolean result = false;
        if (!acsDelayPostingEnabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "useDelayedActiveClusterSet - batching not enabled");
            }
            result = false;
        } else {
            Object object = delayCacheMutex;
            synchronized (object) {
                if (!managementThreadExists) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "useDelayedActiveClusterSet - creating management thread");
                    }
                    managementThreadExists = true;
                    DelayCacheManagementThread dcmThread = new DelayCacheManagementThread(delayCacheManagementCycleTime);
                    dcmThread.start();
                }
                ++hotCounter;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "useDelayedActiveClusterSet - counter is " + hotCounter);
                }
                if (runningHot) {
                    if (totalDelayCounter >= 30000) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "useDelayedActiveClusterSet - Reached maximum allowable delay, forcing a publish");
                        }
                        totalDelayCounter = 0;
                        hit30secDelay = true;
                        result = false;
                    } else {
                        result = true;
                    }
                } else if (hotCounter >= 5) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "useDelayedActiveClusterSet - threshold reached, runningHot is true");
                    }
                    runningHot = true;
                    result = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "useDelayedActiveClusterSet", result);
        }
        return result;
    }

    public static void setDelayed(boolean bool) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDelayed", bool);
        }
        acsDelayPostingEnabled = bool;
    }

    public static void setManagementCycleTime(int interval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setManagementCycleTime", interval);
        }
        delayCacheManagementCycleTime = interval;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.1");
        }
        delayCacheMutex = new Object();
        delayedUpdatesCache = new HashMap<DescriptionKey, Integer>(2);
        acsDelayPostingEnabled = WLMCustomPropertyUtility.getACSDelayPostingValue();
        delayCacheManagementCycleTime = WLMCustomPropertyUtility.getDelayCacheManagementCycleTimeValue();
        managementThreadExists = false;
        runningHot = false;
        hotCounter = 0;
        totalDelayCounter = 0;
        hit30secDelay = false;
        hit2secDelay = false;
    }
}

