/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EndPointImpl
extends DescriptionA
implements EndPoint,
ExtrinsicDescription {
    private static final TraceComponent tc = Tr.register(EndPointImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final String TYPE_STATE_CHANGE_REACHABILITY = "type.state.change.reachability";
    private static final DescriptionFactory descriptionFactory = DescriptionFactory.getInstance();
    private static final boolean USE_NON_DEFAULT_COOKIE_NAMES = WLMCustomPropertyUtility.getNonDefaultCookieNameValue();
    private byte[] data = new byte[0];
    private boolean reachable = true;
    private boolean local = false;
    private Identity memberIdentity = null;
    private Map dataCache = Collections.synchronizedMap(new HashMap(3));
    private static Object mutex;
    private boolean hadZeroData = false;

    public EndPointImpl(DescriptionKey key) {
        super(key);
    }

    public Identity getIdentity() {
        return this.getKey();
    }

    public byte[] getData() {
        return ((MementoImpl)this.getMemento()).m_data;
    }

    public void setData(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setData");
        }
        this.data = data;
        if (this.local) {
            MementoImpl newMemento = (MementoImpl)this.createMemento();
            MementoImpl.access$002(newMemento, data);
            this.setMemento(newMemento);
        } else {
            this.updateMemento();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setData", this);
        }
    }

    protected void setMemberIdentity(Identity memberIdentity) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMemberIdentity: memberIdentity " + memberIdentity);
        }
        this.memberIdentity = memberIdentity;
    }

    public void setAvailability(boolean available) {
        if (this.reachable != available) {
            this.reachable = available;
            this.notifyListeners(TYPE_STATE_CHANGE_REACHABILITY, this);
        }
    }

    public boolean isAvailable() {
        return this.reachable;
    }

    public void setlocal(boolean local) {
        this.local = local;
    }

    public boolean islocal() {
        return this.local;
    }

    public boolean isChannelEndPoint() {
        Identity endPointIdentity = this.getIdentity();
        Map properties = endPointIdentity.getProperties();
        return properties.size() == 6 && properties.containsKey("TYPE") && properties.containsValue("CHANNEL");
    }

    public String getDefinitionKey() {
        return EndPoint.class.getName();
    }

    public Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        byte[] bytes;
        MementoImpl newMemento;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        byte version = in.readByte();
        int length = in.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + version);
            Tr.debug(tc, "read length " + length);
        }
        if ((bytes = new byte[length]).length > 0) {
            in.readFully(bytes, 0, length);
        }
        MementoImpl.access$002(newMemento, bytes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream", this);
        }
        int version = 0;
        out.writeByte(version);
        byte[] bytes = null;
        int length = 0;
        if (this.islocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Endpoint is local don't export");
            }
            bytes = new byte[]{};
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Endpoint is not local so export");
            }
            bytes = this.data;
            if (format.getType() == 3) {
                bytes = this.getData();
            }
            length = bytes.length;
        }
        out.writeInt(length);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + version);
            Tr.debug(tc, "wrote length " + length);
            Tr.debug(tc, "wrote data", bytes);
        }
        if (length > 0) {
            out.write(bytes, 0, length);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setClusterMemberAssociation(DescriptionKey association) {
    }

    public Object getCachedData(String key) {
        return this.dataCache.get(key);
    }

    public Object putCachedData(String key, Object lData) {
        return this.dataCache.put(key, lData);
    }

    public void emptyCachedData() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "emptying dataCache for EndPoint " + this.getIdentity());
        }
        this.dataCache.clear();
    }

    public Object getSyncObject() {
        return mutex;
    }

    public String toString() {
        MementoImpl m_memento = (MementoImpl)this.getMemento();
        byte[] epData = m_memento.getData();
        if (epData == null) {
            return super.toString() + "[" + this.reachable + ":null EPData:" + this.getKey() + ":" + this.local + "]";
        }
        if (epData.length == 0) {
            return super.toString() + "[" + this.reachable + ":EPData.length == 0:" + this.getKey() + ":" + this.local + "]";
        }
        return super.toString() + "[" + this.reachable + ":" + ":" + this.getKey() + ":" + this.local + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemento(Description.Memento memento) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemento");
        }
        MementoImpl current_memento = (MementoImpl)this.getMemento();
        MementoImpl new_memento = (MementoImpl)memento;
        byte[] mcurrent_data = current_memento.getData();
        byte[] mnew_data = new_memento.getData();
        if (mnew_data.length == 0) {
            this.setAvailability(false);
            this.hadZeroData = true;
        } else if (this.hadZeroData) {
            this.setAvailability(true);
            this.hadZeroData = false;
        }
        Object object = this.getSyncObject();
        synchronized (object) {
            this.emptyCachedData();
            super.setMemento(memento);
        }
        if ((this.memberIdentity != null || USE_NON_DEFAULT_COOKIE_NAMES) && mcurrent_data.length == 0 && mnew_data.length != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMemento Member Scoped Data define: memberIdentity:" + this.memberIdentity);
            }
            this.notifyListeners("type.member.scoped.data.added", this.memberIdentity);
            descriptionFactory.notifyListeners(this.getKey(), "type.member.scoped.data.added", this.memberIdentity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemento");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.29 ");
        }
        mutex = new Object();
    }

    public final class MementoImpl
    extends DescriptionA.MementoA
    implements ExtrinsicDescription.Memento {
        private final Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private byte[] m_data = new byte[0];

        public Concern getConcern() {
            return this.concern;
        }

        public DescriptionKey getClusterMemberAssociation() {
            return null;
        }

        public byte[] getData() {
            if (this.m_data == null) {
                return new byte[0];
            }
            return this.m_data;
        }

        public String toString() {
            if (this.m_data == null) {
                return super.toString() + "[" + EndPointImpl.this.reachable + ":null EPData:" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
            }
            if (this.m_data.length == 0) {
                return super.toString() + "[" + EndPointImpl.this.reachable + ":EPData.length == 0:" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
            }
            return super.toString() + "[" + EndPointImpl.this.reachable + ":" + ":" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
        }

        static /* synthetic */ byte[] access$002(MementoImpl x0, byte[] x1) {
            x0.m_data = x1;
            return x1;
        }
    }
}

