/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Iterator;
import java.util.List;

public class ZeroWeightRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(ZeroWeightRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final ClusterDescription cluster;

    public ZeroWeightRule(Identity clusterIdentity) {
        this.cluster = (ClusterDescription)descMgr.getDescription((DescriptionKey)clusterIdentity);
    }

    public void subset(List identities, StringBuffer reason) {
        int weight;
        ClusterDescription.Memento memento = (ClusterDescription.Memento)this.cluster.getMemento();
        boolean nonZeroWeight = false;
        for (DescriptionKey element : identities) {
            block7: {
                weight = 0;
                try {
                    weight = memento.getWeightTableEntry(element);
                }
                catch (IllegalArgumentException e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "subset: cluster member not in memento", element);
                }
            }
            if (weight == 0) continue;
            nonZeroWeight = true;
            break;
        }
        if (nonZeroWeight) {
            Iterator iter = identities.iterator();
            while (iter.hasNext()) {
                DescriptionKey element;
                block8: {
                    element = (DescriptionKey)iter.next();
                    weight = 2;
                    try {
                        weight = memento.getWeightTableEntry(element);
                    }
                    catch (IllegalArgumentException e) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "subset:nonZeroWeight cluster member not in memento", element);
                    }
                }
                if (weight != 0) continue;
                iter.remove();
                reason.append(element).append(" removed for zero weight.");
            }
        }
    }

    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        coordinator.registerNotificationType(this, this.cluster.getKey(), "type.cluster.weight.update");
    }
}

