/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.selection.algorithm.AffinityAlgorithm;
import com.ibm.ws.cluster.selection.algorithm.RandomAlgorithm;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.algorithm.WeightedProportionalAlgorithm;
import com.ibm.ws.cluster.selection.feedback.BlendedWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.DesiredWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.NoWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.ObservedWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.ws.cluster.selection.rule.ApplicableStatesRule;
import com.ibm.ws.cluster.selection.rule.ReachabilityRule;
import com.ibm.ws.cluster.selection.rule.RuleEtiquette;
import com.ibm.ws.cluster.selection.rule.ZeroWeightRule;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.cluster.selection.rule.EndPointRule;
import com.ibm.wsspi.cluster.selection.rule.QuiesceRule;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;

public final class SelectionAdvisor
implements DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(SelectionAdvisor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private final DescriptionKey clusterKey;
    private RuleEtiquette[] etiquette;
    private SelectionAlgorithm[] algorithms;
    private StringBuffer[] reason;
    private final Map attributes;
    private final Integer syncObject = new Integer(42);
    private boolean beingRemoved = false;
    private static final Byte feedbackTypeCache;

    SelectionAdvisor(DescriptionKey clusterIdentity, Map criteriaContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterIdentity, criteriaContext});
        }
        this.clusterKey = clusterIdentity;
        this.attributes = criteriaContext;
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        SelectionRule[][] rules = this.assembleRules(this.attributes);
        SelectionAlgorithm[] newAlgorithms = new SelectionAlgorithm[rules.length];
        StringBuffer[] newReason = new StringBuffer[rules.length];
        RuleEtiquette[] newEtiquette = new RuleEtiquette[rules.length];
        RuleEtiquette[] oldEtiquette = null;
        boolean debug = tc.isDebugEnabled();
        for (int i = 0; i < rules.length; ++i) {
            if (debug) {
                Tr.debug(tc, "Building Rules", rules[i]);
            }
            newAlgorithms[i] = this.getAlgorithm(this.attributes);
            WeightBasedFeedback feedback = this.getFeedback(this.attributes);
            feedback.init(this.clusterKey, newAlgorithms[i]);
            newReason[i] = new StringBuffer(256);
            newEtiquette[i] = new RuleEtiquette(this.clusterKey, rules[i], newReason[i], feedback, this.attributes);
        }
        Integer i = this.syncObject;
        synchronized (i) {
            oldEtiquette = this.etiquette;
            this.etiquette = newEtiquette;
            this.reason = newReason;
            this.algorithms = newAlgorithms;
        }
        if (oldEtiquette != null) {
            for (int i2 = 0; i2 < oldEtiquette.length; ++i2) {
                oldEtiquette[i2].beingRemoved();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private static Byte checkFeedbackCustomProperty() {
        Byte result;
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "checkFeedbackCustomProperty");
            }
            String customPropValue = null;
            result = null;
            customPropValue = WLMCustomPropertyUtility.getFeedbackMechanismValue();
            if (customPropValue != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom feedback found in ProcessProperties", customPropValue);
                }
            } else {
                customPropValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String prop = System.getProperty("IBM_CLUSTER_FEEDBACK_MECHANISM", null);
                        return prop;
                    }
                });
                if (customPropValue != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom feedback found in System Propertys", customPropValue);
                }
            }
            if (customPropValue != null) {
                try {
                    Byte tempFeedbackValue;
                    result = tempFeedbackValue = Byte.valueOf(customPropValue);
                }
                catch (NumberFormatException nfe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                    Tr.event(tc, "Feedback mechanism custom property could not be parsed", customPropValue);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFeedbackCustomProperty", result);
        }
        return result;
    }

    private SelectionRule[][] assembleRules(Map attributes) {
        SelectionRule[] restrictive = this.assembleLayers(this.clusterKey, attributes);
        SelectionRule[] precedence = this.assembleOrder(this.clusterKey, attributes);
        SelectionRule[][] rules = new SelectionRule[precedence.length][];
        for (int i = 0; i < precedence.length; ++i) {
            rules[i] = new SelectionRule[restrictive.length + 1];
            System.arraycopy(restrictive, 0, rules[i], 0, restrictive.length);
            rules[i][restrictive.length] = precedence[i];
        }
        return rules;
    }

    private SelectionRule[] assembleLayers(DescriptionKey clusterKey, Map attributes) {
        SelectionRule[] restrictive = (SelectionRule[])attributes.get("rules.restriction");
        if (restrictive == null) {
            restrictive = new SelectionRule[]{};
        }
        int ruleCount = restrictive.length;
        ReachabilityRule reachability = new ReachabilityRule();
        ++ruleCount;
        ZeroWeightRule zeroWeights = new ZeroWeightRule(clusterKey);
        ++ruleCount;
        byte[] acceptableStates = (byte[])attributes.get("AcceptableStates");
        if (acceptableStates == null) {
            acceptableStates = new byte[]{0};
        }
        ApplicableStatesRule applicableStates = new ApplicableStatesRule(acceptableStates);
        ++ruleCount;
        AttributeRule attribute = null;
        Set matchingAttributes = (Set)attributes.get("attributes");
        if (matchingAttributes != null) {
            attribute = new AttributeRule(matchingAttributes);
            ++ruleCount;
        }
        EndPointRule endpoint = null;
        Map matchingEndpoints = (Map)attributes.get("endpoints");
        if (matchingEndpoints != null) {
            endpoint = new EndPointRule(matchingEndpoints);
            ++ruleCount;
        }
        QuiesceRule quiesce = null;
        if (!attributes.containsKey("affinity.key")) {
            quiesce = new QuiesceRule(clusterKey);
            ++ruleCount;
        }
        SelectionRule[] result = new SelectionRule[ruleCount];
        System.arraycopy(restrictive, 0, result, 0, restrictive.length);
        int index = restrictive.length;
        if (reachability != null) {
            result[index++] = reachability;
        }
        if (applicableStates != null) {
            result[index++] = applicableStates;
        }
        if (attribute != null) {
            result[index++] = attribute;
        }
        if (endpoint != null) {
            result[index++] = endpoint;
        }
        if (quiesce != null) {
            result[index++] = quiesce;
        }
        if (zeroWeights != null) {
            result[index++] = zeroWeights;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "assembleLayers", result);
        }
        return result;
    }

    private SelectionRule[] assembleOrder(DescriptionKey clusterKey, Map attributes) {
        SelectionRule[] precedence = (SelectionRule[])attributes.get("rules.precedence");
        if (precedence == null) {
            ClusterDescription cluster = (ClusterDescription)descMgr.getDescription(clusterKey);
            cluster.registerNotificationListener(this, "type.selection.description.modified", null);
            ClusterDescription.Memento memento = (ClusterDescription.Memento)cluster.getMemento();
            SelectionDescription selection = memento.getSelectionDescription();
            SelectionService selectionService = SelectionServiceFactory.getSelectionService();
            precedence = selection.getKey().equals(SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL) ? new SelectionRule[]{selectionService.getRule("rule.local.server"), selectionService.getRule("rule.local.host"), selectionService.getRule("rule.default")} : new SelectionRule[]{selectionService.getRule("rule.local.server"), selectionService.getRule("rule.default")};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "assembleOrder", precedence);
        }
        return precedence;
    }

    private WeightBasedFeedback getFeedback(Map attributes) {
        Byte feedbackType;
        Byte by = feedbackType = feedbackTypeCache != null ? feedbackTypeCache : (Byte)attributes.get("FeedbackMechanism");
        WeightBasedFeedback result = feedbackType == null || feedbackType.equals(SelectionCriteria.FEEDBACK_THRESHOLD) ? new BlendedWeightFeedback() : (feedbackType.equals(SelectionCriteria.FEEDBACK_ERROR) ? new ObservedWeightFeedback() : (feedbackType.equals(SelectionCriteria.FEEDBACK_STATIC) ? new DesiredWeightFeedback() : (feedbackType.equals(SelectionCriteria.FEEDBACK_NONE) ? new NoWeightFeedback() : new BlendedWeightFeedback())));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFeedback", result.getClass());
        }
        return result;
    }

    private SelectionAlgorithm getAlgorithm(Map attributes) {
        Identity affinityKey = (Identity)attributes.get("affinity.key");
        if (affinityKey != null) {
            return new AffinityAlgorithm(affinityKey);
        }
        String selectionAlgorithmType = (String)attributes.get("SelectionAlgorithmType");
        if (selectionAlgorithmType != null && selectionAlgorithmType.equals("Random")) {
            return new RandomAlgorithm();
        }
        return new WeightedProportionalAlgorithm();
    }

    public ClusterMemberDescription select() {
        ClusterMemberDescription result = null;
        Identity memberIdentity = null;
        SelectionAlgorithm[] lAlgorithms = this.algorithms;
        for (int i = 0; i < lAlgorithms.length; ++i) {
            memberIdentity = lAlgorithms[i].select();
            if (memberIdentity == null || (result = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)memberIdentity)) == null) continue;
            return result;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "select failed", this.reason);
        }
        return null;
    }

    public String getReason() {
        StringBuffer result = new StringBuffer();
        StringBuffer[] lReason = this.reason;
        for (int i = 0; i < lReason.length; ++i) {
            result.append(lReason[i]).append('\n');
        }
        return result.toString();
    }

    public void handleNotification(DescriptionKey key, String type, Object userData, Object handback) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{key, type, userData, handback});
        }
        if (!this.beingRemoved && type.equals("type.selection.description.modified")) {
            this.clearRuleEtiquettes();
            this.initialize();
        } else if (this.beingRemoved && tc.isDebugEnabled()) {
            Tr.debug(tc, "beingRemoved");
        }
    }

    private void clearRuleEtiquettes() {
        int i;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearRuleEtiquettes");
        }
        SelectionRule[] restrictive = (SelectionRule[])this.attributes.get("rules.restriction");
        SelectionRule[] precedence = (SelectionRule[])this.attributes.get("rules.precedence");
        if (precedence != null) {
            for (i = 0; i < precedence.length; ++i) {
                if (!(precedence[i] instanceof DefaultRule)) continue;
                ((DefaultRule)precedence[i]).clearArbitrators(this.etiquette);
            }
        }
        if (restrictive != null) {
            for (i = 0; i < restrictive.length; ++i) {
                if (!(restrictive[i] instanceof DefaultRule)) continue;
                ((DefaultRule)restrictive[i]).clearArbitrators(this.etiquette);
            }
        }
    }

    public String toString() {
        SelectionAlgorithm[] lAlgorithms = this.algorithms;
        RuleEtiquette[] lEtiquette = this.etiquette;
        StringBuffer[] lReason = this.reason;
        StringBuffer result = new StringBuffer(super.toString());
        result.append("[");
        for (int i = 0; i < lAlgorithms.length; ++i) {
            result.append(lAlgorithms[i]).append("::");
            result.append(lEtiquette[i]).append("::");
            result.append(lReason[i]);
        }
        result.append("]");
        return result.toString();
    }

    protected void beingRemoved() {
        this.beingRemoved = true;
        RuleEtiquette[] lEtiquette = this.etiquette;
        for (int i = 0; i < this.etiquette.length; ++i) {
            lEtiquette[i].beingRemoved();
        }
        this.clearRuleEtiquettes();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.27.1.15 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        feedbackTypeCache = SelectionAdvisor.checkFeedbackCustomProperty();
    }
}

