/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public abstract class AdvisorMediatorA
implements AdvisorMediator {
    private static final TraceComponent tc = Tr.register(AdvisorMediatorA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final Integer zero = new Integer(0);
    protected Map unavailableServers = new HashMap();
    private final WeightTable weightTable = new WeightTable();
    private static final DescriptionManager descMgr;

    public boolean isAvailable(Identity member) {
        return false;
    }

    public void setAvailable(Identity member) {
    }

    public void setUnavailable(Identity member) {
    }

    public boolean isQuiesced(Identity cluster, Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isQuiesced", new Object[]{"cluster is: " + cluster, "member is: " + member});
        }
        if (cluster == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (member == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clustDesc = null;
        Description theDescription = descMgr.getDescription((DescriptionKey)cluster);
        if (theDescription == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clustDesc = (ClusterDescription)theDescription;
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clustDesc.getMemento();
            Map memberMap = memento.getMembers();
            if (!memberMap.containsKey(member)) {
                throw new IllegalArgumentException("The passed in member is not a member of the passed in cluster.");
            }
            boolean quiesced = memento.isQuiesced(member);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isQuiesced", "survey says: " + quiesced);
            }
            return quiesced;
        }
        catch (ClassCastException cce) {
            IllegalArgumentException iae = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            iae.initCause(cce);
            throw iae;
        }
    }

    public void setQuiesce(Identity cluster, Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQuiesced", new Object[]{"cluster is: " + cluster, "member is: " + member});
        }
        if (cluster == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (member == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clustDesc = null;
        Description theDescription = descMgr.getDescription((DescriptionKey)cluster);
        if (theDescription == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clustDesc = (ClusterDescription)theDescription;
            clustDesc.setQuiesce(member);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setQuiesced");
            }
        }
        catch (ClassCastException cce) {
            IllegalArgumentException iae = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            iae.initCause(cce);
            throw iae;
        }
    }

    public void unsetQuiesce(Identity cluster, Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetQuiesced", new Object[]{"cluster is: " + cluster, "member is: " + member});
        }
        if (cluster == null) {
            throw new IllegalArgumentException("The passed in cluster Identity is null.");
        }
        if (member == null) {
            throw new IllegalArgumentException("The passed in member Identity is null.");
        }
        ClusterDescription clustDesc = null;
        Description theDescription = descMgr.getDescription((DescriptionKey)cluster);
        if (theDescription == null) {
            throw new IllegalArgumentException("The cluster identified by the passed in cluster Identity does not exist.");
        }
        try {
            clustDesc = (ClusterDescription)theDescription;
            clustDesc.unsetQuiesce(member);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unsetQuiesced");
            }
        }
        catch (ClassCastException cce) {
            IllegalArgumentException iae = new IllegalArgumentException("The passed in Identity of the cluster did not identify a cluster.");
            iae.initCause(cce);
            throw iae;
        }
    }

    public int getObservedWeight(Identity cluster, Identity member) {
        return this.weightTable.get(cluster, member);
    }

    public void setObservedWeight(Identity cluster, Identity member, int weight) {
        this.weightTable.set(cluster, member, new Integer(weight));
    }

    public void tareObservedWeights(Identity cluster) {
        this.weightTable.remove(cluster);
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }

    private final class AvailabilityTimer
    extends TimerTask {
        private AvailabilityTimer() {
        }

        void unavailable(Identity member) {
        }

        public void run() {
        }
    }

    private final class WeightTable {
        private final Map weights = new HashMap();

        private WeightTable() {
        }

        Integer get(Identity cluster, Identity member) {
            Map members = (Map)this.weights.get(cluster);
            if (members == null) {
                return zero;
            }
            Integer weight = (Integer)members.get(member);
            return weight == null ? zero : weight;
        }

        void set(Identity cluster, Identity member, Integer weight) {
            HashMap<Identity, Integer> members = (HashMap<Identity, Integer>)this.weights.get(cluster);
            if (member == null) {
                members = new HashMap<Identity, Integer>();
            }
            members.put(member, weight);
        }

        void remove(Identity cluster) {
            this.weights.remove(cluster);
        }
    }
}

