/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLMNonDefaultCookieUtility {
    private static final TraceComponent tc = Tr.register(WLMNonDefaultCookieUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String SERVER_DOCUMENT = "server.xml";
    private static final String DEPLOYMENT_DOCUMENT = "deployment.xml";
    private static ClusterMemberService clusterMemberService;
    private static ConfigService configService;
    private boolean serverCookieHasBeenSet;
    private static final String NON_DEFAULT_APPLICATION_COOKIE = "NON_DEFAULT_APPLICATION_COOKIE";
    private DescriptionManager descMgr;
    private static final ClusterService clusterService;
    private static final ClusterManagement clusterManagement;

    public WLMNonDefaultCookieUtility() {
        block7: {
            block6: {
                this.serverCookieHasBeenSet = false;
                this.descMgr = DescriptionManagerFactory.getDescriptionManager();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "<init>");
                }
                try {
                    clusterMemberService = WsServiceRegistry.getService(this, ClusterMemberService.class);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, WLMNonDefaultCookieUtility.class.getName() + ".<init>", "72");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event(tc, "<init> getService ClusterMemberService Failed");
                }
            }
            try {
                configService = WsServiceRegistry.getService(this, ConfigService.class);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, WLMNonDefaultCookieUtility.class.getName() + ".<init>", "81");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "<init> getService ConfigService Failed", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void parseAndSetCookie(Identity memberIdentity, String appName) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseAndSetCookie", new Object[]{memberIdentity, appName});
            }
            try {
                String nodeName = IdentityMapping.getNodeNameFromClusterMemberIdentity(memberIdentity);
                String serverName = IdentityMapping.getServerNameFromClusterMemberIdentity(memberIdentity);
                String cellName = IdentityMapping.getCellNameFromIdentity(memberIdentity);
                if (!this.serverCookieHasBeenSet) {
                    String serverCookieName = this.parseServerLevelCookieFromXML(nodeName, serverName);
                    this.setCookie(memberIdentity, serverCookieName);
                    if (serverCookieName != null) {
                        this.serverCookieHasBeenSet = true;
                    }
                }
                HashMap<String, String> cookies = this.parseAppModuleCookieFromXML(appName, cellName, nodeName);
                String applicationCookieName = cookies.get(NON_DEFAULT_APPLICATION_COOKIE);
                this.setCookie(memberIdentity, appName, applicationCookieName);
                Iterator<String> moduleIter = cookies.keySet().iterator();
                while (moduleIter != null && moduleIter.hasNext()) {
                    String moduleName = moduleIter.next();
                    if (moduleName == NON_DEFAULT_APPLICATION_COOKIE) continue;
                    String moduleCookie = cookies.get(moduleName);
                    this.setCookie(memberIdentity, appName, moduleName, moduleCookie);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, WLMNonDefaultCookieUtility.class.getName() + ".parseAndSetCookie", "135");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "parseAndSetCookie - Unexpected exception", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAndSetCookie");
        }
    }

    public String parseServerLevelCookieFromXML(String nodeName, String serverName) {
        String cookie;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseServerLevelCookieFromXML", new Object[]{nodeName, serverName});
            }
            cookie = null;
            try {
                ConfigScope serverConfigScope = configService.createScope(4);
                List serverResource = null;
                serverResource = configService.getDocumentObjects(serverConfigScope, SERVER_DOCUMENT);
                ConfigObject serverConfigObject = (ConfigObject)serverResource.get(0);
                List components = serverConfigObject.getObjectList("components");
                for (ConfigObject component : components) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "parseServerLevelCookieFromXML component", component.getTypeName());
                    }
                    if (component == null || !component.getTypeName().startsWith("ApplicationServer")) continue;
                    List appServerComponents = component.getObjectList("components");
                    for (ConfigObject appServerComponent : appServerComponents) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "parseServerLevelCookieFromXML appServerComponents", appServerComponent.getTypeName());
                        }
                        if (appServerComponent == null || !appServerComponent.getTypeName().startsWith("WebContainer")) continue;
                        List services = appServerComponent.getObjectList("services");
                        for (ConfigObject service : services) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML service", service.getTypeName());
                            }
                            if (service == null || !service.getTypeName().startsWith("SessionManager")) continue;
                            ConfigObject defaultCookieSettings = service.getObject("defaultCookieSettings");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML defaultCookieSettings", defaultCookieSettings);
                            }
                            if (defaultCookieSettings == null) continue;
                            cookie = defaultCookieSettings.getString("name", null);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML cookie", cookie);
                            }
                            if (cookie == null || !cookie.equalsIgnoreCase("JSESSIONID")) continue;
                            cookie = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, WLMNonDefaultCookieUtility.class.getName() + ".parseServerLevelCookieFromXML", "210", this, new Object[]{serverName, nodeName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                Tr.event(tc, "Unexpected exception reading config for ", new Object[]{serverName, nodeName, e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerLevelCookieFromXML", cookie);
        }
        return cookie;
    }

    public HashMap<String, String> parseAppModuleCookieFromXML(String applicationName, String cellName, String nodeName) {
        HashMap<String, String> cookies;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseAppModuleCookieFromXML", new Object[]{applicationName, cellName, nodeName});
            }
            cookies = new HashMap<String, String>();
            try {
                ConfigScope applicationConfigScope = configService.createScope(1);
                applicationConfigScope.set(3, nodeName);
                applicationConfigScope.set(0, cellName);
                String[] applications = applicationConfigScope.list(null);
                if (applications != null) {
                    for (int i = 0; i < applications.length; ++i) {
                        applicationConfigScope.set(1, applications[i]);
                        String[] deployments = applicationConfigScope.list("deployments");
                        for (int j = 0; j < deployments.length; ++j) {
                            if (!deployments[j].equals(applicationName)) continue;
                            List applicationResource = null;
                            applicationResource = configService.getDocumentObjects(applicationConfigScope, "deployments" + File.separator + applicationName + File.separator + DEPLOYMENT_DOCUMENT);
                            ConfigObject applicationConfigObject = (ConfigObject)applicationResource.get(0);
                            List deployedObjects = applicationConfigObject.getObjectList("deployedObject");
                            for (ConfigObject deployedObject : deployedObjects) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML deployedObject", deployedObject.getTypeName());
                                }
                                if (deployedObject == null || !deployedObject.getTypeName().startsWith("ApplicationDeployment")) continue;
                                List configsObjects = deployedObject.getObjectList("configs");
                                for (ConfigObject configs : configsObjects) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML appServerComponents", configs.getTypeName());
                                    }
                                    if (configs == null || !configs.getTypeName().startsWith("ApplicationConfig")) continue;
                                    ConfigObject sessionManagement = configs.getObject("sessionManagement");
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML sessionManagement", sessionManagement);
                                    }
                                    if (sessionManagement == null) continue;
                                    String applicationOverride = sessionManagement.getString("enable", "false");
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML applicationOverride", applicationOverride);
                                    }
                                    String applicationCookie = null;
                                    if (applicationOverride.equals("true")) {
                                        ConfigObject defaultCookieSettings = sessionManagement.getObject("defaultCookieSettings");
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "parseAppModuleCookieFromXML defaultCookieSettings", defaultCookieSettings);
                                        }
                                        if (defaultCookieSettings != null) {
                                            applicationCookie = defaultCookieSettings.getString("name", null);
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "parseAppModuleCookieFromXML applicationCookie", applicationCookie);
                                            }
                                            if (applicationCookie.equalsIgnoreCase("JSESSIONID")) {
                                                applicationCookie = null;
                                            }
                                        }
                                    }
                                    cookies.put(NON_DEFAULT_APPLICATION_COOKIE, applicationCookie);
                                }
                                List modules = deployedObject.getObjectList("modules");
                                for (ConfigObject module : modules) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML module", module.getTypeName());
                                    }
                                    if (module == null) continue;
                                    String moduleName = module.getString("uri", "");
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML moduleName", moduleName);
                                    }
                                    List moduleConfigsObjects = module.getObjectList("configs");
                                    for (ConfigObject configs : moduleConfigsObjects) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "parseAppModuleCookieFromXML configs", configs.getTypeName());
                                        }
                                        if (configs == null) continue;
                                        ConfigObject sessionManagement = configs.getObject("sessionManagement");
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "parseAppModuleCookieFromXML sessionManagement", sessionManagement);
                                        }
                                        if (sessionManagement == null) continue;
                                        String moduleOverride = sessionManagement.getString("enable", "false");
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "parseAppModuleCookieFromXML moduleOverride", moduleOverride);
                                        }
                                        String moduleCookie = null;
                                        if (moduleOverride.equals("true")) {
                                            ConfigObject defaultCookieSettings = sessionManagement.getObject("defaultCookieSettings");
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "parseAppModuleCookieFromXML defaultCookieSettings", defaultCookieSettings);
                                            }
                                            if (defaultCookieSettings != null) {
                                                moduleCookie = defaultCookieSettings.getString("name", null);
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "parseAppModuleCookieFromXML moduleCookie", moduleCookie);
                                                }
                                                if (moduleCookie.equalsIgnoreCase("JSESSIONID")) {
                                                    moduleCookie = null;
                                                }
                                            }
                                        }
                                        cookies.put(moduleName, moduleCookie);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, WLMNonDefaultCookieUtility.class.getName() + ".parseAppModuleCookieFromXML", "346", this, new Object[]{cellName, nodeName, applicationName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block30;
                Tr.event(tc, "Unexpected exception reading config for ", new Object[]{cellName, nodeName, applicationName, e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAppModuleCookieFromXML", cookies);
        }
        return cookies;
    }

    public void setCookie(Identity memberIdentity, String cookie) {
        this.setCookie(memberIdentity, null, null, cookie);
    }

    public void setCookie(Identity memberIdentity, String appName, String cookie) {
        this.setCookie(memberIdentity, appName, null, cookie);
    }

    public void setCookie(Identity memberIdentity, String appName, String moduleName, String cookie) {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setCookie", new Object[]{memberIdentity, appName, moduleName, cookie});
            }
            String cellName = IdentityMapping.getCellNameFromIdentity(memberIdentity);
            String serverName = IdentityMapping.getServerNameFromClusterMemberIdentity(memberIdentity);
            String nodeName = IdentityMapping.getNodeNameFromClusterMemberIdentity(memberIdentity);
            byte[] cookieByteData = null;
            if (cookie != null) {
                cookieByteData = cookie.getBytes();
            }
            Identity nonDefaultCookieIdentity = IdentityMapping.getNonDefaultCookieIdentity(cellName, nodeName, serverName, appName, moduleName);
            if (cookie != null) {
                try {
                    clusterManagement.defineMemberScopedData(memberIdentity, nonDefaultCookieIdentity, cookieByteData);
                }
                catch (NoMemberAvailableException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    byte[] data = clusterService.getMemberScopedData(memberIdentity, nonDefaultCookieIdentity);
                    if (data == null) break block13;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setCookie - Clearing cookie");
                    }
                    EndPointImpl endpoint = null;
                    try {
                        endpoint = (EndPointImpl)this.descMgr.getDescription((DescriptionKey)nonDefaultCookieIdentity, EndPoint.class.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (endpoint != null) {
                        clusterMemberService.undefineLocalScopedData(endpoint);
                    }
                }
                catch (NoMemberAvailableException e) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setCookie");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.1");
        }
        clusterMemberService = null;
        configService = null;
        clusterService = ClusterServiceFactory.getClusterService();
        clusterManagement = ClusterManagementFactory.getClusterManagement();
    }
}

