/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.runtime.WLMNonDefaultCookieUtility;
import com.ibm.ws.csi.EJBClusterNameService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class ApplicationServerRuntimeImpl
extends WsComponentImpl
implements EJBClusterNameService,
DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ApplicationServerRuntimeImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String cellName = AdminServiceFactory.getAdminService().getCellName();
    private static ClusterMemberService clusterMemberService = null;
    private static WLMNonDefaultCookieUtility cookieUtility = null;
    private static Object cookieMutex = new Object();
    private Identity containingClusterIdentity = null;
    private Server server = null;
    private static final boolean USE_NON_DEFAULT_COOKIE_NAMES;
    private ConfigService configService = null;
    private String processType;

    public void initialize(Object arg0) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", arg0);
        }
        super.initialize(arg0);
        try {
            clusterMemberService = WsServiceRegistry.getService(this, ClusterMemberService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "115");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService ClusterMemberService Failed");
            }
            throw new ComponentDisabledException();
        }
        try {
            this.configService = WsServiceRegistry.getService(this, ConfigService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "162");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService ConfigService Failed", e);
            }
            throw new ComponentDisabledException();
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.processType = adminService.getProcessType();
        if (this.processType.equals("AdminAgent") || this.processType.equals("JobManager")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize - running in a ADMIN_AGENT_PROCESS or JOB_MANAGER_PROCESS throwing ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        try {
            this.server = WsServiceRegistry.getService(this, Server.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "116");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Server Failed");
            }
            throw new ComponentDisabledException();
        }
        String clusterName = this.server.getClusterName();
        if (clusterName != null) {
            this.containingClusterIdentity = IdentityMapping.getApplicationServerCluster(cellName, clusterName);
        }
        ApplicationMgr appMgr = null;
        try {
            appMgr = WsServiceRegistry.getService(this, ApplicationMgr.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "147");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService ApplicationMgr Failed");
            }
            throw new ComponentDisabledException();
        }
        this.setApplicationMgr(appMgr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{clusterMemberService, this.containingClusterIdentity});
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        this.joinStandaloneCluster(cellName, this.server.getNodeName(), this.server.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public Identity getClusterIdentity(J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentity", new Object[]{j2eeName, j2eeName.getModule()});
        }
        Identity result = this.containingClusterIdentity;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentity", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent doe) throws RuntimeError, RuntimeWarning {
        block25: {
            DeployedObject dObj;
            String deployedName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", doe);
            }
            try {
                deployedName = doe.getDeployedObject().getName();
                dObj = doe.getDeployedObject();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, ApplicationServerRuntimeImpl.class.getName(), "188", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected exception", e);
                }
                return;
            }
            String appName = null;
            if (!(dObj instanceof DeployedModule)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "stateChanged", deployedName + " is not a deployed module.");
                }
                return;
            }
            appName = ((DeployedModule)dObj).getDeployedApplication().getName();
            if (doe.getPropertyName() != null && doe.getPropertyName().equals("state")) {
                if (doe.getNewValue() != null && doe.getNewValue().equals("STARTED")) {
                    block23: {
                        Identity clusterId = IdentityMapping.getApplicationCluster(cellName, appName, deployedName);
                        try {
                            clusterMemberService.joinCluster(clusterId);
                            clusterMemberService.defineAttribute(deployedName);
                        }
                        catch (NoClusterDefinedException e) {
                            FFDCFilter.processException((Throwable)e, ApplicationServerRuntimeImpl.class.getName(), "165", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                            Tr.event(tc, "unexpected exception", e);
                        }
                    }
                    if (USE_NON_DEFAULT_COOKIE_NAMES && this.processType.equals("ManagedProcess")) {
                        Object e = cookieMutex;
                        synchronized (e) {
                            block24: {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "stateChanged - loading non-default cookie information");
                                }
                                try {
                                    if (cookieUtility == null) {
                                        cookieUtility = new WLMNonDefaultCookieUtility();
                                    }
                                    String serverName = this.configService.getServerName();
                                    String nodeName = this.configService.getNodeName();
                                    Identity memberIdentity = IdentityMapping.getMemberIdentityFromMemberName(cellName, nodeName, serverName);
                                    cookieUtility.parseAndSetCookie(memberIdentity, appName);
                                }
                                catch (Exception e2) {
                                    FFDCFilter.processException((Throwable)e2, ApplicationServerRuntimeImpl.class.getName() + ".stateChanged()", "311", this);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                                    Tr.event(tc, "Unexpected exception trying to initialize non-default cookie path, non-default cookies may not be loaded", e2);
                                }
                            }
                        }
                    }
                } else if (doe.getOldValue() != null && doe.getOldValue().equals("STARTED")) {
                    Identity clusterId = IdentityMapping.getApplicationCluster(cellName, appName, deployedName);
                    try {
                        clusterMemberService.disjoinCluster(clusterId);
                    }
                    catch (NoClusterDefinedException e) {
                        FFDCFilter.processException((Throwable)e, ApplicationServerRuntimeImpl.class.getName(), "176", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block25;
                        Tr.event(tc, "unexpected exception", e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged", new Object[]{doe.getPropertyName(), doe.getOldValue(), doe.getNewValue(), doe.getRuntimeState()});
        }
    }

    private void joinStandaloneCluster(String myCellName, String myNodeName, String myServerName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "joinStandaloneCluster", new Object[]{myCellName, myNodeName, myServerName});
        }
        try {
            Identity singletonIdentity = IdentityMapping.getServerInstanceCluster(myCellName, myNodeName, myServerName);
            clusterMemberService.joinCluster(singletonIdentity);
        }
        catch (NoClusterDefinedException ncde) {
            FFDCFilter.processException(ncde, ApplicationServerRuntimeImpl.class.getName() + ".joinSingletonCluster", "197", this, new Object[]{myCellName, myNodeName, myServerName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "joinSingletonCluster", ncde);
            }
            Tr.error(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"joinSingletonCluster", ncde});
        }
    }

    public void setEJBContainer(EJBContainer ejbContainer) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.entry(tc, "setEJBContainer", new Object[]{ejbContainer, this.containingClusterIdentity});
            }
            try {
                if (this.containingClusterIdentity != null && ejbContainer != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                        Tr.debug(tc, "setting Cluster Name Service for EJBContainer");
                    }
                    ejbContainer.setClusterNameService((EJBClusterNameService)this);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, ApplicationServerRuntimeImpl.class.getName() + ".setEJBContainer", "337", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled() || !TraceComponent.isAnyTracingEnabled()) break block6;
                Tr.event(tc, "setEJBContainer: unexpected exception", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.exit(tc, "setEJBContainer");
        }
    }

    public void setApplicationMgr(ApplicationMgr applicationMgr) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.entry(tc, "setApplicationMgr", applicationMgr);
            }
            try {
                if (applicationMgr != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                        Tr.debug(tc, "adding Listener to ApplicationMgr");
                    }
                    applicationMgr.addDeployedObjectListener(this);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, ApplicationServerRuntimeImpl.class.getName() + ".setApplicationMgr", "357", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled() || !TraceComponent.isAnyTracingEnabled()) break block6;
                Tr.event(tc, "setApplicationMgr: unexpected exception", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.exit(tc, "setApplicationMgr");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.20.1.1 ");
        }
        USE_NON_DEFAULT_COOKIE_NAMES = WLMCustomPropertyUtility.getNonDefaultCookieNameValue();
    }
}

