/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.adapter.channel.MonitorAdvisor;
import java.util.ArrayList;
import java.util.HashMap;

public class MonitorAdvisorManager {
    private static final TraceComponent tc = Tr.register(MonitorAdvisorManager.class, "WLMHealthMonitor", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Class[] AdvisorsList = new Class[0];
    private HashMap advisors = new HashMap();

    public ArrayList getAdvisors(Class accessor) {
        if (accessor == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdvisors accessor is null: returning null");
            }
            return null;
        }
        ArrayList advisorGroup = (ArrayList)this.advisors.get(accessor);
        if (advisorGroup == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdvisors advisorGroup is null: returning null");
            }
            return null;
        }
        ArrayList<MonitorAdvisor> advisorsInstances = new ArrayList<MonitorAdvisor>();
        for (int i = 0; i < advisorGroup.size(); ++i) {
            try {
                Class advisorClass = (Class)advisorGroup.get(i);
                MonitorAdvisor advisor = (MonitorAdvisor)advisorClass.newInstance();
                advisorsInstances.add(advisor);
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, MonitorAdvisorManager.class.getName() + ".getAdvisor()", "125");
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "getAdvisor", "Warning: Unable to instantiate or load WLM Health Monitor Advisor: " + advisorGroup.get(i) == null ? "Unknown" : advisorGroup.get(i).getClass().getName());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAdvisors:", new Object[]{new Integer(advisorsInstances.size()), advisorsInstances});
        }
        return advisorsInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdvisor(Class monitorAdvisorClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAdvisor", monitorAdvisorClass.getName());
        }
        Class[] classArray = this.AdvisorsList;
        synchronized (this.AdvisorsList) {
            block15: {
                Class[] tempAdvisorsList = new Class[this.AdvisorsList.length + 1];
                if (this.AdvisorsList.length != 0) {
                    for (int i = 0; i < this.AdvisorsList.length; ++i) {
                        if (this.AdvisorsList[i] != null && this.AdvisorsList[i].equals(monitorAdvisorClass)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "registerAdvisor-Already in list", new Object[]{new Integer(this.AdvisorsList.length), new Integer(this.advisors.size())});
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        tempAdvisorsList[i] = this.AdvisorsList[i];
                    }
                }
                tempAdvisorsList[tempAdvisorsList.length - 1] = monitorAdvisorClass;
                this.AdvisorsList = tempAdvisorsList;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                try {
                    MonitorAdvisor advisor = (MonitorAdvisor)monitorAdvisorClass.newInstance();
                    Class accessor = advisor.getAccessor();
                    HashMap hashMap = this.advisors;
                    synchronized (hashMap) {
                        ArrayList<Class> advisorGroup = (ArrayList<Class>)this.advisors.get(accessor);
                        if (advisorGroup == null) {
                            advisorGroup = new ArrayList<Class>();
                            this.advisors.put(accessor, advisorGroup);
                        }
                        advisorGroup.add(monitorAdvisorClass);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, MonitorAdvisorManager.class.getName() + ".registerAdvisor()", "187");
                    if (!tc.isEventEnabled()) break block15;
                    Tr.event(tc, "registerAdvisor", "Warning: Unable to instantiate or load WLM Health Monitor Advisor: " + monitorAdvisorClass == null ? "Unknown" : monitorAdvisorClass.getName());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerAdvisor", new Object[]{new Integer(this.AdvisorsList.length), new Integer(this.advisors.size())});
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAdvisor(Class monitorAdvisorClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterAdvisor", monitorAdvisorClass.getName());
        }
        if (this.AdvisorsList.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deregisterAdvisor-List is empty", new Object[]{new Integer(this.AdvisorsList.length), new Integer(this.advisors.size())});
            }
            return;
        }
        boolean foundit = false;
        Class[] classArray = this.AdvisorsList;
        synchronized (this.AdvisorsList) {
            block22: {
                Class[] tempAdvisorsList = new Class[this.AdvisorsList.length - 1];
                for (int i = 0; i < this.AdvisorsList.length; ++i) {
                    if (this.AdvisorsList[i] != null && this.AdvisorsList[i].equals(monitorAdvisorClass)) {
                        foundit = true;
                        continue;
                    }
                    if (foundit) {
                        tempAdvisorsList[i - 1] = this.AdvisorsList[i];
                        continue;
                    }
                    if (tempAdvisorsList.length == 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "deregisterAdvisor-Not in list", new Object[]{new Integer(this.AdvisorsList.length), new Integer(this.advisors.size())});
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    tempAdvisorsList[i] = this.AdvisorsList[i];
                }
                if (foundit) {
                    this.AdvisorsList = tempAdvisorsList;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                boolean usingit = false;
                if (foundit) {
                    try {
                        MonitorAdvisor advisor = (MonitorAdvisor)monitorAdvisorClass.newInstance();
                        Class accessor = advisor.getAccessor();
                        for (int i = 0; i < this.AdvisorsList.length; ++i) {
                            if (!accessor.equals(((MonitorAdvisor)this.AdvisorsList[i].newInstance()).getAccessor())) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "deregisterAdvisor-At least one advisor is still using this accessor don't remove it");
                            }
                            usingit = true;
                            break;
                        }
                        if (usingit) break block22;
                        HashMap hashMap = this.advisors;
                        synchronized (hashMap) {
                            ArrayList advisorGroup = (ArrayList)this.advisors.get(accessor);
                            if (advisorGroup != null) {
                                this.advisors.remove(accessor);
                            }
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, MonitorAdvisorManager.class.getName() + ".deregisterAdvisor()", "206");
                        if (!tc.isEventEnabled()) break block22;
                        Tr.event(tc, "deregisterAdvisor", "Warning: Unable to unload WLM Health Monitor Advisor: " + monitorAdvisorClass == null ? "Unknown" : monitorAdvisorClass.getName());
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deregisterAdvisor", new Object[]{new Integer(this.AdvisorsList.length), new Integer(this.advisors.size())});
            }
            return;
        }
    }

    public Class[] getRegisteredAdvisors() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegisteredAdvisors");
        }
        Class[] result = this.AdvisorsList;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegisteredAdvisors", new Object[]{new Integer(result.length), result});
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.6 : none");
        }
    }
}

