/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.HealthMonitorSleepTimePolicy;
import com.ibm.ws.cluster.channel.MonitorTaskInfo;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import java.util.WeakHashMap;

public class HealthMonitorSteppedSleepTimePolicy
implements HealthMonitorSleepTimePolicy {
    private static final TraceComponent tc = Tr.register(HealthMonitorSteppedSleepTimePolicy.class, "WLMHealthMonitor", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int Default_Sleep_Poll_Interval = 1000;
    private WeakHashMap epTasks = null;
    private SleeperThreadPool sleeperThreadPool = null;
    private int sleepInterval = 1000;
    private int[][][] intervalMap = new int[][][]{new int[][]{{5, 1000}, {10, 5000}, {30, 15000}, {90, 60000}, {Integer.MAX_VALUE, 300000}}, new int[][]{{180, 5000}, {420, 15000}, {540, 60000}, {600, 120000}, {Integer.MAX_VALUE, 300000}}};

    public HealthMonitorSteppedSleepTimePolicy(WeakHashMap epTasks, SleeperThreadPool sleeperThreadPool) {
        this.epTasks = epTasks;
        this.sleeperThreadPool = sleeperThreadPool;
    }

    public int getSleepTime(MonitorTaskInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSleepTime ", info);
        }
        int numberOfSuccessiveTest = Math.abs(info.getTestCount());
        if (tc.isDebugEnabled()) {
            int numberOfTasks = this.epTasks.size();
            int threadQueueLength = this.sleeperThreadPool.queueLength();
            int numberOfFreeThread = this.sleeperThreadPool.getNumberOfFreeThread();
            int longestSleepTime = this.sleeperThreadPool.getLongestSleepTime();
            long curTimeStamp = System.currentTimeMillis();
            long lastAccessedInterval = info.getLastAccessedTimeStamp() - curTimeStamp;
            long lastStateChangedInterval = info.getStateChangedTimeStamp() - curTimeStamp;
            Tr.debug(tc, "getSleepTime", new Object[]{"# of Tasks=" + numberOfTasks, "thread Q Length=" + threadQueueLength, "# Free Threads=" + numberOfFreeThread, "# Of Successive Test=" + numberOfSuccessiveTest, "longestSleepTime=" + longestSleepTime, "last Access Interval=" + Long.toString(lastAccessedInterval), "last State Changed Interval=" + Long.toString(lastStateChangedInterval)});
        }
        int rtnVal = this.sleepInterval;
        int[][] curMap = this.intervalMap[info.getEndPoint().isAvailable() ? 0 : 1];
        for (int i = 0; i < curMap.length; ++i) {
            if (numberOfSuccessiveTest > curMap[i][0]) continue;
            rtnVal = curMap[i][1];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSleepTime", Integer.toString(rtnVal));
        }
        return rtnVal;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.3 : none");
        }
    }
}

