/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ProcessProperties
extends HashMap
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(ProcessProperties.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = -7848078131132374203L;
    public static final String unusableIntervalKey = "com.ibm.websphere.wlm.unusable.interval";
    public static final Integer KEY_UNUSABLE_INTERVAL;
    public static final String KEY_CONTAINING_CLUSTER = "key.containing.cluster";
    public static final String KEY_CONTAINING_CLUSTER_WEIGHT_TABLE = "key.containing.cluster.weight.table";
    public static final String KEY_CONTAINING_CELLNAME = "key.containing.cellname";
    public static final String KEY_CONTAINING_CLUSTERNAME = "key.containing.clustername";
    public static final String KEY_ORIGINAL_IOR = "key.original.ior";
    public static final String KEY_WEIGHTED = "key.weighted";
    public static final String KEY_WEIGHTED_PREFER_LOCAL = "key.weighted.preferlocal";
    public static final String KEY_WEIGHTED_NOT_INITIALIZED = "key.weighted.not.initialized";
    public static final String KEY_VIRTUAL_HOST = "key.virtual.host";
    public static final String KEY_DMGR_BOOTSTRAP = "key.dmgr.bootstrap";
    public static final String KEY_LOCAL_MEMBER = "key.local.member";
    public static final String KEY_BOOTSTRAP_REGISTRAR = "key.bootstrap.registrar";
    public static final String KEY_BULLETINBOARD_FACTORY = "key.bulletinboard.factory";
    public static final String KEY_HA_GROUPMANAGER = "key.ha.groupmanager";
    public static final String KEY_CLUSTERMEMBER_SERVICE = "key.clustermember.service";
    public static final String KEY_ENDPOINT_SERVICE = "key.endpoint.service";
    public static final String KEY_CLUSTERMGR = "key.clustermgr";
    public static final String KEY_LOCALTEMPLATE_IOR = "key.localtemplate.ior";
    public static final String KEY_ENDPOINTMGR = "key.endpointmgr";
    public static final String KEY_BBSCOPES = "key.bbscopes";
    public static final String KEY_PUBLIC_BBSCOPE = "key.public.bbscope";
    public static final String KEY_CONFIGURED_WEIGHT = "key.configured.weight";
    public static final String KEY_CONTROLLER_CLUSTER_MANAGER = "key.controller.cluster.manager";
    public static final String KEY_CLUSTERMEMBER_SERVICEPROXY = "key.cluster.member.service.proxy";
    public static final String KEY_ORB = "key.orb";
    public static final String KEY_IGNORE_BB_UPDATES = "key.ignore.bb.updates";
    public static final String KEY_SERVER_LOG_ROOT = "key.server.log.root";
    private static final ProcessProperties instance;

    private ProcessProperties() {
        try {
            String unusableIntervalProp = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String prop = System.getProperty(ProcessProperties.unusableIntervalKey);
                    return prop;
                }
            });
            if (unusableIntervalProp != null) {
                this.put(KEY_UNUSABLE_INTERVAL, new Integer(Integer.parseInt(unusableIntervalProp) * 1000));
            } else {
                this.put(KEY_UNUSABLE_INTERVAL, new Integer(300000));
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, ProcessProperties.class.getName() + ".initialize", "209", this);
            Tr.warning(tc, "NLSKEY_UNABLE_TO_SET_PROPERTIES", e);
        }
        String virtualHost = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String vHost = System.getProperty(ProcessProperties.KEY_VIRTUAL_HOST);
                return vHost;
            }
        });
        if (virtualHost == null) {
            try {
                virtualHost = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        String vHost = InetAddress.getLocalHost().getHostName();
                        return vHost;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae, ProcessProperties.class.getName() + ".initialize", "231", this);
                Tr.warning(tc, "There is a problem to get either virtual host or local host", pae);
            }
        }
        if (virtualHost != null) {
            this.put(KEY_VIRTUAL_HOST, virtualHost);
        }
        TreeMap<String, String> originalIOR = new TreeMap<String, String>();
        TreeMap<String, String> selectionWeighted = new TreeMap<String, String>();
        TreeMap<String, String> selectionWeightedPreferLocal = new TreeMap<String, String>();
        originalIOR.put("ORIGINAL_IOR_MEMBER", "ORIGINAL_IOR_MEMBER");
        selectionWeighted.put("selection", "selection");
        selectionWeighted.put("weighted", "weighted");
        selectionWeightedPreferLocal.put("selection", "selection");
        selectionWeightedPreferLocal.put("weighted", "weighted");
        selectionWeightedPreferLocal.put("preferlocal", "preferlocal");
        KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        try {
            DescriptionKey iorKey = keyRepository.getDescriptionKey(originalIOR);
            DescriptionKey selectionWeightedKey = keyRepository.getDescriptionKey(selectionWeighted);
            DescriptionKey selectionWeightedPreferLocalKey = keyRepository.getDescriptionKey(selectionWeightedPreferLocal);
            this.put(KEY_ORIGINAL_IOR, iorKey);
            this.put(KEY_WEIGHTED, selectionWeightedKey);
            this.put(KEY_WEIGHTED_PREFER_LOCAL, selectionWeightedPreferLocalKey);
            this.put(KEY_IGNORE_BB_UPDATES, new Boolean(false));
            TreeMap<String, String> selectionWeightedNotInit = new TreeMap<String, String>((Map<String, String>)selectionWeighted);
            selectionWeightedNotInit.put("initialized", "false");
            this.put(KEY_WEIGHTED_NOT_INITIALIZED, keyRepository.getDescriptionKey(selectionWeightedNotInit));
        }
        catch (IllegalArgumentException e1) {
            FFDCFilter.processException((Throwable)e1, ProcessProperties.class.getName() + ".initialize", "259", this);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Error - not allowed to serialize this class");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IOException("Error - not allowed to serialize this class");
    }

    public static ProcessProperties getInstance() {
        return instance;
    }

    public String[] introspectSelf() {
        Set set = this.entrySet();
        int size = set.size();
        if (size <= 0) {
            return new String[]{"Map is empty"};
        }
        Iterator iter = this.entrySet().iterator();
        String[] results = new String[size + 1];
        StringBuffer introspectBuffer = new StringBuffer();
        Object key = null;
        Object value = null;
        results[0] = "Dump of each Map entry:";
        int i = 1;
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            key = e.getKey();
            if (key == null) continue;
            value = e.getValue();
            introspectBuffer.setLength(0);
            introspectBuffer.append("   key = ");
            introspectBuffer.append((Object)key);
            introspectBuffer.append(", value = ");
            introspectBuffer.append((Object)value);
            results[i] = new String(introspectBuffer);
            ++i;
        }
        return results;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.16 ");
        }
        KEY_UNUSABLE_INTERVAL = new Integer(0);
        instance = new ProcessProperties();
    }
}

