/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.URL.ParserUtils;
import com.ibm.ws.classloader.SinglePathClassProvider;
import com.ibm.ws.classloader.ZipFileHandle;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class Handler
extends AbstractURLStreamHandlerService {
    private static TraceComponent tc = Tr.register(Handler.class.getName(), "Websphere ClassLoader", null);

    public static boolean register() {
        BundleContext bundleContext = BundleContextMap.instance().get(Handler.class.getClassLoader());
        if (bundleContext == null) {
            return false;
        }
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"wsjar"});
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), properties);
        return true;
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseURL", new Object[]{url, spec, new Integer(start), new Integer(limit)});
        }
        boolean hasScheme = start != 0 && spec.charAt(start - 1) == ':';
        spec = spec.substring(start, limit);
        String path = hasScheme ? spec : Handler.parseRelativeURL(url, spec);
        this.setURL(url, "wsjar", url.getHost(), url.getPort(), url.getAuthority(), url.getUserInfo(), path, url.getQuery(), url.getRef());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseURL", url);
        }
    }

    private static String parseRelativeURL(URL url, String spec) {
        String result;
        String path;
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseRelativePath", new Object[]{url, spec});
        }
        if ((index = (path = url.getPath()).indexOf("!/")) == -1) {
            try {
                url = new URL(new URL(path), spec);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            result = url.toString();
        } else {
            String entry;
            entry = spec.startsWith("/") ? Handler.canonicalize(spec) : ((entry = path.substring(index + 1)).endsWith("/") ? Handler.canonicalize(entry + spec) : (entry.endsWith("/.") ? Handler.canonicalize(entry + '/' + spec) : Handler.canonicalize(entry + "/../" + spec)));
            result = path.substring(0, index) + '!' + entry;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseRelativePath", result);
        }
        return result;
    }

    private static String canonicalize(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalize", s);
        }
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        result.append('/');
        for (int i = 1; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' || result.charAt(result.length() - 1) != '/') {
                result.append(ch);
                continue;
            }
            if (i + 1 == length || s.charAt(i + 1) == '/') {
                ++i;
                continue;
            }
            if (s.charAt(i + 1) == '.' && (i + 2 == length || s.charAt(i + 2) == '/')) {
                i += 2;
                int j = result.length();
                if (--j <= 0) continue;
                while (result.charAt(j - 1) != '/' && --j > 0) {
                }
                result.setLength(j);
                continue;
            }
            result.append('.');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalize", result);
        }
        return result.toString();
    }

    public URLConnection openConnection(URL url) throws IOException {
        URLConnection conn;
        String path;
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openConnection", url);
        }
        if ((index = (path = url.getPath()).indexOf("!/")) == -1) {
            conn = new URL(path).openConnection();
        } else {
            String urlString = ParserUtils.decode(path.substring(0, index));
            String entry = ParserUtils.decode(path.substring(index + 2));
            URL jarURL = new URL(urlString);
            if (!jarURL.getProtocol().equalsIgnoreCase("file")) {
                throw new IOException("invalid jar url for wsjar: " + jarURL);
            }
            conn = new ClassLoaderURLConnection(url, jarURL.getPath(), entry);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openConnection", conn);
        }
        return conn;
    }

    private static class ZipEntryInputStream
    extends FilterInputStream {
        private ZipFileHandle zipFileHandle;

        ZipEntryInputStream(ZipFileHandle zipFileHandle, InputStream in) {
            super(in);
            this.zipFileHandle = zipFileHandle;
        }

        public synchronized void close() throws IOException {
            if (this.zipFileHandle != null) {
                try {
                    super.close();
                }
                catch (IOException ex) {
                    Manager.Ffdc.log(ex, this, this.getClass().getName(), "364");
                }
                this.zipFileHandle.close();
                this.zipFileHandle = null;
            }
        }
    }

    private static class ClassLoaderURLConnection
    extends URLConnection {
        private static TraceComponent tc = Tr.register(ClassLoaderURLConnection.class.getName(), "Websphere ClassLoader", "com.ibm.ws.runtime.runtime");
        private String path;
        private String entry;
        private boolean connected;
        private String contentType;

        ClassLoaderURLConnection(URL url, String path, String entry) {
            super(url);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{url, path, entry});
            }
            this.path = path;
            this.entry = entry;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void connect() throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connect");
            }
            if (!this.connected) {
                boolean exists;
                ZipFileHandle zipFileHandle = SinglePathClassProvider.openZipFile(this.path);
                ZipFile zipFile = zipFileHandle.getZipFile();
                try {
                    exists = zipFile.getEntry(this.entry) != null;
                    Object var5_4 = null;
                    zipFileHandle.close();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    zipFileHandle.close();
                    throw throwable;
                }
                if (!exists) {
                    throw new FileNotFoundException("JAR entry " + this.entry + " not found in " + this.path);
                }
                this.connected = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connect");
            }
        }

        public long getLastModified() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLastModified", this.path);
            }
            long result = new File(this.path).lastModified();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLastModified", result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            ZipEntryInputStream result;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInputStream");
            }
            ZipFileHandle zipFileHandle = SinglePathClassProvider.openZipFile(this.path);
            ZipFile zipFile = zipFileHandle.getZipFile();
            try {
                ZipEntry zipEntry = zipFile.getEntry(this.entry);
                if (zipEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entry + " not found in " + this.path);
                }
                this.connected = true;
                InputStream input = zipFile.getInputStream(zipEntry);
                result = new ZipEntryInputStream(zipFileHandle, input);
                zipFileHandle = null;
                Object var7_6 = null;
                if (zipFileHandle != null) {
                    zipFileHandle.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (zipFileHandle != null) {
                    zipFileHandle.close();
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream", result);
            }
            return result;
        }

        public Permission getPermission() throws IOException {
            String permissionPath = File.separatorChar != '/' ? this.path.replace('/', File.separatorChar) : this.path;
            return new FilePermission(permissionPath, "read");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContentType() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getContentType");
            }
            if (this.contentType == null) {
                block9: {
                    try {
                        InputStream input = this.getInputStream();
                        try {
                            this.contentType = ClassLoaderURLConnection.guessContentTypeFromStream(new BufferedInputStream(input));
                            Object var3_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                        {
                        }
                    }
                    catch (IOException ex) {
                        if (!tc.isDebugEnabled()) break block9;
                        ex.printStackTrace();
                    }
                }
                if (this.contentType == null) {
                    this.contentType = ClassLoaderURLConnection.guessContentTypeFromName(this.entry);
                    if (this.contentType == null) {
                        this.contentType = "content/unknown";
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getContentType", this.contentType);
            }
            return this.contentType;
        }
    }
}

