/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.chains.Chain;
import com.ibm.ws.channel.framework.chains.impl.ChainImpl;
import com.ibm.ws.channel.framework.chains.impl.InboundChainImpl;
import com.ibm.ws.channel.framework.chains.impl.OutboundChainImpl;
import com.ibm.ws.channel.framework.chains.impl.StopChainTask;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChainGroupDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelContainer;
import com.ibm.ws.channel.framework.impl.ChannelDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFactoryDataImpl;
import com.ibm.ws.channel.framework.impl.ChildChannelDataImpl;
import com.ibm.ws.channel.framework.impl.Config;
import com.ibm.ws.channel.framework.impl.InboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.RuntimeState;
import com.ibm.ws.channel.framework.internals.impl.ChannelFrameworkFFDC;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainTimerException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.DuplicatePoolException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.InvalidChainNameException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelNameException;
import com.ibm.wsspi.channel.framework.exception.InvalidRuntimeStateException;
import com.ibm.wsspi.channel.framework.exception.InvalidWeightException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.channel.ws390.BoundRegion;
import com.ibm.wsspi.channel.ws390.CrossRegionSharable;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ChannelFrameworkImpl
implements ChannelFramework {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private Map channelDataMap;
    private Map channelRunningMap;
    private Map chainDataMap;
    private Map chainRunningMap;
    private Map channelFactories;
    protected Map outboundVCFactories;
    private VirtualConnectionFactory inboundVCFactory;
    private Map chainGroups;
    private List globalChainEventListeners;
    private ChannelFrameworkFFDC ffdcModule;
    private Timer stopTimer;
    public static final int DEFAULT_DISC_WEIGHT = 10;
    ThreadPool defaultThreadPool = null;
    protected int defaultMinimumThreads = 10;
    protected int defaultMaximumThreads = 50;
    public static final int DEFAULT_THREADPOOL_KEEPALIVE_TIME = 5000;
    public static final int DEFAULT_THREADPOOL_REQUESTBUFFER_SIZE = 1000;
    private Map services = null;
    public static final String PROPERTY_CHAIN_START_RETRY_INTERVAL = "ChainStartRetryInterval";
    public static final String PROPERTY_CHAIN_START_RETRY_ATTEMPTS = "ChainStartRetryAttempts";
    public static final int DEFAULT_CHAIN_START_RETRY_INTERVAL = 5000;
    public static final int DEFAULT_CHAIN_START_RETRY_ATTEMPTS = 60;
    protected int chainStartRetryInterval = 5000;
    protected int chainStartRetryAttempts = 60;
    private HashMap ChannelZRegions = new HashMap();
    private ThreadPoolRepository threadPoolSource = null;

    public ChannelFrameworkImpl() {
        this(new Config());
    }

    public ChannelFrameworkImpl(Config config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        config2 = null;
        this.channelDataMap = new HashMap();
        this.channelRunningMap = new HashMap();
        this.chainDataMap = new HashMap();
        this.chainRunningMap = new HashMap();
        this.channelFactories = new HashMap();
        this.outboundVCFactories = new HashMap();
        this.inboundVCFactory = new InboundVirtualConnectionFactoryImpl();
        this.chainGroups = new HashMap();
        this.services = new HashMap();
        this.globalChainEventListeners = new ArrayList();
        this.stopTimer = new Timer(true);
        this.ffdcModule = new ChannelFrameworkFFDC(this);
        this.ffdcModule.register();
        this.threadPoolSource = ThreadPoolRepositoryManager.getThreadPoolRepository();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public void setChainStartRetryInterval(String string) throws NumberFormatException {
        int n = this.validateIntCustomProperty(PROPERTY_CHAIN_START_RETRY_INTERVAL, string);
        if (n != -1) {
            this.chainStartRetryInterval = n;
        }
    }

    public void setChainStartRetryAttempts(String string) throws NumberFormatException {
        int n = this.validateIntWithUnlimitedCustomProperty(PROPERTY_CHAIN_START_RETRY_ATTEMPTS, string);
        if (n != -99) {
            this.chainStartRetryAttempts = n;
        }
    }

    public int validateIntCustomProperty(String string, String string2) throws NumberFormatException {
        int n = -1;
        boolean bl = false;
        try {
            n = Integer.parseInt(string2);
            if (n < 0) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            Tr.error(tc, "framework.property.error", new Object[]{string2, string});
            throw new NumberFormatException("Found invalid value of " + string2 + " for property " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found valid value of " + string2 + " for property " + string);
        }
        return n;
    }

    public int validateIntWithUnlimitedCustomProperty(String string, String string2) throws NumberFormatException {
        int n = -99;
        boolean bl = false;
        try {
            n = Integer.parseInt(string2);
            if (n < -1) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            Tr.error(tc, "framework.property.error", new Object[]{string2, string});
            throw new NumberFormatException("Found invalid value of " + string2 + " for property " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found valid value of " + string2 + " for property " + string);
        }
        return n;
    }

    public synchronized void destroy() throws ChannelException, ChainException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.stopTimer.cancel();
        this.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public synchronized void clear() throws ChannelException, ChainException, ChainGroupException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Chain chain = null;
        StringBuffer stringBuffer = new StringBuffer();
        objectArray = this.chainRunningMap.values().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            chain = (Chain)objectArray[n];
            if (chain.getState() == RuntimeState.STARTED || chain.getState() == RuntimeState.QUIESCED) {
                try {
                    this.stopChainInternal(chain, 0L);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "322", this, new Object[]{chain, this});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught stopChainInternal exception " + exception.getMessage());
                    }
                    stringBuffer.append(exception.toString());
                }
            }
            try {
                this.destroyChainInternal(chain);
            }
            catch (ChannelException channelException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught destroyChainInternal exception " + channelException.getMessage());
                }
                stringBuffer.append(channelException.toString());
            }
            catch (ChainException chainException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught destroyChainInternal exception " + chainException.getMessage());
                }
                stringBuffer.append(chainException.toString());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "329", this, new Object[]{chain, this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught destroyChainInternal exception " + exception.getMessage());
                }
                stringBuffer.append(exception.toString());
            }
            try {
                this.removeChain(chain.getName());
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "335", this, new Object[]{chain, this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught removeChain exception " + exception.getMessage());
                }
                stringBuffer.append(exception.toString());
            }
        }
        this.chainRunningMap.clear();
        this.channelRunningMap.clear();
        objectArray2 = this.chainGroups.keySet().toArray();
        for (n = 0; n < objectArray2.length; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove chainGroup, " + objectArray2[n]);
            }
            try {
                this.removeChainGroup((String)objectArray2[n]);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "351", this, new Object[]{objectArray2[n], this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught removeChainGroup exception " + exception.getMessage());
                }
                stringBuffer.append(exception.toString());
            }
        }
        this.chainGroups.clear();
        objectArray2 = this.channelDataMap.keySet().toArray();
        for (n = 0; n < objectArray2.length; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove channelData, " + objectArray2[n]);
            }
            try {
                this.removeChannel((String)objectArray2[n]);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "366", this, new Object[]{objectArray2[n], this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught removeChannel exception " + exception.getMessage());
                }
                stringBuffer.append(exception.toString());
            }
        }
        this.channelDataMap.clear();
        this.chainDataMap.clear();
        objectArray2 = this.channelFactories.keySet().toArray();
        for (n = 0; n < objectArray2.length; ++n) {
            ChannelFactory channelFactory;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove channelFactory, " + objectArray2[n]);
            }
            if ((channelFactory = ((ChannelFactoryDataImpl)this.channelFactories.remove(objectArray2[n])).getChannelFactory()) == null) continue;
            try {
                channelFactory.destroy();
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.clear", "384", this, new Object[]{channelFactory, this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught factory.destroy exception " + exception.getMessage());
                }
                stringBuffer.append(exception.toString());
            }
        }
        this.channelFactories.clear();
        this.globalChainEventListeners.clear();
        ThreadPool threadPool = this.getThreadPool("ChannelFramework Threadpool");
        if (threadPool != null) {
            threadPool.shutdown();
        }
        this.services.clear();
        if (stringBuffer.length() > 0) {
            throw new ChannelException(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized VirtualConnectionFactory getOutboundVCFactory(String string) throws ChannelException, ChainException {
        OutboundVirtualConnectionFactoryImpl outboundVirtualConnectionFactoryImpl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOutboundVCFactory");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chainName=" + string);
            }
            outboundVirtualConnectionFactoryImpl = null;
            if (null == string) {
                InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to get VCFactory for null chain name");
                throw invalidChainNameException;
            }
            outboundVirtualConnectionFactoryImpl = (OutboundVirtualConnectionFactoryImpl)this.outboundVCFactories.get(string);
            if (outboundVirtualConnectionFactoryImpl == null) {
                ChainData chainData = (ChainData)this.chainDataMap.get(string);
                if (null != chainData) {
                    outboundVirtualConnectionFactoryImpl = this.createVirtualConnectionFactory(chainData, this);
                    this.outboundVCFactories.put(string, outboundVirtualConnectionFactoryImpl);
                    break block9;
                } else {
                    if (-1 != string.indexOf("_CFINTERNAL_CHILD_")) {
                        return this.getNestedOutboundVCFactory(string);
                    }
                    InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Chain configuration not found in framework, " + string);
                    FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.getChannelFactory", "459", this, new Object[]{chainData, outboundVirtualConnectionFactoryImpl});
                    throw invalidChainNameException;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing VCF, " + string);
            }
            outboundVirtualConnectionFactoryImpl.incrementRefCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory");
        }
        return outboundVirtualConnectionFactoryImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized VirtualConnectionFactory getNestedOutboundVCFactory(String string) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNestedOutboundVCFactory");
        }
        OutboundVirtualConnectionFactoryImpl outboundVirtualConnectionFactoryImpl = null;
        ChainData[] chainDataArray = this.getInternalRunningChains(string);
        if (chainDataArray.length == 0) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Chain or channel not found in framework, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.getChannelFactory", "548", this, new Object[]{string});
            throw invalidChainNameException;
        }
        ChainData chainData = chainDataArray[0];
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray = chainData.getChannelList();
        int n = 0;
        boolean bl = false;
        for (n = 0; n < channelDataArray.length; ++n) {
            if (!string.startsWith(channelDataArray[n].getName() + "_CFINTERNAL_CHILD_")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found named channel, " + string + " in chain " + chainData.getName() + " at index " + n);
            }
            bl = true;
            break;
        }
        if (!bl) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Chain or channel not found in framework, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.getChannelFactory", "543", this, new Object[]{chainData});
            throw invalidChainNameException;
        }
        int n2 = channelDataArray.length - n - 1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Length of chain to build: " + n2);
        }
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray2 = new com.ibm.websphere.channel.framework.ChannelData[n2];
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i = n + 1; i < channelDataArray.length; ++n3, ++i) {
            channelDataArray2[n3] = channelDataArray[i];
            stringArray[n3] = channelDataArray2[n3].getName();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Channel '" + channelDataArray2[n3].getName() + "' added to new nested chain, index=" + n3);
        }
        ChainDataImpl chainDataImpl = new ChainDataImpl(string, FlowType.OUTBOUND, channelDataArray2, this, null);
        this.addChain(string, FlowType.OUTBOUND, stringArray);
        outboundVirtualConnectionFactoryImpl = this.createVirtualConnectionFactory(chainDataImpl, this);
        this.outboundVCFactories.put(string, outboundVirtualConnectionFactoryImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNestedOutboundVCFactory");
        }
        return outboundVirtualConnectionFactoryImpl;
    }

    public VirtualConnectionFactory getInboundVCFactory() {
        return this.inboundVCFactory;
    }

    public synchronized ChannelFactoryData updateAllChannelFactoryProperties(Class clazz, Map map) throws ChannelFactoryException {
        ChannelFactoryDataImpl channelFactoryDataImpl = this.findOrCreateChannelFactoryData(clazz);
        channelFactoryDataImpl.setProperties(map);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateAllChannelFactoryProperties for factory " + clazz + ", properties:\n" + ChannelFrameworkImpl.stringForMap(map));
        }
        return channelFactoryDataImpl;
    }

    public static String stringForMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map == null) {
            stringBuffer.append("\tNULL");
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                stringBuffer.append("\tkey=" + k + ", value=" + v + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public synchronized ChannelFactoryData updateChannelFactoryProperty(Class clazz, Object object, Object object2) throws ChannelFactoryException {
        ChannelFactoryDataImpl channelFactoryDataImpl = this.findOrCreateChannelFactoryData(clazz);
        channelFactoryDataImpl.setProperty(object, object2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateChannelFactoryProperty for factory " + clazz + ", key=" + object + ", value=" + object2);
        }
        return channelFactoryDataImpl;
    }

    public synchronized ChannelFactoryData getChannelFactory(Class clazz) throws ChannelFactoryException {
        return this.findOrCreateChannelFactoryData(clazz);
    }

    public synchronized ChannelFactoryDataImpl findOrCreateChannelFactoryData(Class clazz) throws ChannelFactoryException {
        ChannelFactoryDataImpl channelFactoryDataImpl = (ChannelFactoryDataImpl)this.channelFactories.get(clazz);
        if (channelFactoryDataImpl == null) {
            ChannelFactory channelFactory = this.getChannelFactoryInternal(clazz, false);
            Class[] classArray = null;
            Class clazz2 = null;
            try {
                classArray = channelFactory.getDeviceInterface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz2 = channelFactory.getApplicationInterface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            channelFactoryDataImpl = new ChannelFactoryDataImpl(clazz, classArray, clazz2);
            this.channelFactories.put(clazz, channelFactoryDataImpl);
        }
        return channelFactoryDataImpl;
    }

    public synchronized ChannelFactory getChannelFactoryInternal(Class clazz, boolean bl) throws ChannelFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelFactoryInternal");
        }
        ChannelFactory channelFactory = null;
        ChannelFactoryDataImpl channelFactoryDataImpl = null;
        if (clazz == null) {
            InvalidChannelFactoryException invalidChannelFactoryException = new InvalidChannelFactoryException("ChannelFactory type is null");
            throw invalidChannelFactoryException;
        }
        try {
            channelFactoryDataImpl = (ChannelFactoryDataImpl)this.channelFactories.get(clazz);
            if (channelFactoryDataImpl != null) {
                channelFactory = channelFactoryDataImpl.getChannelFactory();
            }
            if (null == channelFactory) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create channel factory");
                }
                channelFactory = (ChannelFactory)clazz.newInstance();
                if (bl) {
                    this.initChannelFactory(clazz, channelFactory, null);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.getChannelFactory", "675", this, new Object[]{channelFactoryDataImpl});
            throw new InvalidChannelFactoryException("Can't create instance of channel factory " + clazz.getName() + " " + exception.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getChannelFactoryInternal");
            }
        }
        return channelFactory;
    }

    protected synchronized void initChannelFactory(Class clazz, ChannelFactory channelFactory, Map map) throws ChannelFactoryException {
        ChannelFactoryDataImpl channelFactoryDataImpl = this.findOrCreateChannelFactoryData(clazz);
        channelFactoryDataImpl.setChannelFactory(channelFactory);
        channelFactoryDataImpl.setChannelFramework(this);
        if (map != null) {
            channelFactoryDataImpl.setProperties(map);
        }
        try {
            channelFactory.init(channelFactoryDataImpl);
        }
        catch (ChannelFactoryException channelFactoryException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Factory " + channelFactory + " threw ChannelFactoryException " + channelFactoryException.getMessage());
            }
            throw channelFactoryException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChannelFactory", "770", this, new Object[]{channelFactory});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Factory " + channelFactory + " threw non-ChannelFactoryException " + throwable.getMessage());
            }
            throw new ChannelFactoryException(throwable);
        }
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData addChannel(String string, Class clazz, Map map, int n) throws ChannelException {
        return this.addChannelInternal(string, clazz, map, n);
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData addChannel(String string, Class clazz, Map map) throws ChannelException {
        return this.addChannelInternal(string, clazz, map, 10);
    }

    private com.ibm.websphere.channel.framework.ChannelData addChannelInternal(String string, Class clazz, Map hashMap, int n) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelInternal");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + ", factoryType=" + clazz + ", weight=" + n);
        }
        com.ibm.websphere.channel.framework.ChannelData channelData = null;
        HashMap hashMap2 = hashMap;
        if (null == hashMap2) {
            hashMap2 = new HashMap();
        }
        if (n < 0) {
            InvalidWeightException invalidWeightException = new InvalidWeightException("Invalid weight for channel, " + n);
            throw invalidWeightException;
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Input channel name is null");
            throw invalidChannelNameException;
        }
        channelData = (com.ibm.websphere.channel.framework.ChannelData)this.channelDataMap.get(string);
        if (null != channelData) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Channel already exists: " + string);
            throw invalidChannelNameException;
        }
        this.getChannelFactoryInternal(clazz, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel configuration doesn't exist, create it.");
        }
        channelData = this.createChannelData(string, clazz, hashMap2, n, this);
        this.channelDataMap.put(string, channelData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelInternal");
        }
        return channelData;
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData removeChannel(String string) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChannelInternal");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Input channel name is null");
            throw invalidChannelNameException;
        }
        ChannelDataImpl channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(string);
        if (null == channelDataImpl) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Can't remove unknown channel, " + string);
            throw invalidChannelNameException;
        }
        if (0 != channelDataImpl.getNumChildren()) {
            String string2 = "Can't remove channel config " + string + " in runtime.  Destroy must happen first. ";
            ChannelException channelException = new ChannelException(string2);
            throw channelException;
        }
        this.channelDataMap.remove(string);
        Object[] objectArray = this.chainDataMap.values().toArray();
        ChainDataImpl chainDataImpl = null;
        for (int i = 0; i < objectArray.length; ++i) {
            chainDataImpl = (ChainDataImpl)objectArray[i];
            if (!chainDataImpl.containsChannel(string)) continue;
            this.removeChain(chainDataImpl.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChannelInternal");
        }
        return channelDataImpl;
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData updateAllChannelProperties(String string, Map map) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAllChannelProperties");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Input channel name is null");
            throw invalidChannelNameException;
        }
        ChannelDataImpl channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(string);
        if (null == channelDataImpl) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Unable to find input channel, " + string);
            throw invalidChannelNameException;
        }
        if (null == map) {
            ChannelException channelException = new ChannelException("Null properties found.");
            throw channelException;
        }
        channelDataImpl.setPropertyBag(map);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New properties for channel " + string + ", properties:\n" + ChannelFrameworkImpl.stringForMap(map));
        }
        this.updateRunningChannels(channelDataImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAllChannelProperties");
        }
        return channelDataImpl;
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData updateChannelProperty(String string, Object object, Object object2) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChannelProperty");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + "propertyKey=" + object + ", propertyValue=" + object2);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Input channel name is null");
            throw invalidChannelNameException;
        }
        ChannelDataImpl channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(string);
        if (null == channelDataImpl) {
            String string2 = "Unable to find input channel, " + string;
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException(string2);
            throw invalidChannelNameException;
        }
        if (null == object || null == object2) {
            ChannelException channelException = new ChannelException("Null property key or value found.");
            throw channelException;
        }
        channelDataImpl.setProperty(object, object2);
        this.updateRunningChannels(channelDataImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChannelProperty");
        }
        return channelDataImpl;
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData updateChannelWeight(String string, int n) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChannelWeight");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + ", newWeight=" + n);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Input channel name is null");
            throw invalidChannelNameException;
        }
        ChannelDataImpl channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(string);
        if (null == channelDataImpl) {
            String string2 = "Unable to find input channel, " + string;
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException(string2);
            throw invalidChannelNameException;
        }
        if (n < 0) {
            InvalidWeightException invalidWeightException = new InvalidWeightException("Invalid input weight, " + n);
            throw invalidWeightException;
        }
        channelDataImpl.setDiscriminatorWeight(n);
        this.updateRunningChannels(channelDataImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChannelWeight");
        }
        return channelDataImpl;
    }

    private void updateRunningChannels(ChannelDataImpl channelDataImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRunningChannels");
        }
        ChildChannelDataImpl childChannelDataImpl = null;
        Channel channel = null;
        ChannelContainer channelContainer = null;
        Iterator iterator = channelDataImpl.children();
        while (iterator.hasNext()) {
            childChannelDataImpl = (ChildChannelDataImpl)iterator.next();
            channelContainer = (ChannelContainer)this.channelRunningMap.get(childChannelDataImpl.getName());
            channel = channelContainer.getChannel();
            channel.update(channelContainer.getChannelData());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRunningChannels");
        }
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData getChannel(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            return null;
        }
        com.ibm.websphere.channel.framework.ChannelData channelData = null;
        channelData = (com.ibm.websphere.channel.framework.ChannelData)this.channelDataMap.get(string);
        if (null == channelData && tc.isDebugEnabled()) {
            Tr.debug(tc, "Can't find unknown channel config, " + string);
        }
        return channelData;
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData[] getAllChannels() {
        return this.channelDataMap.values().toArray(new com.ibm.websphere.channel.framework.ChannelData[this.channelDataMap.size()]);
    }

    public synchronized com.ibm.websphere.channel.framework.ChannelData[] getRunningChannels() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChannels");
        }
        ArrayList<ChannelDataImpl> arrayList = new ArrayList<ChannelDataImpl>();
        ChannelContainer channelContainer = null;
        ChannelDataImpl channelDataImpl = null;
        Iterator iterator = this.channelRunningMap.values().iterator();
        while (iterator.hasNext()) {
            channelContainer = (ChannelContainer)iterator.next();
            channelDataImpl = channelContainer.getChannelData().getParent();
            arrayList.add(channelDataImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChannels");
        }
        return arrayList.toArray(new com.ibm.websphere.channel.framework.ChannelData[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getListeningPort(String string) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListeningPort");
        }
        int n = -1;
        Chain chain = (Chain)this.chainRunningMap.get(string);
        if (chain == null) throw new ChainException("Chain " + string + " not found in runtime.");
        ChainDataImpl chainDataImpl = (ChainDataImpl)chain.getChainData();
        if (chainDataImpl.getType() != FlowType.INBOUND) throw new ChainException("Chain " + string + " is not inbound.");
        com.ibm.websphere.channel.framework.ChannelData channelData = chainDataImpl.getChannelList()[0];
        Map map = channelData.getPropertyBag();
        if (map == null) throw new ChainException("Chain " + string + " has no properties.");
        String string2 = (String)map.get("port");
        if (string2 != null && !string2.trim().equalsIgnoreCase("0")) {
            n = Integer.parseInt(string2);
        } else {
            string2 = (String)map.get("listeningPort");
            if (string2 == null) throw new ChainException("Chain " + string + " has no port in the device channel properties.");
            n = Integer.parseInt(string2);
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit(tc, "getListeningPort");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getListeningHost(String string) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListeningHost");
        }
        String string2 = null;
        Chain chain = (Chain)this.chainRunningMap.get(string);
        if (chain == null) throw new ChainException("Chain " + string + " not found in runtime.");
        ChainDataImpl chainDataImpl = (ChainDataImpl)chain.getChainData();
        if (chainDataImpl.getType() != FlowType.INBOUND) throw new ChainException("Chain " + string + " is not inbound.");
        com.ibm.websphere.channel.framework.ChannelData channelData = chainDataImpl.getChannelList()[0];
        Map map = channelData.getPropertyBag();
        if (map == null) throw new ChainException("Chain " + string + " has no properties.");
        string2 = (String)map.get("hostname");
        if (string2 == null) {
            throw new ChainException("Chain " + string + " has no host in the device channel properties.");
        }
        if (!tc.isEntryEnabled()) return string2;
        Tr.exit(tc, "getListeningHost");
        return string2;
    }

    private boolean initChannelInChain(Channel channel, Chain chain) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initChannelInChain");
        }
        String string = channel.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + " chainName=" + chain.getName());
        }
        boolean bl = false;
        ChannelContainer channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        if (null == channelContainer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel not found in runtime so build it");
            }
            ChannelData[] channelDataArray = chain.getChannelsData();
            int n = 0;
            for (n = 0; n < channelDataArray.length && !channelDataArray[n].getName().equals(channel.getName()); ++n) {
            }
            try {
                channel.init();
            }
            catch (ChannelException channelException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Channel " + channel + " threw ChannelException " + channelException.getMessage());
                }
                throw channelException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChannelInChain", "1168", this, new Object[]{channel});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Channel " + channel + " threw non-ChannelException " + throwable.getMessage());
                }
                throw new ChannelException(throwable);
            }
            bl = true;
            channelContainer = new ChannelContainer(channel, (ChildChannelDataImpl)channelDataArray[n]);
            this.channelRunningMap.put(string, channelContainer);
        }
        channelContainer.addChainReference(chain);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initChannelInChain");
        }
        return bl;
    }

    private boolean startChannelInChain(Channel channel, Chain chain) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startChannelInChain");
        }
        String string = channel.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + " chainName=" + chain.getName());
        }
        boolean bl = false;
        ChannelContainer channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        RuntimeState runtimeState = channelContainer.getState();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found channel, state: " + runtimeState.ordinal);
        }
        channel = channelContainer.getChannel();
        if (RuntimeState.INITIALIZED == runtimeState || RuntimeState.QUIESCED == runtimeState) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting channel");
            }
            try {
                channel.start();
            }
            catch (ChannelException channelException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Channel " + channel + " threw ChannelException " + channelException.getMessage());
                }
                throw channelException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChannelInChain", "1228", this, new Object[]{channel});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Channel " + channel + " threw non-ChannelException " + throwable.getMessage());
                }
                throw new ChannelException(throwable);
            }
            bl = true;
            channelContainer.setState(RuntimeState.STARTED);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Skip channel start, invalid former state: " + runtimeState.ordinal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startChannelInChain");
        }
        return bl;
    }

    private boolean disableChannelInChain(Channel channel, Chain chain) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableChannelInChain");
        }
        String string = channel.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + " chainName=" + chain.getName());
        }
        boolean bl = false;
        ChannelContainer channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        RuntimeState runtimeState = channelContainer.getState();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found channel, state: " + runtimeState.ordinal);
        }
        channel = channelContainer.getChannel();
        Map map = channelContainer.getChainMap();
        Iterator iterator = map.values().iterator();
        Chain chain2 = null;
        RuntimeState runtimeState2 = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            chain2 = (Chain)iterator.next();
            runtimeState2 = chain2.getState();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found chain reference: " + chain2.getName() + ", state: " + runtimeState2.ordinal);
            }
            if (chain2.getName().equals(chain.getName()) || RuntimeState.STARTED != runtimeState2 && RuntimeState.QUIESCED != runtimeState2) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found chain that is not ready to stop, " + chain2.getName());
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Disabling channel, " + channel.getName());
            }
            ((InboundChainImpl)chain).disableChannel(channel);
            bl = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Skip channel stop, in use by other chain(s)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableChannelInChain");
        }
        return bl;
    }

    private void stopChannel(Channel channel) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopChannel");
        }
        String string = channel.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        ChannelContainer channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        try {
            channel.stop(0L);
        }
        catch (ChannelException channelException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel " + channel + " threw ChannelException " + channelException.getMessage());
            }
            throw channelException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChannel", "1338", this, new Object[]{channel});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel " + channel + " threw non-ChannelException " + throwable.getMessage());
            }
            throw new ChannelException(throwable);
        }
        channelContainer.setState(RuntimeState.INITIALIZED);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopChannel");
        }
    }

    private synchronized void destroyChannelInChain(Channel channel, Chain chain, com.ibm.websphere.channel.framework.ChannelData channelData) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyChannelInChain");
        }
        String string = channel.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string + " chainName=" + chain.getName());
        }
        ChannelContainer channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        channel = channelContainer.getChannel();
        Map map = channelContainer.getChainMap();
        RuntimeState runtimeState = channelContainer.getState();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remove chain reference for channel, " + string);
        }
        channelContainer.removeChainReference(chain.getName());
        int n = map.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remaining chain refs, " + n);
        }
        if (n == 0) {
            if (RuntimeState.INITIALIZED != runtimeState) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skip channel destroy, not in correct state, state=" + runtimeState.ordinal);
                }
            } else {
                if (chain.getChainData().getType() == FlowType.INBOUND) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Disabling channel, " + channel.getName());
                    }
                    ((InboundChainImpl)chain).disableChannel(channel);
                }
                try {
                    channel.destroy();
                }
                catch (ChannelException channelException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Channel " + channel + " threw ChannelException " + channelException.getMessage());
                    }
                    throw channelException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChannelInChain", "1408", this, new Object[]{channel});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Channel " + channel + " threw non-ChannelException " + throwable.getMessage());
                    }
                    throw new ChannelException(throwable);
                }
                this.channelRunningMap.remove(string);
                ChildChannelDataImpl childChannelDataImpl = (ChildChannelDataImpl)channelData;
                childChannelDataImpl.getParent().removeChild(childChannelDataImpl);
                ChainData[] chainDataArray = this.getRunningChains(channelData.getFactoryType());
                if (chainDataArray == null || chainDataArray.length == 0 || chainDataArray[0] == null || chainDataArray.length == 1 && chainDataArray[0].getName().equals(chain.getChainData().getName())) {
                    ChannelFactoryDataImpl channelFactoryDataImpl = (ChannelFactoryDataImpl)this.channelFactories.remove(channelData.getFactoryType());
                    ChannelFactory channelFactory = channelFactoryDataImpl.getChannelFactory();
                    channelFactoryDataImpl.setChannelFactory(null);
                    if (channelFactory != null) {
                        try {
                            channelFactory.destroy();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChannelInChain", "1450", this, new Object[]{channelFactory});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Factory " + channelFactory + " threw non-ChannelFactoryException " + throwable.getMessage());
                            }
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Skip channel destroy, in use by other chain(s)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyChannelInChain");
        }
    }

    protected boolean currentlyOnZ() {
        return false;
    }

    protected int currentZRegion() {
        return 16;
    }

    public synchronized ChainData addChain(String string, FlowType flowType, String[] stringArray) throws ChannelException, ChainException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        int n = 16;
        boolean bl = true;
        ChannelFactory channelFactory = null;
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Input chain name is null");
            throw invalidChainNameException;
        }
        ChainDataImpl chainDataImpl = null;
        chainDataImpl = (ChainDataImpl)this.chainDataMap.get(string);
        if (null != chainDataImpl) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Chain config already exists, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChain", "1411", this, new Object[]{chainDataImpl});
            throw invalidChainNameException;
        }
        if (null == stringArray || 0 == stringArray.length) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Invalid channel list");
            throw invalidChannelNameException;
        }
        if (this.currentlyOnZ()) {
            n = this.currentZRegion();
        }
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray = new com.ibm.websphere.channel.framework.ChannelData[stringArray.length];
        com.ibm.websphere.channel.framework.ChannelData channelData = null;
        int n2 = 0;
        int n3 = stringArray.length - 1;
        for (n2 = 0; n2 <= n3; ++n2) {
            channelFactory = null;
            channelData = (com.ibm.websphere.channel.framework.ChannelData)this.channelDataMap.get(stringArray[n2]);
            if (null == channelData) {
                serializable = new InvalidChannelNameException("Can't add chain config due to unknown channel, " + stringArray[n2]);
                FFDCFilter.processException((Throwable)serializable, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChain", "1443", this, new Object[]{stringArray[n2]});
                throw serializable;
            }
            if (n != 16 && flowType == FlowType.INBOUND) {
                if (n2 == n3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "On Z, looking at Application Channel, " + channelData.getName());
                    }
                    channelFactory = this.getChannelFactoryInternal(channelData.getFactoryType(), false);
                    if (n == 8) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Operating in Servant Region");
                        }
                        if (channelFactory instanceof BoundRegion && !((BoundRegion)((Object)channelFactory)).isServantStartable(this.channelDataMap)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Channel says it is not startable in Servant Region");
                            }
                            bl = false;
                        }
                    } else if (n == 2 || n == 4) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Operating in CR or CRA Region, Region constant: " + n);
                        }
                        if (channelFactory instanceof BoundRegion && n != ((BoundRegion)((Object)channelFactory)).getRegion(this.channelDataMap)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "This Channel says it is not startable in this Region: getRegion returned: " + ((BoundRegion)((Object)channelFactory)).getRegion(this.channelDataMap));
                            }
                            bl = false;
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "On Z, looking at non-application Channel, " + channelData.getName());
                    }
                    if (n == 2 || n == 4) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Operating in CR or CRA Region, Region constant: " + n);
                        }
                        if ((serializable = (Integer)this.ChannelZRegions.get(channelData.getName())) == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "First time setting region entry for this channel");
                            }
                            this.ChannelZRegions.put(channelData.getName(), new Integer(n));
                        } else {
                            int n4 = (Integer)serializable;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not first time setting region entry for this channel, current region entry is: " + n4);
                            }
                            if ((n4 & n) == 0) {
                                if (channelFactory == null) {
                                    channelFactory = this.getChannelFactoryInternal(channelData.getFactoryType(), false);
                                }
                                if (channelFactory instanceof CrossRegionSharable && !((CrossRegionSharable)((Object)channelFactory)).isSharable(this.channelDataMap)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Channel says it is not sharable");
                                    }
                                    Tr.warning(tc, "channel.shared.warning", new Object[]{channelData.getName()});
                                }
                                this.ChannelZRegions.put(channelData.getName(), new Integer(n4 | n));
                            }
                        }
                    }
                }
            }
            channelDataArray[n2] = channelData;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ok to add channel (okToAdd) is: " + bl);
        }
        if (bl) {
            try {
                serializable = null;
                if (FlowType.INBOUND == flowType) {
                    serializable = new HashMap();
                    Map map = channelDataArray[0].getPropertyBag();
                    serializable.put("hostname", map.get("hostname"));
                    serializable.put("port", map.get("port"));
                    serializable.put("listeningPort", map.get("listeningPort"));
                }
                chainDataImpl = (ChainDataImpl)this.createChainData(string, flowType, channelDataArray, this, (Map)((Object)serializable));
                this.chainDataMap.put(string, chainDataImpl);
                for (int i = 0; i < this.globalChainEventListeners.size(); ++i) {
                    chainDataImpl.addChainEventListener((ChainEventListener)this.globalChainEventListeners.get(i));
                }
            }
            catch (IncoherentChainException incoherentChainException) {
                FFDCFilter.processException(incoherentChainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChain", "1601", this, new Object[]{string, flowType, channelDataArray});
                throw incoherentChainException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChain");
        }
        return chainDataImpl;
    }

    public synchronized ChainData removeChain(String string) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Input chain name is null");
            throw invalidChainNameException;
        }
        ChainData chainData = null;
        Chain chain = (Chain)this.chainRunningMap.get(string);
        if (chain != null) {
            String string2 = "Can't remove chain config " + string + " in runtime.  Destroy first must happen first.";
            ChainException chainException = new ChainException(string2);
            FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.removeChainInternal", "1638", this, new Object[]{chain});
            throw chainException;
        }
        chainData = (ChainData)this.chainDataMap.get(string);
        if (null == chainData) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Can't remove unknown chain, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.removeChainInternal", "1646", this, new Object[]{string});
            throw invalidChainNameException;
        }
        ChainGroupData chainGroupData = null;
        ChainData[] chainDataArray = null;
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        String string3 = null;
        boolean bl = false;
        Object[] objectArray = this.chainGroups.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            bl = false;
            string3 = (String)objectArray[i];
            chainGroupData = (ChainGroupData)this.chainGroups.get(string3);
            chainDataArray = chainGroupData.getChains();
            arrayList.clear();
            for (int j = 0; j < chainDataArray.length; ++j) {
                if (!string.equals(chainDataArray[j].getName())) {
                    arrayList.add(chainDataArray[j]);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing chain from chain group, " + string3);
                }
                bl = true;
            }
            if (!bl) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Updating chain group with new chain config list, " + string3);
            }
            ChainData[] chainDataArray2 = new ChainData[arrayList.size()];
            for (int j = 0; j < arrayList.size(); ++j) {
                chainDataArray2[j] = (ChainData)arrayList.get(j);
            }
            chainGroupData = this.createChainGroupData(string3, chainDataArray2);
            this.chainGroups.put(string3, chainGroupData);
        }
        chainData = (ChainData)this.chainDataMap.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChain");
        }
        return chainData;
    }

    public synchronized ChainData updateChain(String string, String[] stringArray) throws ChannelException, ChainException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        ChainDataImpl chainDataImpl = null;
        ChainDataImpl chainDataImpl2 = null;
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chain name");
            throw invalidChainNameException;
        }
        if (null == stringArray || 0 == stringArray.length) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Null or empty channel list");
            throw invalidChannelNameException;
        }
        chainDataImpl2 = (ChainDataImpl)this.chainDataMap.get(string);
        if (null == chainDataImpl2) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to update unknown chain, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.updateChain", "1724", this, new Object[]{string});
            throw invalidChainNameException;
        }
        Chain chain = (Chain)this.chainRunningMap.get(string);
        if (chain != null) {
            String string2 = "Unable to update runtime chain " + string + ".  Destroy chain first.";
            ChainException chainException = new ChainException(string2);
            FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.updateChain", "1733", this, new Object[]{chain});
            throw chainException;
        }
        boolean bl = false;
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray = new com.ibm.websphere.channel.framework.ChannelData[stringArray.length];
        int n = 0;
        for (n = 0; n < stringArray.length; ++n) {
            channelDataArray[n] = (com.ibm.websphere.channel.framework.ChannelData)this.channelDataMap.get(stringArray[n]);
            if (null != this.channelDataMap.get(stringArray[n])) continue;
            bl = true;
            break;
        }
        if (bl) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Unable to update chain config with unknown channel, " + stringArray[n]);
            FFDCFilter.processException(invalidChannelNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.updateChain", "1752", this, new Object[]{stringArray[n]});
            throw invalidChannelNameException;
        }
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray2 = chainDataImpl2.getChannelList();
        boolean bl2 = true;
        if (channelDataArray2.length == channelDataArray.length) {
            object2 = null;
            object = null;
            boolean bl3 = false;
            bl2 = false;
            for (int i = 0; i < channelDataArray2.length; ++i) {
                object2 = channelDataArray2[i].getName();
                bl3 = false;
                for (int j = 0; j < channelDataArray.length; ++j) {
                    object = channelDataArray[j].getName();
                    if (!((String)object2).equals(object)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            object2 = new InvalidChannelNameException("Unable to update chain config due to identical channel list");
            throw object2;
        }
        try {
            chainDataImpl = (ChainDataImpl)this.createChainData(string, FlowType.INBOUND, channelDataArray, this, chainDataImpl2.getPropertyBag());
        }
        catch (IncoherentChainException incoherentChainException) {
            FFDCFilter.processException(incoherentChainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.updateChain", "1792", this, new Object[]{string, channelDataArray});
            throw incoherentChainException;
        }
        chainDataImpl.setChainEventListeners(chainDataImpl2.removeAllChainEventListeners());
        this.chainDataMap.put(string, chainDataImpl);
        object2 = null;
        object = this.chainGroups.values().iterator();
        while (object.hasNext()) {
            object2 = (ChainGroupDataImpl)object.next();
            if (!((ChainGroupDataImpl)object2).containsChain(string)) continue;
            ((ChainGroupDataImpl)object2).updateChain(chainDataImpl);
        }
        chainDataImpl.chainUpdated();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChain");
        }
        return chainDataImpl;
    }

    public synchronized ChainData getChain(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        if (null == string) {
            return null;
        }
        ChainData chainData = null;
        chainData = (ChainData)this.chainDataMap.get(string);
        if (null == chainData && tc.isDebugEnabled()) {
            Tr.debug(tc, "Can't find unknown chain config, " + string);
        }
        return chainData;
    }

    public synchronized ChainData[] getAllChains() {
        return this.chainDataMap.values().toArray(new ChainData[this.chainDataMap.size()]);
    }

    public synchronized ChainData[] getAllChains(String string) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllChains");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Null channelName found");
            throw invalidChannelNameException;
        }
        ChainDataImpl chainDataImpl = null;
        ArrayList<ChainDataImpl> arrayList = new ArrayList<ChainDataImpl>();
        Iterator iterator = this.chainDataMap.values().iterator();
        while (iterator.hasNext()) {
            chainDataImpl = (ChainDataImpl)iterator.next();
            if (!chainDataImpl.containsChannel(string)) continue;
            arrayList.add(chainDataImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllChains");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ChainData[] getAllChains(Class clazz) throws InvalidChannelFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllChains");
        }
        if (null == clazz) {
            InvalidChannelFactoryException invalidChannelFactoryException = new InvalidChannelFactoryException("Null factory class found");
            throw invalidChannelFactoryException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory=" + clazz.getName());
        }
        String string = clazz.getName();
        String string2 = null;
        ChainDataImpl chainDataImpl = null;
        com.ibm.websphere.channel.framework.ChannelData channelData = null;
        ArrayList<ChainDataImpl> arrayList = new ArrayList<ChainDataImpl>();
        Iterator iterator = this.chainDataMap.values().iterator();
        while (iterator.hasNext()) {
            chainDataImpl = (ChainDataImpl)iterator.next();
            for (int i = 0; i < chainDataImpl.getChannelList().length; ++i) {
                channelData = chainDataImpl.getChannelList()[i];
                string2 = channelData.getFactoryType().getName();
                if (!string2.equals(string)) continue;
                arrayList.add(chainDataImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllChains");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ChainData[] getRunningChains() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChains");
        }
        ChainData[] chainDataArray = new ChainData[this.chainRunningMap.size()];
        ChainDataImpl chainDataImpl = null;
        Chain chain = null;
        int n = 0;
        Iterator iterator = this.chainRunningMap.values().iterator();
        while (iterator.hasNext()) {
            chain = (Chain)iterator.next();
            chainDataImpl = (ChainDataImpl)chain.getChainData();
            chainDataArray[n++] = chainDataImpl.getExternalChainData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChains");
        }
        return chainDataArray;
    }

    public synchronized ChainData[] getRunningChains(String string) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChains");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Null channelName found");
            throw invalidChannelNameException;
        }
        ChainDataImpl chainDataImpl = null;
        ChannelDataImpl channelDataImpl = null;
        ChildChannelDataImpl childChannelDataImpl = null;
        ArrayList<ChainDataImpl> arrayList = new ArrayList<ChainDataImpl>();
        ChannelContainer channelContainer = null;
        Map map = null;
        Iterator iterator = null;
        Iterator iterator2 = null;
        Chain chain = null;
        channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(string);
        if (channelDataImpl == null) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Channel not found in config, " + string);
            throw invalidChannelNameException;
        }
        iterator = channelDataImpl.children();
        while (iterator.hasNext()) {
            childChannelDataImpl = (ChildChannelDataImpl)iterator.next();
            channelContainer = (ChannelContainer)this.channelRunningMap.get(childChannelDataImpl.getName());
            map = channelContainer.getChainMap();
            iterator2 = map.values().iterator();
            while (iterator2.hasNext()) {
                chain = (Chain)iterator2.next();
                chainDataImpl = (ChainDataImpl)chain.getChainData();
                arrayList.add(chainDataImpl.getExternalChainData());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChains");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public ChainData[] getInternalRunningChains(String string) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInternalRunningChains");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        if (null == string) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Null channelName found");
            throw invalidChannelNameException;
        }
        ChainDataImpl chainDataImpl = null;
        ArrayList<ChainDataImpl> arrayList = new ArrayList<ChainDataImpl>();
        ChannelContainer channelContainer = null;
        Map map = null;
        Iterator iterator = null;
        Chain chain = null;
        channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        if (channelContainer == null) {
            InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Channel not found in runtime, " + string);
            throw invalidChannelNameException;
        }
        map = channelContainer.getChainMap();
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            chain = (Chain)iterator.next();
            chainDataImpl = (ChainDataImpl)chain.getChainData();
            arrayList.add(chainDataImpl.getExternalChainData());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInternalRunningChains");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ChainData[] getRunningChains(Class clazz) throws InvalidChannelFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChains");
        }
        if (null == clazz) {
            InvalidChannelFactoryException invalidChannelFactoryException = new InvalidChannelFactoryException("Null factory class found");
            throw invalidChannelFactoryException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory=" + clazz.getName());
        }
        String string = clazz.getName();
        String string2 = null;
        ChainDataImpl chainDataImpl = null;
        com.ibm.websphere.channel.framework.ChannelData channelData = null;
        ArrayList<ChainDataImpl> arrayList = new ArrayList<ChainDataImpl>();
        Iterator iterator = this.chainRunningMap.values().iterator();
        while (iterator.hasNext()) {
            chainDataImpl = (ChainDataImpl)((Chain)iterator.next()).getChainData();
            for (int i = 0; i < chainDataImpl.getChannelList().length; ++i) {
                channelData = chainDataImpl.getChannelList()[i];
                string2 = channelData.getFactoryType().getName();
                if (!string2.equals(string)) continue;
                arrayList.add(chainDataImpl.getExternalChainData());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChains");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized void initChain(String string) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chainName found");
            throw invalidChainNameException;
        }
        ChainData chainData = (ChainData)this.chainDataMap.get(string);
        if (null == chainData) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to init unknown chain, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChain", "2142", this, new Object[]{string});
            throw invalidChainNameException;
        }
        if (FlowType.INBOUND != chainData.getType()) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Outbound chain cannot use this interface.");
            throw invalidChainNameException;
        }
        Chain chain = this.getRunningChain(string);
        if (null != chain) {
            InvalidRuntimeStateException invalidRuntimeStateException = new InvalidRuntimeStateException("Chain cannot be initialized, its already in the runtime.");
            FFDCFilter.processException(invalidRuntimeStateException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChain", "2158", this, new Object[]{chain});
            throw invalidRuntimeStateException;
        }
        this.initChainInternal(chainData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initChain");
        }
    }

    synchronized void initChainInternal(ChainData chainData) throws ChannelException, ChainException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initChainInternal");
        }
        String string = chainData.getName();
        ChainImpl chainImpl = null;
        ChainDataImpl chainDataImpl = null;
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray = chainData.getChannelList();
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray2 = new com.ibm.websphere.channel.framework.ChannelData[channelDataArray.length];
        ChannelDataImpl channelDataImpl = null;
        ChildChannelDataImpl childChannelDataImpl = null;
        boolean[] blArray = new boolean[channelDataArray.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        try {
            if (FlowType.INBOUND == chainData.getType()) {
                channelDataArray2 = this.generateChildDataArray(channelDataArray, blArray);
                chainDataImpl = new ChainDataImpl((ChainDataImpl)chainData, channelDataArray2, this);
                try {
                    chainImpl = new InboundChainImpl(chainDataImpl, this);
                }
                catch (ChannelException channelException) {
                    FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainInternal", "2206", this, new Object[]{chainDataImpl});
                    Tr.error(tc, "chain.initialization.error", new Object[]{chainData.getName(), channelException.toString()});
                    this.cleanChildRefsInParent(channelDataArray2, blArray);
                    throw channelException;
                }
                catch (IncoherentChainException incoherentChainException) {
                    this.cleanChildRefsInParent(channelDataArray2, blArray);
                    throw incoherentChainException;
                }
            }
            for (n = 0; n < channelDataArray.length; ++n) {
                channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(channelDataArray[n].getName());
                channelDataArray2[n] = channelDataImpl.getOutboundChild();
                if (null == channelDataArray2[n]) {
                    channelDataArray2[n] = channelDataImpl.createChild();
                    blArray[n] = true;
                    continue;
                }
                blArray[n] = false;
            }
            chainDataImpl = new ChainDataImpl(string, chainData.getType(), channelDataArray2, this, null);
            try {
                chainImpl = new OutboundChainImpl(chainDataImpl, this);
            }
            catch (ChannelException channelException) {
                FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainInternal", "2241", this, new Object[]{chainDataImpl});
                Tr.error(tc, "chain.initialization.error", new Object[]{chainData.getName(), channelException.toString()});
                this.cleanChildRefsInParent(channelDataArray2, blArray);
                throw channelException;
            }
            catch (IncoherentChainException incoherentChainException) {
                this.cleanChildRefsInParent(channelDataArray2, blArray);
                throw incoherentChainException;
            }
            Channel[] channelArray = chainImpl.getChannels();
            ArrayList<Channel> arrayList = new ArrayList<Channel>();
            try {
                for (int i = 0; i < channelArray.length; ++i) {
                    this.initChannelInChain(channelArray[i], chainImpl);
                    arrayList.add(channelArray[i]);
                }
                chainImpl.init();
            }
            catch (ChannelException channelException) {
                int n2;
                if (channelException instanceof RetryableChannelException) {
                    Tr.debug(tc, "Caught RetryableChannelException indicating the port is busy");
                } else {
                    FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainInternal", "2266", this, new Object[]{channelArray, arrayList, chainImpl});
                    Tr.error(tc, "chain.initialization.error", new Object[]{chainImpl.getName(), channelException.toString()});
                }
                for (n2 = 0; n2 < channelDataArray2.length; ++n2) {
                    if (!blArray[n2]) continue;
                    childChannelDataImpl = (ChildChannelDataImpl)channelDataArray2[n2];
                    childChannelDataImpl.getParent().removeChild(childChannelDataImpl);
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    try {
                        this.destroyChannelInChain((Channel)arrayList.get(n2), chainImpl, channelDataArray2[n2]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw channelException;
            }
            this.chainRunningMap.put(string, chainImpl);
        }
        catch (IncoherentChainException incoherentChainException) {
            FFDCFilter.processException(incoherentChainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainInternal", "2290", this, new Object[]{chainData, chainImpl});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exceptionduring chain init: " + incoherentChainException);
            }
            throw incoherentChainException;
        }
        catch (InvalidChannelNameException invalidChannelNameException) {
            FFDCFilter.processException(invalidChannelNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainInternal", "2298", this, new Object[]{chainData, chainImpl});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exceptionduring chain init: " + invalidChannelNameException);
            }
            throw invalidChannelNameException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initChainInternal");
        }
    }

    private void cleanChildRefsInParent(com.ibm.websphere.channel.framework.ChannelData[] channelDataArray, boolean[] blArray) {
        ChildChannelDataImpl childChannelDataImpl = null;
        for (int i = 0; i < channelDataArray.length; ++i) {
            if (!blArray[i]) continue;
            childChannelDataImpl = (ChildChannelDataImpl)channelDataArray[i];
            childChannelDataImpl.getParent().removeChild(childChannelDataImpl);
        }
    }

    public com.ibm.websphere.channel.framework.ChannelData[] generateChildDataArray(com.ibm.websphere.channel.framework.ChannelData[] channelDataArray, boolean[] blArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateChildDataArray");
        }
        com.ibm.websphere.channel.framework.ChannelData[] channelDataArray2 = new com.ibm.websphere.channel.framework.ChannelData[channelDataArray.length];
        ChannelDataImpl channelDataImpl = null;
        ChildChannelDataImpl childChannelDataImpl = null;
        ChainDataImpl chainDataImpl = null;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < channelDataArray.length; ++i) {
            int n;
            channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(channelDataArray[i].getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Find or create a child for parent " + channelDataImpl.getName());
            }
            if (channelDataImpl.getNumChildren() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parent not in runtime");
                }
                channelDataArray2[i] = channelDataImpl.createChild();
                blArray[i] = true;
                for (n = i + 1; n < channelDataArray2.length; ++n) {
                    channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(channelDataArray[n].getName());
                    channelDataArray2[n] = channelDataImpl.createChild();
                    blArray[n] = true;
                }
            } else {
                if (i == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found connector channel");
                    }
                    arrayList = this.getRunningChains(channelDataImpl);
                    channelDataArray2[i] = channelDataImpl.getInboundChild();
                    if (channelDataArray2[i] == null) {
                        channelDataArray2[i] = channelDataImpl.createChild();
                        blArray[i] = true;
                        continue;
                    }
                    blArray[i] = false;
                    continue;
                }
                n = 0;
                String string = channelDataArray[i].getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found non connector channel, " + string);
                }
                while (arrayList.size() > 0) {
                    chainDataImpl = (ChainDataImpl)arrayList.get(0);
                    if (chainDataImpl.getType() == FlowType.OUTBOUND) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing chain that is outbound, " + chainDataImpl.getName());
                        }
                        arrayList.remove(chainDataImpl);
                        continue;
                    }
                    if (i + 1 > chainDataImpl.getChannelList().length) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing chain that is too short, " + chainDataImpl.getName());
                        }
                        arrayList.remove(chainDataImpl);
                        continue;
                    }
                    childChannelDataImpl = (ChildChannelDataImpl)chainDataImpl.getChannelList()[i];
                    if (!string.equals(childChannelDataImpl.getExternalName())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing divergent chain, " + chainDataImpl.getName());
                        }
                        arrayList.remove(chainDataImpl);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found reusable channel from chain, " + chainDataImpl.getName());
                    }
                    channelDataArray2[i] = childChannelDataImpl;
                    blArray[i] = false;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Channel not in runtime so create it, " + channelDataImpl.getName());
                }
                channelDataArray2[i] = channelDataImpl.createChild();
                blArray[i] = true;
                for (int j = i + 1; j < channelDataArray2.length; ++j) {
                    channelDataImpl = (ChannelDataImpl)this.channelDataMap.get(channelDataArray[j].getName());
                    channelDataArray2[j] = channelDataImpl.createChild();
                    blArray[j] = true;
                }
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateChildDataArray");
        }
        return channelDataArray2;
    }

    public synchronized void startChain(String string) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chainName found");
            throw invalidChainNameException;
        }
        ChainData chainData = (ChainData)this.chainDataMap.get(string);
        if (null == chainData) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Nonexistent chain configuration");
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChain", "2470", this, new Object[]{string});
            throw invalidChainNameException;
        }
        if (FlowType.INBOUND != chainData.getType()) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Outbound chain cannot use this interface.");
            throw invalidChainNameException;
        }
        this.startChainInternal(chainData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startChain");
        }
    }

    synchronized void startChainInternal(ChainData chainData) throws ChannelException, ChainException {
        this.startChainInternal(chainData, ChainStartMode.FAIL_EACH_SILENT);
    }

    public synchronized void startChainInternal(ChainData chainData, ChainStartMode chainStartMode) throws ChannelException, ChainException {
        Chain chain;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startChainInternal");
            }
            String string = chainData.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chainName=" + string);
            }
            if (null == (chain = this.getRunningChain(string))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Chain not found running.  Double check it is configured.");
                }
                if (null == (chainData = (ChainData)this.chainDataMap.get(string))) {
                    InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to start unknown chain, " + string);
                    throw invalidChainNameException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Chain exists, but not in runtime yet.  Initialize it.");
                }
                this.initChainInternal(chainData);
                chain = this.getRunningChain(string);
                if (null == chain) {
                    InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to start unknown chain, " + string);
                    FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2539", this, new Object[]{chainData, chainStartMode});
                    throw invalidChainNameException;
                }
            }
            chainData = chain.getChainData();
            ArrayList<Channel> arrayList = new ArrayList<Channel>();
            try {
                RuntimeState runtimeState = chain.getState();
                if (RuntimeState.INITIALIZED == runtimeState) {
                    if (chainData.getType() == FlowType.INBOUND) {
                        ((InboundChainImpl)chain).setupDiscProcess();
                        Channel[] channelArray = chain.getChannels();
                        boolean bl = false;
                        ChannelData[] channelDataArray = chain.getChannelsData();
                        for (int i = channelArray.length - 1; i >= 0; --i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Start channel in chain: " + channelArray[i].getName());
                            }
                            if (bl = this.startChannelInChain(channelArray[i], chain)) {
                                arrayList.add(channelArray[i]);
                                if (i == 0) continue;
                                ((InboundChainImpl)chain).startDiscProcessBetweenChannels((InboundChannel)channelArray[i], (InboundChannel)channelArray[i - 1], channelDataArray[i].getDiscriminatorWeight());
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Channel was already started, nothing left to do.  channel=" + channelArray[i].getName());
                            }
                            break block30;
                        }
                        break block30;
                    }
                    Channel[] channelArray = chain.getChannels();
                    for (int i = 0; i < channelArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Start channel in chain: " + channelArray[i].getName());
                        }
                        if (!this.startChannelInChain(channelArray[i], chain)) continue;
                        arrayList.add(channelArray[i]);
                    }
                    break block30;
                }
                if (RuntimeState.STARTED != runtimeState) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot start chain " + chainData.getName() + ", state: " + runtimeState.ordinal);
                    }
                    InvalidRuntimeStateException invalidRuntimeStateException = new InvalidRuntimeStateException("Cannot start chain " + chainData.getName());
                    FFDCFilter.processException(invalidRuntimeStateException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2571", this, new Object[]{chainData});
                    throw invalidRuntimeStateException;
                }
            }
            catch (ChannelException channelException) {
                if (!(channelException instanceof RetryableChannelException) || chainStartMode != ChainStartMode.RETRY_EACH_ON_FAIL) {
                    FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2577", this, new Object[]{chainData});
                    ((ChainDataImpl)chainData).chainStartFailed(1, 0);
                    Tr.error(tc, "chain.start.error", new Object[]{chain.getName(), channelException.toString()});
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught RetryableException");
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        this.stopChannel((Channel)arrayList.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2589", this, new Object[]{arrayList.get(i)});
                    }
                }
                throw channelException;
            }
            catch (ChainException chainException) {
                FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2595", this, new Object[]{chainData});
                Tr.error(tc, "chain.start.error", new Object[]{chain.getName(), chainException.toString()});
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        this.stopChannel((Channel)arrayList.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainInternal", "2602", this, new Object[]{arrayList.get(i)});
                    }
                }
                throw chainException;
            }
        }
        chain.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startChainInternal");
        }
    }

    public synchronized void stopChain(String string, long l) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string + "millisec=" + l);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chainName found");
            throw invalidChainNameException;
        }
        if (l < 0L) {
            ChainTimerException chainTimerException = new ChainTimerException("Invalid time length give to stopChain, " + l);
            throw chainTimerException;
        }
        Chain chain = this.getRunningChain(string);
        if (null == chain) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to stop unknown chain, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChain", "2645", this, new Object[]{string});
            throw invalidChainNameException;
        }
        if (FlowType.INBOUND != chain.getChainData().getType()) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Outbound chain cannot use this interface.");
            throw invalidChainNameException;
        }
        this.stopChainInternal(chain, l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopChain");
        }
    }

    synchronized void stopChainInternal(Chain chain, long l) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopChainInternal");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + chain.getName() + ", millisec=" + l);
        }
        RuntimeState runtimeState = chain.getState();
        Channel[] channelArray = chain.getChannels();
        if (RuntimeState.STARTED == runtimeState || RuntimeState.QUIESCED == runtimeState) {
            if (l > 0L) {
                if (RuntimeState.QUIESCED == runtimeState) {
                    InvalidRuntimeStateException invalidRuntimeStateException = new InvalidRuntimeStateException("Stop notification already given for chain: " + chain.getName());
                    throw invalidRuntimeStateException;
                }
                int n = 0;
                try {
                    for (n = 0; n < channelArray.length; ++n) {
                        if (this.getNumStartedChainsUsingChannel(channelArray[n].getName()) != 1) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Quiescing channel: " + channelArray[n].getName());
                        }
                        channelArray[n].stop(l);
                        this.setChannelState(channelArray[n].getName(), RuntimeState.QUIESCED);
                    }
                    StopChainTask stopChainTask = this.scheduleStopChain(chain.getName(), l);
                    chain.setStopTask(stopChainTask);
                    chain.quiesce();
                }
                catch (ChannelException channelException) {
                    FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChainInternal", "2711", this, new Object[]{chain});
                    Tr.error(tc, "chain.stop.error", new Object[]{chain.getName(), channelException.toString()});
                    for (int i = 0; i < n; ++i) {
                        channelArray[i].start();
                        this.setChannelState(channelArray[i].getName(), RuntimeState.STARTED);
                    }
                    throw channelException;
                }
            } else {
                Object object;
                if (RuntimeState.QUIESCED == runtimeState && (object = chain.getStopTask()) != null) {
                    ((TimerTask)object).cancel();
                    chain.setStopTask(null);
                }
                object = new ArrayList();
                for (int i = 0; i < channelArray.length; ++i) {
                    if (this.getNumStartedChainsUsingChannel(channelArray[i].getName()) > 1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Placing channel in list to stop: " + channelArray[i].getName());
                    }
                    if (chain.getChainData().getType() == FlowType.OUTBOUND) {
                        ((ArrayList)object).add(channelArray[i]);
                        continue;
                    }
                    if (!this.disableChannelInChain(channelArray[i], chain)) continue;
                    ((ArrayList)object).add(channelArray[i]);
                }
                if (FlowType.OUTBOUND == chain.getChainData().getType()) {
                    OutboundVirtualConnectionFactoryImpl outboundVirtualConnectionFactoryImpl = null;
                    outboundVirtualConnectionFactoryImpl = (OutboundVirtualConnectionFactoryImpl)this.channelFactories.get(chain.getName());
                    if (outboundVirtualConnectionFactoryImpl != null) {
                        outboundVirtualConnectionFactoryImpl.destroyInternal();
                    }
                }
                int n = 0;
                try {
                    for (n = ((ArrayList)object).size() - 1; n >= 0; --n) {
                        this.stopChannel((Channel)((ArrayList)object).get(n));
                    }
                    chain.stop();
                }
                catch (ChannelException channelException) {
                    FFDCFilter.processException(channelException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChainInternal", "2763", this, new Object[]{chain});
                    Tr.error(tc, "chain.stop.error", new Object[]{chain.getName(), channelException.toString()});
                    if (FlowType.INBOUND == chain.getChainData().getType()) {
                        ((InboundChainImpl)chain).setupDiscProcess();
                    }
                    for (int i = 0; i < n; ++i) {
                        this.startChannelInChain((Channel)((ArrayList)object).get(i), chain);
                    }
                    throw channelException;
                }
            }
        } else {
            InvalidRuntimeStateException invalidRuntimeStateException = new InvalidRuntimeStateException("Unable to stop chain: " + chain.getName() + " because it is not started.");
            FFDCFilter.processException(invalidRuntimeStateException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChainInternal", "2779", this, new Object[]{chain, runtimeState});
            throw invalidRuntimeStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopChainInternal");
        }
    }

    public synchronized void destroyChain(String string) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chainName found");
            throw invalidChainNameException;
        }
        Chain chain = this.getRunningChain(string);
        if (null == chain) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to destroy unknown runtime chain, " + string);
            FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChain", "2809", this, new Object[]{string});
            throw invalidChainNameException;
        }
        if (FlowType.INBOUND != chain.getChainData().getType()) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Outbound chain cannot use this interface.");
            throw invalidChainNameException;
        }
        this.destroyChainInternal(chain);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyChain");
        }
    }

    public synchronized void destroyChainInternal(Chain chain) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyChainInternal");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + chain.getName());
        }
        if (RuntimeState.INITIALIZED == chain.getState()) {
            Channel[] channelArray = chain.getChannels();
            ChannelData[] channelDataArray = chain.getChannelsData();
            for (int i = 0; i < channelArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destroy channel in chain: " + channelArray[i].getName());
                }
                try {
                    this.destroyChannelInChain(channelArray[i], chain, channelDataArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChainInternal", "2865", this, new Object[]{chain, channelDataArray[i]});
                    Tr.error(tc, "chain.destroy.error", new Object[]{chain.getName(), exception.toString()});
                }
            }
            chain.destroy();
            this.chainRunningMap.remove(chain.getName());
            if (FlowType.OUTBOUND == chain.getChainData().getType()) {
                this.outboundVCFactories.remove(chain.getName());
            }
        } else {
            InvalidRuntimeStateException invalidRuntimeStateException = new InvalidRuntimeStateException("Unable to destroy chain: " + chain.getName() + ", state: " + chain.getState().ordinal);
            FFDCFilter.processException(invalidRuntimeStateException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChainInternal", "2861", this, new Object[]{chain});
            throw invalidRuntimeStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyChainInternal");
        }
    }

    public synchronized void addChainEventListener(ChainEventListener chainEventListener, String string) throws InvalidChainNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChainEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
            Tr.debug(tc, "Listener=" + chainEventListener);
        }
        ChainDataImpl chainDataImpl = null;
        if (string != null && string.equals("all_chains")) {
            Iterator iterator = this.chainDataMap.values().iterator();
            while (iterator.hasNext()) {
                chainDataImpl = (ChainDataImpl)iterator.next();
                chainDataImpl.addChainEventListener(chainEventListener);
            }
            this.globalChainEventListeners.add(chainEventListener);
        } else {
            chainDataImpl = (ChainDataImpl)this.chainDataMap.get(string);
            if (null == chainDataImpl) {
                InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to register listener for unknown chain config, " + string);
                FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChainEventListener", "2910", this, new Object[]{string});
                throw invalidChainNameException;
            }
            chainDataImpl.addChainEventListener(chainEventListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChainEventListener");
        }
    }

    public synchronized void removeChainEventListener(ChainEventListener chainEventListener, String string) throws InvalidChainNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChainEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
            Tr.debug(tc, "Listener=" + chainEventListener);
        }
        ChainDataImpl chainDataImpl = null;
        if (string != null && string.equals("all_chains")) {
            Iterator iterator = this.chainDataMap.values().iterator();
            while (iterator.hasNext()) {
                chainDataImpl = (ChainDataImpl)iterator.next();
                chainDataImpl.removeChainEventListener(chainEventListener);
            }
            this.globalChainEventListeners.remove(chainEventListener);
        } else {
            chainDataImpl = (ChainDataImpl)this.chainDataMap.get(string);
            if (null == chainDataImpl) {
                InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Unable to unregister listener for unknown chain config, " + string);
                FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.removeChainEventListener", "2948", this, new Object[]{string});
                throw invalidChainNameException;
            }
            if (this.globalChainEventListeners.contains(chainEventListener)) {
                InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Can't remove a global listener from individual chains, " + string);
                FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.removeChainEventListener", "2953", this, new Object[]{string});
                throw invalidChainNameException;
            }
            chainDataImpl.removeChainEventListener(chainEventListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChainEventListener");
        }
    }

    public synchronized void addGroupEventListener(ChainEventListener chainEventListener, String string) throws ChainGroupException {
        ChainGroupDataImpl chainGroupDataImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addGroupEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
            Tr.debug(tc, "Listener=" + chainEventListener);
        }
        if (null == (chainGroupDataImpl = (ChainGroupDataImpl)this.chainGroups.get(string))) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to register listener for unknown group, " + string);
            FFDCFilter.processException(chainGroupException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.registerGroupEventListener", "2982", this, new Object[]{string});
            throw chainGroupException;
        }
        chainGroupDataImpl.addChainEventListener(chainEventListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addGroupEventListener");
        }
    }

    public synchronized void removeGroupEventListener(ChainEventListener chainEventListener, String string) throws ChainGroupException {
        ChainGroupDataImpl chainGroupDataImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroupEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
            Tr.debug(tc, "Listener=" + chainEventListener);
        }
        if (null == (chainGroupDataImpl = (ChainGroupDataImpl)this.chainGroups.get(string))) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to unregister listener for unknown group, " + string);
            FFDCFilter.processException(chainGroupException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.unregisterGroupEventListener", "3011", this, new Object[]{string});
            throw chainGroupException;
        }
        chainGroupDataImpl.removeChainEventListener(chainEventListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeGroupEventListener");
        }
    }

    public synchronized ChainGroupData addChainGroup(String string, String[] stringArray) throws InvalidChainNameException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChainGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
        }
        ChainData[] chainDataArray = null;
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null group name");
            throw chainGroupException;
        }
        if (null == stringArray || 0 == stringArray.length) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null or empty chain name list");
            throw invalidChainNameException;
        }
        chainDataArray = new ChainData[stringArray.length];
        ChainData chainData = null;
        for (int i = 0; i < stringArray.length; ++i) {
            chainData = (ChainData)this.chainDataMap.get(stringArray[i]);
            if (null != chainData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found chain for group, " + stringArray[i]);
                }
            } else {
                InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Missing chain config during add: " + stringArray[i]);
                FFDCFilter.processException(invalidChainNameException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChainGroup", "3071", this, new Object[]{stringArray[i]});
                throw invalidChainNameException;
            }
            chainDataArray[i] = chainData;
        }
        ChainGroupData chainGroupData = this.createChainGroupData(string, chainDataArray);
        this.chainGroups.put(string, chainGroupData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChainGroup");
        }
        return chainGroupData;
    }

    public synchronized ChainGroupData removeChainGroup(String string) throws ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing chain group, " + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Input group name is null");
            throw chainGroupException;
        }
        ChainGroupData chainGroupData = null;
        chainGroupData = (ChainGroupData)this.chainGroups.remove(string);
        if (null == chainGroupData) {
            ChainGroupException chainGroupException = new ChainGroupException("Null group name");
            throw chainGroupException;
        }
        return chainGroupData;
    }

    public synchronized ChainGroupData updateChainGroup(String string, String[] stringArray) throws ChainGroupException, InvalidChainNameException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updating chain group, " + string);
        }
        ChainGroupData chainGroupData = this.addChainGroup(string, stringArray);
        return chainGroupData;
    }

    public synchronized ChainGroupData getChainGroup(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getChainGroup groupName=" + string);
        }
        if (null == string) {
            return null;
        }
        ChainGroupData chainGroupData = (ChainGroupData)this.chainGroups.get(string);
        if (null == chainGroupData && tc.isDebugEnabled()) {
            Tr.debug(tc, "Chain group not found, " + string);
        }
        return chainGroupData;
    }

    public synchronized ChainGroupData addChainToGroup(String string, String string2) throws ChainGroupException, ChainException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addChainToGroup chainName=" + string2 + ", groupName=" + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainData chainData = (ChainData)this.chainDataMap.get(string2);
        if (null == chainData) {
            ChainException chainException = new ChainException("Unable to find chain: " + string2);
            throw chainException;
        }
        ChainGroupDataImpl chainGroupDataImpl = (ChainGroupDataImpl)this.chainGroups.get(string);
        if (null == chainGroupDataImpl) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        chainGroupDataImpl.addChain(chainData);
        return chainGroupDataImpl;
    }

    public synchronized ChainGroupData removeChainFromGroup(String string, String string2) throws ChainGroupException, ChainException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeChainFromGroup chainName=" + string2 + ", groupName=" + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainData chainData = (ChainData)this.chainDataMap.get(string2);
        if (null == chainData) {
            ChainException chainException = new ChainException("Unable to find chain: " + string2);
            throw chainException;
        }
        ChainGroupDataImpl chainGroupDataImpl = (ChainGroupDataImpl)this.chainGroups.get(string);
        if (null == chainGroupDataImpl) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        chainGroupDataImpl.removeChain(chainData);
        return chainGroupDataImpl;
    }

    public synchronized ChainGroupData[] getAllChainGroups() {
        return this.chainGroups.values().toArray(new ChainGroupData[this.chainGroups.size()]);
    }

    public synchronized ChainGroupData[] getAllChainGroups(String string) throws ChainException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllChainGroups chainName=" + string);
        }
        if (null == string) {
            InvalidChainNameException invalidChainNameException = new InvalidChainNameException("Null chain");
            throw invalidChainNameException;
        }
        ChainData chainData = (ChainData)this.chainDataMap.get(string);
        if (null == chainData) {
            ChainException chainException = new ChainException("Unable to find chain: " + string);
            throw chainException;
        }
        int n = 0;
        int n2 = this.getNumGroupsUsingChain(string);
        ChainGroupData[] chainGroupDataArray = new ChainGroupData[n2];
        ChainGroupData chainGroupData = null;
        Iterator iterator = this.chainGroups.values().iterator();
        while (iterator.hasNext()) {
            chainGroupData = (ChainGroupData)iterator.next();
            if (!chainGroupData.containsChain(string)) continue;
            chainGroupDataArray[n++] = chainGroupData;
        }
        return chainGroupDataArray;
    }

    public synchronized ChainData[] initChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initChainGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainGroupData chainGroupData = (ChainGroupData)this.chainGroups.get(string);
        if (null == chainGroupData) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        ChainData[] chainDataArray = chainGroupData.getChains();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string2 = null;
        Chain chain = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            string2 = chainDataArray[i].getName();
            if (chainDataArray[i].getType() == FlowType.OUTBOUND) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain " + string2 + " is outbound so no action being taken.");
                continue;
            }
            try {
                chain = this.getRunningChain(string2);
                if (null == chain) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initialize the chain, " + string2);
                    }
                    this.initChainInternal(chainDataArray[i]);
                    arrayList.add(chainDataArray[i]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain already in initialized state, " + string2);
                continue;
            }
            catch (Exception exception) {
                String string3 = new String("Error initializing chain " + string2 + " in group " + string + ", exception=" + exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                bl = true;
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.initChainGroup", "3327", this, new Object[]{string2, string});
                stringBuffer.append("\r\n");
                stringBuffer.append(string3);
            }
        }
        if (bl) {
            ChainGroupException chainGroupException = new ChainGroupException(stringBuffer.toString());
            throw chainGroupException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initChainGroup");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ChainData[] startChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        return this.startChainGroup(string, ChainStartMode.FAIL_EACH_SILENT);
    }

    public ChainData[] startChainGroup(String string, ChainStartMode chainStartMode) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startChainGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string + " startMode=" + chainStartMode.getOrdinal());
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainGroupData chainGroupData = (ChainGroupData)this.chainGroups.get(string);
        if (null == chainGroupData) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        ChainData[] chainDataArray = chainGroupData.getChains();
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        String string2 = null;
        Chain chain = null;
        RuntimeState runtimeState = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < chainDataArray.length; ++i) {
            string2 = chainDataArray[i].getName();
            if (chainDataArray[i].getType() == FlowType.OUTBOUND) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain " + string2 + " is outbound so no action being taken.");
                continue;
            }
            try {
                chain = this.getRunningChain(string2);
                if (null == chain) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Chain not found so build it.");
                    }
                    this.initChainInternal(chainDataArray[i]);
                    chain = this.getRunningChain(string2);
                    if (null == chain) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Error starting chain " + string2 + " in group " + string);
                        continue;
                    }
                }
                runtimeState = chain.getState();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Consider starting chain: " + string2 + ", state: " + runtimeState.ordinal);
                }
                if (RuntimeState.INITIALIZED != runtimeState && RuntimeState.QUIESCED != runtimeState) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Start the chain, " + string2);
                }
                this.startChainInternal(chainDataArray[i], chainStartMode);
                arrayList.add(chainDataArray[i]);
                continue;
            }
            catch (Exception exception) {
                if (exception instanceof RetryableChannelException && chainStartMode == ChainStartMode.RETRY_EACH_ON_FAIL) {
                    this.retryChainStart(chainDataArray[i], exception);
                    continue;
                }
                String string3 = new String("Error starting chain " + string2 + " in group " + string + ", exception=" + exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.startChainGroup", "3436", this, new Object[]{string2, string});
                bl = true;
                stringBuffer.append("\r\n");
                stringBuffer.append(string3);
            }
        }
        if (bl) {
            ChainGroupException chainGroupException = new ChainGroupException(stringBuffer.toString());
            throw chainGroupException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startChainGroup");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    protected void retryChainStart(ChainData chainData, Exception exception) {
        FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.retryChainStart", "3470", this, new Object[]{chainData});
        Tr.error(tc, "chain.retrystart.error", new Object[]{chainData.getName(), new Integer(1)});
        ((ChainDataImpl)chainData).chainStartFailed(1, 0);
    }

    public synchronized ChainData[] stopChainGroup(String string, long l) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopChainGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainGroupData chainGroupData = (ChainGroupData)this.chainGroups.get(string);
        if (null == chainGroupData) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        if (l < 0L) {
            ChainTimerException chainTimerException = new ChainTimerException("Invalid time length give to stopChain, " + l);
            throw chainTimerException;
        }
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        ChainData[] chainDataArray = chainGroupData.getChains();
        Chain chain = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        RuntimeState runtimeState = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            string2 = chainDataArray[i].getName();
            if (chainDataArray[i].getType() == FlowType.OUTBOUND) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain " + string2 + " is outbound so no action being taken.");
                continue;
            }
            try {
                chain = this.getRunningChain(string2);
                if (null != chain) {
                    runtimeState = chain.getState();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Consider stopping chain: " + string2 + ", state: " + runtimeState.ordinal);
                    }
                    if (RuntimeState.STARTED != runtimeState && RuntimeState.QUIESCED != runtimeState) continue;
                    if (RuntimeState.QUIESCED == runtimeState && l > 0L) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Stop notification already given for chain: " + string2);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stop the chain, " + string2);
                    }
                    this.stopChainInternal(chain, l);
                    arrayList.add(chainDataArray[i]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain doesn't exist, " + string2);
                continue;
            }
            catch (Exception exception) {
                String string3 = new String("Error stopping chain " + string2 + " in group " + string + ", exception=" + exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                bl = true;
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.stopChainGroup", "3558", this, new Object[]{string2, string});
                stringBuffer.append("\r\n");
                stringBuffer.append(string3);
            }
        }
        if (bl) {
            ChainGroupException chainGroupException = new ChainGroupException(stringBuffer.toString());
            throw chainGroupException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopChainGroup");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ChainData[] destroyChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyChainGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName=" + string);
        }
        if (null == string) {
            ChainGroupException chainGroupException = new ChainGroupException("Null chain group");
            throw chainGroupException;
        }
        ChainGroupData chainGroupData = (ChainGroupData)this.chainGroups.get(string);
        if (null == chainGroupData) {
            ChainGroupException chainGroupException = new ChainGroupException("Unable to find group: " + string);
            throw chainGroupException;
        }
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        ChainData[] chainDataArray = chainGroupData.getChains();
        Chain chain = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        RuntimeState runtimeState = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            string2 = chainDataArray[i].getName();
            if (chainDataArray[i].getType() == FlowType.OUTBOUND) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain " + string2 + " is outbound so no action being taken.");
                continue;
            }
            try {
                chain = this.getRunningChain(string2);
                if (null != chain) {
                    runtimeState = chain.getState();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Consider destroying chain: " + string2 + ", state: " + runtimeState.ordinal);
                    }
                    if (RuntimeState.INITIALIZED != runtimeState) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Destroy the chain, " + string2);
                    }
                    this.destroyChainInternal(chain);
                    arrayList.add(chainDataArray[i]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Chain doesn't exist, " + string2);
                continue;
            }
            catch (Exception exception) {
                String string3 = new String("Error destroying chain " + string2 + " in group " + string + ", exception=" + exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                bl = true;
                FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.destroyChainGroup", "3647", this, new Object[]{string2, string});
                stringBuffer.append("\r\n");
                stringBuffer.append(string3);
            }
        }
        if (bl) {
            ChainGroupException chainGroupException = new ChainGroupException(stringBuffer.toString());
            throw chainGroupException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyChainGroup");
        }
        return arrayList.toArray(new ChainData[arrayList.size()]);
    }

    public synchronized ArrayList getRunningChains(ChannelDataImpl channelDataImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChains");
        }
        ChildChannelDataImpl childChannelDataImpl = null;
        ChannelContainer channelContainer = null;
        Map map = null;
        Chain chain = null;
        ArrayList<ChainData> arrayList = new ArrayList<ChainData>();
        Iterator iterator = channelDataImpl.children();
        while (iterator.hasNext()) {
            childChannelDataImpl = (ChildChannelDataImpl)iterator.next();
            channelContainer = (ChannelContainer)this.channelRunningMap.get(childChannelDataImpl.getName());
            map = channelContainer.getChainMap();
            Iterator iterator2 = map.values().iterator();
            while (iterator2.hasNext()) {
                chain = (Chain)iterator2.next();
                arrayList.add(chain.getChainData());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChains");
        }
        return arrayList;
    }

    public synchronized Chain getRunningChain(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string);
        }
        Chain chain = null;
        if (null == string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null value for chainName");
            }
        } else {
            chain = (Chain)this.chainRunningMap.get(string);
            if (null == chain && tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't find unknown chain, " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChain");
        }
        return chain;
    }

    public synchronized Channel getRunningChannel(String string, Chain chain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChannel");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inputChannelName=" + string);
        }
        if (string == null || chain == null) {
            return null;
        }
        if (null == this.chainRunningMap.get(chain.getName())) {
            return null;
        }
        Channel channel = null;
        boolean bl = false;
        ChannelData[] channelDataArray = chain.getChannelsData();
        ChildChannelDataImpl childChannelDataImpl = null;
        int n = 0;
        for (n = 0; n < channelDataArray.length; ++n) {
            childChannelDataImpl = (ChildChannelDataImpl)channelDataArray[n];
            if (!childChannelDataImpl.getExternalName().equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            channel = chain.getChannels()[n];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChannel");
        }
        return channel;
    }

    public synchronized RuntimeState getChannelState(String string, Chain chain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelState");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName=" + string);
        }
        RuntimeState runtimeState = null;
        Channel channel = this.getRunningChannel(string, chain);
        if (channel != null) {
            ChannelContainer channelContainer = null;
            channelContainer = (ChannelContainer)this.channelRunningMap.get(channel.getName());
            if (null != channelContainer) {
                runtimeState = channelContainer.getState();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelState");
        }
        return runtimeState;
    }

    private synchronized void setChannelState(String string, RuntimeState runtimeState) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setChannelState channelName=" + string + ", state=" + runtimeState.ordinal);
        }
        ChannelContainer channelContainer = null;
        if (null == string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null value for channelName");
            }
        } else {
            channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
            if (null != channelContainer) {
                channelContainer.setState(runtimeState);
            }
        }
    }

    public synchronized boolean doesChannelReferenceChain(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesChannelReferenceChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName:" + string + ", chainName:" + string2);
        }
        boolean bl = false;
        Chain chain = (Chain)this.chainRunningMap.get(string2);
        if (chain != null) {
            ChannelData[] channelDataArray = chain.getChannelsData();
            ChildChannelDataImpl childChannelDataImpl = null;
            for (int i = 0; i < channelDataArray.length; ++i) {
                childChannelDataImpl = (ChildChannelDataImpl)channelDataArray[i];
                if (!childChannelDataImpl.getExternalName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesChannelReferenceChain");
        }
        return bl;
    }

    public synchronized int getNumStartedChainsUsingChannel(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumStartedChainsUsingChannel");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName:" + string);
        }
        int n = 0;
        ChannelContainer channelContainer = null;
        RuntimeState runtimeState = null;
        channelContainer = (ChannelContainer)this.channelRunningMap.get(string);
        if (null != channelContainer) {
            Iterator iterator = channelContainer.getChainMap().values().iterator();
            while (iterator.hasNext()) {
                runtimeState = ((Chain)iterator.next()).getState();
                if (runtimeState != RuntimeState.STARTED) continue;
                ++n;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel not found in runtime, " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumStartedChainsUsingChannel");
        }
        return n;
    }

    public synchronized int getNumRunningChannels() {
        return this.channelRunningMap.size();
    }

    public synchronized int getNumChannels() {
        return this.channelDataMap.size();
    }

    public synchronized int getNumChannelFactories() {
        return this.channelFactories.size();
    }

    public synchronized int getNumRunningChains() {
        return this.chainRunningMap.size();
    }

    public synchronized int getNumChains() {
        return this.chainDataMap.size();
    }

    public synchronized int getNumChainGroups() {
        return this.chainGroups.size();
    }

    public synchronized int getNumGroupsUsingChain(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumGroupsUsingChain");
        }
        int n = 0;
        ChainGroupData chainGroupData = null;
        Iterator iterator = this.chainGroups.values().iterator();
        while (iterator.hasNext()) {
            chainGroupData = (ChainGroupData)iterator.next();
            if (!chainGroupData.containsChain(string)) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumGroupsUsingChain");
        }
        return n;
    }

    public synchronized int getNumOutboundVCFs() {
        return this.outboundVCFactories.size();
    }

    public synchronized StopChainTask scheduleStopChain(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scheduleStopChain");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainName=" + string + " delay=" + l);
        }
        StopChainTask stopChainTask = new StopChainTask(string, this);
        this.stopTimer.schedule((TimerTask)stopChainTask, l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scheduleStopChain");
        }
        return stopChainTask;
    }

    public long getChainStartRetryAttempts() {
        return this.chainStartRetryAttempts;
    }

    public long getChainStartRetryInterval() {
        return this.chainStartRetryInterval;
    }

    protected com.ibm.websphere.channel.framework.ChannelData createChannelData(String string, Class clazz, Map map, int n, ChannelFramework channelFramework) {
        return new ChannelDataImpl(string, clazz, map, n, channelFramework);
    }

    protected ChainData createChainData(String string, FlowType flowType, com.ibm.websphere.channel.framework.ChannelData[] channelDataArray, ChannelFrameworkImpl channelFrameworkImpl, Map map) throws IncoherentChainException {
        return new ChainDataImpl(string, flowType, channelDataArray, channelFrameworkImpl, map);
    }

    protected ChainGroupData createChainGroupData(String string, ChainData[] chainDataArray) {
        return new ChainGroupDataImpl(string, chainDataArray, this);
    }

    protected OutboundVirtualConnectionFactoryImpl createVirtualConnectionFactory(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, ChainException {
        return new OutboundVirtualConnectionFactoryImpl(chainData, this);
    }

    public synchronized String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\n**********************************\r\n**    Outbound Conn Factories   **\r\n**********************************\r\n");
        Iterator iterator = this.outboundVCFactories.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + "\r\n");
        }
        stringBuffer.append("\r\n**********************************\r\n**       Channel Factories      **\r\n**********************************\r\n");
        Iterator iterator2 = this.channelFactories.values().iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append(iterator2.next() + "\r\n");
        }
        stringBuffer.append("\r\n**********************************\r\n**   Channel Configurations     **\r\n**********************************\r\n");
        Iterator iterator3 = this.channelDataMap.values().iterator();
        while (iterator3.hasNext()) {
            stringBuffer.append(iterator3.next().toString());
        }
        stringBuffer.append("\r\n**********************************\r\n**    Chain Configurations      **\r\n**********************************\r\n");
        Iterator iterator4 = this.chainDataMap.values().iterator();
        while (iterator4.hasNext()) {
            stringBuffer.append(iterator4.next().toString());
        }
        stringBuffer.append("\r\n**********************************\r\n**          Chain Groups        **\r\n**********************************\r\n");
        Iterator iterator5 = this.chainGroups.values().iterator();
        ChainGroupData chainGroupData = null;
        ChainData[] chainDataArray = null;
        while (iterator5.hasNext()) {
            chainGroupData = (ChainGroupData)iterator5.next();
            stringBuffer.append("Group: " + chainGroupData.getName() + "\r\n");
            chainDataArray = chainGroupData.getChains();
            for (int i = 0; i < chainDataArray.length; ++i) {
                stringBuffer.append("\tchain: " + chainDataArray[i] + "\r\n");
            }
        }
        stringBuffer.append("\r\n**********************************\r\n**      Runtime Channels        **\r\n**********************************\r\n");
        ChannelContainer channelContainer = null;
        Map map = null;
        Iterator iterator6 = this.channelRunningMap.keySet().iterator();
        while (iterator6.hasNext()) {
            channelContainer = (ChannelContainer)this.channelRunningMap.get(iterator6.next());
            stringBuffer.append("Channel: " + channelContainer.getChannel().getName() + "\r\n");
            stringBuffer.append("\tState: " + channelContainer.getState().ordinal + "\r\n");
            stringBuffer.append("\tReferenced Chains:\r\n");
            map = channelContainer.getChainMap();
            object = map.keySet().iterator();
            while (object.hasNext()) {
                stringBuffer.append("\t\t" + object.next() + "\r\n");
            }
        }
        stringBuffer.append("\r\n**********************************\r\n**       Runtime Chains         **\r\n**********************************\r\n");
        object = null;
        Iterator iterator7 = this.chainRunningMap.values().iterator();
        while (iterator7.hasNext()) {
            object = (Chain)iterator7.next();
            stringBuffer.append(object + "\r\n");
            ChannelData[] channelDataArray = object.getChannelsData();
            stringBuffer.append("\tReferenced Channels:\r\n");
            for (int i = 0; i < channelDataArray.length; ++i) {
                stringBuffer.append("\t\t" + channelDataArray[i].getName() + "\r\n");
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void setDefaultThreadPool(int n, int n2) throws IllegalStateException {
        if (this.threadPoolExists("ChannelFramework Threadpool")) {
            throw new IllegalStateException("ThreadPool already exists");
        }
        this.defaultMaximumThreads = n2;
        this.defaultMinimumThreads = n;
    }

    public synchronized ThreadPool addThreadPool(String string, int n, int n2) throws DuplicatePoolException {
        ThreadPool threadPool = null;
        try {
            threadPool = this.threadPoolSource.createThreadPool(string, n, n2);
        }
        catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
            throw new DuplicatePoolException("Pool name " + string + " already exists", threadPoolAlreadyKnownException);
        }
        return threadPool;
    }

    public synchronized ThreadPool getThreadPool(String string) {
        ThreadPool threadPool = this.threadPoolSource.getThreadPool(string);
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("obtained thread pool ");
            stringBuffer.append(string);
            stringBuffer.append(" from the ThreadPoolRegistryManager.  Thread Pool is ");
            stringBuffer.append(threadPool);
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool");
        }
        return threadPool;
    }

    public synchronized ThreadPool getDefaultThreadPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultThreadPool");
        }
        if (this.defaultThreadPool == null) {
            this.defaultThreadPool = this.getThreadPool("ChannelFramework Threadpool");
            if (this.defaultThreadPool == null) {
                try {
                    this.defaultThreadPool = this.threadPoolSource.createThreadPool("ChannelFramework Threadpool", this.defaultMinimumThreads, this.defaultMaximumThreads, 5000L, 1000);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Created Default Thread Pool With The Name: ChannelFramework Threadpool");
                    }
                }
                catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
                    FFDCFilter.processException(threadPoolAlreadyKnownException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.getDefaultThreadPool", "4446", this, null);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved Default Thread Pool With The Name: ChannelFramework Threadpool");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultThreadPool");
        }
        return this.defaultThreadPool;
    }

    public synchronized void setThreadPool(String string, ThreadPool threadPool) throws DuplicatePoolException {
    }

    public synchronized boolean threadPoolExists(String string) {
        ThreadPool threadPool = this.threadPoolSource.getThreadPool(string);
        return threadPool != null;
    }

    public void registerService(Class clazz, Object object) {
        this.services.put(clazz, object);
    }

    public Object deregisterService(Class clazz) {
        return this.services.remove(clazz);
    }

    public Object lookupService(Class clazz) {
        return this.services.get(clazz);
    }
}

