/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectiveBundleMetadataMgr {
    private static SelectiveBundleData selectiveBundleData = null;
    private static Map<String, Set<String>> hostClasspaths = null;
    private static boolean hostClasspathsSet = false;
    private static boolean metadataProcessed = false;
    private static final String BUNDLE_METADATA_DIR = "wsBundleMetadata";
    private static final String WS_BUNDLE_METADATA = "ws.bundle.metadata";
    private static final String OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String OSGI_CONFIG_AREA = "osgi.configuration.area";
    private static XMLStreamReader parser = null;
    private static final String BUNDLE = "bundle";
    private static final String BUNDLES = "bundles";
    private static final String DIRECTORY = "directory";
    private static final String FRAGMENT = "fragment";
    private static final String EXCLUDE_BUNDLE = "exclude-bundle";
    private static final String INCLUDE_ALL = "include-all";
    private static final String PATH = "path";
    private static final String HOST_CLASSPATH = "host-classpath-prefix";
    private static int event = 0;
    private static boolean debugEnabled = Boolean.getBoolean("ws.selective.bundle.debug");
    private static String debugFileName = System.getProperty("ws.selective.bundle.debugFile");
    private static boolean debugFileAppend = Boolean.getBoolean("ws.selective.bundle.debugFile.append");
    private static BufferedWriter bw = null;
    private static File homeDirectory = null;
    private static File configurationDirectory = null;
    private static Map<String, String> fragmentClasspaths = null;

    public SelectiveBundleMetadataMgr(File inputHomeDirectory, File inputConfigurationDirectory) throws Exception {
        homeDirectory = inputHomeDirectory;
        configurationDirectory = inputConfigurationDirectory;
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("debugFileName for SelectiveBundleMetadataMgr - " + debugFileName);
            if (debugFileName != null) {
                try {
                    File debugFile = new File(debugFileName);
                    File debugFileParent = debugFile.getParentFile();
                    if (!debugFileParent.exists()) {
                        debugFileParent.mkdirs();
                    }
                    if (debugFileAppend) {
                        bw = new BufferedWriter(new FileWriter(debugFileName, true));
                        bw.newLine();
                    } else {
                        bw = new BufferedWriter(new FileWriter(debugFileName));
                    }
                    SelectiveBundleMetadataMgr.log("SelectiveBundleMetaDataMgr constructor");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (debugFileName != null && !debugEnabled) {
            SelectiveBundleMetadataMgr.log("debug file name specified but debug is not enabled");
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("homeDirectory - " + (homeDirectory != null ? homeDirectory.getAbsolutePath() : null));
            SelectiveBundleMetadataMgr.log("configurationDirectory - " + (configurationDirectory != null ? configurationDirectory.getAbsolutePath() : null));
        }
        if (homeDirectory != null && !homeDirectory.exists()) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("specified homeDirectory, " + homeDirectory.getAbsolutePath() + ", does not exist");
            }
            homeDirectory = null;
        }
        if (configurationDirectory != null && !configurationDirectory.exists()) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("specified configurationDirectory, " + configurationDirectory.getAbsolutePath() + ", does not exist");
            }
            configurationDirectory = null;
        }
    }

    public static SelectiveBundleData getSelectiveBundleData() throws Exception {
        SelectiveBundleMetadataMgr.ensureMetadataProcessed();
        return selectiveBundleData;
    }

    public static Set<File> getBundlesToExclude() throws Exception {
        SelectiveBundleMetadataMgr.ensureMetadataProcessed();
        if (selectiveBundleData != null) {
            return SelectiveBundleMetadataMgr.selectiveBundleData.bundlesToExclude;
        }
        return null;
    }

    public static Set<File> getBundlesToInstall() throws Exception {
        SelectiveBundleMetadataMgr.ensureMetadataProcessed();
        if (selectiveBundleData != null) {
            return SelectiveBundleMetadataMgr.selectiveBundleData.bundlesToAdd;
        }
        return null;
    }

    public static Map<String, String> getFragmentClasspaths() throws Exception {
        SelectiveBundleMetadataMgr.ensureMetadataProcessed();
        return fragmentClasspaths;
    }

    public static File getHomeDirectory() throws Exception {
        SelectiveBundleMetadataMgr.ensureMetadataProcessed();
        return homeDirectory;
    }

    private static Set<File> retrieveMetadataFiles() {
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin retrieveMetadataFiles()");
        }
        HashSet<File> metadataDirs = new HashSet<File>();
        HashSet<File> metadataFiles = new HashSet<File>();
        String wsBundleMetadata = System.getProperty(WS_BUNDLE_METADATA);
        if (wsBundleMetadata != null) {
            File wsBundleMetadataDirectory = new File(wsBundleMetadata);
            if (!wsBundleMetadataDirectory.isAbsolute()) {
                wsBundleMetadataDirectory = new File(homeDirectory, wsBundleMetadata);
            }
            if (wsBundleMetadataDirectory.isDirectory()) {
                if (debugEnabled) {
                    SelectiveBundleMetadataMgr.log("found metadataDirectory - " + wsBundleMetadataDirectory.getAbsolutePath());
                }
                metadataDirs.add(wsBundleMetadataDirectory);
            } else if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("metadataDirectory - " + wsBundleMetadataDirectory.getAbsolutePath() + " does not exist");
            }
        }
        if (configurationDirectory != null) {
            File configMetadataDirectory = new File(configurationDirectory, BUNDLE_METADATA_DIR);
            if (configMetadataDirectory.isDirectory()) {
                if (debugEnabled) {
                    SelectiveBundleMetadataMgr.log("found metadataDirectory - " + configMetadataDirectory.getAbsolutePath());
                }
                metadataDirs.add(configMetadataDirectory);
            } else if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("metadata directory " + configMetadataDirectory.getAbsolutePath() + " does not exist or is not a directory");
            }
        }
        if (homeDirectory != null) {
            File wasInstallConfigMetadataDirectory = new File(homeDirectory, "configuration/wsBundleMetadata");
            if (wasInstallConfigMetadataDirectory.isDirectory()) {
                if (debugEnabled) {
                    SelectiveBundleMetadataMgr.log("found metadataDirectory - " + wasInstallConfigMetadataDirectory.getAbsolutePath());
                }
                metadataDirs.add(wasInstallConfigMetadataDirectory);
            } else if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("metadata directory " + wasInstallConfigMetadataDirectory.getAbsolutePath() + " does not exist");
            }
        }
        for (File metadataDir : metadataDirs) {
            File[] files;
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("processing metadata directory - " + metadataDir.getAbsolutePath());
            }
            if ((files = metadataDir.listFiles()) == null) {
                if (!debugEnabled) continue;
                SelectiveBundleMetadataMgr.log("Null returned for list of files in " + metadataDir.getAbsolutePath() + ". There could be a problem with file permissions.");
                continue;
            }
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("number of files - " + files.length);
            }
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getPath().endsWith(".xml")) {
                    if (!debugEnabled) continue;
                    SelectiveBundleMetadataMgr.log("File name, " + files[i].getPath() + ", does not end in '.xml'");
                    continue;
                }
                if (debugEnabled) {
                    SelectiveBundleMetadataMgr.log("metadata file found - " + files[i].getAbsolutePath());
                }
                metadataFiles.add(files[i]);
            }
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end retrieveMetadataFiles()");
        }
        return metadataFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processMetadataFile(File metadataFile) throws Exception {
        FileReader fr = null;
        try {
            fr = new FileReader(metadataFile);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(fr);
            event = parser.nextTag();
            parser.require(1, null, BUNDLES);
            SelectiveBundleMetadataMgr.processBundlesElement();
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    private static void processBundlesElement() throws Exception {
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin processBundlesElement()");
        }
        event = parser.nextTag();
        while (event != 2) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.logElementInfo();
            }
            parser.require(1, null, DIRECTORY);
            SelectiveBundleMetadataMgr.processDirectoryElement();
            event = parser.nextTag();
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("Expecting END_ELEMENT for bundles");
            SelectiveBundleMetadataMgr.logElementInfo();
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end processBundlesElement()");
        }
    }

    private static void processDirectoryElement() throws Exception {
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin processDirectoryElement");
        }
        boolean includeAll = false;
        String path = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName = parser.getAttributeLocalName(i);
            String attrValue = parser.getAttributeValue(i);
            if (attrName.equals(INCLUDE_ALL)) {
                includeAll = true;
                continue;
            }
            if (attrName.equals(PATH)) {
                path = attrValue;
                continue;
            }
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("invalid attribute on <directory> element - " + attrName);
            }
            throw new IllegalArgumentException("invalid attribute on <directory> element - " + attrName);
        }
        if (path == null || path.length() == 0) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("required attribute, path, for <directory> is missing");
            }
            throw new IllegalArgumentException("required path attribute missing from <directory> element");
        }
        File directoryPath = new File(path);
        if (!directoryPath.isAbsolute()) {
            directoryPath = new File(homeDirectory, path);
        }
        if (!directoryPath.exists()) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("The path for the <directory> element, " + directoryPath.getAbsolutePath() + ", does not exist.");
            }
            boolean found = false;
            while (!found) {
                event = parser.next();
                if (event != 2 || !parser.getLocalName().equals(DIRECTORY)) continue;
                found = true;
            }
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("returning from processDirectoryElement");
            }
            return;
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("directory path - " + directoryPath.getAbsolutePath());
        }
        if (includeAll) {
            File[] bundles = directoryPath.listFiles();
            if (bundles != null && bundles.length != 0) {
                for (File bundle : bundles) {
                    if (debugEnabled) {
                        SelectiveBundleMetadataMgr.log("bundle in directory - " + bundle.getAbsolutePath());
                    }
                    SelectiveBundleMetadataMgr.selectiveBundleData.bundlesToAdd.add(bundle);
                }
            } else if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("no bundles found in directory - " + directoryPath.getAbsolutePath());
            }
        }
        event = parser.nextTag();
        while (event != 2) {
            String elementName;
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.logElementInfo();
            }
            if ((elementName = parser.getLocalName()).equals(BUNDLE)) {
                if (includeAll) {
                    throw new IllegalArgumentException("The <bundle> element is not allowed when include_all is specified on the <directory> element");
                }
                SelectiveBundleMetadataMgr.processBundleElement(directoryPath);
            } else if (elementName.equals(FRAGMENT)) {
                SelectiveBundleMetadataMgr.processFragmentElement(directoryPath);
            } else if (elementName.equals(EXCLUDE_BUNDLE)) {
                SelectiveBundleMetadataMgr.processExcludeBundleElement(directoryPath);
            } else {
                throw new IllegalArgumentException("Invalid sub-element for <directory> element - " + elementName);
            }
            event = parser.nextTag();
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("Expecting END_ELEMENT for directory");
            SelectiveBundleMetadataMgr.logElementInfo();
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end processDirectoryElement");
        }
    }

    private static File processBundleElement(File directoryPath) throws Exception {
        File bundlePath;
        String bundleName;
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin processBundleElement");
        }
        if ((bundleName = parser.getElementText().trim()) == null || bundleName.length() == 0) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("Missing data for <bundle> elememt.");
            }
            throw new IllegalArgumentException("Missing data for <bundle> element");
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("bundleName - " + bundleName);
        }
        if (!(bundlePath = new File(directoryPath, bundleName)).exists()) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("Specified bundle not found - " + bundlePath.getAbsolutePath());
            }
        } else {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("bundle path - " + bundlePath.getAbsolutePath());
            }
            SelectiveBundleMetadataMgr.selectiveBundleData.bundlesToAdd.add(bundlePath);
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end processBundleElement");
        }
        return bundlePath;
    }

    private static void processFragmentElement(File directoryPath) throws Exception {
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin processFragmentElement");
        }
        String attrName = null;
        String classpath = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrName = parser.getAttributeLocalName(i);
            String attrValue = parser.getAttributeValue(i);
            if (!attrName.equals(HOST_CLASSPATH)) {
                if (debugEnabled) {
                    SelectiveBundleMetadataMgr.log("invalid attribute on <fragment> element - " + attrName);
                }
                throw new IllegalArgumentException("invalid attribute on <fragment> element - " + attrName);
            }
            classpath = attrValue;
        }
        File fragmentPathFile = SelectiveBundleMetadataMgr.processBundleElement(directoryPath);
        if (classpath == null) {
            return;
        }
        if (fragmentClasspaths == null) {
            fragmentClasspaths = new HashMap<String, String>();
        }
        String fragmentPath = fragmentPathFile.getAbsolutePath();
        fragmentClasspaths.put(fragmentPath, classpath);
    }

    private static void processExcludeBundleElement(File directoryPath) throws Exception {
        String bundleName;
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin processExcludeBundleElement");
        }
        if ((bundleName = parser.getElementText().trim()) == null || bundleName.length() == 0) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("Missing data for <exclude-bundle> elememt.");
            }
            throw new IllegalArgumentException("Missing data for <exclude-bundle> element");
        }
        File bundlePath = new File(directoryPath, bundleName);
        if (!bundlePath.exists()) {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("Specified exclude bundle not found - " + bundlePath.getAbsolutePath());
            }
        } else {
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("exclude bundle path - " + bundlePath.getAbsolutePath());
            }
            SelectiveBundleMetadataMgr.selectiveBundleData.bundlesToExclude.add(bundlePath.getAbsoluteFile());
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end processExcludeBundleElement");
        }
    }

    private static void log(String logString) {
        if (bw == null) {
            System.out.println(logString);
        } else {
            try {
                bw.write(logString);
                bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void logElementInfo() {
        if (event == 1) {
            SelectiveBundleMetadataMgr.log("START_ELEMENT - " + parser.getLocalName());
        } else if (event == 2) {
            SelectiveBundleMetadataMgr.log("END_ELEMENT - " + parser.getLocalName());
        } else {
            SelectiveBundleMetadataMgr.log("tag is - " + event);
        }
    }

    public static Map<String, Set<String>> getHostClasspaths() throws Exception {
        return hostClasspaths;
    }

    public static void setHostClasspaths(Map<String, Set<String>> hostClasspaths) {
        SelectiveBundleMetadataMgr.hostClasspaths = hostClasspaths;
        hostClasspathsSet = true;
    }

    public static boolean isHostClasspathsSet() throws Exception {
        return hostClasspathsSet;
    }

    private static void ensureMetadataProcessed() throws Exception {
        if (!metadataProcessed) {
            try {
                if (homeDirectory == null) {
                    homeDirectory = SelectiveBundleMetadataMgr.retrieveOsgiInstallDir();
                }
                if (configurationDirectory == null) {
                    configurationDirectory = SelectiveBundleMetadataMgr.retrieveOsgiConfigDir();
                }
                Set<File> metadataFiles = SelectiveBundleMetadataMgr.retrieveMetadataFiles();
                if (selectiveBundleData == null) {
                    selectiveBundleData = new SelectiveBundleData();
                }
                if (metadataFiles != null && !metadataFiles.isEmpty()) {
                    for (File metadataFile : metadataFiles) {
                        SelectiveBundleMetadataMgr.processMetadataFile(metadataFile);
                    }
                }
            }
            catch (Exception e) {
                metadataProcessed = true;
                throw new Exception("Problem processing metadata files", e);
            }
            metadataProcessed = true;
        }
    }

    private static File retrieveOsgiConfigDir() {
        String osgiConfigArea;
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin retrieveOsgiConfigDir()");
        }
        if ((osgiConfigArea = System.getProperty(OSGI_CONFIG_AREA)).indexOf(32) != -1) {
            osgiConfigArea = SelectiveBundleMetadataMgr.convertSpaces(osgiConfigArea);
        }
        File osgiConfigDir = null;
        try {
            osgiConfigDir = new File(new URI(osgiConfigArea));
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("osgiConfigDir - " + osgiConfigDir.getAbsolutePath());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("problem converting osgi.configuration.area string, " + osgiConfigArea + " to URI", e);
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end retrieveOsgiConfigDir()");
        }
        return osgiConfigDir;
    }

    private static File retrieveOsgiInstallDir() {
        String osgiInstallArea;
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("begin retrieveOsgiInstallDir()");
        }
        if ((osgiInstallArea = System.getProperty(OSGI_INSTALL_AREA)).indexOf(32) != -1) {
            osgiInstallArea = SelectiveBundleMetadataMgr.convertSpaces(osgiInstallArea);
        }
        File osgiInstallDir = null;
        try {
            osgiInstallDir = new File(new URI(osgiInstallArea));
            if (debugEnabled) {
                SelectiveBundleMetadataMgr.log("osgiInstallDir - " + osgiInstallDir.getAbsolutePath());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Problem converting osgi.install.area string, " + osgiInstallArea + " to URI", e);
        }
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("end retrieveOsgiInstallDir()");
        }
        return osgiInstallDir;
    }

    private static String convertSpaces(String string) {
        StringBuilder sb = new StringBuilder(string);
        int index = sb.indexOf(" ");
        while (index != -1) {
            sb.replace(index, index + 1, "%20");
            index = sb.indexOf(" ");
        }
        return sb.toString();
    }

    static {
        if (debugEnabled) {
            SelectiveBundleMetadataMgr.log("debugFileName for SelectiveBundleMetadataMgr - " + debugFileName);
            if (debugFileName != null) {
                try {
                    File debugFile = new File(debugFileName);
                    File debugFileParent = debugFile.getParentFile();
                    if (!debugFileParent.exists()) {
                        debugFileParent.mkdirs();
                    }
                    bw = new BufferedWriter(new FileWriter(debugFileName));
                    SelectiveBundleMetadataMgr.log("SelectiveBundleMetaDataMgr static initializer");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (debugFileName != null && !debugEnabled) {
            SelectiveBundleMetadataMgr.log("debug file name specified but debug is not enabled");
        }
    }

    public static class SelectiveBundleData {
        public Set<File> bundlesToAdd = new HashSet<File>();
        public Set<File> bundlesToExclude = new HashSet<File>();
    }
}

