/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.wssapi.trust;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClientValidateResult;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import com.ibm.wsspi.wssecurity.trust.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.trust.config.RequesterConfig;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.util.Base64;

public abstract class WSSTrustClient
implements WSSConstants {
    private static Map<String, String> clientMap = null;
    private static Map<String, WSSTrustClient> factories = new HashMap<String, WSSTrustClient>();
    protected ProviderConfig providerConfig = null;
    private static Map<String, String> providerMap = null;
    private static Map<String, String> requesterMap = null;
    protected static final SecurityPermission ISSUE_TOKEN_PERM = new SecurityPermission("wssapi.TrustClient.issue");

    public static byte[] decode(String data) {
        return Base64.decode(data);
    }

    public static String encode(byte[] data) {
        return Base64.encode(data);
    }

    public static WSSTrustClient getInstance(ProviderConfig providerConfig) throws WSSException {
        String wst2;
        WSSTrustClient instance;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        if ((instance = factories.get(wst2 = providerConfig.getWSTrustNamespace())) == null) {
            String factoryImpl = clientMap.get(wst2);
            if (factoryImpl == null) {
                throw WSSException.format("security.wssecurity.trust.client.wstnamespace", wst2);
            }
            instance = (WSSTrustClient)WSSTrustClient.loadClass(factoryImpl);
            instance.init(providerConfig);
            factories.put(wst2, instance);
        }
        return instance;
    }

    private static Object loadClass(String factoryImpl) throws WSSException {
        Object instance = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            instance = cl.loadClass(factoryImpl).newInstance();
        }
        catch (Throwable t) {
            try {
                instance = Class.forName(factoryImpl).newInstance();
            }
            catch (Throwable e) {
                throw WSSException.format("security.wssecurity.trust.client.instance", e);
            }
        }
        return instance;
    }

    public static ProviderConfig newProviderConfig(String wstNamespace, String stsAddress) throws WSSException {
        String providerConfigImpl = providerMap.get(wstNamespace);
        ProviderConfig providerConfig = null;
        if (providerConfigImpl == null) {
            throw WSSException.format("security.wssecurity.trust.client.wstnamespace", wstNamespace);
        }
        providerConfig = (ProviderConfig)WSSTrustClient.loadClass(providerConfigImpl);
        providerConfig.init(wstNamespace, stsAddress);
        return providerConfig;
    }

    public static RequesterConfig newRequesterConfig(String wstNamespace) throws WSSException {
        String requesterConfigImpl = requesterMap.get(wstNamespace);
        if (requesterConfigImpl == null) {
            throw WSSException.format("security.wssecurity.trust.client.wstnamespace", wstNamespace);
        }
        return (RequesterConfig)WSSTrustClient.loadClass(requesterConfigImpl);
    }

    protected void init(ProviderConfig providerConfig) {
        this.providerConfig = providerConfig;
    }

    public abstract List<SecurityToken> issue(ProviderConfig var1, RequesterConfig var2) throws WSSException;

    public abstract List<SecurityToken> issue(ProviderConfig var1, List<RequesterConfig> var2) throws WSSException;

    public abstract List<WSSTrustClientValidateResult> validate(ProviderConfig var1, RequesterConfig var2) throws WSSException;

    public abstract List<WSSTrustClientValidateResult> validate(ProviderConfig var1, List<RequesterConfig> var2) throws WSSException;

    static {
        clientMap = new HashMap<String, String>();
        clientMap.put("http://schemas.xmlsoap.org/ws/2005/02/trust", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.WSSTrust12ClientFactory");
        clientMap.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.WSSTrust13ClientFactory");
        requesterMap = new HashMap<String, String>();
        requesterMap.put("http://schemas.xmlsoap.org/ws/2005/02/trust", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.Trust12RequesterConfig");
        requesterMap.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.Trust13RequesterConfig");
        providerMap = new HashMap<String, String>();
        providerMap.put("http://schemas.xmlsoap.org/ws/2005/02/trust", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.TrustProviderConfig");
        providerMap.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "com.ibm.ws.wssecurity.wssapi.trust.client.impl.TrustProviderConfig");
    }
}

