/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.token;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.wssecurity.util.SecurityContextTokenCache;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.axis2.jaxws.spi.BindingProvider;

public class SecurityContextTokenUtil {
    private static SecurityContextTokenCache _sctCache = null;
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public static SecurityContextToken getSecurityContextToken(javax.xml.ws.BindingProvider bp) {
        if (bp instanceof BindingProvider) {
            SecurityContextToken sct = SecurityContextTokenUtil.getSecurityContextTokenCache().getSecurityContextToken((BindingProvider)bp);
            return sct;
        }
        return null;
    }

    private static SecurityContextTokenCache getSecurityContextTokenCache() {
        if (_sctCache != null) {
            return _sctCache;
        }
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        String className = "com.ibm.ws.wssecurity.platform.auth.SecurityContextTokenCacheImpl";
        try {
            _sctCache = cl != null ? (SecurityContextTokenCache)cl.loadClass(className).newInstance() : (SecurityContextTokenCache)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return _sctCache;
    }
}

