/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertStore;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class X509GenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = -2223655857588374454L;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_KEYSTORE = 1;
    private static final int TYPE_SPECIAL = 2;
    private int type;
    private boolean requestorCertificate;
    private boolean identityAssertion;
    private String storeRef;
    private String storePath;
    private String storeType;
    private char[] storePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private List<CertStore> certStores;

    public X509GenerateCallbackHandler(Map<Object, Object> properties) {
        this.type = 0;
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            KeyInformationConfig kiconfig;
            KeyStoreConfig ksconfig = config2.getResolvingKeyStore();
            if (ksconfig != null) {
                this.storeRef = ksconfig.getKsRef();
                this.storePath = ksconfig.getPath();
                this.storeType = ksconfig.getType();
                String tmp = ksconfig.getPassword();
                char[] cArray = this.storePassword = tmp == null ? null : tmp.toCharArray();
            }
            if ((kiconfig = config2.getKeyInformation()) != null) {
                this.alias = kiconfig.getAlias();
                String tmp = kiconfig.getKeyPass();
                this.keyPassword = tmp == null ? null : tmp.toCharArray();
                this.keyName = kiconfig.getName();
            }
            this.certStores = config2.getCertStores();
            Object obj = config2.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (obj != null) {
                this.identityAssertion = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get("com.ibm.wsspi.wssecurity.token.cert.useRequestorCert")) != null) {
                this.requestorCertificate = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
        }
    }

    public X509GenerateCallbackHandler(String storeRef, String storePath, String storeType, char[] storePassword, String alias, char[] keyPassword, String keyName, List<CertStore> certStores) {
        this.type = 1;
        this.storeRef = storeRef;
        this.storePath = storePath;
        this.storeType = storeType;
        this.storePassword = storePassword;
        this.alias = alias;
        this.keyPassword = (char[])(keyPassword != null && keyPassword.length != 0 ? keyPassword : null);
        this.keyName = keyName;
        this.certStores = certStores;
    }

    public X509GenerateCallbackHandler(boolean requestorCertificate, boolean identityAssertion) {
        this.type = 2;
        this.requestorCertificate = requestorCertificate;
        this.identityAssertion = identityAssertion;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (!(callback instanceof X509GenerateCallback)) continue;
            X509GenerateCallback x509Callback = (X509GenerateCallback)callback;
            if (this.type == 0) {
                x509Callback.setKeyStoreReference(this.storeRef);
                x509Callback.setKeyStorePath(this.storePath);
                x509Callback.setKeyStoreType(this.storeType);
                x509Callback.setKeyStorePassword(this.storePassword);
                x509Callback.setAlias(this.alias);
                x509Callback.setKeyPassword(this.keyPassword);
                x509Callback.setKeyName(this.keyName);
                x509Callback.setCertStores(this.certStores);
                x509Callback.setUsedRequestorCertificate(this.requestorCertificate);
                x509Callback.setUsedIdentityAssertion(this.identityAssertion);
                continue;
            }
            if (this.type == 1) {
                x509Callback.setKeyStoreReference(this.storeRef);
                x509Callback.setKeyStorePath(this.storePath);
                x509Callback.setKeyStoreType(this.storeType);
                x509Callback.setKeyStorePassword(this.storePassword);
                x509Callback.setAlias(this.alias);
                x509Callback.setKeyPassword(this.keyPassword);
                x509Callback.setKeyName(this.keyName);
                x509Callback.setCertStores(this.certStores);
                continue;
            }
            if (this.type != 2) continue;
            x509Callback.setUsedRequestorCertificate(this.requestorCertificate);
            x509Callback.setUsedIdentityAssertion(this.identityAssertion);
        }
    }
}

