/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.LoginPanel;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;
import org.apache.axis2.context.MessageContext;

public class UNTGUIPromptCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 8793785569405324482L;
    private static final TraceComponent tc = Tr.register(UNTGUIPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String userid;
    private String password;
    private String realmName = "<default>";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private int result = 0;
    private boolean nonce = false;
    private boolean createdTimestamp = false;
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static String WSSECURITY_LOGINPROMPT_CONTEXT = "com.ibm.ws.wssecurity.constants.wssLoginPromptContext";

    public UNTGUIPromptCallbackHandler() {
    }

    public UNTGUIPromptCallbackHandler(Map properties) {
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            Object obj = config2.getProperties().get(Constants.WSSECURITY_ADD_NONCE);
            if (obj != null) {
                this.nonce = UNTGUIPromptCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                this.createdTimestamp = UNTGUIPromptCallbackHandler.isTrue(obj.toString());
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        boolean done = false;
        boolean foundInCache = false;
        int retries = 0;
        for (int i = 0; i < callbacks.length; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                this.userNamePrompt = ((NameCallback)c).getPrompt();
                continue;
            }
            if (c instanceof PasswordCallback) {
                this.passwordPrompt = ((PasswordCallback)c).getPrompt();
                continue;
            }
            if (c instanceof PropertyCallback) {
                Object obj;
                Map<Object, Object> context = ((PropertyCallback)c).getProperties();
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                CallbackHandlerConfig config2 = (CallbackHandlerConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
                if (config2 != null) {
                    obj = config2.getProperties().get(Constants.WSSECURITY_ADD_NONCE);
                    if (obj != null) {
                        this.nonce = UNTGUIPromptCallbackHandler.isTrue(obj.toString());
                    }
                    if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                        this.createdTimestamp = UNTGUIPromptCallbackHandler.isTrue(obj.toString());
                    }
                }
                if (messageContext == null) continue;
                obj = null;
                if (!WSSContextManagerFactory.getInstance().processIsServer()) {
                    Set<SecurityTokenWrapper> set;
                    Subject subject;
                    block29: {
                        WSSContext sContext = null;
                        Object cntxt = messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                        if (!(cntxt instanceof WSSContext)) {
                            cntxt = messageContext.getProperty(WSSECURITY_LOGINPROMPT_CONTEXT);
                        }
                        sContext = (WSSContext)cntxt;
                        subject = null;
                        try {
                            subject = sContext.getRunAsSubject(messageContext);
                        }
                        catch (SoapSecurityException se) {
                            if (!tc.isDebugEnabled()) break block29;
                            Tr.debug(tc, "Exception caught " + se.getMessage());
                        }
                    }
                    if (subject != null && (set = subject.getPrivateCredentials(SecurityTokenWrapper.class)) != null && !set.isEmpty()) {
                        for (SecurityTokenWrapper stw : set) {
                            SecurityToken t = stw.getSecurityToken();
                            if (t == null || !(t instanceof UsernameToken) || stw.getEndPoint() == null || stw.getEndPoint().length() <= 0 || messageContext.getTo() == null || !messageContext.getTo().getAddress().equals(stw.getEndPoint())) continue;
                            obj = t;
                            break;
                        }
                    }
                }
                if (obj == null || !(obj instanceof UsernameToken)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cached username token is used.");
                }
                foundInCache = true;
                continue;
            }
            if (!(c instanceof UNTGenerateCallback)) continue;
            ((UNTGenerateCallback)c).setNonce(this.nonce);
            ((UNTGenerateCallback)c).setCreatedTimestamp(this.createdTimestamp);
        }
        if (foundInCache) {
            return;
        }
        LoginPanel lgpanel = null;
        JFrame tmpFrame = null;
        while (!done) {
            tmpFrame = new JFrame();
            lgpanel = new LoginPanel(this.userid, this.realmName, "", tmpFrame);
            this.result = lgpanel.showPanel();
            if (this.result == 2) {
                String sn = lgpanel.getId();
                if (sn != null && sn.length() > 0) {
                    this.userid = new String(sn.trim());
                    if (this.userid != null && this.userid.length() > 0) {
                        String pw = lgpanel.getPassword();
                        this.password = pw != null && pw.length() > 0 ? new String(pw) : "";
                        lgpanel.dispose();
                        lgpanel = null;
                        tmpFrame.dispose();
                        tmpFrame = null;
                        done = true;
                    } else {
                        this.userid = "";
                        this.password = "";
                    }
                } else {
                    this.userid = "";
                    this.password = "";
                }
                if (!done) {
                    lgpanel.dispose();
                    lgpanel = null;
                    tmpFrame.dispose();
                    tmpFrame = null;
                    if (retries < 1) {
                        ++retries;
                    } else {
                        done = true;
                    }
                }
            } else {
                lgpanel.dispose();
                lgpanel = null;
                tmpFrame.dispose();
                tmpFrame = null;
                this.userid = null;
                this.password = null;
                done = true;
            }
            if (tmpFrame == null) continue;
            tmpFrame.dispose();
            tmpFrame = null;
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userid);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            if (!(callback instanceof UNTGenerateCallback)) continue;
            ((UNTGenerateCallback)callback).setNonce(this.nonce);
            ((UNTGenerateCallback)callback).setCreatedTimestamp(this.createdTimestamp);
        }
    }

    public static boolean isTrue(String flag) {
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
                return true;
            }
        }
        return ret;
    }
}

