/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTConsumeCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SharedContextCallback;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SCTConsumeCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = -1898995112290984932L;
    private String serviceLabel = "WS-SecureConversation";
    private String clientLabel = "WS-SecureConversation";
    private String encryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private boolean requireDerivedKey;
    private int keylenghth = 0;
    private int nonceLength = 16;
    private WSSDecryption wssDecryption;
    private WSSVerification wssVerification;

    public SCTConsumeCallbackHandler(String serviceLabel, String clientLabel, String encryptionAlgorithm) {
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.requireDerivedKey = true;
    }

    public SCTConsumeCallbackHandler(String serviceLabel, String clientLabel, String encryptionAlgorithm, WSSDecryption dec, WSSVerification ver) {
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.requireDerivedKey = true;
        this.wssDecryption = dec;
        this.wssVerification = ver;
    }

    public SCTConsumeCallbackHandler(String serviceLabel, String clientLabel, String encryptionAlgorithm, boolean reqireDerivedKey, int derivedKeyLength, int nonceLength) {
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.requireDerivedKey = reqireDerivedKey;
        this.nonceLength = nonceLength;
        this.keylenghth = derivedKeyLength;
    }

    public SCTConsumeCallbackHandler(String serviceLabel, String clientLabel, String encryptionAlgorithm, boolean reqireDerivedKey, int derivedKeyLength, int nonceLength, WSSDecryption dec, WSSVerification ver) {
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.requireDerivedKey = reqireDerivedKey;
        this.nonceLength = nonceLength;
        this.keylenghth = derivedKeyLength;
        this.wssDecryption = dec;
        this.wssVerification = ver;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof SCTConsumeCallback) {
                SCTConsumeCallback sctConsumeCallback = (SCTConsumeCallback)callback;
                sctConsumeCallback.setServiceLabel(this.serviceLabel);
                sctConsumeCallback.setClientLabel(this.clientLabel);
                sctConsumeCallback.setEncryptionAlgorithm(this.encryptionAlgorithm);
            }
            if (callback instanceof DerivedKeyInfoCallback) {
                DerivedKeyInfoCallback dkcallback = (DerivedKeyInfoCallback)callback;
                dkcallback.setClientLabel(this.clientLabel);
                dkcallback.setServerLabel(this.serviceLabel);
                dkcallback.setKeyBytesLength(this.keylenghth);
                dkcallback.setNonceBytesLength(this.nonceLength);
                dkcallback.setRequiredDKT(this.requireDerivedKey);
            }
            if (!(callback instanceof SharedContextCallback)) continue;
            SharedContextCallback sharedCallback = (SharedContextCallback)callback;
            sharedCallback.setWSSDecryption(this.wssDecryption);
            sharedCallback.setWSSVerification(this.wssVerification);
        }
    }

    public String getServiceLabel() {
        return this.serviceLabel;
    }

    public String getClientLabel() {
        return this.clientLabel;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getServerLabel() {
        return this.serviceLabel;
    }

    public boolean getRequiredDKT() {
        return this.requireDerivedKey;
    }

    public int getKeyBytesLength() {
        return this.keylenghth;
    }

    public int getNonceBytesLength() {
        return this.nonceLength;
    }
}

