/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.SAMLGenerateCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SAMLGenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final TraceComponent tc = Tr.register(UNTGUIPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -2223655857588374454L;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_KEYSTORE = 1;
    private static final int TYPE_SPECIAL = 2;
    private int type = 0;
    private String storeRef;
    private String storePath;
    private String storeType;
    private char[] storePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private List<CertStore> certStores;
    private boolean requestorCertificate;
    private boolean identityAssertion;
    private String stsURI;
    private String keyType;
    private String keySize;
    private String confirmationMethod = "Bearer";
    private String stsPolicy = null;
    private String stsBinding = null;
    private String stsBindingScope = null;
    private boolean loadStsPolicySetAndBindingFromJar = false;
    private String stsSoapVersion = null;
    private String tokenRequest = "issue";
    private String wstNamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private boolean collectionRequest = false;
    private boolean failOverToTokenRequest = true;
    private boolean signatureRequired = true;
    private boolean cacheToken = true;
    private long cacheCushion = 300000L;
    private String targetAlias = null;
    private String usekeyType = null;
    Map<String, String> rstt = new HashMap<String, String>();

    public SAMLGenerateCallbackHandler(Map<Object, Object> properties) {
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            String useKey;
            String serviceAlias;
            String cache;
            String cushion;
            String isFailOverToTokenRequest;
            String s;
            KeyInformationConfig kiconfig;
            KeyStoreConfig ksconfig = config2.getResolvingKeyStore();
            if (ksconfig != null) {
                this.storeRef = ksconfig.getKsRef();
                this.storePath = ksconfig.getPath();
                this.storeType = ksconfig.getType();
                String tmp = ksconfig.getPassword();
                char[] cArray = this.storePassword = tmp == null ? null : tmp.toCharArray();
            }
            if ((kiconfig = config2.getKeyInformation()) != null) {
                this.alias = kiconfig.getAlias();
                String tmp = kiconfig.getKeyPass();
                this.keyPassword = tmp == null ? null : tmp.toCharArray();
                this.keyName = kiconfig.getName();
            }
            this.certStores = config2.getCertStores();
            Object obj = config2.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (obj != null) {
                this.identityAssertion = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get("com.ibm.wsspi.wssecurity.token.cert.useRequestorCert")) != null) {
                this.requestorCertificate = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get("signatureRequired")) != null && ((s = (String)obj).equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("optional"))) {
                this.signatureRequired = false;
            }
            this.stsURI = (String)config2.getProperties().get("stsURI");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... stsURI " + this.stsURI);
            }
            this.keyType = (String)config2.getProperties().get("keyType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... keyType " + this.keyType);
            }
            this.keySize = (String)config2.getProperties().get("keySize");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... keySize " + this.keySize);
            }
            this.confirmationMethod = (String)config2.getProperties().get("confirmationMethod");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... confirmationMethod " + this.confirmationMethod);
            }
            this.stsPolicy = (String)config2.getProperties().get("wstrustClientPolicy");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... stsPolicy " + this.stsPolicy);
            }
            this.stsBinding = (String)config2.getProperties().get("wstrustClientBinding");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... stsBinding " + this.stsBinding);
            }
            this.stsBindingScope = (String)config2.getProperties().get("wstrustClientBindingScope");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... stsBindingScope " + this.stsBindingScope);
            }
            if ((isFailOverToTokenRequest = (String)config2.getProperties().get("failOverToTokenRequest")) != null && isFailOverToTokenRequest.equalsIgnoreCase("false")) {
                this.failOverToTokenRequest = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... failOverToTokenRequest " + this.failOverToTokenRequest);
            }
            Object loadFromJar = config2.getProperties().get("wstrustClientLoadPolicySetAndBindingFromJar");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... loadFromJar " + loadFromJar);
            }
            if (loadFromJar != null) {
                if (loadFromJar instanceof Boolean) {
                    this.loadStsPolicySetAndBindingFromJar = (Boolean)loadFromJar;
                } else if (loadFromJar instanceof String) {
                    this.loadStsPolicySetAndBindingFromJar = Boolean.valueOf((String)loadFromJar);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... loadStsPolicySetAndBindingFromJar " + this.loadStsPolicySetAndBindingFromJar);
            }
            String wstnamespace = (String)config2.getProperties().get("wstrustClientWSTNamespace");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... wstnamespace " + wstnamespace);
            }
            if (wstnamespace == null) {
                this.wstNamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust".equals(wstnamespace) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(wstnamespace)) {
                this.wstNamespace = wstnamespace;
            } else if ("trust12".equals(wstnamespace)) {
                this.wstNamespace = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            } else if ("trust13".equals(wstnamespace)) {
                this.wstNamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... wstNamespace " + this.wstNamespace);
            }
            Object collectionRequest = config2.getProperties().get("wstrustClientCollectionRequest");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... collectionRequest " + collectionRequest);
            }
            if (collectionRequest != null) {
                if (collectionRequest instanceof Boolean) {
                    this.collectionRequest = (Boolean)collectionRequest;
                } else if (collectionRequest instanceof String) {
                    this.collectionRequest = Boolean.valueOf((String)collectionRequest);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... collectionRequest " + this.collectionRequest);
            }
            this.stsSoapVersion = (String)config2.getProperties().get("wstrustClientSoapVersion");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... stsSoapVersion " + this.stsSoapVersion);
            }
            this.tokenRequest = (String)config2.getProperties().get("tokenRequest");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... tokenRequest " + this.tokenRequest);
            }
            if ((cushion = (String)config2.getProperties().get("cacheCushion")) != null && !cushion.trim().isEmpty()) {
                this.cacheCushion = Long.parseLong(cushion) * 60L * 1000L;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... cacheCushion " + this.cacheCushion);
            }
            if ((cache = (String)config2.getProperties().get("cacheToken")) != null && cache.equalsIgnoreCase("false")) {
                this.cacheToken = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... cacheToken " + this.cacheToken);
            }
            if ((serviceAlias = (String)config2.getProperties().get("recipientAlias")) != null) {
                this.targetAlias = serviceAlias;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... targetAlias " + this.targetAlias);
            }
            if ((useKey = (String)config2.getProperties().get("usekeyType")) != null) {
                this.usekeyType = useKey;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... useKey type " + this.usekeyType);
            }
            Map<Object, Object> map = config2.getProperties();
            for (Object key : map.keySet()) {
                if (!(key instanceof String)) continue;
                Object value = map.get(key);
                if (key == null || !(value instanceof String)) continue;
                this.rstt.put((String)key, (String)value);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "SAMLGenerateCallbackHandler.SAMLGenerateCallbackHandler()... rstt.put(" + key + ", " + value + ")");
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (!(callback instanceof SAMLGenerateCallback)) continue;
            SAMLGenerateCallback samlCallback = (SAMLGenerateCallback)callback;
            if (this.type == 0) {
                samlCallback.setKeyStoreReference(this.storeRef);
                samlCallback.setKeyStorePath(this.storePath);
                samlCallback.setKeyStoreType(this.storeType);
                samlCallback.setKeyStorePassword(this.storePassword);
                samlCallback.setAlias(this.alias);
                samlCallback.setKeyPassword(this.keyPassword);
                samlCallback.setKeyName(this.keyName);
                samlCallback.setCertStores(this.certStores);
            } else if (this.type == 1) {
                samlCallback.setKeyStoreReference(this.storeRef);
                samlCallback.setKeyStorePath(this.storePath);
                samlCallback.setKeyStoreType(this.storeType);
                samlCallback.setKeyStorePassword(this.storePassword);
                samlCallback.setAlias(this.alias);
                samlCallback.setKeyPassword(this.keyPassword);
                samlCallback.setKeyName(this.keyName);
                samlCallback.setCertStores(this.certStores);
            } else if (this.type == 2) {
                // empty if block
            }
            samlCallback.setConfirmationMethod(this.confirmationMethod);
            samlCallback.setStsURI(this.stsURI);
            samlCallback.setKeyType(this.keyType);
            samlCallback.setKeySize(this.keySize);
            samlCallback.setIsSignatureRequired(this.signatureRequired);
            samlCallback.setStsPolicy(this.stsPolicy);
            samlCallback.setStsBinding(this.stsBinding);
            samlCallback.setStsBindingScope(this.stsBindingScope);
            samlCallback.setLoadStsPolicySetAndBindingFromJar(this.loadStsPolicySetAndBindingFromJar);
            samlCallback.setStsSoapVersion(this.stsSoapVersion);
            samlCallback.setTokenRequest(this.tokenRequest);
            samlCallback.setWSTrustNamespace(this.wstNamespace);
            samlCallback.setCollectionRequest(this.collectionRequest);
            samlCallback.setRSTTProperties(this.rstt);
            samlCallback.setCacheCushion(this.cacheCushion);
            samlCallback.setCacheToken(this.cacheToken);
            samlCallback.setTargetserviceAlias(this.targetAlias);
            samlCallback.setUseKeyType(this.usekeyType);
        }
    }
}

