/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.SAMLConsumeCallback;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SAMLConsumerCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = -2223655857588374454L;
    private String keyStoreRef;
    private String keyStorePath;
    private String keyStoreType;
    private char[] keyStorePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private String trustStoreRef;
    private String trustStorePath;
    private String trustStoreType;
    private char[] trustStorePassword;
    private String trustedAlias;
    private boolean trustAnySigner = false;
    private boolean signatureRequired = true;
    private long clockSkew = 180000L;

    public SAMLConsumerCallbackHandler(Map<Object, Object> properties) {
        CallbackHandlerConfig chconfig = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (chconfig != null) {
            String s;
            String cushion;
            String s2;
            KeyInformationConfig kiconfig;
            KeyStoreConfig ksconfig = chconfig.getResolvingKeyStore();
            if (ksconfig != null) {
                this.keyStoreRef = ksconfig.getKsRef();
                this.keyStorePath = ksconfig.getPath();
                this.keyStoreType = ksconfig.getType();
                String tmp = ksconfig.getPassword();
                char[] cArray = this.keyStorePassword = tmp == null ? null : tmp.toCharArray();
            }
            if ((kiconfig = chconfig.getKeyInformation()) != null) {
                this.alias = kiconfig.getAlias();
                this.keyName = kiconfig.getName();
                String tmp = kiconfig.getKeyPass();
                this.keyPassword = tmp == null ? null : tmp.toCharArray();
            }
            Map<Object, Object> props = chconfig.getProperties();
            Object obj = null;
            if (props.get("keyStoreRef") != null || props.get("keyStorePath") != null) {
                obj = props.get("keyStoreRef");
                this.keyStoreRef = (String)obj;
                obj = props.get("keyStorePath");
                this.keyStorePath = (String)obj;
                obj = props.get("keyStoreType");
                this.keyStoreType = (String)obj;
                obj = props.get("keyStorePassword");
                if (obj != null) {
                    this.keyStorePassword = ((String)obj).toCharArray();
                }
            }
            if (props.get("keyName") != null) {
                obj = props.get("keyAlias");
                this.alias = (String)obj;
                obj = props.get("keyName");
                this.keyName = (String)obj;
                obj = props.get("keyPassword");
                if (obj != null) {
                    this.keyPassword = ((String)obj).toCharArray();
                }
            }
            obj = props.get("trustStoreRef");
            this.trustStoreRef = (String)obj;
            obj = props.get("trustStorePath");
            this.trustStorePath = (String)obj;
            obj = props.get("trustStoreType");
            this.trustStoreType = (String)obj;
            obj = props.get("trustStorePassword");
            if (obj != null) {
                this.trustStorePassword = ((String)obj).toCharArray();
            }
            obj = props.get("trustedAlias");
            this.trustedAlias = (String)obj;
            obj = props.get("trustAnySigner");
            if (obj != null && ((s2 = (String)obj).equalsIgnoreCase("true") || s2.equalsIgnoreCase("yes"))) {
                this.trustAnySigner = true;
            }
            if ((cushion = (String)props.get("clockSkew")) != null && !cushion.trim().isEmpty()) {
                this.clockSkew = Long.parseLong(cushion) * 60L * 1000L;
            }
            if ((obj = props.get("signatureRequired")) != null && ((s = (String)obj).equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("optional"))) {
                this.signatureRequired = false;
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (!(callback instanceof SAMLConsumeCallback)) continue;
            SAMLConsumeCallback samlCallback = (SAMLConsumeCallback)callback;
            samlCallback.setKeyStoreReference(this.keyStoreRef);
            samlCallback.setKeyStorePath(this.keyStorePath);
            samlCallback.setKeyStoreType(this.keyStoreType);
            samlCallback.setKeyStorePassword(this.keyStorePassword);
            samlCallback.setAlias(this.alias);
            samlCallback.setKeyPassword(this.keyPassword);
            samlCallback.setKeyName(this.keyName);
            samlCallback.setTrustStorePath(this.trustStorePath);
            samlCallback.setTrustStoreRef(this.trustStoreRef);
            samlCallback.setTrustStorePassword(this.trustStorePassword);
            samlCallback.setTrustStoreType(this.trustStoreType);
            samlCallback.setTrustedSTSAlias(this.trustedAlias);
            samlCallback.setIsSignatureRequired(this.signatureRequired);
            samlCallback.setTrustAnySigner(this.trustAnySigner);
            samlCallback.setClockSkew(this.clockSkew);
        }
    }
}

