/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.callbackhandler.KRBTokenGenerateCallback;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SharedContextCallback;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.LoginPanel;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.Parameter;

public class KRBTokenGenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 6359305002065428613L;
    private boolean promptUser = false;
    private boolean alwaysSendAP_REQ = false;
    private boolean sha1AsSupportToken = false;
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private String clientName = null;
    private char[] clientpassword = null;
    private String clientNamePrompted = null;
    private char[] clientpasswordPrompted = null;
    private String clientRealmName = null;
    private String clientRealmNameLabel = "<default Kerberos>";
    private String targetServiceName = null;
    private String targetServiceHostName = null;
    private String targetServiceRealmName = null;
    private QName tokenValueType = null;
    private int keylength = 0;
    private int nonceLength = 16;
    private boolean requiredDKT = false;
    private String clientLabel = Constants.DEFAULT_DERIVEDKEY_LABEL;
    private String serviceLabel = Constants.DEFAULT_DERIVEDKEY_LABEL;
    private static final String GENERATE_CALLBACK_BY_WSSAPI = "com.ibm.wsspi.wssecurity.krbtoken.generateCallbackByWSSAPI:";
    private boolean useWSSAPI = false;
    private static final String GENERATE_CALLBACK_HANDLED = "com.ibm.wsspi.wssecurity.krbtoken.generateCallbackHandled:";
    private WSSEncryption wssEncryption;
    private WSSSignature wssSignature;
    private static final long REPROMPT_TIME = 600000L;
    private boolean REPROMPT = true;
    private static String WSSECURITY_LOGINPROMPT_CONTEXT = "com.ibm.ws.wssecurity.constants.wssLoginPromptContext";
    private static final TraceComponent tc = Tr.register(KRBTokenGenerateCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public KRBTokenGenerateCallbackHandler(Map<Object, Object> properties) {
        TokenGeneratorConfig tconfig;
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            this.clientName = config2.getUserId();
            this.clientpassword = config2.getUserPassword();
            Map<Object, Object> m = config2.getProperties();
            if (m != null) {
                this.clientRealmName = (String)m.get(Constants.WSSECURITY_KRB5TOKEN_CLIENTREALM);
                this.promptUser = Boolean.valueOf((String)m.get(Constants.WSSECURITY_KRB5TOKEN_LOGINPROMPT));
            }
        }
        if ((tconfig = (TokenGeneratorConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey")) != null) {
            this.tokenValueType = tconfig.getType();
            Map<Object, Object> _properties = tconfig.getProperties();
            if (_properties != null) {
                this.targetServiceName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICENAME);
                this.targetServiceHostName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICEHOST);
                this.targetServiceRealmName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICEREALM);
            }
        }
    }

    public KRBTokenGenerateCallbackHandler(String name, String password, String realm, String targetService, String targetHost, String targetRealm, QName tokenValuetype, boolean prompt, boolean supportTokenRequireSHA1, boolean alwaysAPREQ, WSSEncryption encComponent, WSSSignature sigComponent) {
        this.clientName = name;
        if (password != null) {
            this.clientpassword = password.toCharArray();
        }
        this.clientRealmName = realm;
        this.targetServiceName = targetService;
        this.targetServiceHostName = targetHost;
        this.targetServiceRealmName = targetRealm;
        this.tokenValueType = tokenValuetype;
        this.promptUser = prompt;
        this.sha1AsSupportToken = supportTokenRequireSHA1;
        this.alwaysSendAP_REQ = alwaysAPREQ;
        this.useWSSAPI = true;
        this.wssEncryption = encComponent;
        this.wssSignature = sigComponent;
    }

    public KRBTokenGenerateCallbackHandler(String name, String password, String realm, String targetService, String targetHost, String targetRealm, QName tokenValuetype, boolean requireDKT, String clabel, String slabel, int keylen, int noncelen, boolean prompt, boolean supportTokenRequireSHA1, boolean alwaysAPREQ, WSSEncryption encComponent, WSSSignature sigComponent) {
        this.clientName = name;
        if (password != null) {
            this.clientpassword = password.toCharArray();
        }
        this.clientRealmName = realm;
        this.targetServiceName = targetService;
        this.targetServiceHostName = targetHost;
        this.targetServiceRealmName = targetRealm;
        this.tokenValueType = tokenValuetype;
        this.requiredDKT = requireDKT;
        if (clabel != null) {
            this.clientLabel = clabel;
        }
        if (slabel != null) {
            this.serviceLabel = slabel;
        }
        this.keylength = keylen;
        this.nonceLength = noncelen;
        this.promptUser = prompt;
        this.sha1AsSupportToken = supportTokenRequireSHA1;
        this.alwaysSendAP_REQ = alwaysAPREQ;
        this.useWSSAPI = true;
        this.wssEncryption = encComponent;
        this.wssSignature = sigComponent;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback callback = null;
        Map<Object, Object> context = null;
        AxisDescription aService = null;
        MessageContext messageContext = null;
        Parameter cbHandledpm = null;
        boolean isClient = true;
        String targetEndPointURL = null;
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    this.userNamePrompt = ((NameCallback)callback).getPrompt();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    this.passwordPrompt = ((PasswordCallback)callback).getPrompt();
                    continue;
                }
                if (callback instanceof PropertyCallback) {
                    Map<Object, Object> _properties;
                    TokenGeneratorConfig tconfig;
                    context = ((PropertyCallback)callback).getProperties();
                    if (context == null) continue;
                    messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    this.REPROMPT = true;
                    if (messageContext != null && !WSSContextManagerFactory.getInstance().processIsServer()) {
                        Object obj = messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                        if (obj != null && !(obj instanceof WSSContext)) {
                            obj = messageContext.getProperty(WSSECURITY_LOGINPROMPT_CONTEXT);
                        }
                        if (obj != null && obj instanceof WSSContext) {
                            Set<SecurityTokenWrapper> set;
                            Subject subject;
                            block22: {
                                WSSContext sContext = (WSSContext)obj;
                                subject = null;
                                try {
                                    subject = sContext.getRunAsSubject(messageContext);
                                }
                                catch (SoapSecurityException se) {
                                    if (!tc.isDebugEnabled()) break block22;
                                    Tr.debug(tc, "Exception caught " + se.getMessage());
                                }
                            }
                            if (subject != null && (set = subject.getPrivateCredentials(SecurityTokenWrapper.class)) != null && !set.isEmpty()) {
                                SecurityTokenWrapper oldStw = null;
                                for (SecurityTokenWrapper stw : set) {
                                    SecurityToken t = stw.getSecurityToken();
                                    if (t == null || !(t instanceof KRBAuthnToken) || stw.getEndPoint() == null || stw.getEndPoint().length() <= 0 || messageContext.getTo() == null || !messageContext.getTo().getAddress().equals(stw.getEndPoint())) continue;
                                    oldStw = stw;
                                    long endTime = ((KRBAuthnToken)((Object)t)).getTokenExpiration();
                                    if (((KRBAuthnToken)((Object)t)).getRenewTill() != null) {
                                        endTime = ((KRBAuthnToken)((Object)t)).getRenewTill().getTime();
                                    }
                                    if (endTime <= new Date().getTime() + 600000L) continue;
                                    this.REPROMPT = false;
                                    break;
                                }
                                if (this.REPROMPT) {
                                    subject.getPrivateCredentials().remove(oldStw);
                                }
                            }
                        }
                    }
                    if (this.useWSSAPI || (tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey")) == null || (_properties = tconfig.getProperties()) == null || this.targetServiceName != null && this.targetServiceHostName != null && this.targetServiceRealmName != null && this.tokenValueType != null) continue;
                    this.targetServiceName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICENAME);
                    this.targetServiceHostName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICEHOST);
                    this.targetServiceRealmName = (String)_properties.get(Constants.WSSECURITY_KRB5TOKEN_SERVICEREALM);
                    this.tokenValueType = tconfig.getType();
                    continue;
                }
                if (callback instanceof KRBTokenGenerateCallback) {
                    if (this.clientRealmName != null && this.clientRealmName.length() != 0) {
                        this.clientRealmNameLabel = this.clientRealmName;
                    }
                    if (this.promptUser && isClient) {
                        if (this.REPROMPT) {
                            this.collectlogindata(this.clientRealmNameLabel);
                        }
                        ((KRBTokenGenerateCallback)callback).setClientName(this.clientNamePrompted);
                        this.getOrsetPwdinCB((KRBTokenGenerateCallback)callback, false, this.clientpasswordPrompted);
                        if (cbHandledpm == null && aService != null) {
                            cbHandledpm = new Parameter();
                            cbHandledpm.setName(GENERATE_CALLBACK_HANDLED + targetEndPointURL);
                            cbHandledpm.setValue(callback);
                            aService.addParameter(cbHandledpm);
                        }
                    } else {
                        ((KRBTokenGenerateCallback)callback).setClientName(this.clientName);
                        this.getOrsetPwdinCB((KRBTokenGenerateCallback)callback, false, this.clientpassword);
                    }
                    ((KRBTokenGenerateCallback)callback).setClientKerberosRealm(this.clientRealmName);
                    ((KRBTokenGenerateCallback)callback).setTargetServiceName(this.targetServiceName);
                    ((KRBTokenGenerateCallback)callback).setTargetServiceHostName(this.targetServiceHostName);
                    ((KRBTokenGenerateCallback)callback).setTargetServiceKerberosRealm(this.targetServiceRealmName);
                    ((KRBTokenGenerateCallback)callback).setValueType(this.tokenValueType);
                    continue;
                }
                if (callback instanceof DerivedKeyInfoCallback) {
                    if (!this.useWSSAPI) continue;
                    ((DerivedKeyInfoCallback)callback).setRequiredDKT(this.requiredDKT);
                    ((DerivedKeyInfoCallback)callback).setClientLabel(this.clientLabel);
                    ((DerivedKeyInfoCallback)callback).setServerLabel(this.serviceLabel);
                    ((DerivedKeyInfoCallback)callback).setKeyBytesLength(this.keylength);
                    ((DerivedKeyInfoCallback)callback).setNonceBytesLength(this.nonceLength);
                    continue;
                }
                if (!(callback instanceof SharedContextCallback)) continue;
                SharedContextCallback sharedCallback = (SharedContextCallback)callback;
                sharedCallback.setWSSEncryption(this.wssEncryption);
                sharedCallback.setWSSSignature(this.wssSignature);
            }
        }
        catch (Exception ex) {
            throw new IOException("Exception caught during callback handling: " + ex);
        }
    }

    private char[] getOrsetPwdinCB(final KRBTokenGenerateCallback finalKCB, final boolean getPwd, final char[] inPwd) {
        return (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (getPwd) {
                    return finalKCB.getClientPassword();
                }
                finalKCB.setClientPassword(inPwd);
                return null;
            }
        });
    }

    private void collectlogindata(String realmName) {
        boolean done = false;
        int retries = 0;
        LoginPanel lgpanel = null;
        JFrame tmpFrame = null;
        int result = 0;
        while (!done) {
            tmpFrame = new JFrame();
            lgpanel = new LoginPanel(this.clientNamePrompted, realmName, "", tmpFrame);
            result = lgpanel.showPanel();
            if (result == 2) {
                String sn = lgpanel.getId();
                if (sn != null && sn.length() > 0) {
                    this.clientNamePrompted = new String(sn.trim());
                    if (this.clientNamePrompted != null && this.clientNamePrompted.length() > 0) {
                        String pw = lgpanel.getPassword();
                        this.clientpasswordPrompted = pw != null && pw.length() > 0 ? pw.toCharArray() : "".toCharArray();
                        lgpanel.dispose();
                        lgpanel = null;
                        tmpFrame.dispose();
                        tmpFrame = null;
                        done = true;
                    } else {
                        this.clientNamePrompted = "";
                        this.clientpasswordPrompted = "".toCharArray();
                    }
                } else {
                    this.clientNamePrompted = "";
                    this.clientpasswordPrompted = "".toCharArray();
                }
                if (!done) {
                    lgpanel.dispose();
                    lgpanel = null;
                    tmpFrame.dispose();
                    tmpFrame = null;
                    if (retries < 1) {
                        ++retries;
                    } else {
                        done = true;
                    }
                }
            } else {
                lgpanel.dispose();
                lgpanel = null;
                tmpFrame.dispose();
                tmpFrame = null;
                this.clientNamePrompted = null;
                this.clientpasswordPrompted = null;
                done = true;
            }
            if (tmpFrame == null) continue;
            tmpFrame.dispose();
            tmpFrame = null;
        }
    }
}

