/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;

public class PolicyAttributesUtil
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(PolicyAttributesUtil.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static PolicyAttributesUtil util = new PolicyAttributesUtil();

    public static PolicyAttributesUtil getInstance() {
        return util;
    }

    public Properties attributeListToProperties(AttributeList attrList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attributeListToProperties, includeEmptyList=false");
        }
        return this.attributeListToProperties(attrList, null, false);
    }

    public Properties attributeListToProperties(AttributeList attrList, boolean includeEmptyList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attributeListToProperties, includeEmptyList=" + includeEmptyList);
        }
        return this.attributeListToProperties(attrList, null, includeEmptyList);
    }

    public Properties attributeListToProperties(AttributeList attrList, Properties requestedProps) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attributeListToProperties, includeEmptyList=false, requestedProps=" + requestedProps);
        }
        return this.attributeListToProperties(attrList, requestedProps, false);
    }

    public Properties attributeListToProperties(AttributeList attrList, Properties requestedProps, boolean includeEmptyList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attributeListToProperties, includeEmptyList=" + includeEmptyList + ", requestedProps=" + requestedProps);
        }
        Properties props = new Properties();
        if (attrList == null) {
            return props;
        }
        for (int i = 0; i < attrList.size(); ++i) {
            props.putAll((Map<?, ?>)this.attributeToProps(null, (Attribute)attrList.get(i), requestedProps, includeEmptyList));
        }
        return props;
    }

    public AttributeList propertiesToAttributeList(Properties props) {
        AttributeList attrList = new AttributeList();
        if (props == null || props.isEmpty()) {
            return attrList;
        }
        AttributeList startAttrList = null;
        Attribute attr = null;
        String name = null;
        String value = null;
        String nameToken = null;
        StringTokenizer tokens = null;
        ArrayList<String> tokenList = null;
        boolean createAttributeList = false;
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = props.getProperty(name);
            tokens = new StringTokenizer(name, ".");
            tokenList = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                tokenList.add(tokens.nextToken());
            }
            startAttrList = attrList;
            for (int i = 0; i < tokenList.size(); ++i) {
                nameToken = (String)tokenList.get(i);
                createAttributeList = i < tokenList.size() - 1 ? true : "remove".equals(value);
                attr = this.getAttribute(startAttrList, nameToken, createAttributeList, value);
                if (!createAttributeList) continue;
                startAttrList = (AttributeList)attr.getValue();
            }
        }
        return attrList;
    }

    private Attribute getAttribute(AttributeList attrList, String token, boolean containAttrList, String value) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAttribute: token=" + token + ", containAttrList=" + containAttrList);
        }
        Attribute attr = null;
        boolean found = false;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if (!attr.getName().equals(token)) continue;
            found = true;
            break;
        }
        if (found) {
            return attr;
        }
        if (containAttrList) {
            attr = new Attribute(token, new AttributeList());
            attrList.add(attr);
        } else {
            attr = new Attribute(token, value);
            attrList.add(attr);
        }
        return attr;
    }

    private Properties attributeToProps(String prefix, Attribute attr, Properties requestedProps, boolean includeEmptyList) {
        Properties props = new Properties();
        Object value = attr.getValue();
        String key = attr.getName();
        String newPrefix = null;
        boolean trDebug = tc.isDebugEnabled();
        newPrefix = prefix == null ? key : prefix + "." + key;
        if (trDebug) {
            Tr.debug(tc, "attributeToProps, prefix=" + prefix + ", newPrefix=" + newPrefix + ", attr name=" + attr.getName() + ", attr value=" + attr.getValue() + ", includeEmptyList=" + includeEmptyList);
        }
        if (value == null) {
            if (includeEmptyList) {
                props.put(newPrefix, "");
            }
            return props;
        }
        if (value instanceof AttributeList) {
            AttributeList attrList = (AttributeList)value;
            if (trDebug) {
                Tr.debug(tc, "attributeToProps, newPrefix=" + newPrefix + ", attrList size=" + attrList.size());
            }
            if (attrList.size() == 0) {
                if (includeEmptyList && this.isRequested(newPrefix, requestedProps)) {
                    if (trDebug) {
                        Tr.debug(tc, "attributeToProps, newPrefix=" + newPrefix + ", props=" + props);
                    }
                    props.put(newPrefix, "");
                }
                return props;
            }
            for (int i = 0; i < attrList.size(); ++i) {
                Properties subProps = this.attributeToProps(newPrefix, (Attribute)attrList.get(i), requestedProps, includeEmptyList);
                props.putAll((Map<?, ?>)subProps);
            }
            return props;
        }
        if (trDebug) {
            Tr.debug(tc, "attributeToProps, newPrefix=" + newPrefix + ", value=" + value);
        }
        if (this.isRequested(newPrefix, requestedProps)) {
            props.put(newPrefix, value);
        }
        return props;
    }

    private boolean isRequested(String newPrefix, Properties requestedProps) {
        if (requestedProps == null || requestedProps.size() == 0) {
            return true;
        }
        Enumeration<?> requestedKeys = requestedProps.propertyNames();
        while (requestedKeys.hasMoreElements()) {
            if (!newPrefix.startsWith((String)requestedKeys.nextElement())) continue;
            return true;
        }
        return false;
    }
}

