/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLSocketFactory.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    protected Properties props;
    private javax.net.ssl.SSLSocketFactory default_factory = null;
    private javax.net.ssl.SSLSocketFactory factory = null;
    protected boolean default_constructor = true;
    private static SSLSocketFactory thisClass = null;

    public SSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(1)");
        }
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting default SSL properties from WebSphere configuration.");
                }
                this.props = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting javax.net.ssl.* SSL System properties.");
                }
                this.default_constructor = false;
            }
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(1)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting default SSL properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor", "100", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(2)", new Object[]{alias});
        }
        try {
            this.default_constructor = false;
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(2)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from alias.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias)", "129", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(Properties sslprops) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(3)");
        }
        try {
            this.default_constructor = false;
            this.props = sslprops;
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(3)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(sslprops)", "158", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String alias, Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(4)", new Object[]{alias, connectionInfo});
        }
        try {
            this.default_constructor = false;
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(4)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from selections.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", "197", this);
            this.props = null;
        }
    }

    public static SocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLSocketFactory();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLSocketFactory exception getting default socket factory.", new Object[]{e});
                }
                Manager.Ffdc.log(e, SSLSocketFactory.class, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.getDefault", "221");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(0)");
        }
        javax.net.ssl.SSLSocketFactory currentFactory = this.default_factory;
        SSLSocket socket = null;
        Properties sslProps = this.props;
        if (this.default_constructor) {
            try {
                Properties sslPropsOnThread = JSSEHelper.getInstance().getSSLPropertiesOnThread();
                HashMap<String, String> currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
                if (sslPropsOnThread != null || currentConnectionInfo != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "either SSLProperties on thread or connectionInfo is available.");
                    }
                    if (currentConnectionInfo == null) {
                        currentConnectionInfo = new HashMap<String, String>();
                        currentConnectionInfo.put("com.ibm.ssl.direction", "outbound");
                    }
                    sslProps = JSSEHelper.getInstance().getProperties(null, currentConnectionInfo, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting SSLSocketFactory");
                    }
                    currentFactory = JSSEHelper.getInstance().getSSLSocketFactory(currentConnectionInfo, sslProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got SSLSocketFactory", new Object[]{currentFactory});
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Use default SSLSocketFactory - Neither SSLProperties nor outboundConnectionInfo is set");
                    }
                    if (sslProps == null) {
                        sslProps = JSSEHelper.getInstance().getProperties(null, null, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "default sslProps is null, load a default");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting SSLSocketFactory. Fall back to the default SSLSocketFactory", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(0)", "303", this);
                currentFactory = this.default_factory;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Use default SSLSocketFactory - the default constructor was not used");
        }
        socket = (SSLSocket)currentFactory.createSocket();
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslProps, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(0)");
        }
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(1)", new Object[]{s, host, new Integer(port), new Boolean(autoClose)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(1)", "359", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(s, host, port, autoClose);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(1)");
        }
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(2)", new Object[]{host, new Integer(port)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName = null;
            if (host != null) {
                try {
                    remoteHostName = host.getHostName();
                    if (remoteHostName == null) {
                        remoteHostName = host.getCanonicalHostName();
                    }
                }
                catch (Throwable e) {
                    remoteHostName = host.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{e});
                    }
                    Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "407", this);
                }
            }
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "427", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(2)");
        }
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(3)", new Object[]{address, new Integer(port), localAddress, new Integer(localPort)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            String remoteHostName = null;
            if (address != null) {
                try {
                    remoteHostName = address.getHostName();
                    if (remoteHostName == null) {
                        remoteHostName = address.getCanonicalHostName();
                    }
                }
                catch (Throwable e) {
                    remoteHostName = address.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{e});
                    }
                    Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "481", this);
                }
            }
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "501", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(address, port, localAddress, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(3)");
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(4)", new Object[]{host, new Integer(port)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(4)", "556", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(4), not null");
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(5)", new Object[]{host, new Integer(port), localHost, new Integer(localPort)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            if (this.default_constructor) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(5)", "611", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port, localHost, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(5)");
        }
        return socket;
    }
}

