/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLServerSocketFactory.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Properties props;
    private javax.net.ssl.SSLServerSocketFactory default_factory = null;
    private javax.net.ssl.SSLServerSocketFactory factory = null;
    private static SSLServerSocketFactory thisClass = null;

    public SSLServerSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory");
        }
        try {
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting default SSL properties from WebSphere configuration.");
                }
                HashMap<String, String> connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "inbound");
                this.props = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting javax.net.ssl.* SSL System properties.");
            }
            this.factory = this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting default SSL properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor", "90", this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory", new Object[]{alias});
        }
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            Properties defaultprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(defaultprops);
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from alias.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias)", "126", this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(Properties sslprops) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory");
        }
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            Properties defaultprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(defaultprops);
            this.props = sslprops;
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(sslprops)", "162", this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String alias, String localEndPointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory", new Object[]{alias, localEndPointName});
        }
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            connectionInfo.put("com.ibm.ssl.endPointName", localEndPointName);
            Properties defaultprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(defaultprops);
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from selections.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", "204", this);
            this.factory = this.default_factory;
        }
    }

    public static ServerSocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLServerSocketFactory();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLServerSocketFactory exception getting default socket factory.", new Object[]{e});
                }
                Manager.Ffdc.log(e, SSLServerSocketFactory.class, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.getDefault", "229");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public ServerSocket createServerSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(0)");
        }
        SSLServerSocket socket = null;
        socket = (SSLServerSocket)this.default_factory.createServerSocket();
        socket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(0)");
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(1)", new Object[]{new Integer(port)});
        }
        SSLServerSocket socket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(2)", "306", this);
            this.factory = this.default_factory;
        }
        socket = (SSLServerSocket)this.factory.createServerSocket(port);
        socket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(1)");
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(2)", new Object[]{new Integer(port), new Integer(backlog)});
        }
        SSLServerSocket socket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(3)", "341", this);
            this.factory = this.default_factory;
        }
        socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        socket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(2)");
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(3)", new Object[]{new Integer(port), new Integer(backlog), ifAddress});
        }
        SSLServerSocket socket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(4)", "378", this);
            this.factory = this.default_factory;
        }
        socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        socket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(3), not null");
        }
        return socket;
    }
}

