/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.websphere.servlet.request.ServletInputStreamAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ChainedRequest
extends HttpServletRequestWrapper {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.filter");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.filter.ChainedRequest";
    private ChainedResponse _resp;
    private HttpServletRequest _req;
    private ServletInputStream _in;
    private BufferedReader _reader;
    private Hashtable _parameters = new Hashtable();
    private Hashtable _headers = new Hashtable();
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    ChainedRequest(ChainedResponse resp, HttpServletRequest req) throws IOException {
        super(req);
        this._resp = resp;
        this._req = req;
        ByteArrayInputStream bin = new ByteArrayInputStream(resp.getOutputBuffer());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletUnloaded", "Creating chained Request with buffer:\n" + new String(resp.getOutputBuffer()));
        }
        this._in = new ServletInputStreamAdapter(bin);
    }

    public Cookie[] getCookies() {
        return this._resp.getCookies();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._in;
    }

    public BufferedReader getReader() throws IOException {
        if (this._reader == null) {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, this._resp.getCharacterEncoding()));
        }
        return this._reader;
    }

    public HttpServletRequest getProxiedHttpServletRequest() {
        return this._req;
    }

    protected void setHeader(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, value);
        }
    }

    public Enumeration getHeaderNames() {
        return this._headers.keys();
    }

    public String getHeader(String name) {
        return (String)this._headers.get(name);
    }

    public int getIntHeader(String name) throws NumberFormatException {
        String val = (String)this._headers.get(name);
        if (val == null) {
            return -1;
        }
        return Integer.valueOf(val);
    }

    public long getDateHeader(String name) {
        String val = (String)this._headers.get(name);
        if (val == null) {
            return -1L;
        }
        return Long.valueOf(val);
    }

    public int getContentLength() {
        return this.getIntHeader("content-length");
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getParameter(String name) {
        String[] values;
        if (this._parameters == null) {
            this.parseParameters();
        }
        if ((values = (String[])this._parameters.get(name)) != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (this._parameters == null) {
            this.parseParameters();
        }
        return this._parameters.keys();
    }

    public String[] getParameterValues(String name) {
        if (this._parameters == null) {
            this.parseParameters();
        }
        return (String[])this._parameters.get(name);
    }

    private synchronized void parseParameters() {
        if (this._parameters == null) {
            try {
                String contentType;
                String method = this.getMethod().toLowerCase();
                if (method.equals("get")) {
                    String queryString = this.getQueryString();
                    if (queryString != null && queryString.indexOf("=") != -1) {
                        this._parameters = RequestUtils.parseQueryString(this.getQueryString());
                    }
                } else if (method.equals("post") && (contentType = this.getContentType()) != null && contentType.equals("application/x-www-form-urlencoded")) {
                    this._parameters = this.parsePostData(this.getContentLength(), this.getInputStream());
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.websphere.servlet.filter.ChainedResponse.parseParameters", "286", this);
            }
            if (this._parameters == null) {
                this._parameters = new Hashtable();
            }
        }
    }

    private Hashtable parsePostData(int len, ServletInputStream in) {
        String postedBody;
        byte[] postedBytes = null;
        if (len <= 0) {
            return null;
        }
        try {
            int inputLen;
            postedBytes = new byte[len];
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(msg);
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", "326", this);
            return new Hashtable();
        }
        try {
            postedBody = new String(postedBytes, this._resp.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", "341", this);
            postedBody = new String(postedBytes);
        }
        return RequestUtils.parseQueryString(postedBody);
    }
}

