/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.CORBA.iiop.OrbTrcLogger;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent6;
import com.ibm.ejs.ras.TraceStateChangeListener;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASITraceEvent;
import com.ibm.ras.RASStackTrace;
import com.ibm.ras.RASTraceLogger;
import com.ibm.websphere.ras.WsHandler;
import com.ibm.websphere.ras.WsOrbRasManager;
import java.util.Enumeration;

public class WsJrasTraceLogger
extends RASTraceLogger
implements RASITraceEvent,
OrbTrcLogger,
TraceStateChangeListener {
    private static final long serialVersionUID = -7930896777201403486L;
    private static String svByteArrayText = "tracing a byte array";
    private static String svExceptionText = "The following exception was logged";
    private static String svEmptyString = "";
    private static Object[] svNullParms = new Object[]{null};
    private static long svEvent = 1128L;
    private static long svEE = 903L;
    private static long svDebug = 16L;
    private static long svMapEvent = svEvent | 0x800L;
    private static long svMapEntryExit = svEE | 0x800L | 0x1000L;
    private static long svMapDebug = svDebug | 0x800L | 0x1000L | 0x2000L;
    private static long svEventMask = svEvent | 0x800L;
    private static long svEEMask = svEE | 0x1000L;
    private static long svDebugMask = svDebug | 0x2000L;
    private static long svAllTrace = svEventMask | svEEMask | svDebugMask;
    private WsHandler svWsHandler = new WsHandler();
    private TraceComponent ivTc = null;
    String ivTrName = null;
    private boolean ivWsHandlerInstalled = true;
    private boolean ivUserHandlerInstalled = false;
    private boolean ivOrbLogger = false;
    private boolean ivInitialized = false;
    private String ivOrganization;
    private String ivProduct;
    private String ivComponent;

    WsJrasTraceLogger(String organization, String product2, String component, String name) {
        super(name, "");
        this.ivOrganization = organization;
        this.ivProduct = product2;
        this.ivComponent = component;
        this.ivTc = Tr.register(name);
        this.ivTrName = this.ivTc.getName();
        super.setSynchronous(true);
        super.addHandler(this.svWsHandler);
        this.ivInitialized = true;
        this.ivTc.setLoggerForCallback(this);
        this.traceStateChanged();
    }

    protected void init() {
        super.init();
    }

    public synchronized void traceStateChanged() {
        long newMask = 0L;
        if (this.ivTc.isEventEnabled()) {
            newMask |= svMapEvent;
        }
        if (this.ivTc.isEntryEnabled()) {
            newMask |= svMapEntryExit;
        }
        if (this.ivTc.isDebugEnabled()) {
            newMask |= svMapDebug;
        }
        long mask = this.getTraceMask();
        mask &= svAllTrace ^ 0xFFFFFFFFFFFFFFFFL;
        this.setTraceMask(mask |= newMask);
        this.isLogging = mask != 0L;
        if (this.ivOrbLogger) {
            WsOrbRasManager.setTrcLogging((boolean)this.isLogging);
        }
    }

    public void setLoggingOutput(String file) {
    }

    public void exception(long type, Object obj, String methodName, Exception exc) {
        this.exception(type, obj, methodName, (Throwable)exc);
    }

    public void exception(long type, String className, String methodName, Exception exc) {
        this.exception(type, className, methodName, (Throwable)exc);
    }

    void setOrbLogger() {
        this.ivOrbLogger = true;
    }

    public void setName(String name) {
        if (!this.ivInitialized) {
            super.setName(name);
        }
    }

    public String getGroup() {
        return null;
    }

    public long getMessageMask() {
        return 0L;
    }

    public void setMessageMask(long mask) {
    }

    public void addMessageEventClass(String name) {
    }

    public void removeMessageEventClass(String name) {
    }

    public void setLogging(boolean flag) {
        super.setLogging(flag);
        if (this.ivOrbLogger) {
            WsOrbRasManager.setTrcLogging((boolean)flag);
        }
    }

    public void addHandler(RASIHandler handler) {
        if (handler != null) {
            if (handler instanceof WsHandler) {
                return;
            }
            this.ivUserHandlerInstalled = true;
            super.addHandler(handler);
        }
    }

    public void removeHandler(RASIHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof WsHandler) {
            this.ivWsHandlerInstalled = false;
        }
        super.removeHandler(handler);
        Enumeration x = this.getHandlers();
        int userCount = 0;
        while (x.hasMoreElements()) {
            RASIHandler y = (RASIHandler)x.nextElement();
            if (y instanceof WsHandler) continue;
            ++userCount;
        }
        if (userCount == 0) {
            this.ivUserHandlerInstalled = false;
        }
    }

    public boolean isSynchronous() {
        return true;
    }

    public void setSynchronous(boolean flag) {
    }

    public void entry(long type, Object obj, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", null, null);
            }
        }
    }

    public void entry(long type, Object obj, String methodName, Object parm1) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void entry(long type, Object obj, String methodName, Object parm1, Object parm2) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void entry(long type, Object obj, String methodName, Object[] parms) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void entry(long type, String className, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", null, null);
            }
        }
    }

    public void entry(long type, String className, String methodName, Object parm1) {
        if (this.isLoggable(type |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void entry(long type, String className, String methodName, Object parm1, Object parm2) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void entry(long type, String className, String methodName, Object[] parms) {
        if (this.isLoggable(type |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Entry", parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Entry", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", null, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, byte retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, short retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Short(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, int retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, long retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Long(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, float retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Float(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, double retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Double(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, char retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Character(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, boolean retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, Object obj, String methodName, Object retValue) {
        if (this.isLoggable(type |= 4L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", retValue, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{retValue};
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", null, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, byte retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, short retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Short(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, int retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, long retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Long(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, float retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Float(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, double retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Double(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, char retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Character(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, boolean retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void exit(long type, String className, String methodName, Object retValue) {
        if (this.isLoggable(type |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, "Exit", retValue, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{retValue};
                this.logTrace(type, className, methodName, "Exit", parms, null);
            }
        }
    }

    public void trace(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, null, null);
            }
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, null, null);
            }
        }
    }

    public void trace(long type, String className, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, String className, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, String className, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, text, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, text, parms, null);
            }
        }
    }

    public void trace(long type, Object obj, String methodName, byte[] data) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, svByteArrayText, data, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, data);
            }
        }
    }

    public void trace(long type, String className, String methodName, byte[] data) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(type, className, methodName, svByteArrayText, data, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, data);
            }
        }
    }

    public void exception(long type, Object obj, String methodName, Throwable throwable) {
        if (this.isLoggable(type |= 8L)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, throwable);
            }
        }
    }

    public void exception(long type, String className, String methodName, Throwable throwable) {
        if (this.isLoggable(type |= 8L)) {
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, throwable);
            }
        }
    }

    public void stackTrace(long type, Object obj, String methodName) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            RASStackTrace rst = new RASStackTrace();
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, rst);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, rst);
            }
        }
    }

    public void stackTrace(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            RASStackTrace rst = new RASStackTrace(text);
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, rst);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, rst);
            }
        }
    }

    public void stackTrace(long type, String className, String methodName) {
        if (this.isLoggable(type)) {
            RASStackTrace rst = new RASStackTrace();
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, rst);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, rst);
            }
        }
    }

    public void stackTrace(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            RASStackTrace rst = new RASStackTrace(text);
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, rst);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(type, className, methodName, null, null, rst);
            }
        }
    }

    private void logTraceToTr(long type, String className, String method, String text, Object parms, boolean checkForNull) {
        try {
            if (this.ivOrbLogger) {
                String threadName = Thread.currentThread().getName();
                method = method == null ? threadName : method + " " + threadName;
            }
            if (checkForNull && parms == null) {
                parms = svNullParms;
            }
            int trType = this.mapJrasTypeToTr(type, text);
            TraceEvent6 event = new TraceEvent6(trType, this.ivTc, text, (Object)parms, this.ivOrganization, this.ivProduct, this.ivComponent, className, method, null);
            Tr.logJrasEvent((TraceEvent6)event);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void logThrowableToTr(long type, String className, String method, Throwable throwable) {
        try {
            if (this.ivOrbLogger) {
                String threadName = Thread.currentThread().getName();
                method = method == null ? threadName : method + " " + threadName;
            }
            int trType = this.mapJrasTypeToTr(type, null);
            String extendedMessage = RasHelper.throwableToString(throwable);
            TraceEvent6 event = new TraceEvent6(trType, this.ivTc, svExceptionText, (Object)extendedMessage, this.ivOrganization, this.ivProduct, this.ivComponent, className, method, extendedMessage);
            Tr.logJrasEvent((TraceEvent6)event);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int mapJrasTypeToTr(long type, String text) {
        if ((type & svDebugMask) != 0L) {
            return 2;
        }
        if ((type & svEventMask) != 0L) {
            return 5;
        }
        if (text == "Exit") {
            return 7;
        }
        return 6;
    }
}

