/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.CORBA.iiop.OrbMsgLogger;
import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceStateChangeListener;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASMessageLogger;
import com.ibm.websphere.ras.WsHandler;
import com.ibm.websphere.ras.WsOrbRasManager;
import java.util.Enumeration;

public class WsJrasMessageLogger
extends RASMessageLogger
implements OrbMsgLogger,
TraceStateChangeListener {
    private static final long serialVersionUID = -7127221463181426909L;
    private static long svWsMessageMask = 7L;
    private static String svEmptyString = "";
    private static Object[] svNullParms = new Object[]{null};
    private WsHandler svWsHandler = new WsHandler();
    private TraceComponent ivTc = null;
    private boolean ivWsHandlerInstalled = true;
    private boolean ivUserHandlerInstalled = false;
    private boolean ivOrbLogger = false;
    private boolean ivInitialized = false;

    WsJrasMessageLogger(String organization, String product2, String component, String name) {
        super(name);
        this.setOrganization(organization);
        this.setProduct(product2);
        this.setComponent(component);
        this.ivTc = Tr.register(name);
        super.setSynchronous(true);
        super.addHandler(this.svWsHandler);
        this.ivInitialized = true;
        this.ivTc.setLoggerForCallback(this);
        this.traceStateChanged();
    }

    protected void init() {
        super.init();
    }

    public void setLoggingOutput(String file) {
    }

    void setOrbLogger() {
        this.ivOrbLogger = true;
    }

    public void setName(String name) {
        if (!this.ivInitialized) {
            super.setName(name);
        }
    }

    public String getGroup() {
        return null;
    }

    public long getTraceMask() {
        return 0L;
    }

    public void setTraceMask(long mask) {
    }

    public void addTraceEventClass(String name) {
    }

    public void removeTraceEventClass(String name) {
    }

    public void setLogging(boolean flag) {
        super.setLogging(flag);
        if (this.ivOrbLogger) {
            WsOrbRasManager.setMsgLogging((boolean)flag);
        }
    }

    public void addHandler(RASIHandler handler) {
        if (handler != null) {
            if (handler instanceof WsHandler) {
                return;
            }
            this.ivUserHandlerInstalled = true;
            super.addHandler(handler);
        }
    }

    public void removeHandler(RASIHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof WsHandler) {
            this.ivWsHandlerInstalled = false;
        }
        super.removeHandler(handler);
        Enumeration x = this.getHandlers();
        int userCount = 0;
        while (x.hasMoreElements()) {
            RASIHandler y = (RASIHandler)x.nextElement();
            if (y instanceof WsHandler) continue;
            ++userCount;
        }
        if (userCount == 0) {
            this.ivUserHandlerInstalled = false;
        }
    }

    public boolean isSynchronous() {
        return true;
    }

    public void setSynchronous(boolean flag) {
    }

    public void message(long type, Object obj, String methodName, String key) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, null, null);
            }
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object parm1) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            Object[] parms = new Object[]{parm1, parm2};
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void message(long type, String className, String methodName, String key) {
        if (this.isLoggable(type)) {
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, null, null);
            }
        }
    }

    public void message(long type, String className, String methodName, String key, Object parm1) {
        if (this.isLoggable(type)) {
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void message(long type, String className, String methodName, String key, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void message(long type, String className, String methodName, String key, Object[] parms) {
        if (this.isLoggable(type)) {
            String messageFile = this.getMessageFile();
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, messageFile, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, messageFile, parms, null);
            }
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, null, null);
            }
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object parm1) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void msg(long type, String className, String methodName, String key, String file) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, null, null);
            }
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object parm1) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object[] parms) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logMessageToTr(type, className, methodName, key, file, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, key, file, parms, null);
            }
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, null, null);
            }
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void textMessage(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, null, null);
            }
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parm1, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] parms = new Object[]{parm1};
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parms, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logTextMessageToTr(type, className, methodName, text, parms, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, text, null, parms, null);
            }
        }
    }

    public void exception(long type, Object obj, String methodName, Exception exception) {
        this.exception(type, obj, methodName, (Throwable)exception);
    }

    public void exception(long type, String className, String methodName, Exception exception) {
        this.exception(type, className, methodName, (Throwable)exception);
    }

    public void exception(long type, Object obj, String methodName, Throwable throwable) {
        if (this.isLoggable(type)) {
            String className = svEmptyString;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, null, null, null, throwable);
            }
        }
    }

    public void exception(long type, String className, String methodName, Throwable throwable) {
        if (this.isLoggable(type)) {
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(type, className, methodName, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logMsg(type, className, methodName, null, null, null, throwable);
            }
        }
    }

    private void logMessageToTr(long type, String className, String methodName, String key, String file, Object parms, boolean checkForNull) {
        try {
            if (!(file != null && this.getSuppressedKeys().contains(key) || (this.getMessageMask() & svWsMessageMask) == 0L)) {
                if (this.ivOrbLogger) {
                    String threadName = Thread.currentThread().getName();
                    methodName = methodName == null ? threadName : methodName + " " + threadName;
                }
                if (checkForNull && parms == null) {
                    parms = svNullParms;
                }
                int trType = this.mapJrasTypeToTr(type);
                MessageEvent6 event = new MessageEvent6(trType, this.ivTc, key, file, (Object)parms, this.getOrganization(), this.getProduct(), this.getComponent(), className, methodName, null);
                Tr.logJrasEvent((MessageEvent6)event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void logTextMessageToTr(long type, String className, String methodName, String text, Object parms, boolean checkForNull) {
        try {
            if ((this.getMessageMask() & svWsMessageMask) != 0L) {
                if (this.ivOrbLogger) {
                    String threadName = Thread.currentThread().getName();
                    methodName = methodName == null ? threadName : methodName + " " + threadName;
                }
                if (checkForNull && parms == null) {
                    parms = svNullParms;
                }
                int trType = this.mapJrasTypeToTr(type);
                MessageEvent6 event = new MessageEvent6(trType, this.ivTc, text, null, (Object)parms, this.getOrganization(), this.getProduct(), this.getComponent(), className, methodName, null);
                Tr.logJrasEvent((MessageEvent6)event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void logThrowableToTr(long type, String className, String methodName, Throwable throwable) {
        try {
            if ((this.getMessageMask() & svWsMessageMask) != 0L) {
                String bundle = "com.ibm.ejs.resources.RasMessages";
                if (this.ivOrbLogger) {
                    String threadName = Thread.currentThread().getName();
                    methodName = methodName == null ? threadName : methodName + " " + threadName;
                }
                int trType = this.mapJrasTypeToTr(type);
                String extendedMessage = RasHelper.throwableToString(throwable);
                MessageEvent6 event = new MessageEvent6(trType, this.ivTc, "MSG_EXCEPTION_LOGGED", bundle, (Object)extendedMessage, this.getOrganization(), this.getProduct(), this.getComponent(), className, methodName, extendedMessage);
                Tr.logJrasEvent((MessageEvent6)event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int mapJrasTypeToTr(long type) {
        int typeToReturn = (type & 4L) != 0L ? 4 : ((type & 2L) != 0L ? 10 : 1);
        return typeToReturn;
    }

    public void traceStateChanged() {
        long newMask = 0L;
        if (this.ivTc.isErrorEnabled()) {
            newMask |= 4L;
        }
        if (this.ivTc.isWarningEnabled()) {
            newMask |= 2L;
        }
        if (this.ivTc.isInfoEnabled()) {
            newMask |= 1L;
        }
        long mask = this.getMessageMask();
        mask &= svWsMessageMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.setMessageMask(mask |= newMask);
        this.isLogging = mask != 0L;
    }
}

