/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationResult
implements Serializable {
    private static final long serialVersionUID = -7618901392163079877L;
    private HashMap validationMsgs = new HashMap();

    public void addMessage(String documentUri, String validator, ValidationMessage msg) {
        ArrayList<ValidationMessage> msgs;
        HashMap<String, ArrayList<ValidationMessage>> perDocResults = (HashMap<String, ArrayList<ValidationMessage>>)this.validationMsgs.get(documentUri);
        if (perDocResults == null) {
            perDocResults = new HashMap<String, ArrayList<ValidationMessage>>();
            this.validationMsgs.put(documentUri, perDocResults);
        }
        if ((msgs = (ArrayList<ValidationMessage>)perDocResults.get(validator)) == null) {
            msgs = new ArrayList<ValidationMessage>();
            perDocResults.put(validator, msgs);
        }
        msgs.add(msg);
    }

    public List getValidationMessages(String documentUri, String validator) {
        Map perDocResults = (Map)this.validationMsgs.get(documentUri);
        List result = null;
        if (perDocResults != null) {
            result = (List)perDocResults.get(validator);
        }
        return result;
    }

    public Set getValidators(String documentUri) {
        Map perDocResults = (Map)this.validationMsgs.get(documentUri);
        Set result = null;
        if (perDocResults != null) {
            result = perDocResults.keySet();
        }
        return result;
    }

    public Set getDocuments() {
        return this.validationMsgs.keySet();
    }

    public static class ValidationMessage
    implements Serializable {
        private static final long serialVersionUID = 6056410902254702293L;
        private String msg;
        private Object targetObject;
        private int severity;
        private int lineNo;

        public ValidationMessage(String msg, Object targetObject, int severity, int lineNo) {
            this.msg = msg;
            this.targetObject = targetObject;
            this.severity = severity;
            this.lineNo = lineNo;
        }

        public String getMessage() {
            return this.msg;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getLineNo() {
            return this.lineNo;
        }
    }
}

