/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.crypto;

import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;

public class PasswordUtil {
    public static final String DEFAULT_CRYPTO_ALGORITHM = com.ibm.ISecurityUtilityImpl.PasswordUtil.DEFAULT_CRYPTO_ALGORITHM;
    public static final String STRING_CONVERSION_CODE = "UTF8";
    public static final Class thisClass = PasswordUtil.class;

    public static final String decode(String encoded_string) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.decode(encoded_string);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.decode", "83");
            throw new InvalidPasswordDecodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.decode", "88");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String encode(String decoded_string) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.encode(decoded_string);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.encode", "106");
            throw new InvalidPasswordEncodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.encode", "111");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String encode(String decoded_string, String crypto_algorithm) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.encode(decoded_string, crypto_algorithm);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.encode", "129");
            throw new InvalidPasswordEncodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), thisClass, "com.ibm.ws.security.util.PasswordUtil.encode", "134");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String getCryptoAlgorithm(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.getCryptoAlgorithm(encoded_string);
    }

    public static final String getCryptoAlgorithmTag(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.getCryptoAlgorithmTag(encoded_string);
    }

    public static final boolean isEncrypted(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isEncrypted(encoded_string);
    }

    public static final boolean isValidCryptoAlgorithm(String crypto_algorithm) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm);
    }

    public static final boolean isValidCryptoAlgorithmTag(String crypto_algorithm_tag) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isValidCryptoAlgorithmTag(crypto_algorithm_tag);
    }

    public static final String passwordDecode(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordDecode(encoded_string);
    }

    public static final String passwordEncode(String decoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordEncode(decoded_string);
    }

    public static final String passwordEncode(String decoded_string, String crypto_algorithm) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordEncode(decoded_string, crypto_algorithm);
    }

    public static final String removeCryptoAlgorithmTag(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.removeCryptoAlgorithmTag(encoded_string);
    }
}

