/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.commons.logging;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.WsLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsJDK14Logger
implements Log {
    private Logger logger;
    private Logger internalLogger;
    private String classname;
    private boolean usingWASLogging;
    private Level[] actualLevels;
    private Level[] levelsForPlainJDK14Logging = new Level[]{Level.FINEST, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};
    private Level[] levelsForWASJDK14Logging = new Level[]{WsLevel.FINEST, WsLevel.FINE, WsLevel.INFO, WsLevel.WARNING, WsLevel.SEVERE, WsLevel.FATAL};
    private final int LEVEL_TRACE = 0;
    private final int LEVEL_DEBUG = 1;
    private final int LEVEL_INFO = 2;
    private final int LEVEL_WARNING = 3;
    private final int LEVEL_ERROR = 4;
    private final int LEVEL_FATAL = 5;

    public WsJDK14Logger(String name) {
        this.logger = Logger.getLogger(name);
        this.classname = this.getClass().getName();
        this.internalLogger = Logger.getLogger(this.classname);
        this.usingWASLogging = this.logger instanceof WsLogger;
        this.actualLevels = this.usingWASLogging ? this.levelsForWASJDK14Logging : this.levelsForPlainJDK14Logging;
        this.internalLogger.logp(Level.FINE, this.classname, "constructor", "Instantiated, running in WAS environment: " + this.usingWASLogging);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(this.actualLevels[1]);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(this.actualLevels[4]);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(this.actualLevels[5]);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(this.actualLevels[2]);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(this.actualLevels[0]);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(this.actualLevels[3]);
    }

    public void trace(Object message) {
        this.log(this.actualLevels[0], message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(this.actualLevels[0], message, t);
    }

    public void debug(Object message) {
        this.log(this.actualLevels[1], message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(this.actualLevels[1], message, t);
    }

    public void info(Object message) {
        this.log(this.actualLevels[2], message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(this.actualLevels[2], message, t);
    }

    public void warn(Object message) {
        this.log(this.actualLevels[3], message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(this.actualLevels[3], message, t);
    }

    public void error(Object message) {
        this.log(this.actualLevels[4], message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(this.actualLevels[4], message, t);
    }

    public void fatal(Object message) {
        this.log(this.actualLevels[5], message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(this.actualLevels[5], message, t);
    }

    public void setLogFactory(LogFactory logFactory) {
        if (this.internalLogger != null && logFactory != null) {
            this.internalLogger.logp(Level.FINE, this.classname, "setLogFactory", "Instantiated by " + logFactory.getClass().getName());
            this.internalLogger.logp(Level.FINE, this.classname, "setLogFactory", "Factory instantiated by " + logFactory.getClass().getClassLoader().toString());
        }
    }

    private void log(Level level, Object message, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            LogRecord logRecord = null;
            try {
                if (message instanceof CommonBaseEvent) {
                    logRecord = new CommonBaseEventLogRecord((CommonBaseEvent)message);
                } else if (message instanceof CommonBaseEventLogRecord || message instanceof LogRecord) {
                    logRecord = (LogRecord)message;
                }
            }
            catch (Exception e) {
                this.internalLogger.logp(Level.WARNING, this.classname, "log", "Exception. ", e);
                logRecord = null;
            }
            if (logRecord == null) {
                logRecord = new LogRecord(level, String.valueOf(message));
            }
            if (throwable != null) {
                logRecord.setThrown(throwable);
            }
            this.logger.log(logRecord);
        }
    }
}

