/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.topography.ClientDescriptionManager;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.wlm.Factory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class DescriptionManagerFactory {
    private static final TraceComponent tc = Tr.register(DescriptionManagerFactory.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static DescriptionManager distributed = (DescriptionManager)Factory.loadImpl(DescriptionManager.class);
    private static DescriptionManager local = new ClientDescriptionManager();
    private static final String STATIC_ROUTING_SYSTEM_PROPERTY = "com.ibm.proxy.enable.static.routing";
    private static final String STATIC_ROUTING_SYSTEM_PROPERTY_TRUE_VALUE = "true";
    private static Boolean staticRoutingEnabled = null;
    private static final DescriptionManagerFactory instance;

    public static DescriptionManagerFactory getInstance() {
        return instance;
    }

    public static DescriptionManager getDescriptionManager() {
        PlatformHelper platformHelper = AdminHelper.getPlatformHelper();
        boolean isZ = platformHelper.isZOS();
        if (DescriptionManagerFactory.isStaticRoutingEnabled() && !isZ) {
            return local;
        }
        return distributed;
    }

    public static DescriptionManager getLocalDescriptionManager() {
        return local;
    }

    public static boolean isStaticRoutingEnabled() {
        if (staticRoutingEnabled == null) {
            try {
                String serverType = AdminServiceFactory.getAdminService().getServerType();
                if (serverType.equals("PROXY_SERVER") || serverType.equals("ONDEMAND_ROUTER")) {
                    String staticRoutingSystemProperty;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isStaticRoutingEnabled - running in a Proxy Server");
                    }
                    if ((staticRoutingSystemProperty = DescriptionManagerFactory.getSystemProperty(STATIC_ROUTING_SYSTEM_PROPERTY)) != null && staticRoutingSystemProperty.equalsIgnoreCase(STATIC_ROUTING_SYSTEM_PROPERTY_TRUE_VALUE)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "isStaticRoutingEnabled - staticRoutingSystemProperty " + staticRoutingSystemProperty);
                        }
                        staticRoutingEnabled = Boolean.TRUE;
                        return staticRoutingEnabled;
                    }
                }
                staticRoutingEnabled = Boolean.FALSE;
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected Could not obtain value for staticRoutingSystemProperty");
                }
                staticRoutingEnabled = Boolean.FALSE;
            }
        }
        return staticRoutingEnabled;
    }

    private static String getSystemProperty(String name) {
        final String temp = name;
        try {
            String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(temp);
                }
            });
            return value;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
        instance = new DescriptionManagerFactory();
    }
}

