/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class XmlHeader {
    public static final String VERSION = "version";
    public static final String ENCODING = "encoding";
    private String version = "1.0";
    private String charset = "UTF-8";
    private HashMap parms = new HashMap();

    public XmlHeader() {
        this.parms.put(VERSION, this.version);
        this.parms.put(ENCODING, this.charset);
    }

    public void put(Object key, Object value) {
        this.parms.put(key, value);
    }

    public String toString() throws IllegalArgumentException {
        StringBuffer answer = new StringBuffer();
        answer.append("<?xml ");
        answer.append("version=\"");
        answer.append(this.parms.get(VERSION));
        answer.append("\" encoding=");
        Object enc = this.parms.get(ENCODING);
        if (enc == null) {
            throw new IllegalArgumentException("illegal encoding type");
        }
        if (!this.charset.equals(enc)) {
            throw new IllegalArgumentException("illegal encoding type");
        }
        answer.append("\"utf-8\"");
        answer.append(" ?>");
        return answer.toString();
    }

    public byte[] toBytes() throws IllegalArgumentException {
        String str = this.toString();
        byte[] answer = null;
        try {
            answer = str.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("illegal encoding type");
        }
        return answer;
    }
}

