/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.ObjectPool;
import com.ibm.ws.wssecurity.xss4j.domutil.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    public static int INITIAL_OBJ_POOL_SIZE = 100;
    public static int MAX_OBJ_POOL_SIZE = 200;
    public static float POOL_LOAD_FACTOR = 0.75f;
    private static TransformerPool _transformerPool = null;
    private static DocumentBuilderPool _documentBuilderPool = null;
    private static SAXParserPool _saxParserPool = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream inStream) throws SAXException, IOException {
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = (DocumentBuilder)_documentBuilderPool.getObject();
            doc = db.parse(inStream);
        }
        finally {
            _documentBuilderPool.returnObject(db);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFile(File file) throws Exception {
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = (DocumentBuilder)_documentBuilderPool.getObject();
            doc = db.parse(file);
        }
        finally {
            _documentBuilderPool.returnObject(db);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = (DocumentBuilder)_documentBuilderPool.getObject();
            doc = db.newDocument();
        }
        finally {
            _documentBuilderPool.returnObject(db);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseString(String xmlString) throws SAXException, IOException {
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = (DocumentBuilder)_documentBuilderPool.getObject();
            doc = db.parse(new ByteArrayInputStream(xmlString.getBytes()));
        }
        finally {
            _documentBuilderPool.returnObject(db);
        }
        return doc;
    }

    public static String getStringUnchanged(Node node) {
        byte[] data;
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                data = XPathCanonicalizer.serializeSubset((Node)((Element)node), (boolean)true);
                break;
            }
            case 9: {
                data = XPathCanonicalizer.serializeAll((Document)((Document)node), (boolean)true);
                break;
            }
            default: {
                return null;
            }
        }
        return new String(data);
    }

    public static byte[] getDataUnchanged(Node node) {
        byte[] data;
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                data = XPathCanonicalizer.serializeSubset((Node)((Element)node), (boolean)true);
                break;
            }
            case 9: {
                data = XPathCanonicalizer.serializeAll((Document)((Document)node), (boolean)true);
                break;
            }
            default: {
                return null;
            }
        }
        return data;
    }

    public static String excanonicalizeElement(Node node, Map nsMappings) {
        byte[] data;
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                data = ExclusiveCanonicalizer.serializeSubset(new Hashtable(nsMappings), (Node)((Element)node), (boolean)true);
                break;
            }
            case 9: {
                data = ExclusiveCanonicalizer.serializeAll(new Hashtable(nsMappings), (Document)((Document)node), (boolean)true);
                break;
            }
            default: {
                return null;
            }
        }
        return new String(data);
    }

    public static String getElementText(Element e, boolean b) {
        String ret = null;
        NodeList all = e.getChildNodes();
        int allLength = all.getLength();
        for (int i = 0; i < allLength; ++i) {
            Node aNode = all.item(i);
            if (aNode.getNodeType() == 3) {
                ret = ((Text)aNode).getNodeValue();
                if ((ret = ret.trim()).length() <= 0) continue;
                break;
            }
            if (!b || aNode.getNodeType() != 4) continue;
            ret = ((CDATASection)aNode).getNodeValue();
            break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser p = null;
        try {
            p = (SAXParser)_saxParserPool.getObject();
        }
        finally {
            _saxParserPool.returnObject(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saxParse(InputStream is, DefaultHandler dh) throws SAXException, IOException {
        SAXParser p = null;
        try {
            p = (SAXParser)_saxParserPool.getObject();
            p.parse(is, dh);
        }
        finally {
            _saxParserPool.returnObject(p);
        }
    }

    public static void transform(DOMSource ds2, StreamResult sr) {
        Transformer transformer = (Transformer)_transformerPool.getObject();
        try {
            transformer.transform(ds2, sr);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        finally {
            _transformerPool.returnObject(transformer);
        }
    }

    public static Element getFirstOccurence(Element top, String uri, String localPart) {
        Element result = null;
        NodeList nList = top.getElementsByTagNameNS(uri, localPart);
        if (nList != null && nList.getLength() > 0) {
            result = (Element)nList.item(0);
        }
        return result;
    }

    public static String getString(Node node, boolean format) throws RuntimeException {
        if (format) {
            return XMLUtil.print(node);
        }
        StringWriter sw = new StringWriter();
        Transformer transformer = (Transformer)_transformerPool.getObject();
        try {
            transformer.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        finally {
            _transformerPool.returnObject(transformer);
        }
        return sw.toString();
    }

    public static String getString(Node node) throws RuntimeException {
        return XMLUtil.getString(node, false);
    }

    private static StringBuffer print(Node node, StringBuffer sb, int deep) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        boolean endTagAdded = false;
        if (node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (type == 9) {
            node = ((Document)node).getDocumentElement();
            type = node.getNodeType();
        }
        switch (type) {
            case 1: {
                sb.append(XMLUtil.indent(deep));
                sb.append('<');
                sb.append(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(' ');
                    sb.append(attrs.item(i).getNodeName());
                    sb.append("=\"");
                    sb.append(attrs.item(i).getNodeValue());
                    sb.append('\"');
                }
                NodeList children = node.getChildNodes();
                if (children != null && children.getLength() > 0) {
                    sb.append('>');
                } else {
                    endTagAdded = true;
                    sb.append("/>");
                }
                sb.append("\n");
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    XMLUtil.print(children.item(i), sb, deep + 1);
                }
                break;
            }
            case 3: {
                String tn = node.getNodeValue().trim();
                if (tn.length() <= 0) break;
                sb.append(XMLUtil.indent(deep) + tn + "\n");
            }
        }
        if (type == 1 && !endTagAdded) {
            sb.append(XMLUtil.indent(deep));
            sb.append("</");
            sb.append(node.getNodeName());
            sb.append(">");
            sb.append('\n');
        }
        return sb;
    }

    private static String indent(int num) {
        String indent = "   ";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(indent);
        }
        return sb.toString();
    }

    public static String print(Node node) {
        return XMLUtil.print(node, null, 0).toString();
    }

    public static boolean isElement(Node node, String uri, String name) {
        boolean result = false;
        if (uri != null && name != null && node != null && node.getNodeType() == 1) {
            Element e = (Element)node;
            String eURI = e.getNamespaceURI();
            String eName = null;
            eName = e.getLocalName();
            if (eName == null && (eName = e.getNodeName()) == null) {
                eName = new String("");
            }
            if (uri.equals(eURI) && name.equals(eName)) {
                result = true;
            }
        }
        return result;
    }

    public static String getText(Element el) {
        StringBuffer result = new StringBuffer();
        Node child = null;
        child = el.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                result.append(child.getNodeValue());
            }
            if ((child = child.getNextSibling()) != null) continue;
        }
        return result.toString();
    }

    public static NodeList getElementsByPath(Node node, PathElement[] path) {
        Element start;
        if (node.getNodeType() == 1) {
            start = (Element)node;
        } else if (node.getNodeType() == 9) {
            start = ((Document)node).getDocumentElement();
        } else {
            return new ListNodeList(Collections.EMPTY_LIST);
        }
        NodeList nextInLine = new ArrayNodeList(new Node[]{node});
        for (int i = 1; i < path.length; ++i) {
            if (start == null) {
                return new ListNodeList(Collections.EMPTY_LIST);
            }
            PathElement next = path[i];
            nextInLine = XMLUtil.getChildren(start, next.getNameSpaceURI(), next.getLocalName());
            start = nextInLine == null || nextInLine.getLength() == 0 ? null : (Element)nextInLine.item(0);
        }
        return nextInLine;
    }

    public static NodeList getChildren(Element el, String ns, String ln) {
        if (!el.hasChildNodes()) {
            return new ListNodeList(Collections.EMPTY_LIST);
        }
        Node firstChild = el.getFirstChild();
        ArrayList<Node> retList = new ArrayList<Node>();
        do {
            if (firstChild == null || firstChild.getNodeType() != 1 || ns == null || !ns.equals(firstChild.getNamespaceURI()) || !ln.equals(firstChild.getLocalName())) continue;
            retList.add(firstChild);
        } while ((firstChild = firstChild == null ? null : firstChild.getNextSibling()) != null);
        return new ListNodeList(retList);
    }

    static {
        _documentBuilderPool = new DocumentBuilderPool(INITIAL_OBJ_POOL_SIZE, MAX_OBJ_POOL_SIZE, POOL_LOAD_FACTOR);
        _transformerPool = new TransformerPool(INITIAL_OBJ_POOL_SIZE, MAX_OBJ_POOL_SIZE, POOL_LOAD_FACTOR);
        _saxParserPool = new SAXParserPool(INITIAL_OBJ_POOL_SIZE, MAX_OBJ_POOL_SIZE, POOL_LOAD_FACTOR);
    }

    public static class ArrayNodeList
    implements NodeList {
        private Node[] _list;

        public ArrayNodeList(Node[] list) {
            this._list = list;
        }

        @Override
        public Node item(int index) {
            return this._list[0];
        }

        @Override
        public int getLength() {
            return this._list.length;
        }
    }

    public static class ListNodeList
    implements NodeList {
        private List _list;

        public ListNodeList(List ra) {
            this._list = new ArrayList(ra);
        }

        @Override
        public Node item(int index) {
            return (Node)this._list.get(index);
        }

        @Override
        public int getLength() {
            return this._list.size();
        }
    }

    public static class PathElement {
        private String _nameSpaceURI;
        private String _localName;

        public PathElement(String nameSpaceURI, String localName) {
            this._nameSpaceURI = nameSpaceURI;
            this._localName = localName;
        }

        public String getLocalName() {
            return this._localName;
        }

        public String getNameSpaceURI() {
            return this._nameSpaceURI;
        }
    }

    private static class SAXParserPool
    extends ObjectPool {
        public SAXParserPool(int initialObjectSize, int maxObjectSize, float loadFactor) {
            super(initialObjectSize, maxObjectSize, loadFactor);
        }

        @Override
        protected Object createObject(int objectNum) {
            SAXParser obj = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                obj = factory.newSAXParser();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return obj;
        }

        public Object getObject() {
            Object obj = super.getObject(true);
            return obj;
        }

        @Override
        public int getNumObjectsInPool() {
            return super.getNumObjectsInPool();
        }

        @Override
        public synchronized void markForPoolRemoval(Object o) {
            super.markForPoolRemoval(o);
        }

        @Override
        public void returnObject(Object o) {
            super.returnObject(o);
        }
    }

    private static class TransformerPool
    extends ObjectPool {
        public TransformerPool(int initialObjectSize, int maxObjectSize, float loadFactor) {
            super(initialObjectSize, maxObjectSize, loadFactor);
        }

        @Override
        protected Object createObject(int objectNum) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            try {
                transformer = tFactory.newTransformer();
            }
            catch (TransformerConfigurationException e1) {
                e1.printStackTrace();
            }
            return transformer;
        }

        public Object getObject() {
            Object obj = super.getObject(true);
            return obj;
        }

        @Override
        public int getNumObjectsInPool() {
            return super.getNumObjectsInPool();
        }

        @Override
        public synchronized void markForPoolRemoval(Object o) {
            super.markForPoolRemoval(o);
        }

        @Override
        public void returnObject(Object o) {
            super.returnObject(o);
        }
    }

    private static class DocumentBuilderPool
    extends ObjectPool {
        public DocumentBuilderPool(int initialObjectSize, int maxObjectSize, float loadFactor) {
            super(initialObjectSize, maxObjectSize, loadFactor);
        }

        @Override
        protected Object createObject(int objectNum) {
            DocumentBuilder db = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return db;
        }

        public Object getObject() {
            Object obj = super.getObject(true);
            return obj;
        }

        @Override
        public int getNumObjectsInPool() {
            return super.getNumObjectsInPool();
        }

        @Override
        public synchronized void markForPoolRemoval(Object o) {
            super.markForPoolRemoval(o);
        }

        @Override
        public void returnObject(Object o) {
            super.returnObject(o);
        }
    }
}

